#!/bin/sh
set -o errexit

###
# Copyright © 2015-2022, Antoine Le Gonidec <vv221@dotslashplay.it>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Gangsters: Organized Crime
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220118.2

# Set game-specific variables

GAME_ID='gangsters-organized-crime'
GAME_NAME='Gangsters: Organized Crime'

ARCHIVE_BASE_0='setup_gangsters_2.0.0.15.exe'
ARCHIVE_BASE_0_MD5='794561f7b449e3bfce82611f11f8bc9b'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='330000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.15'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/gangsters_organized_crime'

CONTENT_PATH_DEFAULT='app'
ARCHIVE_DOC_DATA_FILES='
*.pdf
*.txt
*.wri
eula'
ARCHIVE_GAME_BIN_FILES='
*.dll
*.ini
gangsters.exe'
ARCHIVE_GAME_DATA_FILES='
data
graphics
help
multiplayer?scenarios
music
samples
scenarios
sound
tutorials
video
security.key'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='gangsters.exe'
APP_MAIN_ICON='gangsters.exe'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"
PKG_BIN_DEPS_ARCH='lib32-gstreamer lib32-gst-plugins-base'
PKG_BIN_DEPS_DEB='gstreamer1.0-plugins-base, gstreamer1.0-plugins-good'
PKG_BIN_DEPS_GENTOO='media-libs/gst-plugins-base[abi_x86_32] media-libs/gst-plugins-good[abi_x86_32]'

# Use persistent storage for user data

DATA_DIRS='./multiplayer_saved_games ./saved_games'
APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Work around ./play.it poor support for spaces in paths
if [ ! -e "multiplayer saved games" ]; then
	ln --symbolic multiplayer_saved_games "multiplayer saved games"
fi
if [ ! -e "saved games" ]; then
	ln --symbolic saved_games "saved games"
fi'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Include game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
