#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Evoland 1
# send your bug reports to contact@dotslashplay.it
###

script_version=20230824.1

GAME_ID='evoland-1'
GAME_NAME='Evoland'

ARCHIVE_BASE_GOG_0='setup_evoland_1.1.2490_(20677).exe'
ARCHIVE_BASE_GOG_0_MD5='97978ef959d097876142ae2c6ce765c2'
ARCHIVE_BASE_GOG_0_TYPE='innosetup'
ARCHIVE_BASE_GOG_0_SIZE='120000'
ARCHIVE_BASE_GOG_0_VERSION='1.1.2490-gog20677'
ARCHIVE_BASE_GOG_0_URL='https://www.gog.com/game/evoland'

## This DRM-free native Linux build is no longer available for sale from the Humble Store,
## they now only sell Steam keys for the Evoland "Legendary Edition" bundle.
ARCHIVE_BASE_HUMBLE_0='Evoland.exe'
ARCHIVE_BASE_HUMBLE_0_MD5='9585142f38d769d4ac9125f587d0c891'
ARCHIVE_BASE_HUMBLE_0_TYPE='nullsoft-installer'
ARCHIVE_BASE_HUMBLE_0_SIZE='110000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.1.2490-humble1'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
adobe air
dinput8.dll
evoland.exe
pad.exe'
CONTENT_GAME_DATA_FILES='
icons
meta-inf
mimetype
game.dat'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/com.shirogames.evoland'

APP_MAIN_EXE='evoland.exe'
APP_MAIN_ICONS_LIST='
APP_MAIN_ICON_16
APP_MAIN_ICON_32
APP_MAIN_ICON_48
APP_MAIN_ICON_128'
APP_MAIN_ICON_16='icons/evoicon16.png'
APP_MAIN_ICON_32='icons/evoicon32.png'
APP_MAIN_ICON_48='icons/evoicon48.png'
APP_MAIN_ICON_128='icons/evoicon128.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
# Ensure easy upgrades from packages generated by pre-20201219.1 script
PKG_DATA_PROVIDES='
evoland-data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
# Ensure easy upgrades from packages generated by pre-20201219.1 script
PKG_BIN_PROVIDES='
evoland'

# Load common functions

target_version='2.25'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata"

	case "$(context_archive)" in
		('ARCHIVE_BASE_HUMBLE_'*)
			tolower .
		;;
	esac
)

# Include game icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
