#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dr Livingstone, I Presume?
# send your bug reports to contact@dotslashplay.it
###

script_version=20230706.1

GAME_ID='dr-livingstone-i-presume'
GAME_NAME='Dr Livingstone, I Presume?'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

# Archives

## Full game

ARCHIVE_BASE_0='setup_dr_livingstone_i_presume_220419_0803_(55205).exe'
ARCHIVE_BASE_0_MD5='d6fdb1ce7ee00f5068b1d93f4592dad0'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_dr_livingstone_i_presume_220419_0803_(55205)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='36b0f92cde1b8ccbd42f339fbc752ada'
ARCHIVE_BASE_0_SIZE='5300000'
ARCHIVE_BASE_0_VERSION='2022.04.19-gog55205'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/dr_livingstone_i_presume'

## Demo

## This installer is no longer available from gog.com
ARCHIVE_BASE_DEMO_0='setup_dr_livingstone_i_presume_demo_210726_1631_(48828).exe'
ARCHIVE_BASE_DEMO_0_MD5='57f69d1473e4c24706fe2cc70c56d62b'
ARCHIVE_BASE_DEMO_0_TYPE='innosetup'
ARCHIVE_BASE_DEMO_0_PART1='setup_dr_livingstone_i_presume_demo_210726_1631_(48828)-1.bin'
ARCHIVE_BASE_DEMO_0_PART1_MD5='4adc9914d1629ff3849f9d1d1f139b5c'
ARCHIVE_BASE_DEMO_0_SIZE='3800000'
ARCHIVE_BASE_DEMO_0_VERSION='2021.07.26-gog48828'


UNREALENGINE4_NAME='drlivingstone'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
engine
${UNREALENGINE4_NAME}/binaries
${UNREALENGINE4_NAME}/plugins
${UNREALENGINE4_NAME}.exe"
CONTENT_GAME_DATA_FILES="
${UNREALENGINE4_NAME}"

WINE_DIRECT3D_RENDERER='dxvk'

WINE_PERSISTENT_DIRECTORIES="
users/\${USER}/AppData/Local/${UNREALENGINE4_NAME}/Saved"

APP_MAIN_EXE="${UNREALENGINE4_NAME}.exe"
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_DEMO="$PKG_DATA_ID_DEMO"
PKG_BIN_DEPENDENCIES_GSTREAMER_PLUGINS='
video/quicktime, variant=(string)iso'

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
