#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# CrossCode (demo)
# send your bug reports to contact@dotslashplay.it
###

script_version=20230623.1

GAME_ID='crosscode-demo'
GAME_NAME='CrossCode (demo)'

ARCHIVE_BASE_0='crosscode-demo.zip'
ARCHIVE_BASE_0_MD5='22c54c8c415ecf056bd703dbed09c13d'
ARCHIVE_BASE_0_SIZE='130000'
ARCHIVE_BASE_0_VERSION='0.7.1beta-1'
ARCHIVE_BASE_0_URL='https://www.cross-code.com/en/home'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_MAIN_FILES='
crosscode-demo.exe
ffmpegsumo.dll
icudt.dll
nw.pak'
CONTENT_DOC_MAIN_FILES='
credits.html'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Local/CrossCode'

APP_MAIN_EXE='crosscode-demo.exe'
APP_MAIN_ICON='favicon.png'

PKG_MAIN_ARCH='32'

# Load common functions

target_version='2.23'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
ARCHIVE_EXE="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/crosscode-demo.exe"
ARCHIVE_EXE_EXTRACTOR='unzip'
## Errors during the data extraction from the .exe are expected,
## they should be ignored.
archive_extraction 'SOURCE_ARCHIVE' 2>/dev/null || true

# Include game icons

icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
