#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
set -o errexit

###
# Cat Quest II
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20221129.6

# Set game-specific variables

GAME_ID='cat-quest-2'
GAME_NAME='Cat Quest II'

ARCHIVE_BASE_0='setup_cat_quest_ii_1.7.7.3_(51746).exe'
ARCHIVE_BASE_0_MD5='78f1001f07099b398ce66d971bf9b17c'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='511796'
ARCHIVE_BASE_0_VERSION='1.7.7.3-gog51746'
ARCHIVE_BASE_0_URL='https://www.gog.com/en/game/cat_quest_ii'

UNITY3D_NAME='cat quest ii'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN_FILES='
cat?quest?ii.exe
cat?quest?ii_data/plugins
monobleedingedge
unitycrashhandler32.exe
unityplayer.dll'
ARCHIVE_GAME_DATA_FILES='
cat?quest?ii_data'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="${UNITY3D_NAME}.exe"
APP_MAIN_ICON="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use a dedicated log file for the current game session

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'

# Use a dedicated log file for the current game session
mkdir --parents logs
APP_OPTIONS="${APP_OPTIONS} -logFile ./logs/$(date +%F-%R).log"'

# Use persistent storage for user data

APP_WINE_LINK_DIRS='
userdata:users/${USER}/Documents/Cat Quest II'
USER_PERSISTENT_FILES='
userdata/settings
userdata/settings.bak
userdata/*.dat
userdata/*.dat.bak'

# Load common functions

target_version='2.17'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icon

PKG='PKG_DATA'
icons_inclusion

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
