#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Testament of Sherlock Holmes
# send your bug reports to contact@dotslashplay.it
###

script_version=20240826.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='sherlock-holmes-6-the-testament-of-sherlock-holmes'
GAME_NAME='The Testament of Sherlock Holmes'

ARCHIVE_BASE_0_NAME='setup_testament_of_sherlock_holmes_2.0.0.5.exe'
ARCHIVE_BASE_0_MD5='5942a1e7b0f21d5d4f08c3b3e0bb40e3'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
## TODO: Check if --lowercase is really useful when called alongside --gog
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--lowercase --gog'
ARCHIVE_BASE_0_PART1_NAME='setup_testament_of_sherlock_holmes_2.0.0.5-1.bin'
ARCHIVE_BASE_0_PART1_MD5='5b223e42466e6be155fc0da569848a21'
ARCHIVE_BASE_0_PART1_TYPE='rar'
ARCHIVE_BASE_0_PART2_NAME='setup_testament_of_sherlock_holmes_2.0.0.5-2.bin'
ARCHIVE_BASE_0_PART2_MD5='e9b3a3ce285d95af9937e1269b82cdbb'
ARCHIVE_BASE_0_SIZE='10000000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.5'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/testament_of_sherlock_holmes_the'

CONTENT_PATH_DEFAULT='game'
CONTENT_GAME_BIN_FILES='
d3dx9_32.dll
D3DX9_42.dll
msvcr71.dll
game.exe
game.ini'
CONTENT_GAME_DATA_FILES='
000
001
002
003
004
logo
data.txt
splash_screen.jpg
*.0050'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Frogwares/The Testament of Sherlock Holmes'
## Ensure availability of required library PhysXLoader.dll.
WINE_WINETRICKS_VERBS='physx'

APP_MAIN_EXE='game.exe'
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=101 --language=1033'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
