/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_CONFIGURATIONCAPACITY_H_
#define OPENDRIM_CONFIGURATIONCAPACITY_H_

#include <Instance.h>

const static char* OpenDRIM_ConfigurationCapacity_classnames[] = {"OpenDRIM_ConfigurationCapacity"};
static string OpenDRIM_ConfigurationCapacity_NAMESPACE = _NAMESPACE;

class OpenDRIM_ConfigurationCapacity {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	unsigned short ObjectType;
	bool ObjectType_isNULL;
	
	string OtherTypeDescription;
	bool OtherTypeDescription_isNULL;
	
	unsigned long long MinimumCapacity;
	bool MinimumCapacity_isNULL;
	
	unsigned long long MaximumCapacity;
	bool MaximumCapacity_isNULL;
	
	unsigned int Increment;
	bool Increment_isNULL;
	
	vector<string> VendorCompatibilityStrings;
	bool VendorCompatibilityStrings_isNULL;
	
	OpenDRIM_ConfigurationCapacity() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		Name_isNULL = true;
		ObjectType_isNULL = true;
		OtherTypeDescription_isNULL = true;
		MinimumCapacity_isNULL = true;
		MaximumCapacity_isNULL = true;
		Increment_isNULL = true;
		VendorCompatibilityStrings_isNULL = true;
	}
	
	~OpenDRIM_ConfigurationCapacity() {}
	
	string getKeys() const {
		return CF_toLowCase(".Name=\"" + CF_quoteString(Name) + "\""".ObjectType=\"" + CF_intToStr(ObjectType) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getObjectType(unsigned short& value) const {
		if (ObjectType_isNULL==true)
			return NOT_FOUND;
		value = ObjectType;
		return OK;
	}
	
	int setObjectType(const unsigned short& newValue) {
		ObjectType = newValue;
		ObjectType_isNULL = false;
		return OK;
	}

	int getOtherTypeDescription(string& value) const {
		if (OtherTypeDescription_isNULL==true)
			return NOT_FOUND;
		value = OtherTypeDescription;
		return OK;
	}
	
	int setOtherTypeDescription(const string& newValue) {
		OtherTypeDescription = newValue;
		OtherTypeDescription_isNULL = false;
		return OK;
	}

	int getMinimumCapacity(unsigned long long& value) const {
		if (MinimumCapacity_isNULL==true)
			return NOT_FOUND;
		value = MinimumCapacity;
		return OK;
	}
	
	int setMinimumCapacity(const unsigned long long& newValue) {
		MinimumCapacity = newValue;
		MinimumCapacity_isNULL = false;
		return OK;
	}

	int getMaximumCapacity(unsigned long long& value) const {
		if (MaximumCapacity_isNULL==true)
			return NOT_FOUND;
		value = MaximumCapacity;
		return OK;
	}
	
	int setMaximumCapacity(const unsigned long long& newValue) {
		MaximumCapacity = newValue;
		MaximumCapacity_isNULL = false;
		return OK;
	}

	int getIncrement(unsigned int& value) const {
		if (Increment_isNULL==true)
			return NOT_FOUND;
		value = Increment;
		return OK;
	}
	
	int setIncrement(const unsigned int& newValue) {
		Increment = newValue;
		Increment_isNULL = false;
		return OK;
	}

	int getVendorCompatibilityStrings(vector<string>& value) const {
		if (VendorCompatibilityStrings_isNULL==true)
			return NOT_FOUND;
		value = VendorCompatibilityStrings;
		return OK;
	}
	
	int setVendorCompatibilityStrings(const vector<string>& newValue) {
		VendorCompatibilityStrings = newValue;
		VendorCompatibilityStrings_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_CONFIGURATIONCAPACITY_H_*/
