/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.config.importer;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ColumnConfig;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.config.ExampleConfig;
import amazon.fws.clicommando.config.OutputDescriptionConfig;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.util.StringUtils;
import amazon.fws.clicommando.util.XmlUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpImportHelper {
    private static final String REF = "ref";
    private static final String TITLE = "title";
    private static final String COMMONPARAMETER_HELP = "commonparameter-help";
    private static final String HEADER = "header";
    private static final String COLUMN = "column";
    private static final String OUTPUT_HELP = "output-help";
    private static final String NOTE = "note";
    private static final String EXAMPLE = "example";
    private static final String NAME = "name";
    private static final String PARAM = "param";
    private static final String DESCRIPTION = "description";
    private static final String SHORT_DESCRIPTION = "short-description";
    private static final String SYNOPSIS = "synopsis";
    private static final String COMMAND_HELP = "command-help";
    Map<String, Map<String, String>> commonParams = new HashMap<String, Map<String, String>>();

    public void addHelpTo(Command command, List<Element> helps) {
        if (helps == null) {
            return;
        }
        this.commonParams = this.getCommonParamHelp(helps);
        this.loadCommandConfigHelp(command, helps);
        this.loadOutputDescHelp(command, helps);
    }

    private void loadOutputDescHelp(Command command, List<Element> helps) {
        for (OutputDescriptionConfig outDesc : command.getOutputDescriptions()) {
            if (!StringUtils.notEmpty(outDesc.getHelpRef())) continue;
            Element outHelp = this.findElem(outDesc.getHelpRef(), OUTPUT_HELP, helps);
            NodeList cols = outHelp.getElementsByTagName(COLUMN);
            for (int i = 0; i < cols.getLength(); ++i) {
                Element colElem = (Element)cols.item(i);
                String colHeader = colElem.getAttribute(HEADER);
                if (StringUtils.isEmpty(colHeader) || !outDesc.doesColumnExist(colHeader)) continue;
                ColumnConfig col = outDesc.getColumn(colHeader);
                String desc = colElem.getTextContent();
                col.setHelpDescription(StringUtils.stripWSControlChars(desc));
            }
            NodeList examples = outHelp.getElementsByTagName(EXAMPLE);
            for (int i = 0; i < examples.getLength(); ++i) {
                Element example = (Element)examples.item(i);
                String note = StringUtils.stripWSControlChars(XmlUtils.getTextFromChild(example, NOTE));
                String exText = XmlUtils.getCdataFromNode(example);
                outDesc.addOutputExamples(new ExampleConfig(note, exText));
            }
        }
    }

    private void loadCommandConfigHelp(Command command, List<Element> helps) {
        for (CommandConfig cmdConfig : command.getCommandConfigs()) {
            String helpRef = cmdConfig.getHelpRef();
            if (StringUtils.isEmpty(helpRef)) continue;
            Element helpElem = this.findElem(cmdConfig.getHelpRef(), COMMAND_HELP, helps);
            String synopsis = StringUtils.stripWSControlChars(XmlUtils.getTextFromChild(helpElem, SYNOPSIS));
            String shortD = StringUtils.stripWSControlChars(XmlUtils.getTextFromChild(helpElem, SHORT_DESCRIPTION));
            String longD = StringUtils.stripWSControlChars(XmlUtils.getTextFromChild(helpElem, DESCRIPTION));
            cmdConfig.setHelpText(synopsis, shortD, longD);
            this.loadParamHelp(cmdConfig, helpElem);
            this.loadParamExamples(cmdConfig, helpElem);
            this.findCommonParamHelp(cmdConfig);
        }
    }

    private void findCommonParamHelp(CommandConfig cmdConfig) {
        for (ParamConfig pc : cmdConfig.getAllParameters()) {
            String context;
            if (!StringUtils.isEmpty(pc.getHelpDescription()) || !this.commonParams.containsKey(context = pc.getContextTitle()) || this.commonParams.get(context) == null || !this.commonParams.get(context).containsKey(pc.getName()) || this.commonParams.get(context).get(pc.getName()) == null) continue;
            String helpDescription = this.commonParams.get(context).get(pc.getName());
            pc.setHelpDescription(StringUtils.stripWSControlChars(helpDescription));
        }
    }

    private void loadParamExamples(CommandConfig cmdConfig, Element helpElem) {
        NodeList examples = helpElem.getElementsByTagName(EXAMPLE);
        for (int i = 0; i < examples.getLength(); ++i) {
            Element example = (Element)examples.item(i);
            String note = StringUtils.stripWSControlChars(XmlUtils.getTextFromChild(example, NOTE));
            String exText = XmlUtils.getCdataFromNode(example);
            cmdConfig.addInputExamples(new ExampleConfig(note, exText));
        }
    }

    private void loadParamHelp(CommandConfig cmdConfig, Element helpElem) {
        NodeList params = helpElem.getElementsByTagName(PARAM);
        for (int i = 0; i < params.getLength(); ++i) {
            Element paramElem = (Element)params.item(i);
            String paramName = paramElem.getAttribute(NAME);
            if (!StringUtils.notEmpty(paramName) || !cmdConfig.getParameterMap().containsKey(paramName)) continue;
            ParamConfig pc = cmdConfig.getParameter(paramName);
            String desc = XmlUtils.getTextFromChild(paramElem, DESCRIPTION);
            pc.setHelpDescription(StringUtils.stripWSControlChars(desc));
        }
    }

    private Map<String, Map<String, String>> getCommonParamHelp(List<Element> helps) {
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>();
        for (Element helpFile : helps) {
            NodeList elems = helpFile.getElementsByTagName(COMMONPARAMETER_HELP);
            for (int i = 0; i < elems.getLength(); ++i) {
                Element cph = (Element)elems.item(i);
                String commonName = cph.getAttribute(TITLE);
                Map<String, String> contextList = null;
                if (!ret.containsKey(commonName)) {
                    contextList = new HashMap();
                    ret.put(commonName, contextList);
                } else {
                    contextList = (Map)ret.get(commonName);
                }
                NodeList params = cph.getElementsByTagName(PARAM);
                for (int j = 0; j < params.getLength(); ++j) {
                    Element param = (Element)params.item(j);
                    contextList.put(param.getAttribute(NAME), param.getChildNodes().item(1).getTextContent());
                }
            }
        }
        return ret;
    }

    private Element findElem(String refName, String elementName, List<Element> helps) {
        Element ret = null;
        block0: for (Element helpFile : helps) {
            NodeList elems = helpFile.getElementsByTagName(elementName);
            for (int i = 0; i < elems.getLength(); ++i) {
                Element cmdHlp = (Element)elems.item(i);
                if (!cmdHlp.getAttribute(REF).equals(refName)) continue;
                ret = cmdHlp;
                continue block0;
            }
        }
        if (ret == null) {
            throw new ConfigurationErrorException("Can't find help ref '" + refName + "': it doesn't appear to exist");
        }
        return ret;
    }
}

