import numpy

arrInt = numpy.ones( (5,5,5), 'i')
arrFloat = numpy.ones( (5,5,5), 'i')
arrValues = numpy.arange(125)
arrValues.shape = (5,5,5)

from Volume.Operators.MapData import MapGridData
mapper = MapGridData()

def test_mapIntToFloat():
    result = mapper(arrInt, datatype=numpy.float32)
    assert result.dtype==numpy.float32
    assert result.shape==(5,5,5)

def test_mapFloatToInt():
    result = mapper(arrFloat, datatype=numpy.int32)
    assert result.dtype==numpy.int32
    assert result.shape==(5,5,5)
    
def test_mapPowerOf2():
    result = mapper(arrValues, powerOf2=True)
    assert result.shape==(8,8,8)

def test_fromlist():
    arrlist = arrFloat.tolist()
    result = mapper(arrInt, datatype=numpy.float32)
    assert result.dtype==numpy.float32
    assert result.shape==(5,5,5)
    
def test_mapping1():
    datamap = {}
    datamap['src_min'] = None
    datamap['src_max'] = None
    datamap['dst_min'] = 0
    datamap['dst_max'] = 248
    datamap['map_type'] = 'linear'
    result = mapper(arrValues, datamap=datamap)
    assert result.dtype.char==arrValues.dtype.char
    assert numpy.maximum.reduce(result.ravel())==248
    assert numpy.minimum.reduce(result.ravel())==0

def test_mapping2():
    datamap = {}
    datamap['src_min'] = 50
    datamap['src_max'] = 100
    datamap['dst_min'] = 0
    datamap['dst_max'] = 248
    datamap['map_type'] = 'linear'
    result = mapper(arrValues, datamap=datamap)
    assert result.dtype.char==arrValues.dtype.char
    assert numpy.maximum.reduce(result.ravel())==248
    assert numpy.minimum.reduce(result.ravel())==0
    assert result[2,0,0] == 0 and arrValues[2,0,0]==50
    assert numpy.minimum.reduce(result[:2,0,0]) == 0
    assert numpy.maximum.reduce(result[:2,0,0]) == 0
    assert numpy.maximum.reduce(result[4:,0,0]) == 248
    assert numpy.minimum.reduce(result[4:,0,0]) == 248


def test_mapAndConvert():
    datamap = {}
    datamap['src_min'] = 50
    datamap['src_max'] = 100
    datamap['dst_min'] = 0
    datamap['dst_max'] = 248
    datamap['map_type'] = 'linear'
    result = mapper(arrValues, datamap=datamap, datatype=numpy.float32)
    assert result.dtype==numpy.float32
    assert numpy.maximum.reduce(result.ravel())==248.
    assert numpy.minimum.reduce(result.ravel())==0.
    assert result[2,0,0] == 0 and arrValues[2,0,0] == 50.
    assert numpy.minimum.reduce(result[:2,0,0]) == 0.
    assert numpy.maximum.reduce(result[:2,0,0]) == 0.
    assert numpy.maximum.reduce(result[4:,0,0]) == 248.
    assert numpy.minimum.reduce(result[4:,0,0]) == 248.

