/*  libtrain simple sample
 *  Copyright (c) 2000 ARINO Kazuma & FURUKAWA Yo.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* $Id: simple.c,v 1.1.1.1 2000/05/07 06:44:33 furukawa Exp $ */

#include <stdio.h>
#include <unistd.h>

#include "libtrain.h"

int main(int argc,char *argv[])
{
    char c;
    extern char *optarg;
    extern int optind;
    int startid, endid;

    Train_Initialize();

    while ((c = getopt(argc,argv,"d:")) != EOF){
	switch(c){
	case 'd':
	    Train_SetDataFile(optarg);
	    break;
	}
    }

#if 0
    {
	int i;
	for (i = 0; i < Train_GetStationCount(); i++){
	    fprintf(stdout, "%s\n", Train_GetStationName(i));
	}
    }
#endif
#if 1
    {
	int cookie = 0;
	int id;
	while ((id = Train_GetStationComplementCandidate("sakura", 6, &cookie)) >= 0){
	    fprintf(stdout, "%s\n", Train_GetStationName(id));
	}
    }
#endif

    startid = Train_SetStartPoint(argv[optind]);
    endid = Train_SetEndPoint(argv[optind + 1]);
    Train_Search(startid, endid);
    
    printf("⤭=%s, Ԥ=%s, ֻ=%s, =%s\n",
	   Train_GetWalkText(),
	   Train_GetWaitText(),
	   Train_GetJoushaText(),
	   Train_GetTotalText());

    printf("%s", Train_GetResultText());
	   
    return 0;
}
