/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.EnumerationType;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import edu.harvard.hul.ois.jhove.Utf8BlockMarker;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class HtmlMetadata {
    private String _title = null;
    private String _lang = null;
    private List _meta = null;
    private String _charset = null;
    private TreeSet _languages = null;
    private List _links = null;
    private List _images = null;
    private List _citations = null;
    private List _defs = null;
    private List _frames = null;
    private List _scripts = null;
    private List _abbrs;
    private TreeSet _entities = null;
    private Property _propUnderConstruction = null;
    private Utf8BlockMarker utf8BM = new Utf8BlockMarker();

    public void setTitle(String string) {
        this._title = string;
    }

    public void setLanguage(String string) {
        this._lang = string;
    }

    public void addLanguage(String string) {
        if (!string.equals(this._lang)) {
            if (this._languages == null) {
                this._languages = new TreeSet();
            }
            this._languages.add(string);
        }
    }

    public void addCitation(String string) {
        if (this._citations == null) {
            this._citations = new LinkedList();
        }
        this._citations.add(string);
    }

    public void addMeta(Property property) {
        String string;
        int n;
        if (this._meta == null) {
            this._meta = new LinkedList();
        }
        this._meta.add(property);
        String string2 = this.extractHttpEquivValue(property, "Content-Type");
        if (string2 != null && (n = string2.indexOf("charset=")) != -1) {
            this.setCharset(string2.substring(n + "charset=".length()));
        }
        if ((string = this.extractHttpEquivValue(property, "Content-Language")) != null) {
            this.setLanguage(string);
        }
    }

    public String extractHttpEquivValue(Property property, String string) {
        Property property2;
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = null;
        Property property3 = property.getByName("Httpequiv");
        if (property3 != null && PropertyArity.SCALAR.equals((EnumerationType)property3.getArity()) && PropertyType.STRING.equals((EnumerationType)property3.getType()) && string.equalsIgnoreCase(string2 = (String)property3.getValue()) && (property2 = property.getByName("Content")) != null && PropertyArity.SCALAR.equals((EnumerationType)property2.getArity()) && PropertyType.STRING.equals((EnumerationType)property2.getType())) {
            string3 = (String)property2.getValue();
        }
        return string3;
    }

    public void setCharset(String string) {
        this._charset = string;
    }

    public void addFrame(Property property) {
        if (this._frames == null) {
            this._frames = new LinkedList();
        }
        this._frames.add(property);
    }

    public void addAbbr(Property property) {
        if (this._abbrs == null) {
            this._abbrs = new LinkedList();
        }
        this._abbrs.add(property);
    }

    public void addLink(String string) {
        if (this._links == null) {
            this._links = new LinkedList();
        }
        this._links.add(string);
    }

    public void addImage(Property property) {
        if (this._images == null) {
            this._images = new LinkedList();
        }
        this._images.add(property);
    }

    public void addDef(String string) {
        if (this._defs == null) {
            this._defs = new LinkedList();
        }
        this._defs.add(string);
    }

    public void addScript(String string) {
        if (this._scripts == null) {
            this._scripts = new LinkedList();
        }
        this._scripts.add(string);
    }

    public void addEntity(String string) {
        if (this._entities == null) {
            this._entities = new TreeSet();
        }
        this._entities.add(string);
    }

    public Utf8BlockMarker getUtf8BlockMarker() {
        return this.utf8BM;
    }

    public String getTitle() {
        return this._title;
    }

    public String getCharset() {
        return this._charset;
    }

    public Property toProperty(TextMDMetadata textMDMetadata) {
        Property property;
        LinkedList<Property> linkedList = new LinkedList<Property>();
        Property property2 = new Property("HTMLMetadata", PropertyType.PROPERTY, PropertyArity.LIST, linkedList);
        if (this._lang != null) {
            linkedList.add(new Property("PrimaryLanguage", PropertyType.STRING, (Object)this._lang));
            if (textMDMetadata != null) {
                textMDMetadata.setLanguage(this._lang);
            }
        }
        if (this._languages != null) {
            linkedList.add(new Property("OtherLanguages", PropertyType.STRING, PropertyArity.SET, (Object)this._languages));
        }
        if (this._title != null) {
            linkedList.add(new Property("Title", PropertyType.STRING, (Object)this._title));
        }
        if (this._meta != null) {
            linkedList.add(new Property("MetaTags", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._meta));
        }
        if (this._frames != null) {
            linkedList.add(new Property("Frames", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._frames));
        }
        if (this._links != null) {
            linkedList.add(new Property("Links", PropertyType.STRING, PropertyArity.LIST, (Object)this._links));
        }
        if (this._scripts != null) {
            linkedList.add(new Property("Scripts", PropertyType.STRING, PropertyArity.LIST, (Object)this._scripts));
        }
        if (this._images != null) {
            linkedList.add(new Property("Images", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._images));
        }
        if (this._citations != null) {
            linkedList.add(new Property("Citations", PropertyType.STRING, PropertyArity.LIST, (Object)this._citations));
        }
        if (this._defs != null) {
            linkedList.add(new Property("DefinedTerms", PropertyType.STRING, PropertyArity.LIST, (Object)this._defs));
        }
        if (this._abbrs != null) {
            linkedList.add(new Property("Abbreviations", PropertyType.PROPERTY, PropertyArity.LIST, (Object)this._abbrs));
        }
        if (this._entities != null) {
            linkedList.add(new Property("Entities", PropertyType.STRING, PropertyArity.SET, (Object)this._entities));
        }
        if (this.utf8BM != null && (property = this.utf8BM.getBlocksUsedProperty("UnicodeEntityBlocks")) != null) {
            linkedList.add(property);
        }
        if (textMDMetadata != null) {
            linkedList.add(new Property("TextMDMetadata", PropertyType.TEXTMDMETADATA, PropertyArity.SCALAR, (Object)textMDMetadata));
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        return property2;
    }

    public void setPropUnderConstruction(Property property) {
        this._propUnderConstruction = property;
    }

    public Property getPropUnderConstruction() {
        return this._propUnderConstruction;
    }

    public void addToPropUnderConstruction(char[] cArray, int n, int n2) {
        if (this._propUnderConstruction != null) {
            String string = new String(cArray, n, n2);
            String string2 = this._propUnderConstruction.getName();
            Object object = this._propUnderConstruction.getValue();
            if ("abbr".equals(string2)) {
                List list = (List)this._propUnderConstruction.getValue();
                Property property = new Property("abbr", PropertyType.STRING, (Object)string);
                list.add(0, property);
            } else if ("title".equals(string2) || "dfn".equals(string2)) {
                this._propUnderConstruction = new Property(string2, PropertyType.STRING, (Object)((String)object + string));
            }
        }
    }

    public void finishPropUnderConstruction() {
        if (this._propUnderConstruction != null) {
            String string = this._propUnderConstruction.getName();
            if ("abbr".equals(string)) {
                this.addAbbr(this._propUnderConstruction);
            } else if ("title".equals(string)) {
                this._title = (String)this._propUnderConstruction.getValue();
            }
            this._propUnderConstruction = null;
        }
    }
}

