/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;

public abstract class Signature {
    private int[] _value;
    private String _stringValue;
    private SignatureType _type;
    private SignatureUseType _use;
    private String _note;

    protected Signature(String string, SignatureType signatureType, SignatureUseType signatureUseType) {
        this(new int[string.length()], signatureType, signatureUseType);
        int n = string.length();
        this._stringValue = string;
        for (int i = 0; i < n; ++i) {
            this._value[i] = string.charAt(i);
        }
    }

    protected Signature(int[] nArray, SignatureType signatureType, SignatureUseType signatureUseType) {
        this._value = nArray;
        this._type = signatureType;
        this._use = signatureUseType;
        this._stringValue = null;
    }

    protected Signature(String string, SignatureType signatureType, SignatureUseType signatureUseType, String string2) {
        this(new int[string.length()], signatureType, signatureUseType, string2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this._value[i] = string.charAt(i);
        }
        this._stringValue = string;
    }

    protected Signature(int[] nArray, SignatureType signatureType, SignatureUseType signatureUseType, String string) {
        this(nArray, signatureType, signatureUseType);
        this._note = string;
    }

    public SignatureType getType() {
        return this._type;
    }

    public SignatureUseType getUse() {
        return this._use;
    }

    public int[] getValue() {
        return this._value;
    }

    public String getNote() {
        return this._note;
    }

    public boolean isStringValue() {
        return this._stringValue != null;
    }

    public String getValueString() {
        return this._stringValue;
    }

    public String getValueHexString() {
        StringBuffer stringBuffer = new StringBuffer("0x");
        for (int i = 0; i < this._value.length; ++i) {
            int n = this._value[i];
            if (n < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }
}

