/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JInternalFrameAction;
import org.fest.swing.driver.JInternalFrameCloseTask;
import org.fest.swing.driver.JInternalFrameIconQuery;
import org.fest.swing.driver.JInternalFrameSetIconTask;
import org.fest.swing.driver.JInternalFrameSetMaximumTask;
import org.fest.swing.driver.WindowLikeContainerLocations;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.Pair;
import org.fest.swing.util.Triple;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JInternalFrameDriver
extends JComponentDriver {
    public JInternalFrameDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void moveToFront(JInternalFrame internalFrame) {
        JInternalFrameDriver.toFront(internalFrame);
    }

    @RunsInEDT
    private static void toFront(final JInternalFrame internalFrame) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                internalFrame.toFront();
            }
        });
    }

    @RunsInEDT
    public void moveToBack(JInternalFrame internalFrame) {
        JInternalFrameDriver.toBack(internalFrame);
    }

    @RunsInEDT
    private static void toBack(final JInternalFrame internalFrame) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                internalFrame.moveToBack();
            }
        });
    }

    @RunsInEDT
    public void maximize(JInternalFrame internalFrame) {
        Pair<Container, Point> maximizeLocation = JInternalFrameDriver.validateAndFindMaximizeLocation(internalFrame);
        this.maximizeOrNormalize(internalFrame, JInternalFrameAction.MAXIMIZE, maximizeLocation);
    }

    @RunsInEDT
    private static Pair<Container, Point> validateAndFindMaximizeLocation(final JInternalFrame internalFrame) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Container, Point>>(){

            @Override
            protected Pair<Container, Point> executeInEDT() {
                JInternalFrameDriver.validateCanMaximize(internalFrame);
                return JInternalFrameDriver.findMaximizeLocation(internalFrame);
            }
        });
    }

    @RunsInCurrentThread
    private static void validateCanMaximize(JInternalFrame internalFrame) {
        JInternalFrameDriver.validateIsShowingOrIconified(internalFrame);
        if (!internalFrame.isMaximizable()) {
            throw new IllegalStateException(Strings.concat((Object[])new Object[]{"The JInternalFrame <", Formatting.format(internalFrame), "> is not maximizable"}));
        }
    }

    @RunsInEDT
    public void normalize(JInternalFrame internalFrame) {
        Pair<Container, Point> normalizeLocation = JInternalFrameDriver.validateAndFindNormalizeLocation(internalFrame);
        this.maximizeOrNormalize(internalFrame, JInternalFrameAction.NORMALIZE, normalizeLocation);
    }

    @RunsInEDT
    private static Pair<Container, Point> validateAndFindNormalizeLocation(final JInternalFrame internalFrame) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Container, Point>>(){

            @Override
            protected Pair<Container, Point> executeInEDT() {
                JInternalFrameDriver.validateIsShowingOrIconified(internalFrame);
                return JInternalFrameDriver.findMaximizeLocation(internalFrame);
            }
        });
    }

    @RunsInCurrentThread
    private static void validateIsShowingOrIconified(JInternalFrame internalFrame) {
        if (!internalFrame.isIcon()) {
            ComponentStateValidator.validateIsShowing(internalFrame);
        }
    }

    @RunsInCurrentThread
    private static Pair<Container, Point> findMaximizeLocation(JInternalFrame internalFrame) {
        JComponent clickTarget = internalFrame.isIcon() ? internalFrame.getDesktopIcon() : internalFrame;
        Point location = WindowLikeContainerLocations.maximizeLocationOf(clickTarget);
        return new Pair<Container, Point>(clickTarget, location);
    }

    @RunsInEDT
    private void maximizeOrNormalize(JInternalFrame internalFrame, JInternalFrameAction action, Pair<Container, Point> toMoveMouseTo) {
        this.moveMouseIgnoringAnyError((Component)toMoveMouseTo.i, (Point)toMoveMouseTo.ii);
        this.setMaximumProperty(internalFrame, action);
    }

    @RunsInEDT
    private void setMaximumProperty(JInternalFrame internalFrame, JInternalFrameAction action) {
        try {
            JInternalFrameSetMaximumTask.setMaximum(internalFrame, action);
            this.robot.waitForIdle();
        }
        catch (UnexpectedException unexpected) {
            this.failIfVetoed(internalFrame, action, unexpected);
        }
    }

    @RunsInEDT
    public void iconify(JInternalFrame internalFrame) {
        Pair<Boolean, Point> iconifyInfo = JInternalFrameDriver.validateAndfindIconifyInfo(internalFrame);
        if (((Boolean)iconifyInfo.i).booleanValue()) {
            return;
        }
        this.moveMouseIgnoringAnyError(internalFrame, (Point)iconifyInfo.ii);
        this.setIconProperty(internalFrame, JInternalFrameAction.ICONIFY);
    }

    @RunsInEDT
    private static Pair<Boolean, Point> validateAndfindIconifyInfo(final JInternalFrame internalFrame) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() throws Throwable {
                JInternalFrameDriver.validateIsShowingOrIconified(internalFrame);
                if (!internalFrame.isIconifiable()) {
                    throw new IllegalStateException(Strings.concat((Object[])new Object[]{"The JInternalFrame <", Formatting.format(internalFrame), "> is not iconifiable"}));
                }
                return JInternalFrameDriver.iconifyInfo(internalFrame);
            }
        });
    }

    @RunsInCurrentThread
    private static Pair<Boolean, Point> iconifyInfo(JInternalFrame internalFrame) {
        boolean iconified = JInternalFrameIconQuery.isIconified(internalFrame);
        if (iconified) {
            return new Pair<Boolean, Object>(true, null);
        }
        return new Pair<Boolean, Point>(iconified, JInternalFrameDriver.findIconifyLocation(internalFrame));
    }

    @RunsInEDT
    public void deiconify(JInternalFrame internalFrame) {
        Triple<Boolean, Container, Point> deiconifyInfo = JInternalFrameDriver.validateAndfindDeiconifyInfo(internalFrame);
        if (((Boolean)deiconifyInfo.i).booleanValue()) {
            return;
        }
        this.moveMouseIgnoringAnyError((Component)deiconifyInfo.ii, (Point)deiconifyInfo.iii);
        this.setIconProperty(internalFrame, JInternalFrameAction.DEICONIFY);
    }

    @RunsInEDT
    private static Triple<Boolean, Container, Point> validateAndfindDeiconifyInfo(final JInternalFrame internalFrame) {
        return GuiActionRunner.execute(new GuiQuery<Triple<Boolean, Container, Point>>(){

            @Override
            protected Triple<Boolean, Container, Point> executeInEDT() throws Throwable {
                JInternalFrameDriver.validateIsShowingOrIconified(internalFrame);
                return JInternalFrameDriver.deiconifyInfo(internalFrame);
            }
        });
    }

    @RunsInCurrentThread
    private static Triple<Boolean, Container, Point> deiconifyInfo(JInternalFrame internalFrame) {
        boolean deiconified;
        boolean bl = deiconified = !JInternalFrameIconQuery.isIconified(internalFrame);
        if (deiconified) {
            return new Triple<Boolean, Object, Object>(true, null, null);
        }
        JInternalFrame.JDesktopIcon desktopIcon = internalFrame.getDesktopIcon();
        return new Triple<Boolean, Container, Point>(deiconified, desktopIcon, WindowLikeContainerLocations.iconifyLocationOf(desktopIcon));
    }

    @RunsInCurrentThread
    private static Point findIconifyLocation(JInternalFrame internalFrame) {
        return WindowLikeContainerLocations.iconifyLocationOf(internalFrame.getDesktopIcon());
    }

    @RunsInEDT
    private void setIconProperty(JInternalFrame internalFrame, JInternalFrameAction action) {
        try {
            JInternalFrameSetIconTask.setIcon(internalFrame, action);
            this.robot.waitForIdle();
        }
        catch (UnexpectedException unexpected) {
            this.failIfVetoed(internalFrame, action, unexpected);
        }
    }

    @VisibleForTesting
    void failIfVetoed(JInternalFrame internalFrame, JInternalFrameAction action, UnexpectedException unexpected) {
        PropertyVetoException vetoError = this.vetoFrom(unexpected);
        if (vetoError == null) {
            return;
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{action.name, " of ", Formatting.format(internalFrame), " was vetoed: <", vetoError.getMessage(), ">"}));
    }

    private PropertyVetoException vetoFrom(UnexpectedException unexpected) {
        Throwable cause = unexpected.getCause();
        if (!(cause instanceof PropertyVetoException)) {
            return null;
        }
        return (PropertyVetoException)cause;
    }

    @RunsInEDT
    public void resizeWidthTo(JInternalFrame internalFrame, int width) {
        this.resizeWidth(internalFrame, width);
    }

    @RunsInEDT
    public void resizeHeightTo(JInternalFrame w, int height) {
        this.resizeHeight(w, height);
    }

    @RunsInEDT
    public void resizeTo(JInternalFrame internalFrame, Dimension size) {
        this.resize(internalFrame, size.width, size.height);
    }

    @RunsInEDT
    public void moveTo(JInternalFrame internalFrame, Point where) {
        this.move(internalFrame, where.x, where.y);
    }

    @RunsInEDT
    public void close(JInternalFrame internalFrame) {
        Pair<Boolean, Point> closeInfo = JInternalFrameDriver.validateAndFindCloseInfo(internalFrame);
        if (((Boolean)closeInfo.i).booleanValue()) {
            return;
        }
        this.moveMouseIgnoringAnyError(internalFrame, (Point)closeInfo.ii);
        JInternalFrameCloseTask.close(internalFrame);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static Pair<Boolean, Point> validateAndFindCloseInfo(final JInternalFrame internalFrame) {
        return GuiActionRunner.execute(new GuiQuery<Pair<Boolean, Point>>(){

            @Override
            protected Pair<Boolean, Point> executeInEDT() {
                JInternalFrameDriver.validateCanClose(internalFrame);
                return JInternalFrameDriver.closeInfo(internalFrame);
            }
        });
    }

    @RunsInCurrentThread
    private static void validateCanClose(JInternalFrame internalFrame) {
        ComponentStateValidator.validateIsShowing(internalFrame);
        if (!internalFrame.isClosable()) {
            throw new IllegalStateException(Strings.concat((Object[])new Object[]{"The JInternalFrame <", Formatting.format(internalFrame), "> is not closable"}));
        }
    }

    @RunsInCurrentThread
    private static Pair<Boolean, Point> closeInfo(JInternalFrame internalFrame) {
        if (internalFrame.isClosed()) {
            return new Pair<Boolean, Object>(true, null);
        }
        return new Pair<Boolean, Point>(false, WindowLikeContainerLocations.closeLocationOf(internalFrame));
    }
}

