/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import org.fest.swing.core.FocusOwnerFinder;

final class FocusMonitor
extends FocusAdapter {
    private volatile boolean focused = false;

    static FocusMonitor attachTo(Component c) {
        FocusMonitor monitor = new FocusMonitor(c);
        c.addFocusListener(monitor);
        return monitor;
    }

    private FocusMonitor(Component c) {
        this.focused = FocusOwnerFinder.focusOwner() == c;
    }

    public void focusGained(FocusEvent e) {
        this.focused = true;
    }

    public void focusLost(FocusEvent e) {
        this.focused = false;
    }

    boolean hasFocus() {
        return this.focused;
    }
}

