/*
 * Decompiled with CFR 0.152.
 */
package org.ibex.nestedvm.util;

public final class Sort {
    private static final CompareFunc comparableCompareFunc = new CompareFunc(){

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    };

    private Sort() {
    }

    public static void sort(Comparable[] comparableArray) {
        Sort.sort(comparableArray, comparableCompareFunc);
    }

    public static void sort(Object[] objectArray, CompareFunc compareFunc) {
        Sort.sort(objectArray, compareFunc, 0, objectArray.length - 1);
    }

    private static void sort(Object[] objectArray, CompareFunc compareFunc, int n, int n2) {
        Object object;
        if (n >= n2) {
            return;
        }
        if (n2 - n <= 6) {
            for (int i = n + 1; i <= n2; ++i) {
                Object object2 = objectArray[i];
                for (int j = i - 1; j >= n && compareFunc.compare(objectArray[j], object2) > 0; --j) {
                    objectArray[j + 1] = objectArray[j];
                }
                objectArray[j + 1] = object2;
            }
            return;
        }
        Object object3 = objectArray[n2];
        int n3 = n - 1;
        int n4 = n2;
        while (true) {
            if (n3 < n4 && compareFunc.compare(objectArray[++n3], object3) < 0) {
                continue;
            }
            while (n4 > n3 && compareFunc.compare(objectArray[--n4], object3) > 0) {
            }
            object = objectArray[n3];
            objectArray[n3] = objectArray[n4];
            objectArray[n4] = object;
            if (n3 >= n4) break;
        }
        object = objectArray[n3];
        objectArray[n3] = objectArray[n2];
        objectArray[n2] = object;
        Sort.sort(objectArray, compareFunc, n, n3 - 1);
        Sort.sort(objectArray, compareFunc, n3 + 1, n2);
    }

    public static interface CompareFunc {
        public int compare(Object var1, Object var2);
    }

    public static interface Comparable {
        public int compareTo(Object var1);
    }
}

