/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserListByPathRequest;
import com.amazonaws.services.identitymanagement.model.ListUsersRequest;
import com.amazonaws.services.identitymanagement.model.ListUsersResult;
import com.amazonaws.services.identitymanagement.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserListByPathDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserListByPathDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserListByPathRequest) {
            LOG.debug((Object)("List users " + request));
            UserListByPathRequest req = (UserListByPathRequest)request;
            ListUsersRequest listUsersRequest = new ListUsersRequest();
            listUsersRequest.setPathPrefix(req.getListPath());
            listUsersRequest.setMarker(req.getMarker());
            listUsersRequest.setMaxItems(req.getMaxItems());
            LOG.debug((Object)"List users by path prefix");
            ListUsersResult result = this.getClient().listUsers(listUsersRequest);
            for (User user : result.getUsers()) {
                LOG.info((Object)user.getArn());
            }
            LOG.info((Object)("IsTruncated: " + result.getIsTruncated()));
            if (result.getIsTruncated().booleanValue()) {
                LOG.info((Object)("Marker: " + result.getMarker()));
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

