https://gitlab.com/eztrace/eztrace/-/merge_requests/34

---
 src/eztrace.c.in                 |    3 +++
 src/modules/python/eztrace.py.in |    7 ++++++-
 test/python/CMakeLists.txt       |    1 +
 test/python/run.sh               |   16 ++++++++--------
 4 files changed, 18 insertions(+), 9 deletions(-)

--- a/test/python/CMakeLists.txt
+++ b/test/python/CMakeLists.txt
@@ -11,6 +11,7 @@ if (EZTRACE_ENABLE_PYTHON)
   set_property(TEST ${test_list}
     PROPERTY ENVIRONMENT
     "EZTRACE_LIBRARY_PATH=${EZTRACE_LIBRARY_PATH}"
+    "EZTRACE_PY_PATH=${CMAKE_BINARY_DIR}/src/modules/python/eztrace.py"
     ${TEST_ENVIRONMENT}
   )
 endif()
--- a/src/eztrace.c.in
+++ b/src/eztrace.c.in
@@ -238,6 +238,9 @@ int main(int argc, char **argv) {
   // init binary & catch all modules
   if(python_mode) {
     set_python_path();
+    char *path = getenv("EZTRACE_PY_PATH");
+    if (path)
+      eztrace_py_path = path;
     bin = pptrace_prepare_binary(python_executable);
     if (!bin) {
       fprintf(stderr, "Unable to load binary %s\n", python_executable);
--- a/src/modules/python/eztrace.py.in
+++ b/src/modules/python/eztrace.py.in
@@ -1,6 +1,7 @@
 #!/usr/bin/env python
 # encoding: utf-8
 import sys
+import os
 import importlib.util
 
 # Verify args
@@ -13,7 +14,11 @@ else:
 
 # Load the eztracepython module
 eztpy_module_name = "eztracepython"
-libdir = "@CMAKE_INSTALL_PREFIX@/@CMAKE_INSTALL_LIBDIR@/libeztrace-python.so"
+eztrace_library_path=os.getenv("EZTRACE_LIBRARY_PATH")
+if eztrace_library_path:
+    libdir = eztrace_library_path.split(":")[-1]+"/libeztrace-python.so"
+else:
+    libdir = "@CMAKE_INSTALL_PREFIX@/@CMAKE_INSTALL_LIBDIR@/libeztrace-python.so"
 eztpy_spec = importlib.util.spec_from_file_location(eztpy_module_name, libdir)
 eztpy_module = importlib.util.module_from_spec(eztpy_spec)
 sys.modules[eztpy_module_name] = eztpy_module
--- a/test/python/run.sh
+++ b/test/python/run.sh
@@ -1,10 +1,11 @@
 #!/bin/bash
 CUR_PATH=$(dirname  $(realpath $0))
 
-if [ $# -gt 0 ]; then
-    # if the script is invoked from make test, the binary is already compiled in CMAKE_BINARY_DI
-    export BUILD_DIR="$1"
-fi
+# Python programs don't need to compile
+#if [ $# -gt 0 ]; then
+#    # if the script is invoked from make test, the binary is already compiled in CMAKE_BINARY_DI
+#    export BUILD_DIR="$1"
+#fi
 
 source "$CUR_PATH/../test_utils/test_utils.sh"
 
@@ -12,10 +13,9 @@ check_dependencies "$OTF2_PRINT_PATH" ||
 check_module "python" || exit 1
 
 # Building tests
-# Python programs don't need to compile
-#if [ -z "$BUILD_DIR" ]; then
-#    check_compilation || exit 1
-#fi
+if [ -z "$BUILD_DIR" ]; then
+    check_compilation || exit 1
+fi
 
 nfailed=0
 # Running test scripts
