/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_GTY.C $
   $Locker: ska $	$Name:  $	$State: Exp $

ob(ject): cfgi_getType
su(bsystem): inifile
ty(pe): 
sy(nopsis): 
sh(ort description): Extract type and trustlevel from a value name
he(ader files): 
lo(ng description): Extracts the type and trustlevel form a name of a value.
	The name must not contain any data, e.g. must not contain an
	equal sign '='.
pr(erequistes): strchr(name, '=') == NULL
va(lue): pointer behind the first character NOT used for type or trustlevel,
	this can be the '\0' terminator, if neither type nor trustlevel was
	specified.
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfgi_gty.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <ctype.h>
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_GTY.C 1.4 1999/12/13 02:22:11 ska Exp ska $";
#endif

char *cfgi_getType(const char * const name, int * const trustlevel
	, int * const type)
{	char *p;
	int i, s;

	DBG_ENTER("cfgi_getType", Suppl_cmdline)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	assert(name);
	assert(trustlevel);
	assert(type);
	chkHeap

	*trustlevel = 0;
	*type = CFG_TNONE;

	p = strchr(name, '\0');
	if(p > name && *--p == '>') {		/* parse trustlevel */
		i = 0;
		s = 1;
		while(--p >= name && isdigit(*p))
			i += (*p - '0') * s, s *= 10;
		if(p < name || *p != '<') {		/* no trustlevel --> no type */
			DBG_STRING("Syntax error scanning trustlevel")
			DBG_RETURN_VALUES(("tail=\"\", type=0x%x, lvl=%d", p + 1, *type, *trustlevel) )
			DBG_LEAVE( strchr(p, '\0'))
		}
		*trustlevel = i;
		--p;
	}
	chkHeap

	/* check for expandable flag */
	if(p >= name && *p == '!')
		*type = CFG_TEXPAND, --p;
	chkHeap

	if(p >= name) switch(*p) {
	case '$':	*type |= CFG_TSTRING;	goto ret;
	case '%':	*type |= CFG_TINTEGER;	goto ret;
	case '?':	*type |= CFG_TBOOLEAN;	goto ret;
	}
	/* no type ID --> restore this character */
	++p;

ret:
	DBG_RETURN_VALUES(("tail=\"%s\", type=0x%x, lvl=%d", p + 1, *type, *trustlevel) )
	chkHeap
	DBG_LEAVE(p)
}
