/*
 * Descent 3
 * Copyright (C) 2024 Parallax Software
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// SrvrItem.cpp : implementation of the CEditorSrvrItem class
//

#include "stdafx.h"
#include "editor.h"

#include "editorDoc.h"
#include "SrvrItem.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditorSrvrItem implementation

IMPLEMENT_DYNAMIC(CEditorSrvrItem, COleServerItem)

CEditorSrvrItem::CEditorSrvrItem(CEditorDoc *pContainerDoc) : COleServerItem(pContainerDoc, TRUE) {
  // TODO: add one-time construction code here
  //  (eg, adding additional clipboard formats to the item's data source)
}

CEditorSrvrItem::~CEditorSrvrItem() {
  // TODO: add cleanup code here
}

void CEditorSrvrItem::Serialize(CArchive &ar) {
  // CEditorSrvrItem::Serialize will be called by the framework if
  //  the item is copied to the clipboard.  This can happen automatically
  //  through the OLE callback OnGetClipboardData.  A good default for
  //  the embedded item is simply to delegate to the document's Serialize
  //  function.  If you support links, then you will want to serialize
  //  just a portion of the document.

  if (!IsLinkedItem()) {
    CEditorDoc *pDoc = GetDocument();
    ASSERT_VALID(pDoc);
    pDoc->Serialize(ar);
  }
}

BOOL CEditorSrvrItem::OnGetExtent(DVASPECT dwDrawAspect, CSize &rSize) {
  // Most applications, like this one, only handle drawing the content
  //  aspect of the item.  If you wish to support other aspects, such
  //  as DVASPECT_THUMBNAIL (by overriding OnDrawEx), then this
  //  implementation of OnGetExtent should be modified to handle the
  //  additional aspect(s).

  if (dwDrawAspect != DVASPECT_CONTENT)
    return COleServerItem::OnGetExtent(dwDrawAspect, rSize);

  // CEditorSrvrItem::OnGetExtent is called to get the extent in
  //  HIMETRIC units of the entire item.  The default implementation
  //  here simply returns a hard-coded number of units.

  CEditorDoc *pDoc = GetDocument();
  ASSERT_VALID(pDoc);

  // TODO: replace this arbitrary size

  rSize = CSize(3000, 3000); // 3000 x 3000 HIMETRIC units

  return TRUE;
}

BOOL CEditorSrvrItem::OnDraw(CDC *pDC, CSize &rSize) {
  // Remove this if you use rSize
  UNREFERENCED_PARAMETER(rSize);

  CEditorDoc *pDoc = GetDocument();
  ASSERT_VALID(pDoc);

  // TODO: set mapping mode and extent
  //  (The extent is usually the same as the size returned from OnGetExtent)
  pDC->SetMapMode(MM_ANISOTROPIC);
  pDC->SetWindowOrg(0, 0);
  pDC->SetWindowExt(3000, 3000);

  // TODO: add drawing code here.  Optionally, fill in the HIMETRIC extent.
  //  All drawing takes place in the metafile device context (pDC).

  return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CEditorSrvrItem diagnostics

#ifdef _DEBUG
void CEditorSrvrItem::AssertValid() const { COleServerItem::AssertValid(); }

void CEditorSrvrItem::Dump(CDumpContext &dc) const { COleServerItem::Dump(dc); }
#endif

/////////////////////////////////////////////////////////////////////////////
