/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.impl;

import com.google.gwt.core.client.GWT;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class DevModeLoggingFixes {
    private static Logger root = null;

    public static String getLoggerName(LogRecord record) {
        if (record.getLoggerName() != null) {
            return DevModeLoggingFixes.removeLoggerPrefix(record.getLoggerName());
        }
        return null;
    }

    public static String getName(Logger logger) {
        if (logger.getName() != null) {
            return DevModeLoggingFixes.removeLoggerPrefix(logger.getName());
        }
        return null;
    }

    public static Logger loggerGetLogger(String name) {
        if (root == null) {
            root = Logger.getLogger(DevModeLoggingFixes.getPrefixName());
            root.setUseParentHandlers(false);
        }
        return Logger.getLogger(DevModeLoggingFixes.addLoggerPrefix(name));
    }

    public static Logger logManagerGetLogger(LogManager manager, String name) {
        return manager.getLogger(DevModeLoggingFixes.addLoggerPrefix(name));
    }

    private static String addLoggerPrefix(String name) {
        return DevModeLoggingFixes.getLoggerPrefix() + name;
    }

    private static String getLoggerPrefix() {
        return DevModeLoggingFixes.getPrefixName() + ".";
    }

    private static String getPrefixName() {
        return GWT.getUniqueThreadId();
    }

    private static String removeLoggerPrefix(String name) {
        return name.replaceFirst("^" + DevModeLoggingFixes.getLoggerPrefix(), "");
    }
}

