/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ne" locale.
 */
public class LocalizedNamesImpl_ne extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "NP",
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "CP",
        "DG",
        "EA",
        "GS",
        "IC",
        "TA",
        "AO",
        "AZ",
        "AQ",
        "AD",
        "AF",
        "AS",
        "AR",
        "AX",
        "DZ",
        "AL",
        "AT",
        "AU",
        "IM",
        "CI",
        "IE",
        "IS",
        "AI",
        "AW",
        "AM",
        "EC",
        "EG",
        "IL",
        "IT",
        "ET",
        "ID",
        "IQ",
        "IR",
        "EE",
        "UZ",
        "KP",
        "MP",
        "AG",
        "ER",
        "SV",
        "OM",
        "QA",
        "KH",
        "KZ",
        "KI",
        "KG",
        "CK",
        "KW",
        "CF",
        "KE",
        "CV",
        "KY",
        "CC",
        "CD",
        "CG",
        "KM",
        "CO",
        "CR",
        "CA",
        "CM",
        "CU",
        "CX",
        "HR",
        "GM",
        "GA",
        "GN",
        "GW",
        "GG",
        "GY",
        "GU",
        "GL",
        "GR",
        "GD",
        "GT",
        "GP",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "JM",
        "DE",
        "JE",
        "JP",
        "ZM",
        "GI",
        "ZW",
        "GE",
        "JO",
        "TR",
        "TN",
        "TO",
        "TG",
        "DJ",
        "DK",
        "DO",
        "DM",
        "TW",
        "TJ",
        "TZ",
        "TV",
        "TM",
        "TC",
        "TK",
        "TT",
        "TH",
        "ZA",
        "KR",
        "NC",
        "NO",
        "NE",
        "NG",
        "NR",
        "NA",
        "NI",
        "NU",
        "NL",
        "AN",
        "NP",
        "NF",
        "NZ",
        "PA",
        "PG",
        "PW",
        "EH",
        "PK",
        "PN",
        "TL",
        "PE",
        "PT",
        "PL",
        "PY",
        "PS",
        "PR",
        "FK",
        "FO",
        "FJ",
        "FI",
        "PH",
        "FR",
        "GF",
        "TF",
        "PF",
        "BD",
        "BF",
        "BM",
        "BG",
        "BS",
        "BB",
        "QO",
        "BH",
        "BV",
        "BI",
        "BJ",
        "VG",
        "IO",
        "BY",
        "BZ",
        "BE",
        "BW",
        "BO",
        "BA",
        "BR",
        "BN",
        "VU",
        "IN",
        "VN",
        "BT",
        "GQ",
        "VA",
        "VE",
        "MO",
        "MN",
        "MG",
        "MY",
        "FM",
        "MU",
        "MR",
        "YT",
        "MQ",
        "MH",
        "MW",
        "ML",
        "MT",
        "MD",
        "MV",
        "MX",
        "MZ",
        "MC",
        "MS",
        "ME",
        "MA",
        "MK",
        "MM",
        "UA",
        "UG",
        "UY",
        "EU",
        "YE",
        "RW",
        "RE",
        "RU",
        "RO",
        "LU",
        "LR",
        "LA",
        "LV",
        "LI",
        "LT",
        "LY",
        "LB",
        "LS",
        "WF",
        "LK",
        "GB",
        "AE",
        "US",
        "UM",
        "VI",
        "SJ",
        "RS",
        "CY",
        "SA",
        "ST",
        "SM",
        "WS",
        "SL",
        "SG",
        "SY",
        "SD",
        "SR",
        "SC",
        "SN",
        "KN",
        "PM",
        "BL",
        "VC",
        "MF",
        "LC",
        "SH",
        "SO",
        "SB",
        "ES",
        "SK",
        "SI",
        "SZ",
        "CH",
        "SE",
        "HK",
        "HU",
        "HN",
        "HM",
        "HT",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "विश्व");
    namesMap.put("002", "अफ्रिका");
    namesMap.put("003", "उत्तर अमेरिका");
    namesMap.put("005", "दक्षिण अमेरिका");
    namesMap.put("009", "ओसनिया");
    namesMap.put("011", "पश्चिमी अफ्रिका");
    namesMap.put("013", "केन्द्रीय अमेरिका");
    namesMap.put("014", "पूर्वी अफ्रिका");
    namesMap.put("015", "उत्तरी अफ्रिका");
    namesMap.put("017", "मध्य अफ्रिका");
    namesMap.put("018", "दक्षिणी अफ्रिका");
    namesMap.put("019", "अमेरिकास");
    namesMap.put("021", "उत्तरी अमेरिका");
    namesMap.put("029", "क्यारिबिएन");
    namesMap.put("030", "पूर्वी एशिया");
    namesMap.put("034", "दक्षिणी एशिया");
    namesMap.put("035", "दक्षिण पूर्वी एशिया");
    namesMap.put("039", "दक्षिणी युरोप");
    namesMap.put("053", "अष्ट्रेलिया र न्युजिल्याण्ड");
    namesMap.put("054", "मेलानेसिया");
    namesMap.put("057", "माइक्रोनेसियाली क्षेत्र");
    namesMap.put("061", "पोलिनेशिया");
    namesMap.put("062", "दक्षिण मध्य एशिया");
    namesMap.put("142", "एशिया");
    namesMap.put("143", "केन्द्रीय एशिया");
    namesMap.put("145", "पश्चिमी एशिया");
    namesMap.put("150", "युरोप");
    namesMap.put("151", "पूर्वी युरोप");
    namesMap.put("154", "उत्तरी युरोप");
    namesMap.put("155", "पश्चिमी युरोप");
    namesMap.put("172", "कमनवेल्थका स्वतन्त्र राज्यहरू");
    namesMap.put("419", "ल्याटिन अमेरिका तथा क्यारिबियन");
    namesMap.put("AD", "अन्डोर्रा");
    namesMap.put("AE", "संयुक्त अरब इमिराट्स");
    namesMap.put("AF", "अफ्गानिष्तान");
    namesMap.put("AG", "एन्टिगुआ र बारबुडा");
    namesMap.put("AI", "आङ्गुइला");
    namesMap.put("AL", "अल्बानिया");
    namesMap.put("AM", "आर्मेनिया");
    namesMap.put("AN", "नेदरल्याण्ड्स एण्टिलिस");
    namesMap.put("AO", "अङ्गोला");
    namesMap.put("AQ", "अन्टारतिका");
    namesMap.put("AR", "अर्जेण्टिना");
    namesMap.put("AS", "अमेरिकी समोआ");
    namesMap.put("AT", "अष्ट्रिया");
    namesMap.put("AU", "अष्ट्रेलिया");
    namesMap.put("AW", "आरूबा");
    namesMap.put("AX", "अलान्ड टापु");
    namesMap.put("AZ", "अजरबैजान");
    namesMap.put("BA", "बोस्निया र हर्जगोभिनिया");
    namesMap.put("BB", "बार्बाडोस");
    namesMap.put("BD", "बङ्गलादेश");
    namesMap.put("BE", "बेल्जियम");
    namesMap.put("BF", "बर्किना फासो");
    namesMap.put("BG", "बल्गेरिया");
    namesMap.put("BH", "बाह्रेन");
    namesMap.put("BI", "बुरूण्डी");
    namesMap.put("BJ", "बेनिन");
    namesMap.put("BL", "सेन्ट बार्थालेमी");
    namesMap.put("BM", "बर्मुडा");
    namesMap.put("BN", "ब्रुनाइ");
    namesMap.put("BO", "बोलिभिया");
    namesMap.put("BR", "ब्राजिल");
    namesMap.put("BS", "बहामास");
    namesMap.put("BT", "भुटान");
    namesMap.put("BV", "बुभेट टापु");
    namesMap.put("BW", "बोट्स्वाना");
    namesMap.put("BY", "बेलारूस");
    namesMap.put("BZ", "बेलिज");
    namesMap.put("CA", "क्यानाडा");
    namesMap.put("CC", "कोकोस टापु");
    namesMap.put("CD", "कोङ्गो-किन्शासा");
    namesMap.put("CF", "केन्द्रीय अफ्रिकी गणतन्त्र");
    namesMap.put("CG", "कोङ्गो - ब्राज्जाभिल्ले");
    namesMap.put("CH", "स्विजरल्याण्ड");
    namesMap.put("CI", "आइभोरी कोष्ट");
    namesMap.put("CK", "कुक टापु");
    namesMap.put("CL", "चिली");
    namesMap.put("CM", "क्यामेरून");
    namesMap.put("CN", "चीन");
    namesMap.put("CO", "कोलोम्बिया");
    namesMap.put("CR", "कोष्टारिका");
    namesMap.put("CU", "क्युबा");
    namesMap.put("CV", "केप भर्डे");
    namesMap.put("CX", "क्रिष्टमस टापु");
    namesMap.put("CY", "साइप्रस");
    namesMap.put("CZ", "चेख गणतन्त्र");
    namesMap.put("DE", "जर्मनी");
    namesMap.put("DJ", "डिजिबुटी");
    namesMap.put("DK", "डेन्मार्क");
    namesMap.put("DM", "डोमिनिका");
    namesMap.put("DO", "डोमिनिकन गणतन्त्र");
    namesMap.put("DZ", "अल्जेरिया");
    namesMap.put("EC", "इक्वडेर");
    namesMap.put("EE", "इस्टोनिया");
    namesMap.put("EG", "इजिप्ट");
    namesMap.put("EH", "पश्चिमी साहारा");
    namesMap.put("ER", "एरित्रिया");
    namesMap.put("ES", "स्पेन");
    namesMap.put("ET", "इथोपिया");
    namesMap.put("EU", "युरोपियन युनियन");
    namesMap.put("FI", "फिन्ल्याण्ड");
    namesMap.put("FJ", "फिजी");
    namesMap.put("FK", "फकल्याण्ड टापु");
    namesMap.put("FM", "माइक्रोनेसिया");
    namesMap.put("FO", "फारोर टापु");
    namesMap.put("FR", "फ्रान्स");
    namesMap.put("GA", "गावोन");
    namesMap.put("GB", "संयुक्त अधिराज्य");
    namesMap.put("GD", "ग्रेनाडा");
    namesMap.put("GE", "जोर्जिया");
    namesMap.put("GF", "फ्रान्सेली गायना");
    namesMap.put("GG", "गुएर्नसे");
    namesMap.put("GH", "घाना");
    namesMap.put("GI", "जिब्राल्टार");
    namesMap.put("GL", "ग्रिनल्याण्ड");
    namesMap.put("GM", "गाम्विया");
    namesMap.put("GN", "गिनी");
    namesMap.put("GP", "ग्वाडेलुप");
    namesMap.put("GQ", "भू-मध्यीय गिनी");
    namesMap.put("GR", "ग्रिश");
    namesMap.put("GT", "ग्वाटेमाला");
    namesMap.put("GU", "गुवाम");
    namesMap.put("GW", "गिनी-बिसाउ");
    namesMap.put("GY", "गुयाना");
    namesMap.put("HK", "हङकङ");
    namesMap.put("HM", "हर्ड टापु र म्याकडोनाल्ड टापु");
    namesMap.put("HN", "हन्डुरास");
    namesMap.put("HR", "क्रोएशिया");
    namesMap.put("HT", "हैटी");
    namesMap.put("HU", "हङ्गेरी");
    namesMap.put("ID", "इन्डोनेशिया");
    namesMap.put("IE", "आइरल्याण्ड");
    namesMap.put("IL", "इज्रायल");
    namesMap.put("IM", "आइज्ले अफ् म्यान");
    namesMap.put("IN", "भारत");
    namesMap.put("IO", "बेलायती हिन्द महासागर क्षेत्र");
    namesMap.put("IQ", "इराक");
    namesMap.put("IR", "इरान");
    namesMap.put("IS", "आइस्ल्याण्ड");
    namesMap.put("IT", "इटाली");
    namesMap.put("JE", "जर्सी");
    namesMap.put("JM", "जमाइका");
    namesMap.put("JO", "जोर्डन");
    namesMap.put("JP", "जापान");
    namesMap.put("KE", "केन्या");
    namesMap.put("KG", "किर्गिस्थान");
    namesMap.put("KH", "कम्बोडिया");
    namesMap.put("KI", "किरिबाटी");
    namesMap.put("KM", "कोमोरोस");
    namesMap.put("KN", "सेन्ट किट्स र नेभिस");
    namesMap.put("KP", "उत्तर कोरिया");
    namesMap.put("KR", "दक्षिण कोरिया");
    namesMap.put("KW", "कुवेत");
    namesMap.put("KY", "केयमान टापु");
    namesMap.put("KZ", "काजाकस्थान");
    namesMap.put("LA", "लाओस");
    namesMap.put("LB", "लेबनोन");
    namesMap.put("LC", "सेन्ट लुसिया");
    namesMap.put("LI", "लिएखटेन्स्टाइन");
    namesMap.put("LK", "श्रीलङ्का");
    namesMap.put("LR", "लाइबेरिया");
    namesMap.put("LS", "लेसोथो");
    namesMap.put("LT", "लिथुअनिया");
    namesMap.put("LU", "लक्जेमबर्ग");
    namesMap.put("LV", "लाट्भिया");
    namesMap.put("LY", "लिबिया");
    namesMap.put("MA", "मोरोक्को");
    namesMap.put("MC", "मोनाको");
    namesMap.put("MD", "माल्डोभा");
    namesMap.put("ME", "मोन्टेनेग्रो");
    namesMap.put("MF", "सेन्ट मार्टिन");
    namesMap.put("MG", "मडागास्कर");
    namesMap.put("MH", "मार्शल टापु");
    namesMap.put("MK", "म्याकेडोनिया");
    namesMap.put("ML", "माली");
    namesMap.put("MM", "म्यान्मार");
    namesMap.put("MN", "मङ्गोलिया");
    namesMap.put("MO", "मकावो");
    namesMap.put("MP", "उत्तरी मारिआना टापु");
    namesMap.put("MQ", "मार्टिनिक");
    namesMap.put("MR", "माउरिटानिया");
    namesMap.put("MS", "मोन्टसेर्राट");
    namesMap.put("MT", "माल्टा");
    namesMap.put("MU", "माउरिटस");
    namesMap.put("MV", "माल्दिभ्स");
    namesMap.put("MW", "मालावी");
    namesMap.put("MX", "मेक्सिको");
    namesMap.put("MY", "मलेसिया");
    namesMap.put("MZ", "मोजाम्बिक");
    namesMap.put("NA", "नामिबिया");
    namesMap.put("NC", "नयाँ कालेडोनिया");
    namesMap.put("NE", "नाइजर");
    namesMap.put("NF", "नोरफोल्क टापु");
    namesMap.put("NG", "नाइजेरिया");
    namesMap.put("NI", "निकारागुवा");
    namesMap.put("NL", "नेदरल्याण्ड्स");
    namesMap.put("NO", "नर्वे");
    namesMap.put("NP", "नेपाल");
    namesMap.put("NR", "नाउरू");
    namesMap.put("NU", "नियुइ");
    namesMap.put("NZ", "न्युजिल्याण्ड");
    namesMap.put("OM", "ओमन");
    namesMap.put("PA", "पनामा");
    namesMap.put("PE", "पेरू");
    namesMap.put("PF", "फ्रान्सेली पोलिनेसिया");
    namesMap.put("PG", "पपुआ न्यू गाइनिया");
    namesMap.put("PH", "फिलिपिन्स");
    namesMap.put("PK", "पाकिस्तान");
    namesMap.put("PL", "पोल्याण्ड");
    namesMap.put("PM", "सेन्ट पिर्रे र मिक्केलोन");
    namesMap.put("PN", "पिटकाइर्न");
    namesMap.put("PR", "प्युर्टोरिको");
    namesMap.put("PS", "प्यालेस्टनी भू-भाग");
    namesMap.put("PT", "पोर्तुगल");
    namesMap.put("PW", "पलाउ");
    namesMap.put("PY", "प्यारागुये");
    namesMap.put("QA", "कटार");
    namesMap.put("QO", "बाह्य ओसनिया");
    namesMap.put("RE", "रियुनियन");
    namesMap.put("RO", "रोमानिया");
    namesMap.put("RS", "सर्बिया");
    namesMap.put("RU", "रूस");
    namesMap.put("RW", "रवाण्डा");
    namesMap.put("SA", "साउदी अरब");
    namesMap.put("SB", "सोलोमोन टापु");
    namesMap.put("SC", "सेचेलेस");
    namesMap.put("SD", "सुडान");
    namesMap.put("SE", "स्विडेन");
    namesMap.put("SG", "सिङ्गापुर");
    namesMap.put("SH", "सेन्ट हेलेना");
    namesMap.put("SI", "स्लोभेनिया");
    namesMap.put("SJ", "सभाल्बार्ड र जान मायेन");
    namesMap.put("SK", "स्लोभाकिया");
    namesMap.put("SL", "सिएर्रा लिओन");
    namesMap.put("SM", "सान् मारिनो");
    namesMap.put("SN", "सेनेगाल");
    namesMap.put("SO", "सोमालिया");
    namesMap.put("SR", "सुरिनेम");
    namesMap.put("ST", "साओ टोमे र प्रिन्सिप");
    namesMap.put("SV", "एल् साल्भाडोर");
    namesMap.put("SY", "सिरिया");
    namesMap.put("SZ", "स्वाजिल्याण्ड");
    namesMap.put("TC", "तुर्क र काइकोस टापु");
    namesMap.put("TD", "चाड");
    namesMap.put("TF", "फ्रान्सेली दक्षिणी क्षेत्र");
    namesMap.put("TG", "टोगो");
    namesMap.put("TH", "थाइल्याण्ड");
    namesMap.put("TJ", "ताजिकिस्तान");
    namesMap.put("TK", "तोगो");
    namesMap.put("TL", "पूर्वी टिमोर");
    namesMap.put("TM", "तुर्कमेनिस्तान");
    namesMap.put("TN", "टुनिसिया");
    namesMap.put("TO", "टोंगा");
    namesMap.put("TR", "टर्की");
    namesMap.put("TT", "त्रिनिडाड र तोबागो");
    namesMap.put("TV", "तुभालु");
    namesMap.put("TW", "ताइवान");
    namesMap.put("TZ", "तान्जानिया");
    namesMap.put("UA", "युक्रेन");
    namesMap.put("UG", "युगाण्डा");
    namesMap.put("UM", "संयुक्त राज्य अल्प बाह्य टापु");
    namesMap.put("US", "संयुक्त राज्य");
    namesMap.put("UY", "युरूगुए");
    namesMap.put("UZ", "उज्बेकिस्तान");
    namesMap.put("VA", "भेटिकन");
    namesMap.put("VC", "सेन्ट भिन्सेन्ट र ग्रेनाडिन्स");
    namesMap.put("VE", "भेनेजुएला");
    namesMap.put("VG", "बेलायती भर्जिन टापु");
    namesMap.put("VI", "संयुक्त राज्य भर्जिन टापु");
    namesMap.put("VN", "भिएतनाम");
    namesMap.put("VU", "भानुआतु");
    namesMap.put("WF", "वालिस र फुटुना");
    namesMap.put("WS", "सामोआ");
    namesMap.put("YE", "येमेन");
    namesMap.put("YT", "मायोट्ट");
    namesMap.put("ZA", "दक्षिण अफ्रिका");
    namesMap.put("ZM", "जाम्बिया");
    namesMap.put("ZW", "जिम्बाबे");
    namesMap.put("ZZ", "अपरिचित वा अवैध क्षेत्र");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "विश्व",
        "002": "अफ्रिका",
        "003": "उत्तर अमेरिका",
        "005": "दक्षिण अमेरिका",
        "009": "ओसनिया",
        "011": "पश्चिमी अफ्रिका",
        "013": "केन्द्रीय अमेरिका",
        "014": "पूर्वी अफ्रिका",
        "015": "उत्तरी अफ्रिका",
        "017": "मध्य अफ्रिका",
        "018": "दक्षिणी अफ्रिका",
        "019": "अमेरिकास",
        "021": "उत्तरी अमेरिका",
        "029": "क्यारिबिएन",
        "030": "पूर्वी एशिया",
        "034": "दक्षिणी एशिया",
        "035": "दक्षिण पूर्वी एशिया",
        "039": "दक्षिणी युरोप",
        "053": "अष्ट्रेलिया र न्युजिल्याण्ड",
        "054": "मेलानेसिया",
        "057": "माइक्रोनेसियाली क्षेत्र",
        "061": "पोलिनेशिया",
        "062": "दक्षिण मध्य एशिया",
        "142": "एशिया",
        "143": "केन्द्रीय एशिया",
        "145": "पश्चिमी एशिया",
        "150": "युरोप",
        "151": "पूर्वी युरोप",
        "154": "उत्तरी युरोप",
        "155": "पश्चिमी युरोप",
        "172": "कमनवेल्थका स्वतन्त्र राज्यहरू",
        "419": "ल्याटिन अमेरिका तथा क्यारिबियन",
        "AD": "अन्डोर्रा",
        "AE": "संयुक्त अरब इमिराट्स",
        "AF": "अफ्गानिष्तान",
        "AG": "एन्टिगुआ र बारबुडा",
        "AI": "आङ्गुइला",
        "AL": "अल्बानिया",
        "AM": "आर्मेनिया",
        "AN": "नेदरल्याण्ड्स एण्टिलिस",
        "AO": "अङ्गोला",
        "AQ": "अन्टारतिका",
        "AR": "अर्जेण्टिना",
        "AS": "अमेरिकी समोआ",
        "AT": "अष्ट्रिया",
        "AU": "अष्ट्रेलिया",
        "AW": "आरूबा",
        "AX": "अलान्ड टापु",
        "AZ": "अजरबैजान",
        "BA": "बोस्निया र हर्जगोभिनिया",
        "BB": "बार्बाडोस",
        "BD": "बङ्गलादेश",
        "BE": "बेल्जियम",
        "BF": "बर्किना फासो",
        "BG": "बल्गेरिया",
        "BH": "बाह्रेन",
        "BI": "बुरूण्डी",
        "BJ": "बेनिन",
        "BL": "सेन्ट बार्थालेमी",
        "BM": "बर्मुडा",
        "BN": "ब्रुनाइ",
        "BO": "बोलिभिया",
        "BR": "ब्राजिल",
        "BS": "बहामास",
        "BT": "भुटान",
        "BV": "बुभेट टापु",
        "BW": "बोट्स्वाना",
        "BY": "बेलारूस",
        "BZ": "बेलिज",
        "CA": "क्यानाडा",
        "CC": "कोकोस टापु",
        "CD": "कोङ्गो-किन्शासा",
        "CF": "केन्द्रीय अफ्रिकी गणतन्त्र",
        "CG": "कोङ्गो - ब्राज्जाभिल्ले",
        "CH": "स्विजरल्याण्ड",
        "CI": "आइभोरी कोष्ट",
        "CK": "कुक टापु",
        "CL": "चिली",
        "CM": "क्यामेरून",
        "CN": "चीन",
        "CO": "कोलोम्बिया",
        "CR": "कोष्टारिका",
        "CU": "क्युबा",
        "CV": "केप भर्डे",
        "CX": "क्रिष्टमस टापु",
        "CY": "साइप्रस",
        "CZ": "चेख गणतन्त्र",
        "DE": "जर्मनी",
        "DJ": "डिजिबुटी",
        "DK": "डेन्मार्क",
        "DM": "डोमिनिका",
        "DO": "डोमिनिकन गणतन्त्र",
        "DZ": "अल्जेरिया",
        "EC": "इक्वडेर",
        "EE": "इस्टोनिया",
        "EG": "इजिप्ट",
        "EH": "पश्चिमी साहारा",
        "ER": "एरित्रिया",
        "ES": "स्पेन",
        "ET": "इथोपिया",
        "EU": "युरोपियन युनियन",
        "FI": "फिन्ल्याण्ड",
        "FJ": "फिजी",
        "FK": "फकल्याण्ड टापु",
        "FM": "माइक्रोनेसिया",
        "FO": "फारोर टापु",
        "FR": "फ्रान्स",
        "GA": "गावोन",
        "GB": "संयुक्त अधिराज्य",
        "GD": "ग्रेनाडा",
        "GE": "जोर्जिया",
        "GF": "फ्रान्सेली गायना",
        "GG": "गुएर्नसे",
        "GH": "घाना",
        "GI": "जिब्राल्टार",
        "GL": "ग्रिनल्याण्ड",
        "GM": "गाम्विया",
        "GN": "गिनी",
        "GP": "ग्वाडेलुप",
        "GQ": "भू-मध्यीय गिनी",
        "GR": "ग्रिश",
        "GT": "ग्वाटेमाला",
        "GU": "गुवाम",
        "GW": "गिनी-बिसाउ",
        "GY": "गुयाना",
        "HK": "हङकङ",
        "HM": "हर्ड टापु र म्याकडोनाल्ड टापु",
        "HN": "हन्डुरास",
        "HR": "क्रोएशिया",
        "HT": "हैटी",
        "HU": "हङ्गेरी",
        "ID": "इन्डोनेशिया",
        "IE": "आइरल्याण्ड",
        "IL": "इज्रायल",
        "IM": "आइज्ले अफ् म्यान",
        "IN": "भारत",
        "IO": "बेलायती हिन्द महासागर क्षेत्र",
        "IQ": "इराक",
        "IR": "इरान",
        "IS": "आइस्ल्याण्ड",
        "IT": "इटाली",
        "JE": "जर्सी",
        "JM": "जमाइका",
        "JO": "जोर्डन",
        "JP": "जापान",
        "KE": "केन्या",
        "KG": "किर्गिस्थान",
        "KH": "कम्बोडिया",
        "KI": "किरिबाटी",
        "KM": "कोमोरोस",
        "KN": "सेन्ट किट्स र नेभिस",
        "KP": "उत्तर कोरिया",
        "KR": "दक्षिण कोरिया",
        "KW": "कुवेत",
        "KY": "केयमान टापु",
        "KZ": "काजाकस्थान",
        "LA": "लाओस",
        "LB": "लेबनोन",
        "LC": "सेन्ट लुसिया",
        "LI": "लिएखटेन्स्टाइन",
        "LK": "श्रीलङ्का",
        "LR": "लाइबेरिया",
        "LS": "लेसोथो",
        "LT": "लिथुअनिया",
        "LU": "लक्जेमबर्ग",
        "LV": "लाट्भिया",
        "LY": "लिबिया",
        "MA": "मोरोक्को",
        "MC": "मोनाको",
        "MD": "माल्डोभा",
        "ME": "मोन्टेनेग्रो",
        "MF": "सेन्ट मार्टिन",
        "MG": "मडागास्कर",
        "MH": "मार्शल टापु",
        "MK": "म्याकेडोनिया",
        "ML": "माली",
        "MM": "म्यान्मार",
        "MN": "मङ्गोलिया",
        "MO": "मकावो",
        "MP": "उत्तरी मारिआना टापु",
        "MQ": "मार्टिनिक",
        "MR": "माउरिटानिया",
        "MS": "मोन्टसेर्राट",
        "MT": "माल्टा",
        "MU": "माउरिटस",
        "MV": "माल्दिभ्स",
        "MW": "मालावी",
        "MX": "मेक्सिको",
        "MY": "मलेसिया",
        "MZ": "मोजाम्बिक",
        "NA": "नामिबिया",
        "NC": "नयाँ कालेडोनिया",
        "NE": "नाइजर",
        "NF": "नोरफोल्क टापु",
        "NG": "नाइजेरिया",
        "NI": "निकारागुवा",
        "NL": "नेदरल्याण्ड्स",
        "NO": "नर्वे",
        "NP": "नेपाल",
        "NR": "नाउरू",
        "NU": "नियुइ",
        "NZ": "न्युजिल्याण्ड",
        "OM": "ओमन",
        "PA": "पनामा",
        "PE": "पेरू",
        "PF": "फ्रान्सेली पोलिनेसिया",
        "PG": "पपुआ न्यू गाइनिया",
        "PH": "फिलिपिन्स",
        "PK": "पाकिस्तान",
        "PL": "पोल्याण्ड",
        "PM": "सेन्ट पिर्रे र मिक्केलोन",
        "PN": "पिटकाइर्न",
        "PR": "प्युर्टोरिको",
        "PS": "प्यालेस्टनी भू-भाग",
        "PT": "पोर्तुगल",
        "PW": "पलाउ",
        "PY": "प्यारागुये",
        "QA": "कटार",
        "QO": "बाह्य ओसनिया",
        "RE": "रियुनियन",
        "RO": "रोमानिया",
        "RS": "सर्बिया",
        "RU": "रूस",
        "RW": "रवाण्डा",
        "SA": "साउदी अरब",
        "SB": "सोलोमोन टापु",
        "SC": "सेचेलेस",
        "SD": "सुडान",
        "SE": "स्विडेन",
        "SG": "सिङ्गापुर",
        "SH": "सेन्ट हेलेना",
        "SI": "स्लोभेनिया",
        "SJ": "सभाल्बार्ड र जान मायेन",
        "SK": "स्लोभाकिया",
        "SL": "सिएर्रा लिओन",
        "SM": "सान् मारिनो",
        "SN": "सेनेगाल",
        "SO": "सोमालिया",
        "SR": "सुरिनेम",
        "ST": "साओ टोमे र प्रिन्सिप",
        "SV": "एल् साल्भाडोर",
        "SY": "सिरिया",
        "SZ": "स्वाजिल्याण्ड",
        "TC": "तुर्क र काइकोस टापु",
        "TD": "चाड",
        "TF": "फ्रान्सेली दक्षिणी क्षेत्र",
        "TG": "टोगो",
        "TH": "थाइल्याण्ड",
        "TJ": "ताजिकिस्तान",
        "TK": "तोगो",
        "TL": "पूर्वी टिमोर",
        "TM": "तुर्कमेनिस्तान",
        "TN": "टुनिसिया",
        "TO": "टोंगा",
        "TR": "टर्की",
        "TT": "त्रिनिडाड र तोबागो",
        "TV": "तुभालु",
        "TW": "ताइवान",
        "TZ": "तान्जानिया",
        "UA": "युक्रेन",
        "UG": "युगाण्डा",
        "UM": "संयुक्त राज्य अल्प बाह्य टापु",
        "US": "संयुक्त राज्य",
        "UY": "युरूगुए",
        "UZ": "उज्बेकिस्तान",
        "VA": "भेटिकन",
        "VC": "सेन्ट भिन्सेन्ट र ग्रेनाडिन्स",
        "VE": "भेनेजुएला",
        "VG": "बेलायती भर्जिन टापु",
        "VI": "संयुक्त राज्य भर्जिन टापु",
        "VN": "भिएतनाम",
        "VU": "भानुआतु",
        "WF": "वालिस र फुटुना",
        "WS": "सामोआ",
        "YE": "येमेन",
        "YT": "मायोट्ट",
        "ZA": "दक्षिण अफ्रिका",
        "ZM": "जाम्बिया",
        "ZW": "जिम्बाबे",
        "ZZ": "अपरिचित वा अवैध क्षेत्र"
    };
  }-*/;
}
