########################################################################
#
#    Vision Macro - Python source code - file generated by vision
#    Thursday 01 June 2006 11:30:03 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/AutoDockTools/VisionInterface/PrepareAD3Receptor.py,v 1.1 2006/06/05 22:45:41 rhuey Exp $
#
# $Id: PrepareAD3Receptor.py,v 1.1 2006/06/05 22:45:41 rhuey Exp $
#

from NetworkEditor.macros import MacroNode
class PrepareAD3Receptor(MacroNode):

    def __init__(self, constrkw={}, name='Prepare AD3Receptor', **kw):
        kw['name'] = name
        apply( MacroNode.__init__, (self,), kw)

    def beforeAddingToNetwork(self, net):
        MacroNode.beforeAddingToNetwork(self, net)
        ## loading libraries ##
        from AutoDockTools.VisionInterface.AdtNodes import adtlib
        net.editor.addLibraryInstance(adtlib,"AutoDockTools.VisionInterface.AdtNodes", "adtlib")

        from MolKit.VisionInterface.MolKitNodes import molkitlib
        net.editor.addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")


    def afterAddingToNetwork(self):
        from NetworkEditor.macros import MacroNode
        MacroNode.afterAddingToNetwork(self)
        ## loading libraries ##
        from AutoDockTools.VisionInterface.AdtNodes import adtlib
        from MolKit.VisionInterface.MolKitNodes import molkitlib
        ## building macro network ##
        Prepare_AD3Receptor_16 = self
        from traceback import print_exc

        ## loading libraries ##
        from AutoDockTools.VisionInterface.AdtNodes import adtlib
        self.macroNetwork.getEditor().addLibraryInstance(adtlib,"AutoDockTools.VisionInterface.AdtNodes", "adtlib")

        from MolKit.VisionInterface.MolKitNodes import molkitlib
        self.macroNetwork.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

        try:
            ## saving node input Ports ##
            input_Ports_17 = self.macroNetwork.ipNode
            input_Ports_17.move(165, 26)
        except:
            print "WARNING: failed to restore MacroInputNode named input Ports in network self.macroNetwork"
            print_exc()
            input_Ports_17=None

        try:
            ## saving node output Ports ##
            output_Ports_18 = self.macroNetwork.opNode
            output_Ports_18.move(165, 345)
        except:
            print "WARNING: failed to restore MacroOutputNode named output Ports in network self.macroNetwork"
            print_exc()
            output_Ports_18=None

        try:
            ## saving node Add Hydrogens ##
            from MolKit.VisionInterface.MolKitNodes import AddHydrogens
            Add_Hydrogens_19 = AddHydrogens(constrkw = {}, name='Add Hydrogens', library=molkitlib)
            self.macroNetwork.addNode(Add_Hydrogens_19,182,83)
            apply(Add_Hydrogens_19.inputPortByName['molecules'].configure, (), {'color': '#c64e70', 'cast': True, 'shape': 'oval'})
            apply(Add_Hydrogens_19.outputPortByName['molecules'].configure, (), {'color': '#c64e70', 'shape': 'oval'})
            apply(Add_Hydrogens_19.outputPortByName['new_h_ct'].configure, (), {'color': 'yellow', 'shape': 'circle'})
        except:
            print "WARNING: failed to restore AddHydrogens named Add Hydrogens in network self.macroNetwork"
            print_exc()
            Add_Hydrogens_19=None

        try:
            ## saving node Add Kollman Charges ##
            from MolKit.VisionInterface.MolKitNodes import AddKollmanCharges
            Add_Kollman_Charges_20 = AddKollmanCharges(constrkw = {}, name='Add Kollman Charges', library=molkitlib)
            self.macroNetwork.addNode(Add_Kollman_Charges_20,182,135)
            apply(Add_Kollman_Charges_20.inputPortByName['mols'].configure, (), {'color': '#c64e70', 'cast': True, 'shape': 'oval'})
            apply(Add_Kollman_Charges_20.outputPortByName['mols'].configure, (), {'color': '#c64e70', 'shape': 'oval'})
            apply(Add_Kollman_Charges_20.outputPortByName['charge_total'].configure, (), {'color': 'green', 'shape': 'circle'})
        except:
            print "WARNING: failed to restore AddKollmanCharges named Add Kollman Charges in network self.macroNetwork"
            print_exc()
            Add_Kollman_Charges_20=None

        try:
            ## saving node Add Solvation Parameters ##
            from AutoDockTools.VisionInterface.AdtNodes import Add_SolvationParameters
            Add_Solvation_Parameters_21 = Add_SolvationParameters(constrkw = {}, name='Add Solvation Parameters', library=adtlib)
            self.macroNetwork.addNode(Add_Solvation_Parameters_21,182,288)
            apply(Add_Solvation_Parameters_21.inputPortByName['mols'].configure, (), {'color': '#c64e70', 'cast': True, 'shape': 'oval'})
            apply(Add_Solvation_Parameters_21.outputPortByName['typed_mols'].configure, (), {'color': '#c64e70', 'shape': 'oval'})
            apply(Add_Solvation_Parameters_21.outputPortByName['AtSolPar'].configure, (), {'color': 'cyan', 'shape': 'oval'})
        except:
            print "WARNING: failed to restore Add_SolvationParameters named Add Solvation Parameters in network self.macroNetwork"
            print_exc()
            Add_Solvation_Parameters_21=None

        try:
            ## saving node Merge NonPolar Hydrogens ##
            from AutoDockTools.VisionInterface.AdtNodes import MergeNonPolarHydrogens
            Merge_NonPolar_Hydrogens_22 = MergeNonPolarHydrogens(constrkw = {}, name='Merge NonPolar Hydrogens', library=adtlib)
            self.macroNetwork.addNode(Merge_NonPolar_Hydrogens_22,182,236)
            apply(Merge_NonPolar_Hydrogens_22.inputPortByName['mols'].configure, (), {'color': '#c64e70', 'cast': True, 'shape': 'oval'})
            apply(Merge_NonPolar_Hydrogens_22.inputPortByName['renumber'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
            apply(Merge_NonPolar_Hydrogens_22.outputPortByName['mols'].configure, (), {'color': '#c64e70', 'shape': 'oval'})
            apply(Merge_NonPolar_Hydrogens_22.outputPortByName['num_nphs'].configure, (), {'color': 'yellow', 'shape': 'circle'})
        except:
            print "WARNING: failed to restore MergeNonPolarHydrogens named Merge NonPolar Hydrogens in network self.macroNetwork"
            print_exc()
            Merge_NonPolar_Hydrogens_22=None

        try:
            ## saving node Merge Lone Pairs ##
            from AutoDockTools.VisionInterface.AdtNodes import MergeLonePairs
            Merge_Lone_Pairs_23 = MergeLonePairs(constrkw = {}, name='Merge Lone Pairs', library=adtlib)
            self.macroNetwork.addNode(Merge_Lone_Pairs_23,182,184)
            apply(Merge_Lone_Pairs_23.inputPortByName['mols'].configure, (), {'color': '#c64e70', 'cast': True, 'shape': 'oval'})
            apply(Merge_Lone_Pairs_23.inputPortByName['renumber'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
            apply(Merge_Lone_Pairs_23.outputPortByName['mols'].configure, (), {'color': '#c64e70', 'shape': 'oval'})
            apply(Merge_Lone_Pairs_23.outputPortByName['num_lps'].configure, (), {'color': 'yellow', 'shape': 'circle'})
        except:
            print "WARNING: failed to restore MergeLonePairs named Merge Lone Pairs in network self.macroNetwork"
            print_exc()
            Merge_Lone_Pairs_23=None

        self.macroNetwork.freeze()

        ## saving connections for network Prepare AD3Receptor ##
        input_Ports_17 = self.macroNetwork.ipNode
        if input_Ports_17 is not None and Add_Hydrogens_19 is not None:
            try:
                self.macroNetwork.connectNodes(
                    input_Ports_17, Add_Hydrogens_19, "new", "molecules", blocking=True)
            except:
                print "WARNING: failed to restore connection between input_Ports_17 and Add_Hydrogens_19 in network self.macroNetwork"
        if Add_Hydrogens_19 is not None and Add_Kollman_Charges_20 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Add_Hydrogens_19, Add_Kollman_Charges_20, "molecules", "mols", blocking=True)
            except:
                print "WARNING: failed to restore connection between Add_Hydrogens_19 and Add_Kollman_Charges_20 in network self.macroNetwork"
        if Add_Kollman_Charges_20 is not None and Merge_Lone_Pairs_23 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Add_Kollman_Charges_20, Merge_Lone_Pairs_23, "mols", "mols", blocking=True)
            except:
                print "WARNING: failed to restore connection between Add_Kollman_Charges_20 and Merge_Lone_Pairs_23 in network self.macroNetwork"
        if Merge_Lone_Pairs_23 is not None and Merge_NonPolar_Hydrogens_22 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Merge_Lone_Pairs_23, Merge_NonPolar_Hydrogens_22, "mols", "mols", blocking=True)
            except:
                print "WARNING: failed to restore connection between Merge_Lone_Pairs_23 and Merge_NonPolar_Hydrogens_22 in network self.macroNetwork"
        if Merge_NonPolar_Hydrogens_22 is not None and Add_Solvation_Parameters_21 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Merge_NonPolar_Hydrogens_22, Add_Solvation_Parameters_21, "mols", "mols", blocking=True)
            except:
                print "WARNING: failed to restore connection between Merge_NonPolar_Hydrogens_22 and Add_Solvation_Parameters_21 in network self.macroNetwork"
        output_Ports_18 = self.macroNetwork.opNode
        if Add_Solvation_Parameters_21 is not None and output_Ports_18 is not None:
            try:
                self.macroNetwork.connectNodes(
                    Add_Solvation_Parameters_21, output_Ports_18, "typed_mols", "new", blocking=True)
            except:
                print "WARNING: failed to restore connection between Add_Solvation_Parameters_21 and output_Ports_18 in network self.macroNetwork"
        self.macroNetwork.unfreeze()

        Prepare_AD3Receptor_16.shrink()

        ## reset modifications ##
        Prepare_AD3Receptor_16.resetTags()
        Prepare_AD3Receptor_16.buildOriginalList()
