/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class While
extends Instruction {
    private Expression test;
    private Expression action;

    public While(Expression test, Expression action) {
        this.test = test;
        this.action = action;
        this.adoptChildExpression(test);
        this.adoptChildExpression(action);
    }

    public int getInstructionNameCode() {
        return 265;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.test = visitor.simplify(this.test);
        this.action = visitor.simplify(this.action);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.test = visitor.typeCheck(this.test, contextItemType);
        this.adoptChildExpression(this.test);
        this.action = visitor.typeCheck(this.action, contextItemType);
        this.adoptChildExpression(this.action);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.test = visitor.optimize(this.test, contextItemType);
        this.adoptChildExpression(this.test);
        this.action = visitor.optimize(this.action, contextItemType);
        this.adoptChildExpression(this.action);
        return this;
    }

    public Expression copy() {
        return new While(this.test.copy(), this.action.copy());
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.action.getItemType(th);
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (offer.action != 15) {
            this.test = this.doPromotion(this.test, offer);
        }
        this.action = this.doPromotion(this.action, offer);
    }

    public final boolean createsNewNodes() {
        int props = this.action.getSpecialProperties();
        return (props & 0x400000) == 0;
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.test, this.action);
    }

    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.action;
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.test == original) {
            this.test = replacement;
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        return found;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        while (this.test.effectiveBooleanValue(context)) {
            this.action.process(context);
        }
        return null;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("saxonWhile");
        this.test.explain(out);
        out.startSubsidiaryElement("do");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

