/*
 * Copyright (C) 2019 Igalia S.L.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <wtf/EnumTraits.h>
#include <wtf/Vector.h>
#include <wtf/glib/GRefPtr.h>
#include <wtf/text/CString.h>

typedef struct _GUnixFDList GUnixFDList;
typedef struct _GVariant GVariant;

namespace IPC {
class Decoder;
class Encoder;
}

namespace WebKit {

struct UserMessage {
    enum class Type { Null, Message, Error };

    UserMessage()
        : type(Type::Null)
    {
    }

    UserMessage(const CString& name, uint32_t errorCode)
        : type(Type::Error)
        , name(name)
        , errorCode(errorCode)
    {
    }

    void encode(IPC::Encoder&) const;
    static Optional<UserMessage> decode(IPC::Decoder&);

    Type type { Type::Null };
    CString name;
    GRefPtr<GVariant> parameters;
    GRefPtr<GUnixFDList> fileDescriptors;
    uint32_t errorCode { 0 };
};

} // namespace WebKit

namespace WTF {

template<> struct EnumTraits<WebKit::UserMessage::Type> {
    using values = EnumValues<
        WebKit::UserMessage::Type,
        WebKit::UserMessage::Type::Null,
        WebKit::UserMessage::Type::Message,
        WebKit::UserMessage::Type::Error
    >;
};

} // namespace WTF
