function UnityCallbackManager () {
    this.callbacks = {};
}

UnityCallbackManager.prototype.makeCallback = function (type, callback, funcName, id)  {
    var ctypesCallback = type.ptr(callback);

    if (!(funcName in this.callbacks)) {
        if (id !== undefined)
            this.callbacks[funcName] = {};
    }

    if (id !== undefined) {
        this.callbacks[funcName][id] = [ctypesCallback, callback];
    } else {
        this.callbacks[funcName] = [ctypesCallback, callback];
    }

    return ctypesCallback;
};

UnityCallbackManager.prototype.releaseCallback = function (funcName)  {
    delete this.callbacks[funcName];
};

UnityCallbackManager.prototype.releaseAll = function ()  {
    this.callbacks = {};
};

var EXPORTED_SYMBOLS = ["UnityCallbackManager"];
