// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-
var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;

var stringBundleService = Cc["@mozilla.org/intl/stringbundle;1"].getService(Ci.nsIStringBundleService);

function L10n() {
    this._init();
}

L10n.prototype = {
    _init: function() {
        this._bundle = stringBundleService.createBundle("chrome://unity/locale/unity_webapps.properties");
    },

    formatMessage: function(key, args) {
        if (!args)
            args = [];
        return this._bundle.formatStringFromName(key, args, args.length);
    }
};

var l10n = new L10n();

var EXPORTED_SYMBOLS = [ "l10n" ];
