# HTACG HTML Tidy

All other READMEs and related materials can be found in [README/][100]. Although all of our materials should be linked in this README, be sure to check this directory for documents we’ve not yet added to this document.

## Building HTML Tidy

  - For build instructions please see [README/BUILD.md][115].
  
## Branches and Versions

Learn about which branches are available, which branch you should use, and how HTML Tidy’s versioning scheme works.

  - Learn about version numbering in [README/VERSION.md][160].
  - Learn about our repository branches in [README/BRANCHES.md][110].
  
## Contributing and Development Guides

We gladly accept PRs! Read about some of our contribution guidelines, and check out some of the additional explanatory documents that will aid your understanding of how to accomplish certain things in HTML Tidy.

### General Contribution Guidelines

These are some general guidelines that will help you help us when it comes to making your own contributions to HTML Tidy.

  - Learn about our contributing guidelines in [README/CONTRIBUTING.md][125].
  - Understand HTML Tidy’s source code style in [README/CODESTYLE.md][120].

### Adding Features Guides

When you’re ready to add a great new feature, these write-ups may be useful.

  - Learn how to add new element attributes to HTML Tidy by reading [README/ATTRIBUTES.md][105].
  - Discover how to add new tags to Tidy in [README/TAGS.md][130].
  - If you want to add new messages to Tidy, read [README/MESSAGE.md][150].
  - Configuration options can be added according to [README/OPTIONS.md][155].

### Language Localization Guides

Tidy supports localization, and welcomes translations into various languages. Please read up on how to localize HTML Tidy.

 - The general README for localizing can be found in [/README/LOCALIZE.md][140].
 - And [/localize/README.md][145] contains specific instructions for localizing.


## Other Important Links

 - site: [http://www.html-tidy.org/][4]
 - source: [https://github.com/htacg/tidy-html5][5]
 - binaries: [http://binaries.html-tidy.org][6]
 - bugs: [https://github.com/htacg/tidy-html5/issues][7]
 - list: [https://lists.w3.org/Archives/Public/html-tidy/][8]
 - api and quickref: [http://api.html-tidy.org/][9]

  [4]: http://www.html-tidy.org/
  [5]: https://github.com/htacg/tidy-html5
  [6]: http://binaries.html-tidy.org
  [7]: https://github.com/htacg/tidy-html5/issues
  [8]: https://lists.w3.org/Archives/Public/html-tidy/
  [9]: http://api.html-tidy.org/


## History

This repository should be considered canonical for HTML Tidy as of 2015-January-15.

 - This repository originally transferred from [w3c.github.com/tidy-html5][20], now redirected to the current site.
 
 - First moved to Github from [tidy.sourceforge.net][21]. Note, this site is kept only for historic reasons, and is not now well maintained.

**Tidy is the granddaddy of HTML tools, with support for modern standards.** Have fun...

  [20]: http://w3c.github.com/tidy-html5/
  [21]: http://tidy.sourceforge.net


## License

HTML Tidy and LibTidy are free and open source software with a permissive license.

 - You can read the complete license in [README/LICENSE.md][135].



  [100]: README/
  [105]: README/ATTRIBUTES.md
  [110]: README/BRANCHES.md
  [115]: README/BUILD.md
  [120]: README/CODESTYLE.md
  [125]: README/CONTRIBUTING.md
  [130]: README/TAGS.md
  [135]: README/LICENSE.md
  [140]: /README/LOCALIZE.md
  [145]: /localize/README.md
  [150]: README/MESSAGE.md
  [155]: README/OPTIONS.md
  [160]: README/VERSION.md
 
