/* RGBHistogramManipulator.c generated by valac 0.40.4, the Vala compiler
 * generated from RGBHistogramManipulator.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "shotwell-graphics-processor.h"
#include <gdk/gdk.h>
#include <cairo.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_RGB_HISTOGRAM_MANIPULATOR (rgb_histogram_manipulator_get_type ())
#define RGB_HISTOGRAM_MANIPULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator))
#define RGB_HISTOGRAM_MANIPULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulatorClass))
#define IS_RGB_HISTOGRAM_MANIPULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RGB_HISTOGRAM_MANIPULATOR))
#define IS_RGB_HISTOGRAM_MANIPULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RGB_HISTOGRAM_MANIPULATOR))
#define RGB_HISTOGRAM_MANIPULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulatorClass))

typedef struct _RGBHistogramManipulator RGBHistogramManipulator;
typedef struct _RGBHistogramManipulatorClass RGBHistogramManipulatorClass;
typedef struct _RGBHistogramManipulatorPrivate RGBHistogramManipulatorPrivate;
enum  {
	RGB_HISTOGRAM_MANIPULATOR_0_PROPERTY,
	RGB_HISTOGRAM_MANIPULATOR_NUM_PROPERTIES
};
static GParamSpec* rgb_histogram_manipulator_properties[RGB_HISTOGRAM_MANIPULATOR_NUM_PROPERTIES];

#define RGB_HISTOGRAM_MANIPULATOR_TYPE_LOCATION_CODE (rgb_histogram_manipulator_location_code_get_type ())
#define _rgb_histogram_unref0(var) ((var == NULL) ? NULL : (var = (rgb_histogram_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL,
	RGB_HISTOGRAM_MANIPULATOR_NUM_SIGNALS
};
static guint rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RGBHistogramManipulator {
	GtkDrawingArea parent_instance;
	RGBHistogramManipulatorPrivate * priv;
};

struct _RGBHistogramManipulatorClass {
	GtkDrawingAreaClass parent_class;
};

struct _RGBHistogramManipulatorPrivate {
	gint left_nub_max;
	gint right_nub_min;
	RGBHistogram* histogram;
	gint left_nub_position;
	gint right_nub_position;
	gboolean is_left_nub_tracking;
	gboolean is_right_nub_tracking;
	gint track_start_x;
	gint track_nub_start_position;
	gint offset;
};

typedef enum  {
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH,
	RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA
} RGBHistogramManipulatorLocationCode;


static gpointer rgb_histogram_manipulator_parent_class = NULL;
static GtkWidgetPath* rgb_histogram_manipulator_slider_draw_path;
static GtkWidgetPath* rgb_histogram_manipulator_slider_draw_path = NULL;
static GtkWidgetPath* rgb_histogram_manipulator_frame_draw_path;
static GtkWidgetPath* rgb_histogram_manipulator_frame_draw_path = NULL;
static gboolean rgb_histogram_manipulator_paths_setup;
static gboolean rgb_histogram_manipulator_paths_setup = FALSE;

GType rgb_histogram_manipulator_get_type (void) G_GNUC_CONST;
#define RGB_HISTOGRAM_MANIPULATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulatorPrivate))
static GType rgb_histogram_manipulator_location_code_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE 13
#define RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH (RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE / 2)
#define RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE 4
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_WIDTH (256 + (2 * RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH))
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT 4
#define RGB_HISTOGRAM_MANIPULATOR_TROUGH_BOTTOM_OFFSET 1
#define RGB_HISTOGRAM_MANIPULATOR_CONTROL_WIDTH (RGB_HISTOGRAM_MANIPULATOR_TROUGH_WIDTH + 2)
#define RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT 118
#define RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION (((((RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT - RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT) - RGB_HISTOGRAM_MANIPULATOR_TROUGH_BOTTOM_OFFSET) - ((RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE - RGB_HISTOGRAM_MANIPULATOR_TROUGH_HEIGHT) / 2)) - RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE) - 2)
RGBHistogramManipulator* rgb_histogram_manipulator_new (void);
RGBHistogramManipulator* rgb_histogram_manipulator_construct (GType object_type);
static gboolean rgb_histogram_manipulator_on_button_press (RGBHistogramManipulator* self,
                                                    GdkEventButton* event_record);
static gboolean _rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                   GdkEventButton* event,
                                                                                   gpointer self);
static gboolean rgb_histogram_manipulator_on_button_release (RGBHistogramManipulator* self,
                                                      GdkEventButton* event_record);
static gboolean _rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                       GdkEventButton* event,
                                                                                       gpointer self);
static gboolean rgb_histogram_manipulator_on_button_motion (RGBHistogramManipulator* self,
                                                     GdkEventMotion* event_record);
static gboolean _rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                     GdkEventMotion* event,
                                                                                     gpointer self);
static void rgb_histogram_manipulator_on_size_allocate (RGBHistogramManipulator* self,
                                                 GtkAllocation* region);
static void _rgb_histogram_manipulator_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                           GtkAllocation* allocation,
                                                                           gpointer self);
static RGBHistogramManipulatorLocationCode rgb_histogram_manipulator_hit_test_point (RGBHistogramManipulator* self,
                                                                              gint x,
                                                                              gint y);
static void rgb_histogram_manipulator_force_update (RGBHistogramManipulator* self);
static void rgb_histogram_manipulator_update_nub_extrema (RGBHistogramManipulator* self);
static gboolean rgb_histogram_manipulator_real_focus_out_event (GtkWidget* base,
                                                         GdkEventFocus* event);
static gboolean rgb_histogram_manipulator_real_key_press_event (GtkWidget* base,
                                                         GdkEventKey* event);
static gboolean rgb_histogram_manipulator_real_draw (GtkWidget* base,
                                              cairo_t* ctx);
static void rgb_histogram_manipulator_draw_histogram (RGBHistogramManipulator* self,
                                               cairo_t* ctx,
                                               GdkRectangle* area);
static void rgb_histogram_manipulator_draw_nub (RGBHistogramManipulator* self,
                                         cairo_t* ctx,
                                         GdkRectangle* area,
                                         gint position);
void rgb_histogram_manipulator_update_histogram (RGBHistogramManipulator* self,
                                                 GdkPixbuf* source_pixbuf);
gint rgb_histogram_manipulator_get_left_nub_position (RGBHistogramManipulator* self);
gint rgb_histogram_manipulator_get_right_nub_position (RGBHistogramManipulator* self);
void rgb_histogram_manipulator_set_left_nub_position (RGBHistogramManipulator* self,
                                                      gint user_nub_pos);
void rgb_histogram_manipulator_set_right_nub_position (RGBHistogramManipulator* self,
                                                       gint user_nub_pos);
static void rgb_histogram_manipulator_finalize (GObject * obj);


static GType
rgb_histogram_manipulator_location_code_get_type (void)
{
	static volatile gsize rgb_histogram_manipulator_location_code_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_histogram_manipulator_location_code_type_id__volatile)) {
		static const GEnumValue values[] = {{RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB", "left-nub"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB", "right-nub"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH", "left-trough"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH", "right-trough"}, {RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA, "RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA", "insensitive-area"}, {0, NULL, NULL}};
		GType rgb_histogram_manipulator_location_code_type_id;
		rgb_histogram_manipulator_location_code_type_id = g_enum_register_static ("RGBHistogramManipulatorLocationCode", values);
		g_once_init_leave (&rgb_histogram_manipulator_location_code_type_id__volatile, rgb_histogram_manipulator_location_code_type_id);
	}
	return rgb_histogram_manipulator_location_code_type_id__volatile;
}


static gboolean
_rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                          GdkEventButton* event,
                                                                          gpointer self)
{
	gboolean result;
	result = rgb_histogram_manipulator_on_button_press ((RGBHistogramManipulator*) self, event);
#line 57 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 178 "RGBHistogramManipulator.c"
}


static gboolean
_rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                              GdkEventButton* event,
                                                                              gpointer self)
{
	gboolean result;
	result = rgb_histogram_manipulator_on_button_release ((RGBHistogramManipulator*) self, event);
#line 58 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 191 "RGBHistogramManipulator.c"
}


static gboolean
_rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                            GdkEventMotion* event,
                                                                            gpointer self)
{
	gboolean result;
	result = rgb_histogram_manipulator_on_button_motion ((RGBHistogramManipulator*) self, event);
#line 59 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 204 "RGBHistogramManipulator.c"
}


static void
_rgb_histogram_manipulator_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                      GtkAllocation* allocation,
                                                                      gpointer self)
{
#line 61 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_on_size_allocate ((RGBHistogramManipulator*) self, allocation);
#line 215 "RGBHistogramManipulator.c"
}


RGBHistogramManipulator*
rgb_histogram_manipulator_construct (GType object_type)
{
	RGBHistogramManipulator * self = NULL;
	gboolean _tmp0_;
#line 36 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self = (RGBHistogramManipulator*) g_object_new (object_type, NULL);
#line 37 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), RGB_HISTOGRAM_MANIPULATOR_CONTROL_WIDTH, RGB_HISTOGRAM_MANIPULATOR_CONTROL_HEIGHT);
#line 38 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_set_can_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), TRUE);
#line 40 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = rgb_histogram_manipulator_paths_setup;
#line 40 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (!_tmp0_) {
#line 234 "RGBHistogramManipulator.c"
		GtkWidgetPath* _tmp1_;
		GtkWidgetPath* _tmp2_;
		GtkWidgetPath* _tmp3_;
		GtkWidgetPath* _tmp4_;
		GtkWidgetPath* _tmp5_;
#line 41 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp1_ = rgb_histogram_manipulator_slider_draw_path;
#line 41 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		gtk_widget_path_append_type (_tmp1_, gtk_scale_get_type ());
#line 42 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp2_ = rgb_histogram_manipulator_slider_draw_path;
#line 42 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		gtk_widget_path_iter_add_class (_tmp2_, 0, "scale");
#line 43 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp3_ = rgb_histogram_manipulator_slider_draw_path;
#line 43 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		gtk_widget_path_iter_add_class (_tmp3_, 0, "range");
#line 45 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp4_ = rgb_histogram_manipulator_frame_draw_path;
#line 45 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		gtk_widget_path_append_type (_tmp4_, gtk_frame_get_type ());
#line 46 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp5_ = rgb_histogram_manipulator_frame_draw_path;
#line 46 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		gtk_widget_path_iter_add_class (_tmp5_, 0, "default");
#line 48 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		rgb_histogram_manipulator_paths_setup = TRUE;
#line 262 "RGBHistogramManipulator.c"
	}
#line 51 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_BUTTON_PRESS_MASK);
#line 52 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_BUTTON_RELEASE_MASK);
#line 53 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_BUTTON_MOTION_MASK);
#line 54 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_FOCUS_CHANGE_MASK);
#line 55 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) GDK_KEY_PRESS_MASK);
#line 57 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-press-event", (GCallback) _rgb_histogram_manipulator_on_button_press_gtk_widget_button_press_event, self, 0);
#line 58 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "button-release-event", (GCallback) _rgb_histogram_manipulator_on_button_release_gtk_widget_button_release_event, self, 0);
#line 59 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "motion-notify-event", (GCallback) _rgb_histogram_manipulator_on_button_motion_gtk_widget_motion_notify_event, self, 0);
#line 61 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "size-allocate", (GCallback) _rgb_histogram_manipulator_on_size_allocate_gtk_widget_size_allocate, self, 0);
#line 36 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return self;
#line 284 "RGBHistogramManipulator.c"
}


RGBHistogramManipulator*
rgb_histogram_manipulator_new (void)
{
#line 36 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return rgb_histogram_manipulator_construct (TYPE_RGB_HISTOGRAM_MANIPULATOR);
#line 293 "RGBHistogramManipulator.c"
}


static void
rgb_histogram_manipulator_on_size_allocate (RGBHistogramManipulator* self,
                                            GtkAllocation* region)
{
	GtkAllocation _tmp0_;
	gint _tmp1_;
#line 64 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 64 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (region != NULL);
#line 65 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = *region;
#line 65 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = _tmp0_.width;
#line 65 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->offset = ((_tmp1_ - RGB_HISTOGRAM_GRAPHIC_WIDTH) - RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) / 2;
#line 313 "RGBHistogramManipulator.c"
}


static RGBHistogramManipulatorLocationCode
rgb_histogram_manipulator_hit_test_point (RGBHistogramManipulator* self,
                                          gint x,
                                          gint y)
{
	RGBHistogramManipulatorLocationCode result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
#line 68 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), 0);
#line 69 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (y < RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION) {
#line 70 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA;
#line 70 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 339 "RGBHistogramManipulator.c"
	}
#line 72 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->left_nub_position;
#line 72 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (x > _tmp1_) {
#line 345 "RGBHistogramManipulator.c"
		gint _tmp2_;
#line 72 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp2_ = self->priv->left_nub_position;
#line 72 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = x < (_tmp2_ + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE);
#line 351 "RGBHistogramManipulator.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = FALSE;
#line 355 "RGBHistogramManipulator.c"
	}
#line 72 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp0_) {
#line 73 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB;
#line 73 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 363 "RGBHistogramManipulator.c"
	}
#line 75 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = self->priv->right_nub_position;
#line 75 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (x > _tmp4_) {
#line 369 "RGBHistogramManipulator.c"
		gint _tmp5_;
#line 75 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp5_ = self->priv->right_nub_position;
#line 75 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp3_ = x < (_tmp5_ + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE);
#line 375 "RGBHistogramManipulator.c"
	} else {
#line 75 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp3_ = FALSE;
#line 379 "RGBHistogramManipulator.c"
	}
#line 75 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp3_) {
#line 76 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB;
#line 76 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 387 "RGBHistogramManipulator.c"
	}
#line 78 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (y < ((RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION + RGB_HISTOGRAM_MANIPULATOR_NUB_V_NUDGE) + 1)) {
#line 79 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_INSENSITIVE_AREA;
#line 79 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 395 "RGBHistogramManipulator.c"
	}
#line 81 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp6_ = self->priv->left_nub_position;
#line 81 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp7_ = self->priv->left_nub_position;
#line 81 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp8_ = self->priv->right_nub_position;
#line 81 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp9_ = self->priv->right_nub_position;
#line 81 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (((x - _tmp6_) * (x - _tmp7_)) < ((x - _tmp8_) * (x - _tmp9_))) {
#line 83 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH;
#line 83 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 411 "RGBHistogramManipulator.c"
	} else {
#line 85 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH;
#line 85 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 417 "RGBHistogramManipulator.c"
	}
}


static gboolean
rgb_histogram_manipulator_on_button_press (RGBHistogramManipulator* self,
                                           GdkEventButton* event_record)
{
	gboolean result = FALSE;
	gdouble _tmp0_;
	gint _tmp1_;
	RGBHistogramManipulatorLocationCode loc = 0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gboolean retval = FALSE;
	RGBHistogramManipulatorLocationCode _tmp4_;
	gdouble _tmp15_;
	gint _tmp16_;
#line 88 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), FALSE);
#line 88 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (event_record != NULL, FALSE);
#line 91 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = event_record->x;
#line 91 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->offset;
#line 91 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	event_record->x = _tmp0_ - _tmp1_;
#line 92 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp2_ = event_record->x;
#line 92 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = event_record->y;
#line 92 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	loc = rgb_histogram_manipulator_hit_test_point (self, (gint) _tmp2_, (gint) _tmp3_);
#line 93 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	retval = TRUE;
#line 95 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = loc;
#line 95 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	switch (_tmp4_) {
#line 95 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_NUB:
#line 460 "RGBHistogramManipulator.c"
		{
			gdouble _tmp5_;
			gint _tmp6_;
#line 97 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp5_ = event_record->x;
#line 97 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->track_start_x = (gint) _tmp5_;
#line 98 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp6_ = self->priv->left_nub_position;
#line 98 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->track_nub_start_position = _tmp6_;
#line 99 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->is_left_nub_tracking = TRUE;
#line 100 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			break;
#line 476 "RGBHistogramManipulator.c"
		}
#line 95 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_NUB:
#line 480 "RGBHistogramManipulator.c"
		{
			gdouble _tmp7_;
			gint _tmp8_;
#line 103 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp7_ = event_record->x;
#line 103 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->track_start_x = (gint) _tmp7_;
#line 104 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp8_ = self->priv->right_nub_position;
#line 104 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->track_nub_start_position = _tmp8_;
#line 105 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->is_right_nub_tracking = TRUE;
#line 106 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			break;
#line 496 "RGBHistogramManipulator.c"
		}
#line 95 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_LEFT_TROUGH:
#line 500 "RGBHistogramManipulator.c"
		{
			gdouble _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
#line 109 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp9_ = event_record->x;
#line 109 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->left_nub_position = ((gint) _tmp9_) - RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH;
#line 110 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp10_ = self->priv->left_nub_position;
#line 110 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp11_ = self->priv->left_nub_max;
#line 110 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->left_nub_position = CLAMP (_tmp10_, 0, _tmp11_);
#line 111 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			rgb_histogram_manipulator_force_update (self);
#line 112 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			g_signal_emit (self, rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL], 0);
#line 113 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			rgb_histogram_manipulator_update_nub_extrema (self);
#line 114 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			break;
#line 523 "RGBHistogramManipulator.c"
		}
#line 95 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		case RGB_HISTOGRAM_MANIPULATOR_LOCATION_CODE_RIGHT_TROUGH:
#line 527 "RGBHistogramManipulator.c"
		{
			gdouble _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
#line 117 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp12_ = event_record->x;
#line 117 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->right_nub_position = ((gint) _tmp12_) - RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH;
#line 118 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp13_ = self->priv->right_nub_position;
#line 118 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			_tmp14_ = self->priv->right_nub_min;
#line 118 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			self->priv->right_nub_position = CLAMP (_tmp13_, _tmp14_, 255);
#line 119 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			rgb_histogram_manipulator_force_update (self);
#line 120 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			g_signal_emit (self, rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL], 0);
#line 121 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			rgb_histogram_manipulator_update_nub_extrema (self);
#line 122 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			break;
#line 550 "RGBHistogramManipulator.c"
		}
		default:
		{
#line 125 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			retval = FALSE;
#line 126 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
			break;
#line 558 "RGBHistogramManipulator.c"
		}
	}
#line 130 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp15_ = event_record->x;
#line 130 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp16_ = self->priv->offset;
#line 130 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	event_record->x = _tmp15_ + _tmp16_;
#line 132 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = retval;
#line 132 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 571 "RGBHistogramManipulator.c"
}


static gboolean
rgb_histogram_manipulator_on_button_release (RGBHistogramManipulator* self,
                                             GdkEventButton* event_record)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
#line 135 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), FALSE);
#line 135 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (event_record != NULL, FALSE);
#line 136 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->is_left_nub_tracking;
#line 136 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp1_) {
#line 136 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = TRUE;
#line 592 "RGBHistogramManipulator.c"
	} else {
		gboolean _tmp2_;
#line 136 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp2_ = self->priv->is_right_nub_tracking;
#line 136 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = _tmp2_;
#line 599 "RGBHistogramManipulator.c"
	}
#line 136 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp0_) {
#line 137 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		g_signal_emit (self, rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL], 0);
#line 138 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		rgb_histogram_manipulator_update_nub_extrema (self);
#line 607 "RGBHistogramManipulator.c"
	}
#line 141 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->is_left_nub_tracking = FALSE;
#line 142 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->is_right_nub_tracking = FALSE;
#line 144 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = FALSE;
#line 144 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 617 "RGBHistogramManipulator.c"
}


static gboolean
rgb_histogram_manipulator_on_button_motion (RGBHistogramManipulator* self,
                                            GdkEventMotion* event_record)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gdouble _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gdouble _tmp18_;
	gint _tmp19_;
#line 147 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), FALSE);
#line 147 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (event_record != NULL, FALSE);
#line 148 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->is_left_nub_tracking;
#line 148 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (!_tmp1_) {
#line 641 "RGBHistogramManipulator.c"
		gboolean _tmp2_;
#line 148 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp2_ = self->priv->is_right_nub_tracking;
#line 148 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = !_tmp2_;
#line 647 "RGBHistogramManipulator.c"
	} else {
#line 148 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = FALSE;
#line 651 "RGBHistogramManipulator.c"
	}
#line 148 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp0_) {
#line 149 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = FALSE;
#line 149 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 659 "RGBHistogramManipulator.c"
	}
#line 151 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = event_record->x;
#line 151 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = self->priv->offset;
#line 151 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	event_record->x = _tmp3_ - _tmp4_;
#line 152 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp5_ = self->priv->is_left_nub_tracking;
#line 152 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp5_) {
#line 671 "RGBHistogramManipulator.c"
		gint track_x_delta = 0;
		gdouble _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 153 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp6_ = event_record->x;
#line 153 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp7_ = self->priv->track_start_x;
#line 153 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		track_x_delta = ((gint) _tmp6_) - _tmp7_;
#line 154 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp8_ = self->priv->track_nub_start_position;
#line 154 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp9_ = track_x_delta;
#line 154 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->left_nub_position = _tmp8_ + _tmp9_;
#line 155 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp10_ = self->priv->left_nub_position;
#line 155 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp11_ = self->priv->left_nub_max;
#line 155 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->left_nub_position = CLAMP (_tmp10_, 0, _tmp11_);
#line 697 "RGBHistogramManipulator.c"
	} else {
		gint track_x_delta = 0;
		gdouble _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
#line 157 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp12_ = event_record->x;
#line 157 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp13_ = self->priv->track_start_x;
#line 157 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		track_x_delta = ((gint) _tmp12_) - _tmp13_;
#line 158 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp14_ = self->priv->track_nub_start_position;
#line 158 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp15_ = track_x_delta;
#line 158 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->right_nub_position = _tmp14_ + _tmp15_;
#line 159 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp16_ = self->priv->right_nub_position;
#line 159 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp17_ = self->priv->right_nub_min;
#line 159 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->right_nub_position = CLAMP (_tmp16_, _tmp17_, 255);
#line 724 "RGBHistogramManipulator.c"
	}
#line 162 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_force_update (self);
#line 163 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp18_ = event_record->x;
#line 163 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp19_ = self->priv->offset;
#line 163 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	event_record->x = _tmp18_ + _tmp19_;
#line 165 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = TRUE;
#line 165 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 738 "RGBHistogramManipulator.c"
}


static gboolean
rgb_histogram_manipulator_real_focus_out_event (GtkWidget* base,
                                                GdkEventFocus* event)
{
	RGBHistogramManipulator * self;
	gboolean result = FALSE;
#line 168 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator);
#line 168 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 169 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (GTK_WIDGET_CLASS (rgb_histogram_manipulator_parent_class)->focus_out_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), event)) {
#line 170 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = TRUE;
#line 170 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 758 "RGBHistogramManipulator.c"
	}
#line 173 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 175 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = FALSE;
#line 175 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 766 "RGBHistogramManipulator.c"
}


static gboolean
rgb_histogram_manipulator_real_key_press_event (GtkWidget* base,
                                                GdkEventKey* event)
{
	RGBHistogramManipulator * self;
	gboolean result = FALSE;
	gint delta = 0;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	gboolean _tmp3_ = FALSE;
	guint _tmp4_;
	GdkModifierType _tmp6_;
	gint _tmp8_;
	GdkModifierType _tmp9_;
#line 178 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator);
#line 178 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 179 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (GTK_WIDGET_CLASS (rgb_histogram_manipulator_parent_class)->key_press_event (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), gtk_widget_get_type (), GtkWidget), event)) {
#line 180 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = TRUE;
#line 180 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 794 "RGBHistogramManipulator.c"
	}
#line 183 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	delta = 0;
#line 185 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = event->keyval;
#line 185 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp1_ == ((guint) GDK_KEY_Left)) {
#line 185 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = TRUE;
#line 804 "RGBHistogramManipulator.c"
	} else {
		guint _tmp2_;
#line 185 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp2_ = event->keyval;
#line 185 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = _tmp2_ == ((guint) GDK_KEY_Up);
#line 811 "RGBHistogramManipulator.c"
	}
#line 185 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp0_) {
#line 186 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		delta = -1;
#line 817 "RGBHistogramManipulator.c"
	}
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = event->keyval;
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp4_ == ((guint) GDK_KEY_Right)) {
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp3_ = TRUE;
#line 825 "RGBHistogramManipulator.c"
	} else {
		guint _tmp5_;
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp5_ = event->keyval;
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp3_ = _tmp5_ == ((guint) GDK_KEY_Down);
#line 832 "RGBHistogramManipulator.c"
	}
#line 189 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp3_) {
#line 190 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		delta = 1;
#line 838 "RGBHistogramManipulator.c"
	}
#line 193 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp6_ = event->state;
#line 193 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (!((_tmp6_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK)) {
#line 844 "RGBHistogramManipulator.c"
		gint _tmp7_;
#line 194 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp7_ = delta;
#line 194 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		delta = _tmp7_ * 5;
#line 850 "RGBHistogramManipulator.c"
	}
#line 197 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp8_ = delta;
#line 197 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp8_ == 0) {
#line 198 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		result = FALSE;
#line 198 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return result;
#line 860 "RGBHistogramManipulator.c"
	}
#line 201 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp9_ = event->state;
#line 201 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if ((_tmp9_ & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) {
#line 866 "RGBHistogramManipulator.c"
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
#line 202 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp10_ = self->priv->right_nub_position;
#line 202 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp11_ = delta;
#line 202 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->right_nub_position = _tmp10_ + _tmp11_;
#line 203 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp12_ = self->priv->right_nub_position;
#line 203 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp13_ = self->priv->right_nub_min;
#line 203 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->right_nub_position = CLAMP (_tmp12_, _tmp13_, 255);
#line 883 "RGBHistogramManipulator.c"
	} else {
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
#line 205 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp14_ = self->priv->left_nub_position;
#line 205 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp15_ = delta;
#line 205 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->left_nub_position = _tmp14_ + _tmp15_;
#line 206 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp16_ = self->priv->left_nub_position;
#line 206 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp17_ = self->priv->left_nub_max;
#line 206 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		self->priv->left_nub_position = CLAMP (_tmp16_, 0, _tmp17_);
#line 901 "RGBHistogramManipulator.c"
	}
#line 210 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_signal_emit (self, rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL], 0);
#line 211 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_update_nub_extrema (self);
#line 212 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_force_update (self);
#line 214 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = TRUE;
#line 214 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 913 "RGBHistogramManipulator.c"
}


static gboolean
rgb_histogram_manipulator_real_draw (GtkWidget* base,
                                     cairo_t* ctx)
{
	RGBHistogramManipulator * self;
	gboolean result = FALSE;
	GtkBorder padding = {0};
	GtkStyleContext* _tmp0_;
	GtkBorder _tmp1_ = {0};
	GdkRectangle area = {0};
	GtkBorder _tmp2_;
	gint16 _tmp3_;
	gint _tmp4_;
	GtkBorder _tmp5_;
	gint16 _tmp6_;
	GtkBorder _tmp7_;
	gint16 _tmp8_;
	GtkBorder _tmp9_;
	gint16 _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GdkRectangle _tmp22_;
	GdkRectangle _tmp23_;
	gint _tmp24_;
	GdkRectangle _tmp25_;
	gint _tmp26_;
#line 217 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator);
#line 217 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (ctx != NULL, FALSE);
#line 218 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 218 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gtk_style_context_get_padding (_tmp0_, GTK_STATE_FLAG_NORMAL, &_tmp1_);
#line 218 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	padding = _tmp1_;
#line 220 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	memset (&area, 0, sizeof (GdkRectangle));
#line 221 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp2_ = padding;
#line 221 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = _tmp2_.left;
#line 221 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = self->priv->offset;
#line 221 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	area.x = _tmp3_ + _tmp4_;
#line 222 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp5_ = padding;
#line 222 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp6_ = _tmp5_.top;
#line 222 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	area.y = (gint) _tmp6_;
#line 223 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp7_ = padding;
#line 223 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp8_ = _tmp7_.right;
#line 223 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	area.width = RGB_HISTOGRAM_GRAPHIC_WIDTH + _tmp8_;
#line 224 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp9_ = padding;
#line 224 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp10_ = _tmp9_.bottom;
#line 224 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	area.height = RGB_HISTOGRAM_GRAPHIC_HEIGHT + _tmp10_;
#line 226 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "has-focus", &_tmp11_, NULL);
#line 226 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp12_ = _tmp11_;
#line 226 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp12_) {
#line 987 "RGBHistogramManipulator.c"
		GtkStyleContext* _tmp13_;
		GdkRectangle _tmp14_;
		gint _tmp15_;
		GdkRectangle _tmp16_;
		gint _tmp17_;
		GdkRectangle _tmp18_;
		gint _tmp19_;
		GdkRectangle _tmp20_;
		gint _tmp21_;
#line 227 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp13_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 227 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp14_ = area;
#line 227 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp15_ = _tmp14_.x;
#line 227 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp16_ = area;
#line 227 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp17_ = _tmp16_.y;
#line 227 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp18_ = area;
#line 227 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp19_ = _tmp18_.width;
#line 227 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp20_ = area;
#line 227 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp21_ = _tmp20_.height;
#line 227 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		gtk_render_focus (_tmp13_, ctx, (gdouble) _tmp15_, (gdouble) _tmp17_, (gdouble) (_tmp19_ + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE), (gdouble) ((_tmp21_ + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) + RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH));
#line 1017 "RGBHistogramManipulator.c"
	}
#line 232 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp22_ = area;
#line 232 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_draw_histogram (self, ctx, &_tmp22_);
#line 233 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp23_ = area;
#line 233 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp24_ = self->priv->left_nub_position;
#line 233 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_draw_nub (self, ctx, &_tmp23_, _tmp24_);
#line 234 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp25_ = area;
#line 234 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp26_ = self->priv->right_nub_position;
#line 234 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_draw_nub (self, ctx, &_tmp25_, _tmp26_);
#line 236 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = TRUE;
#line 236 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 1039 "RGBHistogramManipulator.c"
}


static void
rgb_histogram_manipulator_draw_histogram (RGBHistogramManipulator* self,
                                          cairo_t* ctx,
                                          GdkRectangle* area)
{
	RGBHistogram* _tmp0_;
	GdkPixbuf* histogram_graphic = NULL;
	RGBHistogram* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkRectangle _tmp4_;
	gint _tmp5_;
	GdkRectangle _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp17_;
#line 239 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 239 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (ctx != NULL);
#line 239 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (area != NULL);
#line 240 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = self->priv->histogram;
#line 240 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp0_ == NULL) {
#line 241 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		return;
#line 1071 "RGBHistogramManipulator.c"
	}
#line 243 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->histogram;
#line 243 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp2_ = rgb_histogram_get_graphic (_tmp1_);
#line 243 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	histogram_graphic = _tmp2_;
#line 245 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = histogram_graphic;
#line 245 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = *area;
#line 245 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp5_ = _tmp4_.x;
#line 245 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp6_ = *area;
#line 245 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp7_ = _tmp6_.y;
#line 245 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gdk_cairo_set_source_pixbuf (ctx, _tmp3_, (gdouble) (_tmp5_ + RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH), (gdouble) (_tmp7_ + 2));
#line 246 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_paint (ctx);
#line 248 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp8_ = self->priv->left_nub_position;
#line 248 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp8_ > 0) {
#line 1097 "RGBHistogramManipulator.c"
		GdkRectangle _tmp9_;
		gint _tmp10_;
		GdkRectangle _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GdkPixbuf* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
#line 249 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp9_ = *area;
#line 249 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp10_ = _tmp9_.x;
#line 249 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp11_ = *area;
#line 249 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp12_ = _tmp11_.y;
#line 249 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp13_ = self->priv->left_nub_position;
#line 249 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp14_ = histogram_graphic;
#line 249 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp15_ = gdk_pixbuf_get_height (_tmp14_);
#line 249 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp16_ = _tmp15_;
#line 249 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_rectangle (ctx, (gdouble) (_tmp10_ + RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH), (gdouble) (_tmp12_ + 2), (gdouble) _tmp13_, (gdouble) _tmp16_);
#line 252 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_set_source_rgba (ctx, 0.0, 0.0, 0.0, 0.45);
#line 253 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_fill (ctx);
#line 1128 "RGBHistogramManipulator.c"
	}
#line 256 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp17_ = self->priv->right_nub_position;
#line 256 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (_tmp17_ < 255) {
#line 1134 "RGBHistogramManipulator.c"
		GdkRectangle _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		GdkRectangle _tmp21_;
		gint _tmp22_;
		GdkPixbuf* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		GdkPixbuf* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp18_ = *area;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp19_ = _tmp18_.x;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp20_ = self->priv->right_nub_position;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp21_ = *area;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp22_ = _tmp21_.y;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp23_ = histogram_graphic;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp24_ = gdk_pixbuf_get_width (_tmp23_);
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp25_ = _tmp24_;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp26_ = self->priv->right_nub_position;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp27_ = histogram_graphic;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp28_ = gdk_pixbuf_get_height (_tmp27_);
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp29_ = _tmp28_;
#line 257 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_rectangle (ctx, (gdouble) ((_tmp19_ + _tmp20_) + RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH), (gdouble) (_tmp22_ + 2), (gdouble) (_tmp25_ - _tmp26_), (gdouble) _tmp29_);
#line 261 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_set_source_rgba (ctx, 1.0, 1.0, 1.0, 0.45);
#line 262 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		cairo_fill (ctx);
#line 1177 "RGBHistogramManipulator.c"
	}
#line 239 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_g_object_unref0 (histogram_graphic);
#line 1181 "RGBHistogramManipulator.c"
}


static void
rgb_histogram_manipulator_draw_nub (RGBHistogramManipulator* self,
                                    cairo_t* ctx,
                                    GdkRectangle* area,
                                    gint position)
{
	GdkRectangle _tmp0_;
	gint _tmp1_;
	GdkRectangle _tmp2_;
	gint _tmp3_;
	GdkRectangle _tmp4_;
	gint _tmp5_;
	GdkRectangle _tmp6_;
	gint _tmp7_;
	GdkRectangle _tmp8_;
	gint _tmp9_;
	GdkRectangle _tmp10_;
	gint _tmp11_;
#line 266 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 266 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (ctx != NULL);
#line 266 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (area != NULL);
#line 267 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = *area;
#line 267 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = _tmp0_.x;
#line 267 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp2_ = *area;
#line 267 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp3_ = _tmp2_.y;
#line 267 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_move_to (ctx, (gdouble) (_tmp1_ + position), (gdouble) ((_tmp3_ + RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION) + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE));
#line 268 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp4_ = *area;
#line 268 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp5_ = _tmp4_.x;
#line 268 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp6_ = *area;
#line 268 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp7_ = _tmp6_.y;
#line 268 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_line_to (ctx, (gdouble) ((_tmp5_ + position) + RGB_HISTOGRAM_MANIPULATOR_NUB_HALF_WIDTH), (gdouble) (_tmp7_ + RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION));
#line 269 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp8_ = *area;
#line 269 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp9_ = _tmp8_.x;
#line 269 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp10_ = *area;
#line 269 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp11_ = _tmp10_.y;
#line 269 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_line_to (ctx, (gdouble) ((_tmp9_ + position) + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE), (gdouble) ((_tmp11_ + RGB_HISTOGRAM_MANIPULATOR_NUB_V_POSITION) + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE));
#line 270 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_close_path (ctx);
#line 271 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_set_source_rgb (ctx, 0.333, 0.333, 0.333);
#line 272 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	cairo_fill (ctx);
#line 1245 "RGBHistogramManipulator.c"
}


static void
rgb_histogram_manipulator_force_update (RGBHistogramManipulator* self)
{
	GdkWindow* _tmp0_;
#line 275 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 276 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
#line 276 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	gdk_window_invalidate_rect (_tmp0_, NULL, TRUE);
#line 1259 "RGBHistogramManipulator.c"
}


static void
rgb_histogram_manipulator_update_nub_extrema (RGBHistogramManipulator* self)
{
	gint _tmp0_;
	gint _tmp1_;
#line 279 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 280 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = self->priv->left_nub_position;
#line 280 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->right_nub_min = (_tmp0_ + RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) + 1;
#line 281 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->right_nub_position;
#line 281 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->left_nub_max = (_tmp1_ - RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) - 1;
#line 1278 "RGBHistogramManipulator.c"
}


void
rgb_histogram_manipulator_update_histogram (RGBHistogramManipulator* self,
                                            GdkPixbuf* source_pixbuf)
{
	RGBHistogram* _tmp0_;
#line 286 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 286 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (GDK_IS_PIXBUF (source_pixbuf));
#line 287 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = rgb_histogram_new (source_pixbuf);
#line 287 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_rgb_histogram_unref0 (self->priv->histogram);
#line 287 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->histogram = _tmp0_;
#line 288 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_force_update (self);
#line 1299 "RGBHistogramManipulator.c"
}


gint
rgb_histogram_manipulator_get_left_nub_position (RGBHistogramManipulator* self)
{
	gint result = 0;
	gint _tmp0_;
#line 291 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), 0);
#line 292 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = self->priv->left_nub_position;
#line 292 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = _tmp0_;
#line 292 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 1316 "RGBHistogramManipulator.c"
}


gint
rgb_histogram_manipulator_get_right_nub_position (RGBHistogramManipulator* self)
{
	gint result = 0;
	gint _tmp0_;
#line 295 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_val_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self), 0);
#line 296 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = self->priv->right_nub_position;
#line 296 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	result = _tmp0_;
#line 296 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	return result;
#line 1333 "RGBHistogramManipulator.c"
}


void
rgb_histogram_manipulator_set_left_nub_position (RGBHistogramManipulator* self,
                                                 gint user_nub_pos)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
#line 299 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 300 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (user_nub_pos >= 0) {
#line 300 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = user_nub_pos <= 255;
#line 1349 "RGBHistogramManipulator.c"
	} else {
#line 300 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = FALSE;
#line 1353 "RGBHistogramManipulator.c"
	}
#line 300 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_vala_assert (_tmp0_, "(user_nub_pos >= 0) && (user_nub_pos <= 255)");
#line 301 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->left_nub_max;
#line 301 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->left_nub_position = CLAMP (user_nub_pos, 0, _tmp1_);
#line 302 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_update_nub_extrema (self);
#line 1363 "RGBHistogramManipulator.c"
}


void
rgb_histogram_manipulator_set_right_nub_position (RGBHistogramManipulator* self,
                                                  gint user_nub_pos)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
#line 305 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_return_if_fail (IS_RGB_HISTOGRAM_MANIPULATOR (self));
#line 306 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	if (user_nub_pos >= 0) {
#line 306 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = user_nub_pos <= 255;
#line 1379 "RGBHistogramManipulator.c"
	} else {
#line 306 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
		_tmp0_ = FALSE;
#line 1383 "RGBHistogramManipulator.c"
	}
#line 306 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_vala_assert (_tmp0_, "(user_nub_pos >= 0) && (user_nub_pos <= 255)");
#line 307 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = self->priv->right_nub_min;
#line 307 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->right_nub_position = CLAMP (user_nub_pos, _tmp1_, 255);
#line 308 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_update_nub_extrema (self);
#line 1393 "RGBHistogramManipulator.c"
}


static void
rgb_histogram_manipulator_class_init (RGBHistogramManipulatorClass * klass)
{
	GtkWidgetPath* _tmp0_;
	GtkWidgetPath* _tmp1_;
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	g_type_class_add_private (klass, sizeof (RGBHistogramManipulatorPrivate));
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	((GtkWidgetClass *) klass)->focus_out_event = (gboolean (*) (GtkWidget *, GdkEventFocus*)) rgb_histogram_manipulator_real_focus_out_event;
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget *, GdkEventKey*)) rgb_histogram_manipulator_real_key_press_event;
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) rgb_histogram_manipulator_real_draw;
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	G_OBJECT_CLASS (klass)->finalize = rgb_histogram_manipulator_finalize;
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_signals[RGB_HISTOGRAM_MANIPULATOR_NUB_POSITION_CHANGED_SIGNAL] = g_signal_new ("nub-position-changed", TYPE_RGB_HISTOGRAM_MANIPULATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 23 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp0_ = gtk_widget_path_new ();
#line 23 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_slider_draw_path = _tmp0_;
#line 24 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_tmp1_ = gtk_widget_path_new ();
#line 24 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	rgb_histogram_manipulator_frame_draw_path = _tmp1_;
#line 1424 "RGBHistogramManipulator.c"
}


static void
rgb_histogram_manipulator_instance_init (RGBHistogramManipulator * self)
{
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv = RGB_HISTOGRAM_MANIPULATOR_GET_PRIVATE (self);
#line 20 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->left_nub_max = (255 - RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE) - 1;
#line 21 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->right_nub_min = RGB_HISTOGRAM_MANIPULATOR_NUB_SIZE + 1;
#line 27 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->histogram = NULL;
#line 28 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->left_nub_position = 0;
#line 29 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->right_nub_position = 255;
#line 30 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->is_left_nub_tracking = FALSE;
#line 31 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->is_right_nub_tracking = FALSE;
#line 32 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->track_start_x = 0;
#line 33 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->track_nub_start_position = 0;
#line 34 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self->priv->offset = 0;
#line 1453 "RGBHistogramManipulator.c"
}


static void
rgb_histogram_manipulator_finalize (GObject * obj)
{
	RGBHistogramManipulator * self;
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RGB_HISTOGRAM_MANIPULATOR, RGBHistogramManipulator);
#line 27 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	_rgb_histogram_unref0 (self->priv->histogram);
#line 7 "/home/jens/Source/shotwell/src/editing_tools/RGBHistogramManipulator.vala"
	G_OBJECT_CLASS (rgb_histogram_manipulator_parent_class)->finalize (obj);
#line 1467 "RGBHistogramManipulator.c"
}


GType
rgb_histogram_manipulator_get_type (void)
{
	static volatile gsize rgb_histogram_manipulator_type_id__volatile = 0;
	if (g_once_init_enter (&rgb_histogram_manipulator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RGBHistogramManipulatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rgb_histogram_manipulator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RGBHistogramManipulator), 0, (GInstanceInitFunc) rgb_histogram_manipulator_instance_init, NULL };
		GType rgb_histogram_manipulator_type_id;
		rgb_histogram_manipulator_type_id = g_type_register_static (gtk_drawing_area_get_type (), "RGBHistogramManipulator", &g_define_type_info, 0);
		g_once_init_leave (&rgb_histogram_manipulator_type_id__volatile, rgb_histogram_manipulator_type_id);
	}
	return rgb_histogram_manipulator_type_id__volatile;
}



