/* BlindsEffect.c generated by valac 0.40.4, the Vala compiler
 * generated from BlindsEffect.vala, do not modify */

/* Copyright 2013 Jens Bav
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <shotwell-plugin-dev-1.0.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <math.h>
#include <float.h>
#include <gdk/gdk.h>


#define TYPE_SHOTWELL_TRANSITION_DESCRIPTOR (shotwell_transition_descriptor_get_type ())
#define SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptor))
#define SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define IS_SHOTWELL_TRANSITION_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR))
#define SHOTWELL_TRANSITION_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, ShotwellTransitionDescriptorClass))

typedef struct _ShotwellTransitionDescriptor ShotwellTransitionDescriptor;
typedef struct _ShotwellTransitionDescriptorClass ShotwellTransitionDescriptorClass;
typedef struct _ShotwellTransitionDescriptorPrivate ShotwellTransitionDescriptorPrivate;

#define TYPE_BLINDS_EFFECT_DESCRIPTOR (blinds_effect_descriptor_get_type ())
#define BLINDS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptor))
#define BLINDS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptorClass))
#define IS_BLINDS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLINDS_EFFECT_DESCRIPTOR))
#define IS_BLINDS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLINDS_EFFECT_DESCRIPTOR))
#define BLINDS_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptorClass))

typedef struct _BlindsEffectDescriptor BlindsEffectDescriptor;
typedef struct _BlindsEffectDescriptorClass BlindsEffectDescriptorClass;
typedef struct _BlindsEffectDescriptorPrivate BlindsEffectDescriptorPrivate;
enum  {
	BLINDS_EFFECT_DESCRIPTOR_0_PROPERTY,
	BLINDS_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* blinds_effect_descriptor_properties[BLINDS_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_BLINDS_EFFECT (blinds_effect_get_type ())
#define BLINDS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLINDS_EFFECT, BlindsEffect))
#define BLINDS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLINDS_EFFECT, BlindsEffectClass))
#define IS_BLINDS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLINDS_EFFECT))
#define IS_BLINDS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLINDS_EFFECT))
#define BLINDS_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLINDS_EFFECT, BlindsEffectClass))

typedef struct _BlindsEffect BlindsEffect;
typedef struct _BlindsEffectClass BlindsEffectClass;
typedef struct _BlindsEffectPrivate BlindsEffectPrivate;
enum  {
	BLINDS_EFFECT_0_PROPERTY,
	BLINDS_EFFECT_NUM_PROPERTIES
};
static GParamSpec* blinds_effect_properties[BLINDS_EFFECT_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _ShotwellTransitionDescriptor {
	GObject parent_instance;
	ShotwellTransitionDescriptorPrivate * priv;
};

struct _ShotwellTransitionDescriptorClass {
	GObjectClass parent_class;
	const gchar* (*get_id) (ShotwellTransitionDescriptor* self);
	const gchar* (*get_pluggable_name) (ShotwellTransitionDescriptor* self);
	SpitTransitionsEffect* (*create) (ShotwellTransitionDescriptor* self, SpitHostInterface* host);
};

struct _BlindsEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	BlindsEffectDescriptorPrivate * priv;
};

struct _BlindsEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _BlindsEffect {
	GObject parent_instance;
	BlindsEffectPrivate * priv;
};

struct _BlindsEffectClass {
	GObjectClass parent_class;
};

struct _BlindsEffectPrivate {
	gint current_blind_width;
	cairo_surface_t** to_blinds;
	gint to_blinds_length1;
	gint _to_blinds_size_;
	gint blind_count;
};


static gpointer blinds_effect_descriptor_parent_class = NULL;
static gpointer blinds_effect_parent_class = NULL;
static SpitTransitionsEffectIface * blinds_effect_spit_transitions_effect_parent_iface = NULL;

GType shotwell_transition_descriptor_get_type (void) G_GNUC_CONST;
GType blinds_effect_descriptor_get_type (void) G_GNUC_CONST;
BlindsEffectDescriptor* blinds_effect_descriptor_new (GFile* resource_directory);
BlindsEffectDescriptor* blinds_effect_descriptor_construct (GType object_type,
                                                            GFile* resource_directory);
ShotwellTransitionDescriptor* shotwell_transition_descriptor_construct (GType object_type,
                                                                        GFile* resource_directory);
static const gchar* blinds_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* blinds_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* blinds_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                             SpitHostInterface* host);
BlindsEffect* blinds_effect_new (void);
BlindsEffect* blinds_effect_construct (GType object_type);
GType blinds_effect_get_type (void) G_GNUC_CONST;
#define BLINDS_EFFECT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BLINDS_EFFECT, BlindsEffectPrivate))
#define BLINDS_EFFECT_DESIRED_FPS 30
#define BLINDS_EFFECT_MIN_FPS 15
#define BLINDS_EFFECT_BLIND_WIDTH 50
static void blinds_effect_real_get_fps (SpitTransitionsEffect* base,
                                 gint* desired_fps,
                                 gint* min_fps);
static gboolean blinds_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void blinds_effect_real_start (SpitTransitionsEffect* base,
                               SpitTransitionsVisuals* visuals,
                               SpitTransitionsMotion* motion);
static void blinds_effect_real_paint (SpitTransitionsEffect* base,
                               SpitTransitionsVisuals* visuals,
                               SpitTransitionsMotion* motion,
                               cairo_t* ctx,
                               gint width,
                               gint height,
                               gint frame_number);
static void blinds_effect_real_advance (SpitTransitionsEffect* base,
                                 SpitTransitionsVisuals* visuals,
                                 SpitTransitionsMotion* motion,
                                 gint frame_number);
static void blinds_effect_real_cancel (SpitTransitionsEffect* base);
static void blinds_effect_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


BlindsEffectDescriptor*
blinds_effect_descriptor_construct (GType object_type,
                                    GFile* resource_directory)
{
	BlindsEffectDescriptor * self = NULL;
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_val_if_fail (G_IS_FILE (resource_directory), NULL);
#line 12 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = (BlindsEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, resource_directory);
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return self;
#line 172 "BlindsEffect.c"
}


BlindsEffectDescriptor*
blinds_effect_descriptor_new (GFile* resource_directory)
{
#line 11 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return blinds_effect_descriptor_construct (TYPE_BLINDS_EFFECT_DESCRIPTOR, resource_directory);
#line 181 "BlindsEffect.c"
}


static const gchar*
blinds_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	BlindsEffectDescriptor * self;
	const gchar* result = NULL;
#line 15 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptor);
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	result = "org.yorba.shotwell.transitions.blinds";
#line 16 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return result;
#line 196 "BlindsEffect.c"
}


static const gchar*
blinds_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	BlindsEffectDescriptor * self;
	const gchar* result = NULL;
#line 19 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptor);
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	result = _ ("Blinds");
#line 20 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return result;
#line 211 "BlindsEffect.c"
}


static SpitTransitionsEffect*
blinds_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                      SpitHostInterface* host)
{
	BlindsEffectDescriptor * self;
	SpitTransitionsEffect* result = NULL;
	BlindsEffect* _tmp0_;
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptor);
#line 23 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_val_if_fail (SPIT_IS_HOST_INTERFACE (host), NULL);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp0_ = blinds_effect_new ();
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SPIT_TRANSITIONS_TYPE_EFFECT, SpitTransitionsEffect);
#line 24 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return result;
#line 232 "BlindsEffect.c"
}


static void
blinds_effect_descriptor_class_init (BlindsEffectDescriptorClass * klass)
{
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	blinds_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor *)) blinds_effect_descriptor_real_get_id;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor *)) blinds_effect_descriptor_real_get_pluggable_name;
#line 10 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor *, SpitHostInterface*)) blinds_effect_descriptor_real_create;
#line 247 "BlindsEffect.c"
}


static void
blinds_effect_descriptor_instance_init (BlindsEffectDescriptor * self)
{
}


GType
blinds_effect_descriptor_get_type (void)
{
	static volatile gsize blinds_effect_descriptor_type_id__volatile = 0;
	if (g_once_init_enter (&blinds_effect_descriptor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlindsEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) blinds_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlindsEffectDescriptor), 0, (GInstanceInitFunc) blinds_effect_descriptor_instance_init, NULL };
		GType blinds_effect_descriptor_type_id;
		blinds_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "BlindsEffectDescriptor", &g_define_type_info, 0);
		g_once_init_leave (&blinds_effect_descriptor_type_id__volatile, blinds_effect_descriptor_type_id);
	}
	return blinds_effect_descriptor_type_id__volatile;
}


BlindsEffect*
blinds_effect_construct (GType object_type)
{
	BlindsEffect * self = NULL;
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = (BlindsEffect*) g_object_new (object_type, NULL);
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return self;
#line 279 "BlindsEffect.c"
}


BlindsEffect*
blinds_effect_new (void)
{
#line 38 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return blinds_effect_construct (TYPE_BLINDS_EFFECT);
#line 288 "BlindsEffect.c"
}


static void
blinds_effect_real_get_fps (SpitTransitionsEffect* base,
                            gint* desired_fps,
                            gint* min_fps)
{
	BlindsEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 42 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_vala_desired_fps = BLINDS_EFFECT_DESIRED_FPS;
#line 43 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_vala_min_fps = BLINDS_EFFECT_MIN_FPS;
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	if (desired_fps) {
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		*desired_fps = _vala_desired_fps;
#line 310 "BlindsEffect.c"
	}
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	if (min_fps) {
#line 41 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		*min_fps = _vala_min_fps;
#line 316 "BlindsEffect.c"
	}
}


static gboolean
blinds_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	BlindsEffect * self;
	gboolean result = FALSE;
#line 46 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	result = TRUE;
#line 47 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	return result;
#line 332 "BlindsEffect.c"
}


static void
blinds_effect_real_start (SpitTransitionsEffect* base,
                          SpitTransitionsVisuals* visuals,
                          SpitTransitionsMotion* motion)
{
	BlindsEffect * self;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 50 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp0_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp1_ = _tmp0_;
#line 51 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	if (_tmp1_ != NULL) {
#line 356 "BlindsEffect.c"
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		cairo_surface_t** _tmp12_;
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp2_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp3_ = _tmp2_;
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp4_ = gdk_pixbuf_get_width (_tmp3_);
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp5_ = _tmp4_;
#line 52 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->blind_count = _tmp5_ / BLINDS_EFFECT_BLIND_WIDTH;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp6_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp7_ = _tmp6_;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp8_ = gdk_pixbuf_get_width (_tmp7_);
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp9_ = _tmp8_;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp10_ = self->priv->blind_count;
#line 53 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->current_blind_width = (gint) ceil (((gdouble) _tmp9_) / ((gdouble) _tmp10_));
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp11_ = self->priv->blind_count;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp12_ = g_new0 (cairo_surface_t*, _tmp11_ + 1);
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->to_blinds = (_vala_array_free (self->priv->to_blinds, self->priv->to_blinds_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->to_blinds = _tmp12_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->to_blinds_length1 = _tmp11_;
#line 56 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		self->priv->_to_blinds_size_ = self->priv->to_blinds_length1;
#line 402 "BlindsEffect.c"
		{
			gint i = 0;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
			i = 0;
#line 407 "BlindsEffect.c"
			{
				gboolean _tmp13_ = FALSE;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp13_ = TRUE;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				while (TRUE) {
#line 414 "BlindsEffect.c"
					gint _tmp15_;
					gint _tmp16_;
					cairo_surface_t** _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_;
					gint _tmp19_;
					GdkPixbuf* _tmp20_;
					GdkPixbuf* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					cairo_surface_t* _tmp24_;
					cairo_surface_t* _tmp25_;
					cairo_t* ctx = NULL;
					cairo_surface_t** _tmp26_;
					gint _tmp26__length1;
					gint _tmp27_;
					cairo_surface_t* _tmp28_;
					cairo_t* _tmp29_;
					cairo_t* _tmp30_;
					GdkPixbuf* _tmp31_;
					GdkPixbuf* _tmp32_;
					gint _tmp33_;
					gint _tmp34_;
					cairo_t* _tmp35_;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					if (!_tmp13_) {
#line 441 "BlindsEffect.c"
						gint _tmp14_;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
						_tmp14_ = i;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
						i = _tmp14_ + 1;
#line 447 "BlindsEffect.c"
					}
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp13_ = FALSE;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp15_ = i;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp16_ = self->priv->blind_count;
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					if (!(_tmp15_ < _tmp16_)) {
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
						break;
#line 459 "BlindsEffect.c"
					}
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp17_ = self->priv->to_blinds;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp17__length1 = self->priv->to_blinds_length1;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp18_ = i;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp19_ = self->priv->current_blind_width;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp20_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp21_ = _tmp20_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp22_ = gdk_pixbuf_get_height (_tmp21_);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp23_ = _tmp22_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp24_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, _tmp19_, _tmp23_);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_cairo_surface_destroy0 (_tmp17_[_tmp18_]);
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp17_[_tmp18_] = _tmp24_;
#line 59 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp25_ = _tmp17_[_tmp18_];
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp26_ = self->priv->to_blinds;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp26__length1 = self->priv->to_blinds_length1;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp27_ = i;
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp28_ = _tmp26_[_tmp27_];
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp29_ = cairo_create (_tmp28_);
#line 61 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					ctx = _tmp29_;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp30_ = ctx;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp31_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp32_ = _tmp31_;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp33_ = i;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp34_ = self->priv->current_blind_width;
#line 62 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					gdk_cairo_set_source_pixbuf (_tmp30_, _tmp32_, (gdouble) ((-_tmp33_) * _tmp34_), (gdouble) 0);
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp35_ = ctx;
#line 63 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					cairo_paint (_tmp35_);
#line 58 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_cairo_destroy0 (ctx);
#line 515 "BlindsEffect.c"
				}
			}
		}
	}
}


static void
blinds_effect_real_paint (SpitTransitionsEffect* base,
                          SpitTransitionsVisuals* visuals,
                          SpitTransitionsMotion* motion,
                          cairo_t* ctx,
                          gint width,
                          gint height,
                          gint frame_number)
{
	BlindsEffect * self;
	gdouble alpha = 0.0;
	gint y = 0;
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	gint _tmp2_;
	gint x = 0;
	GdkRectangle _tmp3_ = {0};
	GdkRectangle _tmp4_;
	gint _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 68 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (ctx != NULL);
#line 70 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	spit_transitions_visuals_get_to_pos (visuals, &_tmp0_);
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp1_ = _tmp0_;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp2_ = _tmp1_.y;
#line 71 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	y = _tmp2_;
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	spit_transitions_visuals_get_to_pos (visuals, &_tmp3_);
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp4_ = _tmp3_;
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp5_ = _tmp4_.x;
#line 72 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	x = _tmp5_;
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp6_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	_tmp7_ = _tmp6_;
#line 74 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	if (_tmp7_ != NULL) {
#line 576 "BlindsEffect.c"
		GdkPixbuf* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkRectangle _tmp10_ = {0};
		GdkRectangle _tmp11_;
		gint _tmp12_;
		GdkRectangle _tmp13_ = {0};
		GdkRectangle _tmp14_;
		gint _tmp15_;
		gdouble _tmp16_;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp8_ = spit_transitions_visuals_get_from_pixbuf (visuals);
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp9_ = _tmp8_;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		spit_transitions_visuals_get_from_pos (visuals, &_tmp10_);
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp11_ = _tmp10_;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp12_ = _tmp11_.x;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		spit_transitions_visuals_get_from_pos (visuals, &_tmp13_);
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp14_ = _tmp13_;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp15_ = _tmp14_.y;
#line 75 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		gdk_cairo_set_source_pixbuf (ctx, _tmp9_, (gdouble) _tmp12_, (gdouble) _tmp15_);
#line 77 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		_tmp16_ = alpha;
#line 77 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		cairo_paint_with_alpha (ctx, 1 - (_tmp16_ * 2));
#line 608 "BlindsEffect.c"
	}
	{
		gint i = 0;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
		i = 0;
#line 614 "BlindsEffect.c"
		{
			gboolean _tmp17_ = FALSE;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
			_tmp17_ = TRUE;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
			while (TRUE) {
#line 621 "BlindsEffect.c"
				gint _tmp19_;
				gint _tmp20_;
				cairo_surface_t** _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				cairo_surface_t* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gdouble _tmp33_;
				GdkPixbuf* _tmp34_;
				GdkPixbuf* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				if (!_tmp17_) {
#line 644 "BlindsEffect.c"
					gint _tmp18_;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					_tmp18_ = i;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					i = _tmp18_ + 1;
#line 650 "BlindsEffect.c"
				}
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp17_ = FALSE;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp19_ = i;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp20_ = self->priv->blind_count;
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				if (!(_tmp19_ < _tmp20_)) {
#line 80 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
					break;
#line 662 "BlindsEffect.c"
				}
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp21_ = self->priv->to_blinds;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp21__length1 = self->priv->to_blinds_length1;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp22_ = i;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp23_ = _tmp21_[_tmp22_];
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp24_ = x;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp25_ = i;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp26_ = self->priv->current_blind_width;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp27_ = y;
#line 81 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				cairo_set_source_surface (ctx, _tmp23_, (gdouble) (_tmp24_ + (_tmp25_ * _tmp26_)), (gdouble) _tmp27_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp28_ = x;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp29_ = i;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp30_ = self->priv->current_blind_width;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp31_ = y;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp32_ = self->priv->current_blind_width;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp33_ = alpha;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp34_ = spit_transitions_visuals_get_to_pixbuf (visuals);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp35_ = _tmp34_;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp36_ = gdk_pixbuf_get_height (_tmp35_);
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				_tmp37_ = _tmp36_;
#line 82 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				cairo_rectangle (ctx, (gdouble) (_tmp28_ + (_tmp29_ * _tmp30_)), (gdouble) _tmp31_, _tmp32_ * (_tmp33_ + 0.5), (gdouble) _tmp37_);
#line 84 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
				cairo_fill (ctx);
#line 706 "BlindsEffect.c"
			}
		}
	}
#line 87 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	cairo_clip (ctx);
#line 88 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	cairo_paint (ctx);
#line 714 "BlindsEffect.c"
}


static void
blinds_effect_real_advance (SpitTransitionsEffect* base,
                            SpitTransitionsVisuals* visuals,
                            SpitTransitionsMotion* motion,
                            gint frame_number)
{
	BlindsEffect * self;
#line 91 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 91 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_VISUALS (visuals));
#line 91 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_return_if_fail (SPIT_TRANSITIONS_IS_MOTION (motion));
#line 731 "BlindsEffect.c"
}


static void
blinds_effect_real_cancel (SpitTransitionsEffect* base)
{
	BlindsEffect * self;
#line 94 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 741 "BlindsEffect.c"
}


static void
blinds_effect_class_init (BlindsEffectClass * klass)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	blinds_effect_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	g_type_class_add_private (klass, sizeof (BlindsEffectPrivate));
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	G_OBJECT_CLASS (klass)->finalize = blinds_effect_finalize;
#line 754 "BlindsEffect.c"
}


static void
blinds_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	blinds_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->get_fps = (void (*) (SpitTransitionsEffect *, gint*, gint*)) blinds_effect_real_get_fps;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect *)) blinds_effect_real_needs_clear_background;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->start = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*)) blinds_effect_real_start;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->paint = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) blinds_effect_real_paint;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->advance = (void (*) (SpitTransitionsEffect *, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) blinds_effect_real_advance;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	iface->cancel = (void (*) (SpitTransitionsEffect *)) blinds_effect_real_cancel;
#line 775 "BlindsEffect.c"
}


static void
blinds_effect_instance_init (BlindsEffect * self)
{
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self->priv = BLINDS_EFFECT_GET_PRIVATE (self);
#line 784 "BlindsEffect.c"
}


static void
blinds_effect_finalize (GObject * obj)
{
	BlindsEffect * self;
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLINDS_EFFECT, BlindsEffect);
#line 35 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	self->priv->to_blinds = (_vala_array_free (self->priv->to_blinds, self->priv->to_blinds_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
#line 28 "/home/jens/Source/shotwell/plugins/shotwell-transitions/BlindsEffect.vala"
	G_OBJECT_CLASS (blinds_effect_parent_class)->finalize (obj);
#line 798 "BlindsEffect.c"
}


GType
blinds_effect_get_type (void)
{
	static volatile gsize blinds_effect_type_id__volatile = 0;
	if (g_once_init_enter (&blinds_effect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlindsEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) blinds_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlindsEffect), 0, (GInstanceInitFunc) blinds_effect_instance_init, NULL };
		static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) blinds_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType blinds_effect_type_id;
		blinds_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "BlindsEffect", &g_define_type_info, 0);
		g_type_add_interface_static (blinds_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
		g_once_init_leave (&blinds_effect_type_id__volatile, blinds_effect_type_id);
	}
	return blinds_effect_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



