RabbitMQ `3.11.12` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Bug Fixes

 * Boot time import of definitions from a `conf.d`-style directory failed unless
   `definitions.skip_if_unchanged` was set to `true`, for example, like in this
   `rabbitmq.conf`:

   ``` ini
   definitions.skip_if_unchanged = false
   definitions.import_backend = local_filesystem
   definitions.local.path = /path/to/RabbitMQ/definitions/conf.d/
   ```

   GitHub issue: [#7705](https://github.com/rabbitmq/rabbitmq-server/pull/7705)

 * Improved resiliency of dead-lettering.

   GitHib issue: [#7677](https://github.com/rabbitmq/rabbitmq-server/pull/7677)

#### Enhancements

 * When the maximum allowed number of connections to the node was limited using the `connection_max` key
   and the limit was reached, newly connecting client previously would run into a TCP connection timeout.

   Now a more specific error will be returned to the client before connection closure.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#7593](https://github.com/rabbitmq/rabbitmq-server/issues/7593)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl add_vhosts` failed with an exception when `--default-queue-type` option was provided.

   GitHub issue: [#7750](https://github.com/rabbitmq/rabbitmq-server/issues/7750)


### Management Plugin

#### Bug Fixes

 * HTTP API endpoint `PUT /api/vhosts/{name}` incorrectly used `defaultqueuetype` for default queue type
   key name. It is now `default_queue_type`, the same key as returned by `GET /api/vhosts/{name}`.

   GitHub issue: [#7734](https://github.com/rabbitmq/rabbitmq-server/issues/7734)

 * HTTP API will now respond with a `405 Method Not Allowed` instead of a 500 when
   an unsupported method is used by the client.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#7675](https://github.com/rabbitmq/rabbitmq-server/pull/7675)


### AMQP 1.0 Plugin

#### Bug Fixes

 * Fixed AMQP 1.0 authentication issue that affected OAuth 2 token users.

   GitHub issue: [#7758](https://github.com/rabbitmq/rabbitmq-server/pull/7758)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.12.tar.xz`
instead of the source tarball produced by GitHub.
