RabbitMQ `3.9.7` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 23.2, and supports the latest Erlang 24 version, 24.0.5 at the time of release. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.



## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.9.x/release-notes).
Contributors are encouraged to update them together with their changes. This helps with release automation and a more consistent release schedule.

### All Components

  * All bytecode is now compiled using the `+deterministic` compiler flag. This should eliminate the capture of some irrelevant build environment attributes in produced artifacts, improve consistency between builds, and reduce the file level diff between release artifacts.

    GitHub issue: [#3442](https://github.com/rabbitmq/rabbitmq-server/pull/3442)


### Core Server

#### Enhancements

 * Classic queue shutdown now uses a much higher timeout (up to 10 minutes instead of 30 seconds).

   In environments with many queues (especially mirrored queues) and many consumers this means that
   the chance of queue indices rebuilding after node restart is now substantially lower.

   GitHub issue: [#3409](https://github.com/rabbitmq/rabbitmq-server/pull/3409)


### Prometheus Plugin

#### Enhancements

 * More configurability for metrics exposed via the Prometheus endpoint.

   GitHub issue: [#3421](https://github.com/rabbitmq/rabbitmq-server/pull/3421)


### Shovel Plugin

#### Bug Fixes

 * Shovel URIs could be logged with credentials in some scenarios.

   GitHub issue: [#3476](https://github.com/rabbitmq/rabbitmq-server/pull/3476), contributed by @thuandb (AWS)


## Dependency Upgrades

 * observer_cli has been upgraded from `1.6.2` to `1.7.1`


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.7.tar.xz` instead of the source tarball produced by GitHub.
