## RabbitMQ 3.6.7

RabbitMQ `3.6.7` is a maintenance release that includes a [new reworked management plugin](https://github.com/rabbitmq/rabbitmq-management/issues/236) that stores collected stats on all cluster nodes (as opposed to one dedicated node).

### Upgrades and Compatibility

See the ["Upgrading clusters" section of the documentation](https://www.rabbitmq.com/clustering.html#upgrading) and a note at the end of this release notes document for general documentation on upgrades.

#### ⚠️ Erlang/OTP R16B03 and 17.x Compatibility

Erlang/OTP R16B03 users on Debian and Ubuntu may run into [runtime code compilation errors](https://groups.google.com/forum/#!topic/rabbitmq-users/XfQgta5v6Z0).
While this [was addressed in 3.6.8](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_8), we recommend upgrading to at least Erlang 18.0 if possible
(see [Debian installation guide](https://www.rabbitmq.com/install-debian.html) and [RPM installation guide](https://www.rabbitmq.com/install-rpm.html)).

#### ⚠️ New Management Plugin

In clusters that have rabbitmq_management or rabbitmq_management_agent plugins enabled all nodes must be upgraded at the same time.

There is a couple of public-facing changes in the HTTP API.

##### Test Suites that use HTTP API

Integration test suites that rely on HTTP API for listing
or closing connections, channels, etc need to be adjusted with this plugin:

 * We recommend reducing stats retention periods (see [Hop](https://github.com/rabbitmq/hop/blob/master/bin/before_build.sh#L11), [rabbit-hole](https://github.com/michaelklishin/rabbit-hole/blob/master/bin/ci/before_build.sh))
 * Because stats emission is now two-step and asynchronous, test suites may need
   to wait for events to propagate before asserting on them (see [Hop](https://github.com/rabbitmq/hop/blob/master/src/test/groovy/com/rabbitmq/http/client/ClientSpec.groovy#L168), [rabbit-hole](https://github.com/michaelklishin/rabbit-hole/blob/master/rabbithole_test.go#L130)).

##### POST and PUT Responses Use `201 Created`

POST and PUT responses now use `201 Created` instead of `204 No Content`.


#### ⚠️ Single Atom TCP Listener Options

Single atom TCP listener options such as `binary` in this example:

``` erlang
[
 {rabbit, [
           {tcp_listen_options, [
                                 binary,
                                 {backlog, 4096},
                                 {sndbuf, 32768},
                                 {recbuf, 32768}
                                ]}
  %% …
  }].
```

won't serialise to JSON correctly in this release. This is [addressed for 3.6.8](https://github.com/rabbitmq/rabbitmq-management-agent/issues/34).
Note that `binary` is one of the default options and there is no need to override it.

There are no other known incompatibilities with 3.6.2 or later releases.

### Server

#### Bug Fixes

 * queue leader process could terminate with a `{bad_match, {error, not_found}}` error.

   GitHub issue: [rabbitmq-server#1035](https://github.com/rabbitmq/rabbitmq-server/issues/1035)

 * `rabbitmq-service.bat` should exit with a non-0 code when installation fails.

   GitHub issue: [rabbitmq-server#1052](https://github.com/rabbitmq/rabbitmq-server/issues/1052)

 * `rabbitmqctl stop_app` now produces a more technically correct output about
   what the operation does.

   GitHub issue: [rabbitmq-server#1043](https://github.com/rabbitmq/rabbitmq-server/issues/1043)

#### Enhancements

 * Nodes in a cluster now can be restared in arbitrary order. They will attempt to contact
   one of the previously seen peers periodically (10 times with 30 second intervals by default).

   GitHub issue: [rabbitmq-server#1033](https://github.com/rabbitmq/rabbitmq-server/issues/1033)

 * Increased credit flow default settings, background GC is disabled by default
   for more predictable latency.

   GitHub issue: [rabbitmq-server#1098](https://github.com/rabbitmq/rabbitmq-server/pull/1098)

 * TLS listeners now support SNI (via [Ranch 1.3.0](https://ninenines.eu/articles/ranch-1.3/)).

   GitHub issue: [rabbitmq-server#789](https://github.com/rabbitmq/rabbitmq-server/issues/789)

 * Successful connection authentication now leaves additional log entries, just like authentication
   failures. It is now easier to see from the log what user connected to what vhost.

   GitHub issue: [rabbitmq-server#1140](https://github.com/rabbitmq/rabbitmq-server/issues/1140)

 * Internal authentication backend now supports credential validators.

   GitHub issue: [rabbitmq-server#1054](https://github.com/rabbitmq/rabbitmq-server/issues/1054)

 * Worker process shutdown timeout now can be configured.

   GitHub issue: [rabbitmq-server#847](https://github.com/rabbitmq/rabbitmq-server/issues/847)

 * Default Erlang VM ETS limit was increased from 1400 to 50000. This is necessary to support
   a larger number of virtual hosts with the new management plugin.

   GitHub issue: [rabbitmq-server#1059](https://github.com/rabbitmq/rabbitmq-server/issues/1059)

 * `RABBITMQ_PLUGINS_DIR` now supports multiple directories (colon-separated on Linux and other UNIX-like
   platforms, semicolon-separated on Windows).

   Contributed by Alexey Lebedeff.

   GitHub issue: [rabbitmq-server#1001](https://github.com/rabbitmq/rabbitmq-server/issues/1001)

 * Background GC now can be disabled and configured to use a different target interval value.
   Original patch by Tim Stewart.

   GitHub issue: [rabbitmq-server#1026](https://github.com/rabbitmq/rabbitmq-server/issues/1026)

 * `L`-prefixed (`long-long-int`) attribute table (header) keys are now accepted by the parser.

   GitHub issue: [rabbitmq-server#1093](https://github.com/rabbitmq/rabbitmq-server/issues/1093)

### Management Plugin

#### Bug Fixes

 * Node health check responded with status 500 if health check failed due to a timeout.

   GitHub issue: [rabbitmq-management#307](https://github.com/rabbitmq/rabbitmq-management/issues/307)

 * `GET /api/nodes` response entries contained a duplicate JSON document property (key).

   GitHub issue: [rabbitmq-management#305](https://github.com/rabbitmq/rabbitmq-management/issues/305)

 * `rabbitmqadmin` listing commands failed to output values that contained non-ASCII characters
   (such as queue names in Asian languages).

    GitHub issue: [rabbitmq-management#343](https://github.com/rabbitmq/rabbitmq-management/issues/343)

 * Queue details page now correctly displays the number of paged out transient messages.

    GitHub issue: [rabbitmq-management#345](https://github.com/rabbitmq/rabbitmq-management/issues/345)

 * When user filter returned no results, the message incorrectly said "no vhosts."

    GitHub issue: [rabbitmq-management#357](https://github.com/rabbitmq/rabbitmq-management/issues/357)

#### Enhancements

 * New management plugin implementation that stores stats on all cluster nodes.

   GitHub issue: [rabbitmq-management#236](https://github.com/rabbitmq/rabbitmq-management/issues/236)

 * Purging a queue via UI now requires a confirmation.

   GitHub issue: [rabbitmq-management#195](https://github.com/rabbitmq/rabbitmq-management/issues/195)

 * Queue deletion and purging buttons now use separate UI panes.

   GitHub issue: [rabbitmq-management#158](https://github.com/rabbitmq/rabbitmq-management/issues/158)

 * Plugins that use HTTP (management, Web STOMP, Web MQTT) now register their ports
   as TCP listeners.

   GitHub issue: [rabbitmq-web-dispatch#14](https://github.com/rabbitmq/rabbitmq-web-dispatch/issues/14)

 * Overview chart legend labels are now clearer and grouped in a more useful way.

   GitHub issue: [rabbitmq-management#339](https://github.com/rabbitmq/rabbitmq-management/issues/339)

 * Creating a queue in a vhost the user has no access to now provides
   reasonable feedback.

   GitHub issue: [rabbitmq-management#241](https://github.com/rabbitmq/rabbitmq-management/issues/241)

 * Listing queues in a vhost the user has no access to now provides
   reasonable feedback.

   GitHub issue: [rabbitmq-management#237](https://github.com/rabbitmq/rabbitmq-management/issues/237)

 * Deletion UI dialog has clearer wording.

   GitHub issue: [rabbitmq-management#159](https://github.com/rabbitmq/rabbitmq-management/issues/159)

 * When creating exchanges/queues, virtual host is now pre-selected to match the "current" one.

   GitHub issue: [rabbitmq-management#235](https://github.com/rabbitmq/rabbitmq-management/issues/235)

 * User creation form now features the "impersonator" tag.

   GitHub issue: [rabbitmq-management#284](https://github.com/rabbitmq/rabbitmq-management/issues/284)

 * Queue declaration form now includes a shortcut button for switching queue
   mode to "lazy."

   GitHub issue: [rabbitmq-management#205](https://github.com/rabbitmq/rabbitmq-management/issues/205)


### MQTT Plugin

#### Bug Fixes

 * Fixed a memory leak in statistics tables in case of certain
   abnormal connection termination scenarios.

   GitHub issue: [rabbitmq-mqtt#117](https://github.com/rabbitmq/rabbitmq-mqtt/issues/117)

 * Last Will messages that had the `retained` flag set were not retained.

   GitHub issue: [rabbitmq-mqtt#74](https://github.com/rabbitmq/rabbitmq-mqtt/issues/74)

 * More metrics are reported for MQTT connections.

   GitHub issue: [rabbitmq-mqtt#121](https://github.com/rabbitmq/rabbitmq-mqtt/issues/121)

 * Certain virtual host names could cause MQTT retainer to not start.

   GitHub issue: [rabbitmq-mqtt#123](https://github.com/rabbitmq/rabbitmq-mqtt/issues/123)

#### Enhancements

 * Improved logging around connection termination due to unparseable traffic,
   e.g. HTTP requests sent to MQTT plugin port.

   GitHub issue: [rabbitmq-mqtt#119](https://github.com/rabbitmq/rabbitmq-mqtt/issues/119)

 * There is now a way to map MQTT listener ports (target client connection ports)
   to vhosts.

   GitHub issue: [rabbitmq-mqtt#111](https://github.com/rabbitmq/rabbitmq-mqtt/issues/111)

 * There is now a way to map client certificate CN values to vhosts and thus make
   specific clients connect to designated vhosts.

   GitHub issue: [rabbitmq-mqtt#73](https://github.com/rabbitmq/rabbitmq-mqtt/issues/73)

 * Connections to non-existent hosts are now gracefully closed with a reasonable
   error code (invalid credentials).

   GitHub issue: [rabbitmq-mqtt#100](https://github.com/rabbitmq/rabbitmq-mqtt/issues/100)

 * More configuration values are accepted as strings (as well as binaries).

   GitHub issue: [rabbitmq-mqtt#86](https://github.com/rabbitmq/rabbitmq-mqtt/issues/86)


### STOMP Plugin

#### Bug Fixes

 * Fixed a memory leak in statistics tables in case of certain
   abnormal connection termination scenarios.

   GitHub issue: [rabbitmq-stomp#103](https://github.com/rabbitmq/rabbitmq-stomp/pull/103)

 * More metrics are reported for STOMP connections.

   GitHub issue: [rabbitmq-stomp#102](https://github.com/rabbitmq/rabbitmq-stomp/issues/102)


### Federation Plugin

#### Bug Fixes

 * The plugin now tolerates a higher rate of link [re-]connection failures.
   The rate sustained depends on the `reconnect-delay` parameter configured for the upstream
   (see the issue below for details).

   GitHub issue: [rabbitmq-federation#46](https://github.com/rabbitmq/rabbitmq-federation/issues/46)

#### Enhancements

 * Improved logging for federation links that voluntarily stop, e.g. because
   something in their controlling policy has changed.

   GitHub issue: [rabbitmq-federation#43](https://github.com/rabbitmq/rabbitmq-federation/issues/43)

 * Improved logging around network partitions that can affect federation links.

   GitHub issue: [rabbitmq-federation#53](https://github.com/rabbitmq/rabbitmq-federation/issues/53)


### Federation Management Plugin

#### Enhancements

 * New HTTP API endpoint that lists only down links.

   GitHub issue: [rabbitmq-federation-management#18](https://github.com/rabbitmq/rabbitmq-federation-management/issues/18)

 * New HTTP API endpoint that restarts a link.

   GitHub issue: [rabbitmq-federation-management#17](https://github.com/rabbitmq/rabbitmq-federation-management/issues/17)

### LDAP Plugin

#### Bug Fixes

 * Match query was matching too eagerly ("bi-directionally").

   GitHub issue: [rabbitmq-auth-backend-ldap#56](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/56)

 * Default LDAP server port was unintentionally set to `3890` (instead of `389`).

   GitHub issue: [rabbitmq-auth-backend-ldap#64](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/64)

#### Enhancements

 * LDAP server connection pool now supports time-based expiration (and closure) of inactive
   LDAP connections.

   GitHub issue: [rabbitmq-auth-backend-ldap#7](https://github.com/rabbitmq/rabbitmq-auth-backend-ldap/issues/7)


### Top Plugin

#### Enhancements

 * Internal buffer length of processes that implement the `gen_server2` behaviour
   (most notably queues) are now collected and visible in `rabbitmq_top`. Combined
   with Erlang mailbox length this provides a more or less complete picture of Erlang
   message backlog a process has.

   GitHub issue: [rabbitmq-top#20](https://github.com/rabbitmq/rabbitmq-top/issues/20)


### Event Exchange Plugin

#### Enhacements

 * Resource alarm events are now accessible via the event exchange.

   GitHub issue: [rabbitmq-server#1120](https://github.com/rabbitmq/rabbitmq-server/issues/1120)



### Web MQTT Plugin

#### Enhancements

 * Web MQTT port is now registered as a TCP listener and shows up in the management UI
   listeners section.

   GitHub issue: [rabbitmq-web-mqtt#17](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/17)


### Web STOMP Plugin

#### Bug Fixes

 * When HTTP basic authentication is used but credentials are not provided, the plugin should
   fall back to default configured STOMP plugin credentials.

   GitHub issue: [rabbitmq-web-stomp#60](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/60)

#### Enhancements

 * Web STOMP port is now registered as a TCP listener and shows up in the management UI
   listeners section.

   GitHub issue: [rabbitmq-web-stomp#65](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/65)


### Trust Store Plugin

#### Enhancements

 * Pluggable certificate providers (sources).

   GitHub issue: [rabbitmq-trust-store#1](https://github.com/rabbitmq/rabbitmq-trust-store/issues/1)

 * HTTP(S) certificate provider (source).

   GitHub issue: [rabbitmq-trust-store#54](https://github.com/rabbitmq/rabbitmq-trust-store/issues/54)


### .NET Client

#### Bug Fixes

 * `AutorecoveringConnection` had unsynchronised concurrent access to several of its mutable field.

   GitHub issues: [rabbitmq-dotnet-client#288](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/288),
                  [rabbitmq-dotnet-client#291](https://github.com/rabbitmq/rabbitmq-dotnet-client/issues/291)


### Erlang Client

#### Bug Fixes

 * The client OTP app now correctly defines dependencies on
   `compiler` and `syntax_tools`.

   GitHub issue: [rabbitmq-erlang-client#72](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/72)

#### Enhancements

 * URI parser now accepts binaries as well as strings.

   GitHub issue: [rabbitmq-erlang-client#76](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/76)


## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained. When upgrading using definitions export/import from versions earlier than 3.6.0, see http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.6.7.tar.gz`.
