## RabbitMQ 3.6.14

RabbitMQ `3.6.14` is a maintenance release that primarily fixes an issue in systemd
unit files that affected some systems. It is virtually identical to [3.6.13](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_13)
otherwise.

### Upgrades and Compatibility

See the ["Upgrading clusters" section of the documentation](https://www.rabbitmq.com/clustering.html#upgrading)
for general documentation on upgrades.

This release has no known incompatibilities with versions 3.6.7 through 3.6.13.
See the upgrade and compatibility sections in the [3.6.7 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/rabbitmq_v3_6_7) if upgrading from an earlier release.

### 3.6.x Series Support Timeline

Please read this node on [RabbitMQ 3.6.x series support timeline](https://groups.google.com/forum/#!msg/rabbitmq-users/kXkI-f3pgEw/UFowJIK4BQAJ).


### Debian and RPM packages

#### Bug Fixes

 * systemd service unit no longer has trailing comments that could lead nodes
   into restart loops on some systems.
   
   GitHub issues: [rabbitmq-server#1422](https://github.com/rabbitmq/rabbitmq-server/issues/1422)

### Management Plugin

#### Bug Fix

 * Expandable sections on node metrics page failed to expand.
 
   GitHub issues: [rabbitmq-management#507](https://github.com/rabbitmq/rabbitmq-management/issues/507)


## Upgrading

To upgrade a non-clustered RabbitMQ simply install the new version. All configuration and persistent message data are retained.
When upgrading using definitions export/import from versions earlier than 3.6.0, see http://rabbitmq.com/passwords.html.

To upgrade a RabbitMQ cluster, follow the instructions [in RabbitMQ documentation](https://www.rabbitmq.com/clustering.html#upgrading).

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.6.13.tar.gz`.
