-file("/usr/local/lib/erlang/lib/parsetools-2.2/include/leexinc.hrl", 0).
%% The source of this file is part of leex distribution, as such it
%% has the same Copyright as the other files in the leex
%% distribution. The Copyright is defined in the accompanying file
%% COPYRIGHT. However, the resultant scanner generated by leex is the
%% property of the creator of the scanner and is not covered by that
%% Copyright.

-module(redbug_lexer).

-export([string/1,string/2,token/2,token/3,tokens/2,tokens/3]).
-export([format_error/1]).

%% User code. This is placed here to allow extra attributes.
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 95).

%% @hidden

to_atom(Str) ->
    list_to_atom(Str).

char_to_int([$$, C]) ->
    C.

radix_to_int(Str) ->
    case erl_scan:tokens([], Str++". ", 0) of
        {done, {ok, [{integer, _, Int}, {dot, _}], 0}, []} -> Int;
        _ -> throw({error, {0, ?MODULE, "malformed_int: "++Str}, 0})
    end.

int_to_int(Str) ->
    list_to_integer(Str).

to_binary(Str) ->
    try
        {done, {ok, Toks, _}, []} = erl_scan:tokens([], Str++". ", 0),
        {ok, Exprs} = erl_parse:parse_exprs(Toks),
        {value, Val, _} = erl_eval:exprs(Exprs, erl_eval:new_bindings()),
        Val
    catch
        _:_ -> throw({error, {0, ?MODULE, "malformed_binary: "++Str}, 0})
    end.

trim(Str) ->
    lists:reverse(tl(lists:reverse(tl(Str)))).

-file("/usr/local/lib/erlang/lib/parsetools-2.2/include/leexinc.hrl", 14).

format_error({illegal,S}) -> ["illegal characters ",io_lib:write_string(S)];
format_error({user,S}) -> S.

string(String) -> string(String, 1).

string(String, Line) -> string(String, Line, String, []).

%% string(InChars, Line, TokenChars, Tokens) ->
%% {ok,Tokens,Line} | {error,ErrorInfo,Line}.
%% Note the line number going into yystate, L0, is line of token
%% start while line number returned is line of token end. We want line
%% of token start.

string([], L, [], Ts) ->                     % No partial tokens!
    {ok,yyrev(Ts),L};
string(Ics0, L0, Tcs, Ts) ->
    case yystate(yystate(), Ics0, L0, 0, reject, 0) of
        {A,Alen,Ics1,L1} ->                  % Accepting end state
            string_cont(Ics1, L1, yyaction(A, Alen, Tcs, L0), Ts);
        {A,Alen,Ics1,L1,_S1} ->              % Accepting transistion state
            string_cont(Ics1, L1, yyaction(A, Alen, Tcs, L0), Ts);
        {reject,_Alen,Tlen,_Ics1,L1,_S1} ->  % After a non-accepting state
            {error,{L0,?MODULE,{illegal,yypre(Tcs, Tlen+1)}},L1};
        {A,Alen,Tlen,_Ics1,L1,_S1} ->
            Tcs1 = yysuf(Tcs, Alen),
            L2 = adjust_line(Tlen, Alen, Tcs1, L1),
            string_cont(Tcs1, L2, yyaction(A, Alen, Tcs, L0), Ts)
    end.

%% string_cont(RestChars, Line, Token, Tokens)
%% Test for and remove the end token wrapper. Push back characters
%% are prepended to RestChars.

-dialyzer({nowarn_function, string_cont/4}).

string_cont(Rest, Line, {token,T}, Ts) ->
    string(Rest, Line, Rest, [T|Ts]);
string_cont(Rest, Line, {token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    string(NewRest, Line, NewRest, [T|Ts]);
string_cont(Rest, Line, {end_token,T}, Ts) ->
    string(Rest, Line, Rest, [T|Ts]);
string_cont(Rest, Line, {end_token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    string(NewRest, Line, NewRest, [T|Ts]);
string_cont(Rest, Line, skip_token, Ts) ->
    string(Rest, Line, Rest, Ts);
string_cont(Rest, Line, {skip_token,Push}, Ts) ->
    NewRest = Push ++ Rest,
    string(NewRest, Line, NewRest, Ts);
string_cont(_Rest, Line, {error,S}, _Ts) ->
    {error,{Line,?MODULE,{user,S}},Line}.

%% token(Continuation, Chars) ->
%% token(Continuation, Chars, Line) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.
%% Must be careful when re-entering to append the latest characters to the
%% after characters in an accept. The continuation is:
%% {token,State,CurrLine,TokenChars,TokenLen,TokenLine,AccAction,AccLen}

token(Cont, Chars) -> token(Cont, Chars, 1).

token([], Chars, Line) ->
    token(yystate(), Chars, Line, Chars, 0, Line, reject, 0);
token({token,State,Line,Tcs,Tlen,Tline,Action,Alen}, Chars, _) ->
    token(State, Chars, Line, Tcs ++ Chars, Tlen, Tline, Action, Alen).

%% token(State, InChars, Line, TokenChars, TokenLen, TokenLine,
%% AcceptAction, AcceptLen) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.
%% The argument order is chosen to be more efficient.

token(S0, Ics0, L0, Tcs, Tlen0, Tline, A0, Alen0) ->
    case yystate(S0, Ics0, L0, Tlen0, A0, Alen0) of
        %% Accepting end state, we have a token.
        {A1,Alen1,Ics1,L1} ->
            token_cont(Ics1, L1, yyaction(A1, Alen1, Tcs, Tline));
        %% Accepting transition state, can take more chars.
        {A1,Alen1,[],L1,S1} ->                  % Need more chars to check
            {more,{token,S1,L1,Tcs,Alen1,Tline,A1,Alen1}};
        {A1,Alen1,Ics1,L1,_S1} ->               % Take what we got
            token_cont(Ics1, L1, yyaction(A1, Alen1, Tcs, Tline));
        %% After a non-accepting state, maybe reach accept state later.
        {A1,Alen1,Tlen1,[],L1,S1} ->            % Need more chars to check
            {more,{token,S1,L1,Tcs,Tlen1,Tline,A1,Alen1}};
        {reject,_Alen1,Tlen1,eof,L1,_S1} ->     % No token match
            %% Check for partial token which is error.
            Ret = if Tlen1 > 0 -> {error,{Tline,?MODULE,
                                          %% Skip eof tail in Tcs.
                                          {illegal,yypre(Tcs, Tlen1)}},L1};
                     true -> {eof,L1}
                  end,
            {done,Ret,eof};
        {reject,_Alen1,Tlen1,Ics1,L1,_S1} ->    % No token match
            Error = {Tline,?MODULE,{illegal,yypre(Tcs, Tlen1+1)}},
            {done,{error,Error,L1},Ics1};
        {A1,Alen1,Tlen1,_Ics1,L1,_S1} ->       % Use last accept match
            Tcs1 = yysuf(Tcs, Alen1),
            L2 = adjust_line(Tlen1, Alen1, Tcs1, L1),
            token_cont(Tcs1, L2, yyaction(A1, Alen1, Tcs, Tline))
    end.

%% token_cont(RestChars, Line, Token)
%% If we have a token or error then return done, else if we have a
%% skip_token then continue.

-dialyzer({nowarn_function, token_cont/3}).

token_cont(Rest, Line, {token,T}) ->
    {done,{ok,T,Line},Rest};
token_cont(Rest, Line, {token,T,Push}) ->
    NewRest = Push ++ Rest,
    {done,{ok,T,Line},NewRest};
token_cont(Rest, Line, {end_token,T}) ->
    {done,{ok,T,Line},Rest};
token_cont(Rest, Line, {end_token,T,Push}) ->
    NewRest = Push ++ Rest,
    {done,{ok,T,Line},NewRest};
token_cont(Rest, Line, skip_token) ->
    token(yystate(), Rest, Line, Rest, 0, Line, reject, 0);
token_cont(Rest, Line, {skip_token,Push}) ->
    NewRest = Push ++ Rest,
    token(yystate(), NewRest, Line, NewRest, 0, Line, reject, 0);
token_cont(Rest, Line, {error,S}) ->
    {done,{error,{Line,?MODULE,{user,S}},Line},Rest}.

%% tokens(Continuation, Chars, Line) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.
%% Must be careful when re-entering to append the latest characters to the
%% after characters in an accept. The continuation is:
%% {tokens,State,CurrLine,TokenChars,TokenLen,TokenLine,Tokens,AccAction,AccLen}
%% {skip_tokens,State,CurrLine,TokenChars,TokenLen,TokenLine,Error,AccAction,AccLen}

tokens(Cont, Chars) -> tokens(Cont, Chars, 1).

tokens([], Chars, Line) ->
    tokens(yystate(), Chars, Line, Chars, 0, Line, [], reject, 0);
tokens({tokens,State,Line,Tcs,Tlen,Tline,Ts,Action,Alen}, Chars, _) ->
    tokens(State, Chars, Line, Tcs ++ Chars, Tlen, Tline, Ts, Action, Alen);
tokens({skip_tokens,State,Line,Tcs,Tlen,Tline,Error,Action,Alen}, Chars, _) ->
    skip_tokens(State, Chars, Line, Tcs ++ Chars, Tlen, Tline, Error, Action, Alen).

%% tokens(State, InChars, Line, TokenChars, TokenLen, TokenLine, Tokens,
%% AcceptAction, AcceptLen) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.

tokens(S0, Ics0, L0, Tcs, Tlen0, Tline, Ts, A0, Alen0) ->
    case yystate(S0, Ics0, L0, Tlen0, A0, Alen0) of
        %% Accepting end state, we have a token.
        {A1,Alen1,Ics1,L1} ->
            tokens_cont(Ics1, L1, yyaction(A1, Alen1, Tcs, Tline), Ts);
        %% Accepting transition state, can take more chars.
        {A1,Alen1,[],L1,S1} ->                  % Need more chars to check
            {more,{tokens,S1,L1,Tcs,Alen1,Tline,Ts,A1,Alen1}};
        {A1,Alen1,Ics1,L1,_S1} ->               % Take what we got
            tokens_cont(Ics1, L1, yyaction(A1, Alen1, Tcs, Tline), Ts);
        %% After a non-accepting state, maybe reach accept state later.
        {A1,Alen1,Tlen1,[],L1,S1} ->            % Need more chars to check
            {more,{tokens,S1,L1,Tcs,Tlen1,Tline,Ts,A1,Alen1}};
        {reject,_Alen1,Tlen1,eof,L1,_S1} ->     % No token match
            %% Check for partial token which is error, no need to skip here.
            Ret = if Tlen1 > 0 -> {error,{Tline,?MODULE,
                                          %% Skip eof tail in Tcs.
                                          {illegal,yypre(Tcs, Tlen1)}},L1};
                     Ts == [] -> {eof,L1};
                     true -> {ok,yyrev(Ts),L1}
                  end,
            {done,Ret,eof};
        {reject,_Alen1,Tlen1,_Ics1,L1,_S1} ->
            %% Skip rest of tokens.
            Error = {L1,?MODULE,{illegal,yypre(Tcs, Tlen1+1)}},
            skip_tokens(yysuf(Tcs, Tlen1+1), L1, Error);
        {A1,Alen1,Tlen1,_Ics1,L1,_S1} ->
            Token = yyaction(A1, Alen1, Tcs, Tline),
            Tcs1 = yysuf(Tcs, Alen1),
            L2 = adjust_line(Tlen1, Alen1, Tcs1, L1),
            tokens_cont(Tcs1, L2, Token, Ts)
    end.

%% tokens_cont(RestChars, Line, Token, Tokens)
%% If we have an end_token or error then return done, else if we have
%% a token then save it and continue, else if we have a skip_token
%% just continue.

-dialyzer({nowarn_function, tokens_cont/4}).

tokens_cont(Rest, Line, {token,T}, Ts) ->
    tokens(yystate(), Rest, Line, Rest, 0, Line, [T|Ts], reject, 0);
tokens_cont(Rest, Line, {token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    tokens(yystate(), NewRest, Line, NewRest, 0, Line, [T|Ts], reject, 0);
tokens_cont(Rest, Line, {end_token,T}, Ts) ->
    {done,{ok,yyrev(Ts, [T]),Line},Rest};
tokens_cont(Rest, Line, {end_token,T,Push}, Ts) ->
    NewRest = Push ++ Rest,
    {done,{ok,yyrev(Ts, [T]),Line},NewRest};
tokens_cont(Rest, Line, skip_token, Ts) ->
    tokens(yystate(), Rest, Line, Rest, 0, Line, Ts, reject, 0);
tokens_cont(Rest, Line, {skip_token,Push}, Ts) ->
    NewRest = Push ++ Rest,
    tokens(yystate(), NewRest, Line, NewRest, 0, Line, Ts, reject, 0);
tokens_cont(Rest, Line, {error,S}, _Ts) ->
    skip_tokens(Rest, Line, {Line,?MODULE,{user,S}}).

%%skip_tokens(InChars, Line, Error) -> {done,{error,Error,Line},Ics}.
%% Skip tokens until an end token, junk everything and return the error.

skip_tokens(Ics, Line, Error) ->
    skip_tokens(yystate(), Ics, Line, Ics, 0, Line, Error, reject, 0).

%% skip_tokens(State, InChars, Line, TokenChars, TokenLen, TokenLine, Tokens,
%% AcceptAction, AcceptLen) ->
%% {more,Continuation} | {done,ReturnVal,RestChars}.

skip_tokens(S0, Ics0, L0, Tcs, Tlen0, Tline, Error, A0, Alen0) ->
    case yystate(S0, Ics0, L0, Tlen0, A0, Alen0) of
        {A1,Alen1,Ics1,L1} ->                  % Accepting end state
            skip_cont(Ics1, L1, yyaction(A1, Alen1, Tcs, Tline), Error);
        {A1,Alen1,[],L1,S1} ->                 % After an accepting state
            {more,{skip_tokens,S1,L1,Tcs,Alen1,Tline,Error,A1,Alen1}};
        {A1,Alen1,Ics1,L1,_S1} ->
            skip_cont(Ics1, L1, yyaction(A1, Alen1, Tcs, Tline), Error);
        {A1,Alen1,Tlen1,[],L1,S1} ->           % After a non-accepting state
            {more,{skip_tokens,S1,L1,Tcs,Tlen1,Tline,Error,A1,Alen1}};
        {reject,_Alen1,_Tlen1,eof,L1,_S1} ->
            {done,{error,Error,L1},eof};
        {reject,_Alen1,Tlen1,_Ics1,L1,_S1} ->
            skip_tokens(yysuf(Tcs, Tlen1+1), L1, Error);
        {A1,Alen1,Tlen1,_Ics1,L1,_S1} ->
            Token = yyaction(A1, Alen1, Tcs, Tline),
            Tcs1 = yysuf(Tcs, Alen1),
            L2 = adjust_line(Tlen1, Alen1, Tcs1, L1),
            skip_cont(Tcs1, L2, Token, Error)
    end.

%% skip_cont(RestChars, Line, Token, Error)
%% Skip tokens until we have an end_token or error then return done
%% with the original rror.

-dialyzer({nowarn_function, skip_cont/4}).

skip_cont(Rest, Line, {token,_T}, Error) ->
    skip_tokens(yystate(), Rest, Line, Rest, 0, Line, Error, reject, 0);
skip_cont(Rest, Line, {token,_T,Push}, Error) ->
    NewRest = Push ++ Rest,
    skip_tokens(yystate(), NewRest, Line, NewRest, 0, Line, Error, reject, 0);
skip_cont(Rest, Line, {end_token,_T}, Error) ->
    {done,{error,Error,Line},Rest};
skip_cont(Rest, Line, {end_token,_T,Push}, Error) ->
    NewRest = Push ++ Rest,
    {done,{error,Error,Line},NewRest};
skip_cont(Rest, Line, skip_token, Error) ->
    skip_tokens(yystate(), Rest, Line, Rest, 0, Line, Error, reject, 0);
skip_cont(Rest, Line, {skip_token,Push}, Error) ->
    NewRest = Push ++ Rest,
    skip_tokens(yystate(), NewRest, Line, NewRest, 0, Line, Error, reject, 0);
skip_cont(Rest, Line, {error,_S}, Error) ->
    skip_tokens(yystate(), Rest, Line, Rest, 0, Line, Error, reject, 0).

-compile({nowarn_unused_function, [yyrev/1, yyrev/2, yypre/2, yysuf/2]}).

yyrev(List) -> lists:reverse(List).
yyrev(List, Tail) -> lists:reverse(List, Tail).
yypre(List, N) -> lists:sublist(List, N).
yysuf(List, N) -> lists:nthtail(N, List).

%% adjust_line(TokenLength, AcceptLength, Chars, Line) -> NewLine
%% Make sure that newlines in Chars are not counted twice.
%% Line has been updated with respect to newlines in the prefix of
%% Chars consisting of (TokenLength - AcceptLength) characters.

-compile({nowarn_unused_function, adjust_line/4}).

adjust_line(N, N, _Cs, L) -> L;
adjust_line(T, A, [$\n|Cs], L) ->
    adjust_line(T-1, A, Cs, L-1);
adjust_line(T, A, [_|Cs], L) ->
    adjust_line(T-1, A, Cs, L).

%% yystate() -> InitialState.
%% yystate(State, InChars, Line, CurrTokLen, AcceptAction, AcceptLen) ->
%% {Action, AcceptLen, RestChars, Line} |
%% {Action, AcceptLen, RestChars, Line, State} |
%% {reject, AcceptLen, CurrTokLen, RestChars, Line, State} |
%% {Action, AcceptLen, CurrTokLen, RestChars, Line, State}.
%% Generated state transition functions. The non-accepting end state
%% return signal either an unrecognised character or end of current
%% input.

-file("/home/masse/git/redbug/src/redbug_lexer.erl", 337).
yystate() -> 162.

yystate(177, [97|Ics], Line, Tlen, _, _) ->
    yystate(161, Ics, Line, Tlen+1, 19, Tlen);
yystate(177, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(177, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(177, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(177, [C|Ics], Line, Tlen, _, _) when C >= 98, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(177, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,177};
yystate(176, [112|Ics], Line, Tlen, _, _) ->
    yystate(160, Ics, Line, Tlen+1, 19, Tlen);
yystate(176, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(176, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(176, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(176, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 111 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(176, [C|Ics], Line, Tlen, _, _) when C >= 113, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(176, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,176};
yystate(175, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(165, Ics, Line, Tlen+1, Action, Alen);
yystate(175, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,175};
yystate(174, [116|Ics], Line, Tlen, _, _) ->
    yystate(158, Ics, Line, Tlen+1, 19, Tlen);
yystate(174, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(174, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(174, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(174, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(174, [C|Ics], Line, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(174, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,174};
yystate(173, [111|Ics], Line, Tlen, _, _) ->
    yystate(167, Ics, Line, Tlen+1, 19, Tlen);
yystate(173, [101|Ics], Line, Tlen, _, _) ->
    yystate(131, Ics, Line, Tlen+1, 19, Tlen);
yystate(173, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(173, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(173, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(173, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(173, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 110 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(173, [C|Ics], Line, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(173, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,173};
yystate(172, [62|Ics], Line, Tlen, Action, Alen) ->
    yystate(156, Ics, Line, Tlen+1, Action, Alen);
yystate(172, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(172, Ics, Line, Tlen+1, Action, Alen);
yystate(172, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,172};
yystate(171, [100|Ics], Line, Tlen, _, _) ->
    yystate(163, Ics, Line, Tlen+1, 19, Tlen);
yystate(171, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(171, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(171, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(171, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(171, [C|Ics], Line, Tlen, _, _) when C >= 101, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(171, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,171};
yystate(170, [10|Ics], Line, Tlen, _, _) ->
    yystate(170, Ics, Line+1, Tlen+1, 0, Tlen);
yystate(170, [C|Ics], Line, Tlen, _, _) when C >= 0, C =< 9 ->
    yystate(170, Ics, Line, Tlen+1, 0, Tlen);
yystate(170, [C|Ics], Line, Tlen, _, _) when C >= 11, C =< 32 ->
    yystate(170, Ics, Line, Tlen+1, 0, Tlen);
yystate(170, Ics, Line, Tlen, _, _) ->
    {0,Tlen,Ics,Line,170};
yystate(169, [110|Ics], Line, Tlen, _, _) ->
    yystate(171, Ics, Line, Tlen+1, 19, Tlen);
yystate(169, [98|Ics], Line, Tlen, _, _) ->
    yystate(103, Ics, Line, Tlen+1, 19, Tlen);
yystate(169, [97|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(169, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(169, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(169, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(169, [C|Ics], Line, Tlen, _, _) when C >= 99, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(169, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(169, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,169};
yystate(168, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(172, Ics, Line, Tlen+1, Action, Alen);
yystate(168, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,168};
yystate(167, [117|Ics], Line, Tlen, _, _) ->
    yystate(155, Ics, Line, Tlen+1, 19, Tlen);
yystate(167, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(167, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(167, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(167, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 116 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(167, [C|Ics], Line, Tlen, _, _) when C >= 118, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(167, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,167};
yystate(166, [122|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(166, [121|Ics], Line, Tlen, _, _) ->
    yystate(136, Ics, Line, Tlen+1, 19, Tlen);
yystate(166, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(166, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(166, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(166, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 120 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(166, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,166};
yystate(165, [46|Ics], Line, Tlen, Action, Alen) ->
    yystate(149, Ics, Line, Tlen+1, Action, Alen);
yystate(165, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(165, Ics, Line, Tlen+1, Action, Alen);
yystate(165, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,165};
yystate(164, [117|Ics], Line, Tlen, _, _) ->
    yystate(176, Ics, Line, Tlen+1, 19, Tlen);
yystate(164, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(164, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(164, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(164, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 116 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(164, [C|Ics], Line, Tlen, _, _) when C >= 118, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(164, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,164};
yystate(163, [97|Ics], Line, Tlen, _, _) ->
    yystate(151, Ics, Line, Tlen+1, 13, Tlen);
yystate(163, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(163, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(163, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(163, [C|Ics], Line, Tlen, _, _) when C >= 98, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(163, Ics, Line, Tlen, _, _) ->
    {13,Tlen,Ics,Line,163};
yystate(162, [125|Ics], Line, Tlen, Action, Alen) ->
    yystate(146, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [124|Ics], Line, Tlen, Action, Alen) ->
    yystate(146, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [123|Ics], Line, Tlen, Action, Alen) ->
    yystate(146, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [121|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [122|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [120|Ics], Line, Tlen, Action, Alen) ->
    yystate(130, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [119|Ics], Line, Tlen, Action, Alen) ->
    yystate(66, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [117|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [118|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [116|Ics], Line, Tlen, Action, Alen) ->
    yystate(2, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [115|Ics], Line, Tlen, Action, Alen) ->
    yystate(77, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [114|Ics], Line, Tlen, Action, Alen) ->
    yystate(173, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [112|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [113|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [111|Ics], Line, Tlen, Action, Alen) ->
    yystate(99, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [110|Ics], Line, Tlen, Action, Alen) ->
    yystate(19, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [109|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [108|Ics], Line, Tlen, Action, Alen) ->
    yystate(36, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [106|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [107|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [105|Ics], Line, Tlen, Action, Alen) ->
    yystate(116, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [104|Ics], Line, Tlen, Action, Alen) ->
    yystate(126, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [102|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [103|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [101|Ics], Line, Tlen, Action, Alen) ->
    yystate(110, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [100|Ics], Line, Tlen, Action, Alen) ->
    yystate(1, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [99|Ics], Line, Tlen, Action, Alen) ->
    yystate(82, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [98|Ics], Line, Tlen, Action, Alen) ->
    yystate(33, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [97|Ics], Line, Tlen, Action, Alen) ->
    yystate(169, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [95|Ics], Line, Tlen, Action, Alen) ->
    yystate(87, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [93|Ics], Line, Tlen, Action, Alen) ->
    yystate(146, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [91|Ics], Line, Tlen, Action, Alen) ->
    yystate(146, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [62|Ics], Line, Tlen, Action, Alen) ->
    yystate(79, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [61|Ics], Line, Tlen, Action, Alen) ->
    yystate(63, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [60|Ics], Line, Tlen, Action, Alen) ->
    yystate(23, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [59|Ics], Line, Tlen, Action, Alen) ->
    yystate(146, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [58|Ics], Line, Tlen, Action, Alen) ->
    yystate(140, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [51|Ics], Line, Tlen, Action, Alen) ->
    yystate(92, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [50|Ics], Line, Tlen, Action, Alen) ->
    yystate(76, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [49|Ics], Line, Tlen, Action, Alen) ->
    yystate(44, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [48|Ics], Line, Tlen, Action, Alen) ->
    yystate(28, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [47|Ics], Line, Tlen, Action, Alen) ->
    yystate(20, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [45|Ics], Line, Tlen, Action, Alen) ->
    yystate(11, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [44|Ics], Line, Tlen, Action, Alen) ->
    yystate(146, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [43|Ics], Line, Tlen, Action, Alen) ->
    yystate(27, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [42|Ics], Line, Tlen, Action, Alen) ->
    yystate(43, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [41|Ics], Line, Tlen, Action, Alen) ->
    yystate(146, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [40|Ics], Line, Tlen, Action, Alen) ->
    yystate(146, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [39|Ics], Line, Tlen, Action, Alen) ->
    yystate(75, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [36|Ics], Line, Tlen, Action, Alen) ->
    yystate(91, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [35|Ics], Line, Tlen, Action, Alen) ->
    yystate(123, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [34|Ics], Line, Tlen, Action, Alen) ->
    yystate(154, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [10|Ics], Line, Tlen, Action, Alen) ->
    yystate(170, Ics, Line+1, Tlen+1, Action, Alen);
yystate(162, [C|Ics], Line, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(170, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [C|Ics], Line, Tlen, Action, Alen) when C >= 11, C =< 32 ->
    yystate(170, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [C|Ics], Line, Tlen, Action, Alen) when C >= 52, C =< 57 ->
    yystate(60, Ics, Line, Tlen+1, Action, Alen);
yystate(162, [C|Ics], Line, Tlen, Action, Alen) when C >= 65, C =< 90 ->
    yystate(87, Ics, Line, Tlen+1, Action, Alen);
yystate(162, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,162};
yystate(161, [112|Ics], Line, Tlen, _, _) ->
    yystate(136, Ics, Line, Tlen+1, 19, Tlen);
yystate(161, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(161, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(161, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(161, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 111 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(161, [C|Ics], Line, Tlen, _, _) when C >= 113, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(161, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,161};
yystate(160, [108|Ics], Line, Tlen, _, _) ->
    yystate(16, Ics, Line, Tlen+1, 19, Tlen);
yystate(160, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(160, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(160, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(160, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(160, [C|Ics], Line, Tlen, _, _) when C >= 109, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(160, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,160};
yystate(159, [60|Ics], Line, Tlen, Action, Alen) ->
    yystate(175, Ics, Line, Tlen+1, Action, Alen);
yystate(159, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,159};
yystate(158, [111|Ics], Line, Tlen, _, _) ->
    yystate(142, Ics, Line, Tlen+1, 19, Tlen);
yystate(158, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(158, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(158, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(158, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(158, [C|Ics], Line, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(158, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,158};
yystate(157, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 7, Tlen);
yystate(157, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 7, Tlen);
yystate(157, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 7, Tlen);
yystate(157, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 7, Tlen);
yystate(157, Ics, Line, Tlen, _, _) ->
    {7,Tlen,Ics,Line,157};
yystate(156, Ics, Line, Tlen, _, _) ->
    {1,Tlen,Ics,Line};
yystate(155, [110|Ics], Line, Tlen, _, _) ->
    yystate(126, Ics, Line, Tlen+1, 19, Tlen);
yystate(155, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(155, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(155, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(155, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(155, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(155, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,155};
yystate(154, [92|Ics], Line, Tlen, Action, Alen) ->
    yystate(106, Ics, Line, Tlen+1, Action, Alen);
yystate(154, [34|Ics], Line, Tlen, Action, Alen) ->
    yystate(138, Ics, Line, Tlen+1, Action, Alen);
yystate(154, [10|Ics], Line, Tlen, Action, Alen) ->
    yystate(154, Ics, Line+1, Tlen+1, Action, Alen);
yystate(154, [C|Ics], Line, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(154, Ics, Line, Tlen+1, Action, Alen);
yystate(154, [C|Ics], Line, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(154, Ics, Line, Tlen+1, Action, Alen);
yystate(154, [C|Ics], Line, Tlen, Action, Alen) when C >= 35, C =< 91 ->
    yystate(154, Ics, Line, Tlen+1, Action, Alen);
yystate(154, [C|Ics], Line, Tlen, Action, Alen) when C >= 93 ->
    yystate(154, Ics, Line, Tlen+1, Action, Alen);
yystate(154, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,154};
yystate(153, [100|Ics], Line, Tlen, _, _) ->
    yystate(115, Ics, Line, Tlen+1, 19, Tlen);
yystate(153, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(153, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(153, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(153, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(153, [C|Ics], Line, Tlen, _, _) when C >= 101, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(153, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,153};
yystate(152, [46|Ics], Line, Tlen, Action, Alen) ->
    yystate(168, Ics, Line, Tlen+1, Action, Alen);
yystate(152, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(152, Ics, Line, Tlen+1, Action, Alen);
yystate(152, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,152};
yystate(151, [108|Ics], Line, Tlen, _, _) ->
    yystate(135, Ics, Line, Tlen+1, 19, Tlen);
yystate(151, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(151, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(151, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(151, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(151, [C|Ics], Line, Tlen, _, _) when C >= 109, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(151, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,151};
yystate(150, [114|Ics], Line, Tlen, _, _) ->
    yystate(166, Ics, Line, Tlen+1, 19, Tlen);
yystate(150, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(150, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(150, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(150, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(150, [C|Ics], Line, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(150, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,150};
yystate(149, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(133, Ics, Line, Tlen+1, Action, Alen);
yystate(149, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,149};
yystate(148, [116|Ics], Line, Tlen, _, _) ->
    yystate(164, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [115|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [114|Ics], Line, Tlen, _, _) ->
    yystate(120, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [113|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [112|Ics], Line, Tlen, _, _) ->
    yystate(55, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [111|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [110|Ics], Line, Tlen, _, _) ->
    yystate(111, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [109|Ics], Line, Tlen, _, _) ->
    yystate(177, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [108|Ics], Line, Tlen, _, _) ->
    yystate(145, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [106|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [107|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [105|Ics], Line, Tlen, _, _) ->
    yystate(97, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [103|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [104|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [102|Ics], Line, Tlen, _, _) ->
    yystate(9, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [98|Ics], Line, Tlen, _, _) ->
    yystate(102, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [97|Ics], Line, Tlen, _, _) ->
    yystate(174, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [C|Ics], Line, Tlen, _, _) when C >= 99, C =< 101 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, [C|Ics], Line, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(148, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,148};
yystate(147, [102|Ics], Line, Tlen, Action, Alen) ->
    yystate(159, Ics, Line, Tlen+1, Action, Alen);
yystate(147, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,147};
yystate(146, Ics, Line, Tlen, _, _) ->
    {4,Tlen,Ics,Line};
yystate(145, [105|Ics], Line, Tlen, _, _) ->
    yystate(129, Ics, Line, Tlen+1, 19, Tlen);
yystate(145, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(145, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(145, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(145, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 104 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(145, [C|Ics], Line, Tlen, _, _) when C >= 106, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(145, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,145};
yystate(144, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(152, Ics, Line, Tlen+1, Action, Alen);
yystate(144, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,144};
yystate(143, [98|Ics], Line, Tlen, _, _) ->
    yystate(41, Ics, Line, Tlen+1, 19, Tlen);
yystate(143, [97|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(143, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(143, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(143, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(143, [C|Ics], Line, Tlen, _, _) when C >= 99, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(143, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,143};
yystate(142, [109|Ics], Line, Tlen, _, _) ->
    yystate(136, Ics, Line, Tlen+1, 19, Tlen);
yystate(142, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(142, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(142, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(142, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 108 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(142, [C|Ics], Line, Tlen, _, _) when C >= 110, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(142, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,142};
yystate(141, [102|Ics], Line, Tlen, _, _) ->
    yystate(157, Ics, Line, Tlen+1, 19, Tlen);
yystate(141, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(141, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(141, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(141, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 101 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(141, [C|Ics], Line, Tlen, _, _) when C >= 103, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(141, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,141};
yystate(140, [61|Ics], Line, Tlen, _, _) ->
    yystate(146, Ics, Line, Tlen+1, 4, Tlen);
yystate(140, Ics, Line, Tlen, _, _) ->
    {4,Tlen,Ics,Line,140};
yystate(139, [101|Ics], Line, Tlen, Action, Alen) ->
    yystate(147, Ics, Line, Tlen+1, Action, Alen);
yystate(139, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,139};
yystate(138, Ics, Line, Tlen, _, _) ->
    {18,Tlen,Ics,Line};
yystate(137, [110|Ics], Line, Tlen, _, _) ->
    yystate(153, Ics, Line, Tlen+1, 19, Tlen);
yystate(137, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(137, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(137, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(137, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(137, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(137, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,137};
yystate(136, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 5, Tlen);
yystate(136, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 5, Tlen);
yystate(136, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 5, Tlen);
yystate(136, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 5, Tlen);
yystate(136, Ics, Line, Tlen, _, _) ->
    {5,Tlen,Ics,Line,136};
yystate(135, [115|Ics], Line, Tlen, _, _) ->
    yystate(119, Ics, Line, Tlen+1, 19, Tlen);
yystate(135, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(135, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(135, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(135, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 114 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(135, [C|Ics], Line, Tlen, _, _) when C >= 116, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(135, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,135};
yystate(134, [97|Ics], Line, Tlen, _, _) ->
    yystate(150, Ics, Line, Tlen+1, 19, Tlen);
yystate(134, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(134, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(134, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(134, [C|Ics], Line, Tlen, _, _) when C >= 98, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(134, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,134};
yystate(133, [46|Ics], Line, Tlen, Action, Alen) ->
    yystate(117, Ics, Line, Tlen+1, Action, Alen);
yystate(133, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(133, Ics, Line, Tlen+1, Action, Alen);
yystate(133, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,133};
yystate(132, [95|Ics], Line, Tlen, _, _) ->
    yystate(148, Ics, Line, Tlen+1, 19, Tlen);
yystate(132, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(132, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(132, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(132, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,132};
yystate(131, [109|Ics], Line, Tlen, _, _) ->
    yystate(115, Ics, Line, Tlen+1, 19, Tlen);
yystate(131, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(131, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(131, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(131, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 108 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(131, [C|Ics], Line, Tlen, _, _) when C >= 110, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(131, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,131};
yystate(130, [111|Ics], Line, Tlen, _, _) ->
    yystate(114, Ics, Line, Tlen+1, 19, Tlen);
yystate(130, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(130, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(130, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(130, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(130, [C|Ics], Line, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(130, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,130};
yystate(129, [115|Ics], Line, Tlen, _, _) ->
    yystate(113, Ics, Line, Tlen+1, 19, Tlen);
yystate(129, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(129, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(129, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(129, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 114 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(129, [C|Ics], Line, Tlen, _, _) when C >= 116, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(129, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,129};
yystate(128, [46|Ics], Line, Tlen, Action, Alen) ->
    yystate(144, Ics, Line, Tlen+1, Action, Alen);
yystate(128, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(128, Ics, Line, Tlen+1, Action, Alen);
yystate(128, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,128};
yystate(127, [109|Ics], Line, Tlen, _, _) ->
    yystate(143, Ics, Line, Tlen+1, 19, Tlen);
yystate(127, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(127, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(127, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(127, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 108 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(127, [C|Ics], Line, Tlen, _, _) when C >= 110, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(127, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,127};
yystate(126, [100|Ics], Line, Tlen, _, _) ->
    yystate(61, Ics, Line, Tlen+1, 19, Tlen);
yystate(126, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(126, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(126, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(126, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(126, [C|Ics], Line, Tlen, _, _) when C >= 101, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(126, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,126};
yystate(125, [108|Ics], Line, Tlen, _, _) ->
    yystate(141, Ics, Line, Tlen+1, 19, Tlen);
yystate(125, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(125, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(125, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(125, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(125, [C|Ics], Line, Tlen, _, _) when C >= 109, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(125, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,125};
yystate(124, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(108, Ics, Line, Tlen+1, Action, Alen);
yystate(124, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,124};
yystate(123, [123|Ics], Line, Tlen, _, _) ->
    yystate(146, Ics, Line, Tlen+1, 4, Tlen);
yystate(123, [82|Ics], Line, Tlen, _, _) ->
    yystate(139, Ics, Line, Tlen+1, 4, Tlen);
yystate(123, [80|Ics], Line, Tlen, _, _) ->
    yystate(37, Ics, Line, Tlen+1, 4, Tlen);
yystate(123, Ics, Line, Tlen, _, _) ->
    {4,Tlen,Ics,Line,123};
yystate(122, [92|Ics], Line, Tlen, _, _) ->
    yystate(106, Ics, Line, Tlen+1, 18, Tlen);
yystate(122, [34|Ics], Line, Tlen, _, _) ->
    yystate(138, Ics, Line, Tlen+1, 18, Tlen);
yystate(122, [10|Ics], Line, Tlen, _, _) ->
    yystate(154, Ics, Line+1, Tlen+1, 18, Tlen);
yystate(122, [C|Ics], Line, Tlen, _, _) when C >= 0, C =< 9 ->
    yystate(154, Ics, Line, Tlen+1, 18, Tlen);
yystate(122, [C|Ics], Line, Tlen, _, _) when C >= 11, C =< 33 ->
    yystate(154, Ics, Line, Tlen+1, 18, Tlen);
yystate(122, [C|Ics], Line, Tlen, _, _) when C >= 35, C =< 91 ->
    yystate(154, Ics, Line, Tlen+1, 18, Tlen);
yystate(122, [C|Ics], Line, Tlen, _, _) when C >= 93 ->
    yystate(154, Ics, Line, Tlen+1, 18, Tlen);
yystate(122, Ics, Line, Tlen, _, _) ->
    {18,Tlen,Ics,Line,122};
yystate(121, [116|Ics], Line, Tlen, _, _) ->
    yystate(115, Ics, Line, Tlen+1, 19, Tlen);
yystate(121, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(121, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(121, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(121, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(121, [C|Ics], Line, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(121, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,121};
yystate(120, [101|Ics], Line, Tlen, _, _) ->
    yystate(104, Ics, Line, Tlen+1, 19, Tlen);
yystate(120, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(120, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(120, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(120, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(120, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(120, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,120};
yystate(119, [111|Ics], Line, Tlen, _, _) ->
    yystate(98, Ics, Line, Tlen+1, 19, Tlen);
yystate(119, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(119, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(119, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(119, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(119, [C|Ics], Line, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(119, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,119};
yystate(118, [110|Ics], Line, Tlen, _, _) ->
    yystate(134, Ics, Line, Tlen+1, 19, Tlen);
yystate(118, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(118, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(118, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(118, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(118, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(118, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,118};
yystate(117, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(101, Ics, Line, Tlen+1, Action, Alen);
yystate(117, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,117};
yystate(116, [115|Ics], Line, Tlen, _, _) ->
    yystate(132, Ics, Line, Tlen+1, 19, Tlen);
yystate(116, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(116, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(116, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(116, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 114 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(116, [C|Ics], Line, Tlen, _, _) when C >= 116, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(116, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,116};
yystate(115, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 11, Tlen);
yystate(115, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 11, Tlen);
yystate(115, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 11, Tlen);
yystate(115, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 11, Tlen);
yystate(115, Ics, Line, Tlen, _, _) ->
    {11,Tlen,Ics,Line,115};
yystate(114, [114|Ics], Line, Tlen, _, _) ->
    yystate(98, Ics, Line, Tlen+1, 19, Tlen);
yystate(114, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(114, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(114, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(114, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(114, [C|Ics], Line, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(114, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,114};
yystate(113, [116|Ics], Line, Tlen, _, _) ->
    yystate(136, Ics, Line, Tlen+1, 19, Tlen);
yystate(113, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(113, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(113, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(113, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(113, [C|Ics], Line, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(113, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,113};
yystate(112, [62|Ics], Line, Tlen, Action, Alen) ->
    yystate(7, Ics, Line, Tlen+1, Action, Alen);
yystate(112, [34|Ics], Line, Tlen, Action, Alen) ->
    yystate(24, Ics, Line, Tlen+1, Action, Alen);
yystate(112, [10|Ics], Line, Tlen, Action, Alen) ->
    yystate(112, Ics, Line+1, Tlen+1, Action, Alen);
yystate(112, [C|Ics], Line, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(112, Ics, Line, Tlen+1, Action, Alen);
yystate(112, [C|Ics], Line, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(112, Ics, Line, Tlen+1, Action, Alen);
yystate(112, [C|Ics], Line, Tlen, Action, Alen) when C >= 35, C =< 61 ->
    yystate(112, Ics, Line, Tlen+1, Action, Alen);
yystate(112, [C|Ics], Line, Tlen, Action, Alen) when C >= 63 ->
    yystate(112, Ics, Line, Tlen+1, Action, Alen);
yystate(112, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,112};
yystate(111, [117|Ics], Line, Tlen, _, _) ->
    yystate(127, Ics, Line, Tlen+1, 19, Tlen);
yystate(111, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(111, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(111, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(111, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 116 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(111, [C|Ics], Line, Tlen, _, _) when C >= 118, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(111, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,111};
yystate(110, [108|Ics], Line, Tlen, _, _) ->
    yystate(94, Ics, Line, Tlen+1, 19, Tlen);
yystate(110, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(110, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(110, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(110, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(110, [C|Ics], Line, Tlen, _, _) when C >= 109, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(110, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,110};
yystate(109, [101|Ics], Line, Tlen, _, _) ->
    yystate(61, Ics, Line, Tlen+1, 19, Tlen);
yystate(109, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(109, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(109, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(109, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(109, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(109, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,109};
yystate(108, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(108, Ics, Line, Tlen+1, 15, Tlen);
yystate(108, Ics, Line, Tlen, _, _) ->
    {15,Tlen,Ics,Line,108};
yystate(107, Ics, Line, Tlen, _, _) ->
    {14,Tlen,Ics,Line};
yystate(106, [92|Ics], Line, Tlen, Action, Alen) ->
    yystate(106, Ics, Line, Tlen+1, Action, Alen);
yystate(106, [34|Ics], Line, Tlen, Action, Alen) ->
    yystate(122, Ics, Line, Tlen+1, Action, Alen);
yystate(106, [10|Ics], Line, Tlen, Action, Alen) ->
    yystate(154, Ics, Line+1, Tlen+1, Action, Alen);
yystate(106, [C|Ics], Line, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(154, Ics, Line, Tlen+1, Action, Alen);
yystate(106, [C|Ics], Line, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(154, Ics, Line, Tlen+1, Action, Alen);
yystate(106, [C|Ics], Line, Tlen, Action, Alen) when C >= 35, C =< 91 ->
    yystate(154, Ics, Line, Tlen+1, Action, Alen);
yystate(106, [C|Ics], Line, Tlen, Action, Alen) when C >= 93 ->
    yystate(154, Ics, Line, Tlen+1, Action, Alen);
yystate(106, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,106};
yystate(105, [111|Ics], Line, Tlen, _, _) ->
    yystate(121, Ics, Line, Tlen+1, 19, Tlen);
yystate(105, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(105, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(105, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(105, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(105, [C|Ics], Line, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(105, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,105};
yystate(104, [102|Ics], Line, Tlen, _, _) ->
    yystate(96, Ics, Line, Tlen+1, 19, Tlen);
yystate(104, [100|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(104, [101|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(104, [99|Ics], Line, Tlen, _, _) ->
    yystate(0, Ics, Line, Tlen+1, 19, Tlen);
yystate(104, [97|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(104, [98|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(104, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(104, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(104, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(104, [C|Ics], Line, Tlen, _, _) when C >= 103, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(104, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,104};
yystate(103, [115|Ics], Line, Tlen, _, _) ->
    yystate(61, Ics, Line, Tlen+1, 19, Tlen);
yystate(103, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(103, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(103, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(103, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 114 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(103, [C|Ics], Line, Tlen, _, _) when C >= 116, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(103, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,103};
yystate(102, [105|Ics], Line, Tlen, _, _) ->
    yystate(118, Ics, Line, Tlen+1, 19, Tlen);
yystate(102, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(102, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(102, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(102, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 104 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(102, [C|Ics], Line, Tlen, _, _) when C >= 106, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(102, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,102};
yystate(101, [46|Ics], Line, Tlen, Action, Alen) ->
    yystate(85, Ics, Line, Tlen+1, Action, Alen);
yystate(101, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(101, Ics, Line, Tlen+1, Action, Alen);
yystate(101, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,101};
yystate(100, [104|Ics], Line, Tlen, _, _) ->
    yystate(61, Ics, Line, Tlen+1, 19, Tlen);
yystate(100, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(100, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(100, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(100, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 103 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(100, [C|Ics], Line, Tlen, _, _) when C >= 105, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(100, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,100};
yystate(99, [114|Ics], Line, Tlen, _, _) ->
    yystate(83, Ics, Line, Tlen+1, 19, Tlen);
yystate(99, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(99, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(99, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(99, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(99, [C|Ics], Line, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(99, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,99};
yystate(98, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(98, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(98, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(98, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(98, Ics, Line, Tlen, _, _) ->
    {13,Tlen,Ics,Line,98};
yystate(97, [110|Ics], Line, Tlen, _, _) ->
    yystate(89, Ics, Line, Tlen+1, 19, Tlen);
yystate(97, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(97, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(97, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(97, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(97, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(97, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,97};
yystate(96, [101|Ics], Line, Tlen, _, _) ->
    yystate(80, Ics, Line, Tlen+1, 19, Tlen);
yystate(96, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(96, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(96, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(96, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(96, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(96, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,96};
yystate(95, [100|Ics], Line, Tlen, _, _) ->
    yystate(136, Ics, Line, Tlen+1, 19, Tlen);
yystate(95, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(95, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(95, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(95, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(95, [C|Ics], Line, Tlen, _, _) when C >= 101, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(95, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,95};
yystate(94, [101|Ics], Line, Tlen, _, _) ->
    yystate(78, Ics, Line, Tlen+1, 19, Tlen);
yystate(94, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(94, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(94, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(94, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(94, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(94, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,94};
yystate(93, [122|Ics], Line, Tlen, _, _) ->
    yystate(109, Ics, Line, Tlen+1, 19, Tlen);
yystate(93, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(93, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(93, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(93, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 121 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(93, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,93};
yystate(92, [35|Ics], Line, Tlen, _, _) ->
    yystate(124, Ics, Line, Tlen+1, 16, Tlen);
yystate(92, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 54 ->
    yystate(60, Ics, Line, Tlen+1, 16, Tlen);
yystate(92, [C|Ics], Line, Tlen, _, _) when C >= 55, C =< 57 ->
    yystate(28, Ics, Line, Tlen+1, 16, Tlen);
yystate(92, Ics, Line, Tlen, _, _) ->
    {16,Tlen,Ics,Line,92};
yystate(91, [C|Ics], Line, Tlen, Action, Alen) when C >= 32, C =< 126 ->
    yystate(107, Ics, Line, Tlen+1, Action, Alen);
yystate(91, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,91};
yystate(90, Ics, Line, Tlen, _, _) ->
    {3,Tlen,Ics,Line};
yystate(89, [116|Ics], Line, Tlen, _, _) ->
    yystate(73, Ics, Line, Tlen+1, 19, Tlen);
yystate(89, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(89, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(89, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(89, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(89, [C|Ics], Line, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(89, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,89};
yystate(88, [92|Ics], Line, Tlen, Action, Alen) ->
    yystate(56, Ics, Line, Tlen+1, Action, Alen);
yystate(88, [34|Ics], Line, Tlen, Action, Alen) ->
    yystate(112, Ics, Line, Tlen+1, Action, Alen);
yystate(88, [10|Ics], Line, Tlen, Action, Alen) ->
    yystate(88, Ics, Line+1, Tlen+1, Action, Alen);
yystate(88, [C|Ics], Line, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(88, [C|Ics], Line, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(88, [C|Ics], Line, Tlen, Action, Alen) when C >= 35, C =< 91 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(88, [C|Ics], Line, Tlen, Action, Alen) when C >= 93 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(88, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,88};
yystate(87, [95|Ics], Line, Tlen, _, _) ->
    yystate(87, Ics, Line, Tlen+1, 17, Tlen);
yystate(87, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(87, Ics, Line, Tlen+1, 17, Tlen);
yystate(87, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(87, Ics, Line, Tlen+1, 17, Tlen);
yystate(87, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(87, Ics, Line, Tlen+1, 17, Tlen);
yystate(87, Ics, Line, Tlen, _, _) ->
    {17,Tlen,Ics,Line,87};
yystate(86, [110|Ics], Line, Tlen, _, _) ->
    yystate(136, Ics, Line, Tlen+1, 19, Tlen);
yystate(86, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(86, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(86, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(86, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(86, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(86, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,86};
yystate(85, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(69, Ics, Line, Tlen+1, Action, Alen);
yystate(85, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,85};
yystate(84, [116|Ics], Line, Tlen, _, _) ->
    yystate(100, Ics, Line, Tlen+1, 19, Tlen);
yystate(84, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(84, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(84, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(84, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(84, [C|Ics], Line, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(84, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,84};
yystate(83, [101|Ics], Line, Tlen, _, _) ->
    yystate(67, Ics, Line, Tlen+1, 13, Tlen);
yystate(83, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(83, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(83, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(83, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(83, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 13, Tlen);
yystate(83, Ics, Line, Tlen, _, _) ->
    {13,Tlen,Ics,Line,83};
yystate(82, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(82, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(82, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(82, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(82, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,82};
yystate(81, [114|Ics], Line, Tlen, _, _) ->
    yystate(115, Ics, Line, Tlen+1, 19, Tlen);
yystate(81, [108|Ics], Line, Tlen, _, _) ->
    yystate(115, Ics, Line, Tlen+1, 19, Tlen);
yystate(81, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(81, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(81, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(81, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(81, [C|Ics], Line, Tlen, _, _) when C >= 109, C =< 113 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(81, [C|Ics], Line, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(81, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,81};
yystate(80, [114|Ics], Line, Tlen, _, _) ->
    yystate(64, Ics, Line, Tlen+1, 19, Tlen);
yystate(80, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(80, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(80, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(80, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(80, [C|Ics], Line, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(80, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,80};
yystate(79, [61|Ics], Line, Tlen, _, _) ->
    yystate(4, Ics, Line, Tlen+1, 10, Tlen);
yystate(79, Ics, Line, Tlen, _, _) ->
    {10,Tlen,Ics,Line,79};
yystate(78, [109|Ics], Line, Tlen, _, _) ->
    yystate(62, Ics, Line, Tlen+1, 19, Tlen);
yystate(78, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(78, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(78, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(78, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 108 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(78, [C|Ics], Line, Tlen, _, _) when C >= 110, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(78, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,78};
yystate(77, [105|Ics], Line, Tlen, _, _) ->
    yystate(93, Ics, Line, Tlen+1, 19, Tlen);
yystate(77, [101|Ics], Line, Tlen, _, _) ->
    yystate(125, Ics, Line, Tlen+1, 19, Tlen);
yystate(77, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(77, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(77, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(77, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(77, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 104 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(77, [C|Ics], Line, Tlen, _, _) when C >= 106, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(77, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,77};
yystate(76, [35|Ics], Line, Tlen, _, _) ->
    yystate(124, Ics, Line, Tlen+1, 16, Tlen);
yystate(76, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(60, Ics, Line, Tlen+1, 16, Tlen);
yystate(76, Ics, Line, Tlen, _, _) ->
    {16,Tlen,Ics,Line,76};
yystate(75, [39|Ics], Line, Tlen, Action, Alen) ->
    yystate(59, Ics, Line, Tlen+1, Action, Alen);
yystate(75, [10|Ics], Line, Tlen, Action, Alen) ->
    yystate(75, Ics, Line+1, Tlen+1, Action, Alen);
yystate(75, [C|Ics], Line, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(75, Ics, Line, Tlen+1, Action, Alen);
yystate(75, [C|Ics], Line, Tlen, Action, Alen) when C >= 11, C =< 38 ->
    yystate(75, Ics, Line, Tlen+1, Action, Alen);
yystate(75, [C|Ics], Line, Tlen, Action, Alen) when C >= 40, C =< 91 ->
    yystate(75, Ics, Line, Tlen+1, Action, Alen);
yystate(75, [C|Ics], Line, Tlen, Action, Alen) when C >= 93, C =< 123 ->
    yystate(75, Ics, Line, Tlen+1, Action, Alen);
yystate(75, [C|Ics], Line, Tlen, Action, Alen) when C >= 125 ->
    yystate(75, Ics, Line, Tlen+1, Action, Alen);
yystate(75, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,75};
yystate(74, [62|Ics], Line, Tlen, Action, Alen) ->
    yystate(90, Ics, Line, Tlen+1, Action, Alen);
yystate(74, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(74, Ics, Line, Tlen+1, Action, Alen);
yystate(74, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,74};
yystate(73, [101|Ics], Line, Tlen, _, _) ->
    yystate(57, Ics, Line, Tlen+1, 19, Tlen);
yystate(73, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(73, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(73, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(73, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(73, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(73, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,73};
yystate(72, [92|Ics], Line, Tlen, _, _) ->
    yystate(56, Ics, Line, Tlen+1, 21, Tlen);
yystate(72, [34|Ics], Line, Tlen, _, _) ->
    yystate(112, Ics, Line, Tlen+1, 21, Tlen);
yystate(72, [10|Ics], Line, Tlen, _, _) ->
    yystate(88, Ics, Line+1, Tlen+1, 21, Tlen);
yystate(72, [C|Ics], Line, Tlen, _, _) when C >= 0, C =< 9 ->
    yystate(88, Ics, Line, Tlen+1, 21, Tlen);
yystate(72, [C|Ics], Line, Tlen, _, _) when C >= 11, C =< 33 ->
    yystate(88, Ics, Line, Tlen+1, 21, Tlen);
yystate(72, [C|Ics], Line, Tlen, _, _) when C >= 35, C =< 91 ->
    yystate(88, Ics, Line, Tlen+1, 21, Tlen);
yystate(72, [C|Ics], Line, Tlen, _, _) when C >= 93 ->
    yystate(88, Ics, Line, Tlen+1, 21, Tlen);
yystate(72, Ics, Line, Tlen, _, _) ->
    {21,Tlen,Ics,Line,72};
yystate(71, [114|Ics], Line, Tlen, _, _) ->
    yystate(113, Ics, Line, Tlen+1, 19, Tlen);
yystate(71, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(71, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(71, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(71, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(71, [C|Ics], Line, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(71, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,71};
yystate(70, [111|Ics], Line, Tlen, _, _) ->
    yystate(86, Ics, Line, Tlen+1, 19, Tlen);
yystate(70, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(70, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(70, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(70, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(70, [C|Ics], Line, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(70, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,70};
yystate(69, [62|Ics], Line, Tlen, Action, Alen) ->
    yystate(53, Ics, Line, Tlen+1, Action, Alen);
yystate(69, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(69, Ics, Line, Tlen+1, Action, Alen);
yystate(69, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,69};
yystate(68, [103|Ics], Line, Tlen, _, _) ->
    yystate(84, Ics, Line, Tlen+1, 19, Tlen);
yystate(68, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(68, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(68, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(68, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 102 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(68, [C|Ics], Line, Tlen, _, _) when C >= 104, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(68, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,68};
yystate(67, [108|Ics], Line, Tlen, _, _) ->
    yystate(51, Ics, Line, Tlen+1, 19, Tlen);
yystate(67, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(67, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(67, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(67, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(67, [C|Ics], Line, Tlen, _, _) when C >= 109, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(67, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,67};
yystate(66, [104|Ics], Line, Tlen, _, _) ->
    yystate(50, Ics, Line, Tlen+1, 19, Tlen);
yystate(66, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(66, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(66, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(66, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 103 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(66, [C|Ics], Line, Tlen, _, _) when C >= 105, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(66, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,66};
yystate(65, [114|Ics], Line, Tlen, _, _) ->
    yystate(115, Ics, Line, Tlen+1, 19, Tlen);
yystate(65, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(65, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(65, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(65, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(65, [C|Ics], Line, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(65, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,65};
yystate(64, [101|Ics], Line, Tlen, _, _) ->
    yystate(48, Ics, Line, Tlen+1, 19, Tlen);
yystate(64, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(64, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(64, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(64, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(64, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(64, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,64};
yystate(63, [62|Ics], Line, Tlen, _, _) ->
    yystate(146, Ics, Line, Tlen+1, 4, Tlen);
yystate(63, [61|Ics], Line, Tlen, _, _) ->
    yystate(4, Ics, Line, Tlen+1, 4, Tlen);
yystate(63, [60|Ics], Line, Tlen, _, _) ->
    yystate(4, Ics, Line, Tlen+1, 4, Tlen);
yystate(63, [58|Ics], Line, Tlen, _, _) ->
    yystate(47, Ics, Line, Tlen+1, 4, Tlen);
yystate(63, [47|Ics], Line, Tlen, _, _) ->
    yystate(47, Ics, Line, Tlen+1, 4, Tlen);
yystate(63, Ics, Line, Tlen, _, _) ->
    {4,Tlen,Ics,Line,63};
yystate(62, [101|Ics], Line, Tlen, _, _) ->
    yystate(46, Ics, Line, Tlen+1, 19, Tlen);
yystate(62, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(62, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(62, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(62, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(62, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(62, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,62};
yystate(61, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 8, Tlen);
yystate(61, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 8, Tlen);
yystate(61, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 8, Tlen);
yystate(61, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 8, Tlen);
yystate(61, Ics, Line, Tlen, _, _) ->
    {8,Tlen,Ics,Line,61};
yystate(60, [35|Ics], Line, Tlen, _, _) ->
    yystate(124, Ics, Line, Tlen+1, 16, Tlen);
yystate(60, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(28, Ics, Line, Tlen+1, 16, Tlen);
yystate(60, Ics, Line, Tlen, _, _) ->
    {16,Tlen,Ics,Line,60};
yystate(59, Ics, Line, Tlen, _, _) ->
    {20,Tlen,Ics,Line};
yystate(58, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(74, Ics, Line, Tlen+1, Action, Alen);
yystate(58, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,58};
yystate(57, [103|Ics], Line, Tlen, _, _) ->
    yystate(41, Ics, Line, Tlen+1, 19, Tlen);
yystate(57, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(57, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(57, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(57, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 102 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(57, [C|Ics], Line, Tlen, _, _) when C >= 104, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(57, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,57};
yystate(56, [92|Ics], Line, Tlen, Action, Alen) ->
    yystate(56, Ics, Line, Tlen+1, Action, Alen);
yystate(56, [34|Ics], Line, Tlen, Action, Alen) ->
    yystate(24, Ics, Line, Tlen+1, Action, Alen);
yystate(56, [10|Ics], Line, Tlen, Action, Alen) ->
    yystate(88, Ics, Line+1, Tlen+1, Action, Alen);
yystate(56, [C|Ics], Line, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(56, [C|Ics], Line, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(56, [C|Ics], Line, Tlen, Action, Alen) when C >= 35, C =< 91 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(56, [C|Ics], Line, Tlen, Action, Alen) when C >= 93 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(56, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,56};
yystate(55, [111|Ics], Line, Tlen, _, _) ->
    yystate(71, Ics, Line, Tlen+1, 19, Tlen);
yystate(55, [105|Ics], Line, Tlen, _, _) ->
    yystate(95, Ics, Line, Tlen+1, 19, Tlen);
yystate(55, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(55, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(55, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(55, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 104 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(55, [C|Ics], Line, Tlen, _, _) when C >= 106, C =< 110 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(55, [C|Ics], Line, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(55, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,55};
yystate(54, [105|Ics], Line, Tlen, _, _) ->
    yystate(70, Ics, Line, Tlen+1, 19, Tlen);
yystate(54, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(54, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(54, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(54, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 104 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(54, [C|Ics], Line, Tlen, _, _) when C >= 106, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(54, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,54};
yystate(53, Ics, Line, Tlen, _, _) ->
    {2,Tlen,Ics,Line};
yystate(52, [110|Ics], Line, Tlen, _, _) ->
    yystate(68, Ics, Line, Tlen+1, 19, Tlen);
yystate(52, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(52, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(52, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(52, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(52, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(52, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,52};
yystate(51, [115|Ics], Line, Tlen, _, _) ->
    yystate(35, Ics, Line, Tlen+1, 19, Tlen);
yystate(51, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(51, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(51, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(51, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 114 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(51, [C|Ics], Line, Tlen, _, _) when C >= 116, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(51, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,51};
yystate(50, [101|Ics], Line, Tlen, _, _) ->
    yystate(34, Ics, Line, Tlen+1, 19, Tlen);
yystate(50, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(50, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(50, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(50, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(50, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(50, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,50};
yystate(49, [111|Ics], Line, Tlen, _, _) ->
    yystate(65, Ics, Line, Tlen+1, 19, Tlen);
yystate(49, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(49, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(49, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(49, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(49, [C|Ics], Line, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(49, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,49};
yystate(48, [110|Ics], Line, Tlen, _, _) ->
    yystate(32, Ics, Line, Tlen+1, 19, Tlen);
yystate(48, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(48, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(48, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(48, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(48, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(48, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,48};
yystate(47, [61|Ics], Line, Tlen, Action, Alen) ->
    yystate(4, Ics, Line, Tlen+1, Action, Alen);
yystate(47, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,47};
yystate(46, [110|Ics], Line, Tlen, _, _) ->
    yystate(30, Ics, Line, Tlen+1, 19, Tlen);
yystate(46, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(46, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(46, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(46, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(46, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(46, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,46};
yystate(45, [99|Ics], Line, Tlen, _, _) ->
    yystate(61, Ics, Line, Tlen+1, 19, Tlen);
yystate(45, [97|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(45, [98|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(45, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(45, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(45, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(45, [C|Ics], Line, Tlen, _, _) when C >= 100, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(45, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,45};
yystate(44, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(60, Ics, Line, Tlen+1, 16, Tlen);
yystate(44, Ics, Line, Tlen, _, _) ->
    {16,Tlen,Ics,Line,44};
yystate(43, Ics, Line, Tlen, _, _) ->
    {11,Tlen,Ics,Line};
yystate(42, [46|Ics], Line, Tlen, Action, Alen) ->
    yystate(58, Ics, Line, Tlen+1, Action, Alen);
yystate(42, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(42, Ics, Line, Tlen+1, Action, Alen);
yystate(42, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,42};
yystate(41, [101|Ics], Line, Tlen, _, _) ->
    yystate(25, Ics, Line, Tlen+1, 19, Tlen);
yystate(41, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(41, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(41, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(41, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(41, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(41, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,41};
yystate(40, [92|Ics], Line, Tlen, Action, Alen) ->
    yystate(56, Ics, Line, Tlen+1, Action, Alen);
yystate(40, [62|Ics], Line, Tlen, Action, Alen) ->
    yystate(72, Ics, Line, Tlen+1, Action, Alen);
yystate(40, [34|Ics], Line, Tlen, Action, Alen) ->
    yystate(112, Ics, Line, Tlen+1, Action, Alen);
yystate(40, [10|Ics], Line, Tlen, Action, Alen) ->
    yystate(88, Ics, Line+1, Tlen+1, Action, Alen);
yystate(40, [C|Ics], Line, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(40, [C|Ics], Line, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(40, [C|Ics], Line, Tlen, Action, Alen) when C >= 35, C =< 61 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(40, [C|Ics], Line, Tlen, Action, Alen) when C >= 63, C =< 91 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(40, [C|Ics], Line, Tlen, Action, Alen) when C >= 93 ->
    yystate(88, Ics, Line, Tlen+1, Action, Alen);
yystate(40, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,40};
yystate(39, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 6, Tlen);
yystate(39, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 6, Tlen);
yystate(39, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 6, Tlen);
yystate(39, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 6, Tlen);
yystate(39, Ics, Line, Tlen, _, _) ->
    {6,Tlen,Ics,Line,39};
yystate(38, [116|Ics], Line, Tlen, _, _) ->
    yystate(54, Ics, Line, Tlen+1, 19, Tlen);
yystate(38, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(38, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(38, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(38, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(38, [C|Ics], Line, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(38, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,38};
yystate(37, [111|Ics], Line, Tlen, Action, Alen) ->
    yystate(21, Ics, Line, Tlen+1, Action, Alen);
yystate(37, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,37};
yystate(36, [101|Ics], Line, Tlen, _, _) ->
    yystate(52, Ics, Line, Tlen+1, 19, Tlen);
yystate(36, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(36, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(36, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(36, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(36, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(36, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,36};
yystate(35, [101|Ics], Line, Tlen, _, _) ->
    yystate(98, Ics, Line, Tlen+1, 19, Tlen);
yystate(35, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(35, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(35, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(35, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(35, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(35, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,35};
yystate(34, [110|Ics], Line, Tlen, _, _) ->
    yystate(18, Ics, Line, Tlen+1, 19, Tlen);
yystate(34, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(34, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(34, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(34, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(34, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(34, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,34};
yystate(33, [121|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [122|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [120|Ics], Line, Tlen, _, _) ->
    yystate(49, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [115|Ics], Line, Tlen, _, _) ->
    yystate(81, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [111|Ics], Line, Tlen, _, _) ->
    yystate(65, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [110|Ics], Line, Tlen, _, _) ->
    yystate(105, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [97|Ics], Line, Tlen, _, _) ->
    yystate(137, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [C|Ics], Line, Tlen, _, _) when C >= 98, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [C|Ics], Line, Tlen, _, _) when C >= 112, C =< 114 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, [C|Ics], Line, Tlen, _, _) when C >= 116, C =< 119 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(33, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,33};
yystate(32, [99|Ics], Line, Tlen, _, _) ->
    yystate(16, Ics, Line, Tlen+1, 19, Tlen);
yystate(32, [97|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(32, [98|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(32, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(32, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(32, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(32, [C|Ics], Line, Tlen, _, _) when C >= 100, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(32, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,32};
yystate(31, [100|Ics], Line, Tlen, _, _) ->
    yystate(39, Ics, Line, Tlen+1, 19, Tlen);
yystate(31, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(31, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(31, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(31, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(31, [C|Ics], Line, Tlen, _, _) when C >= 101, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(31, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,31};
yystate(30, [116|Ics], Line, Tlen, _, _) ->
    yystate(14, Ics, Line, Tlen+1, 19, Tlen);
yystate(30, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(30, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(30, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(30, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 115 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(30, [C|Ics], Line, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(30, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,30};
yystate(29, [110|Ics], Line, Tlen, _, _) ->
    yystate(45, Ics, Line, Tlen+1, 19, Tlen);
yystate(29, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(29, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(29, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(29, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(29, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(29, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,29};
yystate(28, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(28, Ics, Line, Tlen+1, 16, Tlen);
yystate(28, Ics, Line, Tlen, _, _) ->
    {16,Tlen,Ics,Line,28};
yystate(27, [43|Ics], Line, Tlen, _, _) ->
    yystate(146, Ics, Line, Tlen+1, 11, Tlen);
yystate(27, Ics, Line, Tlen, _, _) ->
    {11,Tlen,Ics,Line,27};
yystate(26, [C|Ics], Line, Tlen, Action, Alen) when C >= 48, C =< 57 ->
    yystate(42, Ics, Line, Tlen+1, Action, Alen);
yystate(26, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,26};
yystate(25, [114|Ics], Line, Tlen, _, _) ->
    yystate(136, Ics, Line, Tlen+1, 19, Tlen);
yystate(25, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(25, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(25, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(25, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(25, [C|Ics], Line, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(25, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,25};
yystate(24, [92|Ics], Line, Tlen, Action, Alen) ->
    yystate(24, Ics, Line, Tlen+1, Action, Alen);
yystate(24, [62|Ics], Line, Tlen, Action, Alen) ->
    yystate(40, Ics, Line, Tlen+1, Action, Alen);
yystate(24, [34|Ics], Line, Tlen, Action, Alen) ->
    yystate(24, Ics, Line, Tlen+1, Action, Alen);
yystate(24, [10|Ics], Line, Tlen, Action, Alen) ->
    yystate(24, Ics, Line+1, Tlen+1, Action, Alen);
yystate(24, [C|Ics], Line, Tlen, Action, Alen) when C >= 0, C =< 9 ->
    yystate(24, Ics, Line, Tlen+1, Action, Alen);
yystate(24, [C|Ics], Line, Tlen, Action, Alen) when C >= 11, C =< 33 ->
    yystate(24, Ics, Line, Tlen+1, Action, Alen);
yystate(24, [C|Ics], Line, Tlen, Action, Alen) when C >= 35, C =< 61 ->
    yystate(24, Ics, Line, Tlen+1, Action, Alen);
yystate(24, [C|Ics], Line, Tlen, Action, Alen) when C >= 63, C =< 91 ->
    yystate(24, Ics, Line, Tlen+1, Action, Alen);
yystate(24, [C|Ics], Line, Tlen, Action, Alen) when C >= 93 ->
    yystate(24, Ics, Line, Tlen+1, Action, Alen);
yystate(24, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,24};
yystate(23, [60|Ics], Line, Tlen, _, _) ->
    yystate(112, Ics, Line, Tlen+1, 10, Tlen);
yystate(23, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(128, Ics, Line, Tlen+1, 10, Tlen);
yystate(23, Ics, Line, Tlen, _, _) ->
    {10,Tlen,Ics,Line,23};
yystate(22, [99|Ics], Line, Tlen, _, _) ->
    yystate(38, Ics, Line, Tlen+1, 19, Tlen);
yystate(22, [97|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(22, [98|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(22, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(22, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(22, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(22, [C|Ics], Line, Tlen, _, _) when C >= 100, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(22, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,22};
yystate(21, [114|Ics], Line, Tlen, Action, Alen) ->
    yystate(5, Ics, Line, Tlen+1, Action, Alen);
yystate(21, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,21};
yystate(20, [61|Ics], Line, Tlen, _, _) ->
    yystate(4, Ics, Line, Tlen+1, 4, Tlen);
yystate(20, Ics, Line, Tlen, _, _) ->
    {4,Tlen,Ics,Line,20};
yystate(19, [111|Ics], Line, Tlen, _, _) ->
    yystate(3, Ics, Line, Tlen+1, 19, Tlen);
yystate(19, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(19, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(19, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(19, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(19, [C|Ics], Line, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(19, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,19};
yystate(18, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 4, Tlen);
yystate(18, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 4, Tlen);
yystate(18, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 4, Tlen);
yystate(18, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 4, Tlen);
yystate(18, Ics, Line, Tlen, _, _) ->
    {4,Tlen,Ics,Line,18};
yystate(17, [118|Ics], Line, Tlen, _, _) ->
    yystate(115, Ics, Line, Tlen+1, 19, Tlen);
yystate(17, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(17, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(17, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(17, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 117 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(17, [C|Ics], Line, Tlen, _, _) when C >= 119, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(17, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,17};
yystate(16, [101|Ics], Line, Tlen, _, _) ->
    yystate(136, Ics, Line, Tlen+1, 19, Tlen);
yystate(16, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(16, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(16, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(16, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 100 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(16, [C|Ics], Line, Tlen, _, _) when C >= 102, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(16, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,16};
yystate(15, [114|Ics], Line, Tlen, _, _) ->
    yystate(31, Ics, Line, Tlen+1, 19, Tlen);
yystate(15, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(15, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(15, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(15, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 113 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(15, [C|Ics], Line, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(15, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,15};
yystate(14, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 9, Tlen);
yystate(14, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 9, Tlen);
yystate(14, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 9, Tlen);
yystate(14, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 9, Tlen);
yystate(14, Ics, Line, Tlen, _, _) ->
    {9,Tlen,Ics,Line,14};
yystate(13, [117|Ics], Line, Tlen, _, _) ->
    yystate(29, Ics, Line, Tlen+1, 19, Tlen);
yystate(13, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(13, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(13, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(13, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 116 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(13, [C|Ics], Line, Tlen, _, _) when C >= 118, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(13, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,13};
yystate(12, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 12, Tlen);
yystate(12, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 12, Tlen);
yystate(12, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 12, Tlen);
yystate(12, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 12, Tlen);
yystate(12, Ics, Line, Tlen, _, _) ->
    {12,Tlen,Ics,Line,12};
yystate(11, [62|Ics], Line, Tlen, _, _) ->
    yystate(146, Ics, Line, Tlen+1, 11, Tlen);
yystate(11, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(28, Ics, Line, Tlen+1, 11, Tlen);
yystate(11, Ics, Line, Tlen, _, _) ->
    {11,Tlen,Ics,Line,11};
yystate(10, [60|Ics], Line, Tlen, Action, Alen) ->
    yystate(26, Ics, Line, Tlen+1, Action, Alen);
yystate(10, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,10};
yystate(9, [117|Ics], Line, Tlen, _, _) ->
    yystate(6, Ics, Line, Tlen+1, 19, Tlen);
yystate(9, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(9, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(9, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(9, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 116 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(9, [C|Ics], Line, Tlen, _, _) when C >= 118, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(9, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,9};
yystate(8, Ics, Line, Tlen, _, _) ->
    {21,Tlen,Ics,Line};
yystate(7, [62|Ics], Line, Tlen, Action, Alen) ->
    yystate(8, Ics, Line, Tlen+1, Action, Alen);
yystate(7, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,7};
yystate(6, [110|Ics], Line, Tlen, _, _) ->
    yystate(22, Ics, Line, Tlen+1, 19, Tlen);
yystate(6, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(6, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(6, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(6, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 109 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(6, [C|Ics], Line, Tlen, _, _) when C >= 111, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(6, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,6};
yystate(5, [116|Ics], Line, Tlen, Action, Alen) ->
    yystate(10, Ics, Line, Tlen+1, Action, Alen);
yystate(5, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,5};
yystate(4, Ics, Line, Tlen, _, _) ->
    {10,Tlen,Ics,Line};
yystate(3, [116|Ics], Line, Tlen, _, _) ->
    yystate(12, Ics, Line, Tlen+1, 19, Tlen);
yystate(3, [100|Ics], Line, Tlen, _, _) ->
    yystate(109, Ics, Line, Tlen+1, 19, Tlen);
yystate(3, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(3, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(3, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(3, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 99 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(3, [C|Ics], Line, Tlen, _, _) when C >= 101, C =< 115 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(3, [C|Ics], Line, Tlen, _, _) when C >= 117, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(3, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,3};
yystate(2, [114|Ics], Line, Tlen, _, _) ->
    yystate(13, Ics, Line, Tlen+1, 19, Tlen);
yystate(2, [108|Ics], Line, Tlen, _, _) ->
    yystate(61, Ics, Line, Tlen+1, 19, Tlen);
yystate(2, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(2, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(2, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(2, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 107 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(2, [C|Ics], Line, Tlen, _, _) when C >= 109, C =< 113 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(2, [C|Ics], Line, Tlen, _, _) when C >= 115, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(2, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,2};
yystate(1, [105|Ics], Line, Tlen, _, _) ->
    yystate(17, Ics, Line, Tlen+1, 19, Tlen);
yystate(1, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(1, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(1, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(1, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 104 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(1, [C|Ics], Line, Tlen, _, _) when C >= 106, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(1, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,1};
yystate(0, [111|Ics], Line, Tlen, _, _) ->
    yystate(15, Ics, Line, Tlen+1, 19, Tlen);
yystate(0, [95|Ics], Line, Tlen, _, _) ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(0, [C|Ics], Line, Tlen, _, _) when C >= 48, C =< 57 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(0, [C|Ics], Line, Tlen, _, _) when C >= 65, C =< 90 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(0, [C|Ics], Line, Tlen, _, _) when C >= 97, C =< 110 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(0, [C|Ics], Line, Tlen, _, _) when C >= 112, C =< 122 ->
    yystate(82, Ics, Line, Tlen+1, 19, Tlen);
yystate(0, Ics, Line, Tlen, _, _) ->
    {19,Tlen,Ics,Line,0};
yystate(S, Ics, Line, Tlen, Action, Alen) ->
    {Action,Alen,Tlen,Ics,Line,S}.

%% yyaction(Action, TokenLength, TokenChars, TokenLine) ->
%% {token,Token} | {end_token, Token} | skip_token | {error,String}.
%% Generated action function.

yyaction(0, _, _, _) ->
    yyaction_0();
yyaction(1, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_1(TokenChars, TokenLine);
yyaction(2, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_2(TokenChars, TokenLine);
yyaction(3, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_3(TokenChars, TokenLine);
yyaction(4, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_4(TokenChars, TokenLine);
yyaction(5, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_5(TokenChars, TokenLine);
yyaction(6, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_6(TokenChars, TokenLine);
yyaction(7, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_7(TokenChars, TokenLine);
yyaction(8, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_8(TokenChars, TokenLine);
yyaction(9, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_9(TokenChars, TokenLine);
yyaction(10, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_10(TokenChars, TokenLine);
yyaction(11, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_11(TokenChars, TokenLine);
yyaction(12, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_12(TokenChars, TokenLine);
yyaction(13, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_13(TokenChars, TokenLine);
yyaction(14, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_14(TokenChars, TokenLine);
yyaction(15, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_15(TokenChars, TokenLine);
yyaction(16, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_16(TokenChars, TokenLine);
yyaction(17, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_17(TokenChars, TokenLine);
yyaction(18, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_18(TokenChars, TokenLine);
yyaction(19, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_19(TokenChars, TokenLine);
yyaction(20, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_20(TokenChars, TokenLine);
yyaction(21, TokenLen, YYtcs, TokenLine) ->
    TokenChars = yypre(YYtcs, TokenLen),
    yyaction_21(TokenChars, TokenLine);
yyaction(_, _, _, _) -> error.

-compile({inline,yyaction_0/0}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 28).
yyaction_0() ->
     skip_token .

-compile({inline,yyaction_1/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 31).
yyaction_1(TokenChars, TokenLine) ->
     { token, { pid, TokenLine, list_to_pid (TokenChars) } } .

-compile({inline,yyaction_2/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 34).
yyaction_2(TokenChars, TokenLine) ->
     { token, { ref, TokenLine, list_to_ref (TokenChars) } } .

-compile({inline,yyaction_3/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 37).
yyaction_3(TokenChars, TokenLine) ->
     { token, { port, TokenLine, list_to_port (TokenChars) } } .

-compile({inline,yyaction_4/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 40).
yyaction_4(TokenChars, TokenLine) ->
     { token, { to_atom (TokenChars), TokenLine } } .

-compile({inline,yyaction_5/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 43).
yyaction_5(TokenChars, TokenLine) ->
     { token, { type_test1, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_6/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 46).
yyaction_6(TokenChars, TokenLine) ->
     { token, { type_isrec, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_7/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 49).
yyaction_7(TokenChars, TokenLine) ->
     { token, { bif0, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_8/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 52).
yyaction_8(TokenChars, TokenLine) ->
     { token, { bif1, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_9/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 55).
yyaction_9(TokenChars, TokenLine) ->
     { token, { bif2, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_10/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 58).
yyaction_10(TokenChars, TokenLine) ->
     { token, { comparison_op, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_11/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 61).
yyaction_11(TokenChars, TokenLine) ->
     { token, { arithmetic_op, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_12/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 64).
yyaction_12(TokenChars, TokenLine) ->
     { token, { boolean_op1, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_13/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 67).
yyaction_13(TokenChars, TokenLine) ->
     { token, { boolean_op2, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_14/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 70).
yyaction_14(TokenChars, TokenLine) ->
     { token, { int, TokenLine, char_to_int (TokenChars) } } .

-compile({inline,yyaction_15/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 73).
yyaction_15(TokenChars, TokenLine) ->
     { token, { int, TokenLine, radix_to_int (TokenChars) } } .

-compile({inline,yyaction_16/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 76).
yyaction_16(TokenChars, TokenLine) ->
     { token, { int, TokenLine, int_to_int (TokenChars) } } .

-compile({inline,yyaction_17/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 79).
yyaction_17(TokenChars, TokenLine) ->
     { token, { variable, TokenLine, TokenChars } } .

-compile({inline,yyaction_18/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 82).
yyaction_18(TokenChars, TokenLine) ->
     { token, { string, TokenLine, trim (TokenChars) } } .

-compile({inline,yyaction_19/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 85).
yyaction_19(TokenChars, TokenLine) ->
     { token, { atom, TokenLine, to_atom (TokenChars) } } .

-compile({inline,yyaction_20/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 88).
yyaction_20(TokenChars, TokenLine) ->
     { token, { atom, TokenLine, to_atom (trim (TokenChars)) } } .

-compile({inline,yyaction_21/2}).
-file("/home/masse/git/redbug/src/redbug_lexer.xrl", 91).
yyaction_21(TokenChars, TokenLine) ->
     { token, { bin, TokenLine, to_binary (TokenChars) } } .

-file("/usr/local/lib/erlang/lib/parsetools-2.2/include/leexinc.hrl", 313).
