#line 2 "pgc.c"
/*-------------------------------------------------------------------------
 *
 * pgc.l
 *	  lexical scanner for ecpg
 *
 * This is a modified version of src/backend/parser/scan.l
 *
 * The ecpg scanner is not backup-free, so the fail rules are
 * only here to simplify syncing this file with scan.l.
 *
 *
 * Portions Copyright (c) 1996-2023, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/interfaces/ecpg/preproc/pgc.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres_fe.h"

#include <ctype.h>
#include <limits.h>

#include "common/string.h"

#include "preproc_extern.h"
#include "preproc.h"

#line 32 "pgc.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer base_yy_create_buffer
#define yy_delete_buffer base_yy_delete_buffer
#define yy_scan_buffer base_yy_scan_buffer
#define yy_scan_string base_yy_scan_string
#define yy_scan_bytes base_yy_scan_bytes
#define yy_init_buffer base_yy_init_buffer
#define yy_flush_buffer base_yy_flush_buffer
#define yy_load_buffer_state base_yy_load_buffer_state
#define yy_switch_to_buffer base_yy_switch_to_buffer
#define yypush_buffer_state base_yypush_buffer_state
#define yypop_buffer_state base_yypop_buffer_state
#define yyensure_buffer_stack base_yyensure_buffer_stack
#define yy_flex_debug base_yy_flex_debug
#define yyin base_yyin
#define yyleng base_yyleng
#define yylex base_yylex
#define yylineno base_yylineno
#define yyout base_yyout
#define yyrestart base_yyrestart
#define yytext base_yytext
#define yywrap base_yywrap
#define yyalloc base_yyalloc
#define yyrealloc base_yyrealloc
#define yyfree base_yyfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define base_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer base_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define base_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer base_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define base_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer base_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define base_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string base_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define base_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes base_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define base_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer base_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define base_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer base_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define base_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state base_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define base_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer base_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define base_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state base_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define base_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state base_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define base_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack base_yyensure_buffer_stack
#endif

#ifdef yylex
#define base_yylex_ALREADY_DEFINED
#else
#define yylex base_yylex
#endif

#ifdef yyrestart
#define base_yyrestart_ALREADY_DEFINED
#else
#define yyrestart base_yyrestart
#endif

#ifdef yylex_init
#define base_yylex_init_ALREADY_DEFINED
#else
#define yylex_init base_yylex_init
#endif

#ifdef yylex_init_extra
#define base_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra base_yylex_init_extra
#endif

#ifdef yylex_destroy
#define base_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy base_yylex_destroy
#endif

#ifdef yyget_debug
#define base_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug base_yyget_debug
#endif

#ifdef yyset_debug
#define base_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug base_yyset_debug
#endif

#ifdef yyget_extra
#define base_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra base_yyget_extra
#endif

#ifdef yyset_extra
#define base_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra base_yyset_extra
#endif

#ifdef yyget_in
#define base_yyget_in_ALREADY_DEFINED
#else
#define yyget_in base_yyget_in
#endif

#ifdef yyset_in
#define base_yyset_in_ALREADY_DEFINED
#else
#define yyset_in base_yyset_in
#endif

#ifdef yyget_out
#define base_yyget_out_ALREADY_DEFINED
#else
#define yyget_out base_yyget_out
#endif

#ifdef yyset_out
#define base_yyset_out_ALREADY_DEFINED
#else
#define yyset_out base_yyset_out
#endif

#ifdef yyget_leng
#define base_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng base_yyget_leng
#endif

#ifdef yyget_text
#define base_yyget_text_ALREADY_DEFINED
#else
#define yyget_text base_yyget_text
#endif

#ifdef yyget_lineno
#define base_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno base_yyget_lineno
#endif

#ifdef yyset_lineno
#define base_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno base_yyset_lineno
#endif

#ifdef yywrap
#define base_yywrap_ALREADY_DEFINED
#else
#define yywrap base_yywrap
#endif

#ifdef yyalloc
#define base_yyalloc_ALREADY_DEFINED
#else
#define yyalloc base_yyalloc
#endif

#ifdef yyrealloc
#define base_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc base_yyrealloc
#endif

#ifdef yyfree
#define base_yyfree_ALREADY_DEFINED
#else
#define yyfree base_yyfree
#endif

#ifdef yytext
#define base_yytext_ALREADY_DEFINED
#else
#define yytext base_yytext
#endif

#ifdef yyleng
#define base_yyleng_ALREADY_DEFINED
#else
#define yyleng base_yyleng
#endif

#ifdef yyin
#define base_yyin_ALREADY_DEFINED
#else
#define yyin base_yyin
#endif

#ifdef yyout
#define base_yyout_ALREADY_DEFINED
#else
#define yyout base_yyout
#endif

#ifdef yy_flex_debug
#define base_yy_flex_debug_ALREADY_DEFINED
#else
#define yy_flex_debug base_yy_flex_debug
#endif

#ifdef yylineno
#define base_yylineno_ALREADY_DEFINED
#else
#define yylineno base_yylineno
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex.
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    #define YY_LINENO_REWIND_TO(dst) \
            do {\
                const char *p;\
                for ( p = yy_cp-1; p >= (dst); --p)\
                    if ( *p == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = NULL; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = NULL;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart ( FILE *input_file  );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size  );
void yy_delete_buffer ( YY_BUFFER_STATE b  );
void yy_flush_buffer ( YY_BUFFER_STATE b  );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state ( void );

static void yyensure_buffer_stack ( void );
static void yy_load_buffer_state ( void );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file  );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size  );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len  );

void *yyalloc ( yy_size_t  );
void *yyrealloc ( void *, yy_size_t  );
void yyfree ( void *  );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define base_yywrap() (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

FILE *yyin = NULL, *yyout = NULL;

typedef int yy_state_type;

extern int yylineno;
int yylineno = 1;

extern char *yytext;
#ifdef yytext_ptr
#undef yytext_ptr
#endif
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state ( void );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  );
static int yy_get_next_buffer ( void );
static void yynoreturn yy_fatal_error ( const char* msg  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;
#define YY_NUM_RULES 147
#define YY_END_OF_BUFFER 148
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static const flex_int16_t yy_accept[616] =
    {   0,
        0,    0,   10,   10,    0,    0,    0,    0,    0,    0,
        9,    9,    0,    0,    0,    0,   19,   19,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  148,  146,   10,   17,    5,    5,
        6,    6,   42,   38,   44,   39,   44,    9,   23,   17,
       20,   19,   19,   19,   19,   24,   24,   17,   29,   23,
       33,   33,   35,   40,  137,  137,  135,   94,   94,  135,
      135,  116,   94,   94,  116,   43,  116,   77,   88,  116,
       12,   92,   93,   87,   90,   86,   91,  116,   89,   59,

       59,   84,   85,  116,   99,  116,   82,   82,   97,   98,
       95,  116,   96,   75,    1,    1,   55,   36,   55,   53,
       54,   55,   14,   54,   54,   54,   54,   59,   59,   54,
       54,   54,   54,   74,   74,   74,   74,   74,   74,  145,
      145,  145,  145,  141,  141,  140,  139,  138,  122,  122,
       10,    5,    7,    4,    3,   42,   41,   44,    9,   23,
       21,   19,   19,   19,   19,   18,   19,   19,   24,   26,
       27,   26,   26,   26,   22,   33,   32,   34,    0,    0,
      136,    0,    0,    0,    0,    0,  108,    0,    0,    0,
        0,    0,    0,  113,  104,    0,   83,  111,  105,  109,

      106,  110,  100,  115,   61,    2,    0,  112,   61,   59,
        0,    0,    0,  102,  107,  101,   82,   82,  103,    1,
        0,   55,   52,   55,    0,    0,   30,   56,   31,    1,
       46,   61,    2,   61,   59,   67,   67,   67,   67,   67,
       67,   45,   47,   73,   49,   51,   48,   50,   74,    8,
       15,   13,    0,   11,    0,  144,    0,    0,    0,  140,
      138,    0,    0,  121,    3,   19,   19,   19,   19,   27,
        0,    0,   28,   34,    0,    0,    0,    0,    0,   81,
       81,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  114,   61,    0,    2,    0,   78,   62,

       61,   64,   63,   60,    0,   59,   82,   55,   55,   56,
       57,   57,   31,    1,    1,   61,   71,   71,   71,    2,
       61,   59,   66,    0,   64,   63,   65,    0,   60,    0,
       59,   73,    0,    0,    0,   37,   16,  143,  142,   19,
       19,   18,   19,   19,   27,    0,    0,   28,    0,    0,
        0,    0,    0,    0,    0,    0,   81,   81,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,   61,
        0,   63,    0,   61,   82,   55,    0,   61,   71,   59,
       70,   70,   63,   72,   72,   69,   69,   60,   68,   68,
       61,   73,    0,    0,    0,   73,  143,  143,  142,  142,

       19,    0,    0,  130,    0,    0,    0,    0,    0,    0,
        0,   81,   81,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   82,   55,   55,
        0,   61,   61,   61,   61,   73,    0,    0,    0,    0,
        0,   25,  130,    0,  132,    0,  126,    0,    0,    0,
        0,    0,    0,   81,   81,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  120,    0,   82,   55,    0,
        0,    0,    0,    0,    0,   73,   73,    0,    0,  134,
      126,  128,    0,    0,    0,    0,  118,    0,  120,    0,
       76,   58,    0,    0,    0,    0,    0,   73,    0,  128,

        0,    0,    0,   79,   79,  118,  124,   76,   76,   82,
       82,   82,   82,   58,   73,    0,    0,    0,    0,   79,
       79,   79,    0,   79,    0,  124,    0,    0,    0,   82,
       82,   82,   82,   82,   82,   58,   73,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   82,   82,   82,
       82,   82,   82,   82,   82,  129,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   82,   82,   82,   82,   82,
       82,   82,   82,  129,    0,  131,    0,  125,    0,    0,
        0,    0,    0,    0,   82,   82,   82,   82,   82,   82,
        0,  133,  125,  127,   80,   80,    0,    0,  119,   82,

       82,   82,  119,  127,   80,   80,   80,   80,  117,    0,
      117,   82,  123,  123,    0
    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    9,   10,   11,   12,
       13,   14,   15,   16,   17,   18,   19,   20,   21,   22,
       22,   22,   22,   22,   22,   23,   23,   24,   25,   26,
       27,   28,   29,   29,   30,   31,   32,   33,   34,   35,
       36,   36,   37,   36,   36,   38,   39,   40,   41,   42,
       43,   44,   45,   46,   47,   36,   36,   48,   36,   36,
       49,   50,   51,   52,   53,   29,   30,   31,   32,   33,

       34,   35,   36,   36,   54,   36,   36,   38,   39,   40,
       41,   42,   43,   44,   45,   46,   55,   36,   36,   56,
       36,   36,   57,   58,   59,   29,    1,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,

       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60,   60,   60,   60,   60,   60,
       60,   60,   60,   60,   60
    } ;

static const YY_CHAR yy_meta[61] =
    {   0,
        1,    2,    3,    3,    4,    5,    4,    6,    7,    4,
        8,    9,    9,   10,    7,    1,   11,   12,   13,   14,
       14,   15,   16,   17,   18,   19,   20,   21,    4,   22,
       22,   22,   22,   22,   22,   23,   23,   23,   23,   23,
       23,   23,   23,   23,   23,   23,   23,   23,   24,   25,
        9,    4,   26,   23,   23,   23,    1,    4,    1,   23
    } ;

static const flex_int16_t yy_base[699] =
    {   0,
        0,    0, 2435, 2434,    0,   54, 2438, 2437,    0,    5,
     2431, 2427, 2426, 2425, 2424, 2423,   18,   21,    1,   28,
        7,   22,    0,   29, 2427, 2426, 2392, 2391,  112,    0,
       40,  171,  205,    0,  265,    0,   28,   59,   73,   86,
      325,    0,  385,    0, 2399, 3460,    0, 3460,    0,    0,
       22, 2384,    0, 2391, 3460, 3460,   10,    0,    0, 2384,
     3460,   90,   93,  174, 2374,    0,    0, 2379,  426, 2378,
        0,    0, 2380, 2381, 3460,  178, 3460, 3460, 3460,   12,
       14, 3460,   98,  185, 2359, 3460,   49,  416, 2358, 2373,
     3460, 3460, 3460,  437,   52, 3460,  166,  176,  438,  454,

      469, 3460, 3460, 2356, 2351, 2349,    0,   43, 3460, 3460,
     3460, 2316, 3460, 3460,  476,  491, 2346, 3460,  518,  446,
        0,    0, 3460, 3460, 2355,  491, 2357,  559,  497,  177,
       81, 2342, 2342,    0, 2357, 2356, 2355, 2355, 2353, 2338,
        0, 3460,    0, 3460,  536, 3460, 3460,    0, 3460,  539,
        0,    0,   26, 3460,    0,    0, 3460, 3460,    0,    0,
     3460,  482,  549, 2345,  554, 3460, 2344,  571,    0, 3460,
      438,    0,    0,    0, 3460,    0, 3460, 2352,  581,  592,
     3460,  146, 2303, 2271,  595,  467, 3460,  617,  461,  528,
     2254,  160, 2222, 3460, 3460,  510, 3460, 3460, 3460, 3460,

     3460, 3460, 2222, 3460,  658,    0, 2204, 3460,  664,  673,
      588, 2136,  679, 3460, 3460, 3460,    0, 2152, 3460,  701,
      532,    0,    0,  722,  491,  552, 3460,  692, 2150,  776,
     3460,  699,    0,  735,  741, 3460,  689,  750,  756, 1725,
      776, 3460, 3460,  717,    0,    0,    0,    0,    0, 3460,
     3460, 3460,  543, 3460, 1752, 3460, 1769, 1746,  721, 3460,
        0,  785,  804, 3460,    0,  809,  813,  819,  829,  668,
        0,    0,    0, 1764,  693, 1738,  422, 1737,  817, 3460,
        0, 1754,    0,  714,  785, 1724, 1733,  802, 1640, 1648,
     1644, 1634, 1632, 3460,  846,  817,    0, 1656, 3460, 3460,

      854,  861,  869, 1605, 1603,  875, 1623,  924, 1638,  882,
     3460,  890, 1640,    0,  978,  896, 3460,  925,  903,    0,
      936,  943,  916,  485,  950,  958,  978,  823, 1017,    0,
      992,  883, 1615,    0, 1015, 3460, 3460,  883,  999, 1018,
     1042, 1052, 1069, 1024, 3460,    0,    0, 3460, 1607, 1603,
      706, 1591, 1568, 1058, 1064, 1072, 1085, 1088, 1550, 1550,
     1536, 1538, 1540, 1540, 1526, 1524,  747, 1521, 1523, 1073,
     1077, 1088, 1095, 1099, 1102, 1145, 1107, 1114, 1122, 1538,
     3460,  593, 1145, 3460, 1155, 3460, 1103, 1184, 3460,    0,
     1159, 1016, 1136, 1182, 1206, 1218, 1186, 3460, 1222, 3460,

     1227,    0,    0, 1154, 1237, 1514, 1504, 1490, 1189, 1480,
     1239, 1493, 1242,  800, 1246, 1471, 1468, 1457,  461, 1457,
     1443, 1432,  745, 1421,  823, 1421, 1268, 1412,    0,  901,
     1255, 1259, 1265, 1277, 1283, 1064, 1330, 1321, 1388, 1312,
        0, 3460, 1198, 1317, 3460, 1341, 1305, 1415, 1402, 1424,
      941, 1403, 1308, 1348, 1443,    0, 1380, 1358, 1366,    0,
     1351, 1325, 1332, 1330, 1328, 1366, 1317, 1315, 1334, 1353,
     1431, 1493,    0,    0, 1322, 1114, 1551,    0, 1456, 3460,
     1375, 1381, 1471, 1294,    0, 1292, 1391, 1284, 1410, 1279,
     1538, 1443, 1284, 1276,  531, 1573,    0, 1632,    0, 1465,

     1524,  496, 1249, 1468, 1476, 1480, 1483, 1620,    0, 1230,
      946,  927, 1214, 1468, 1683,    0,  971, 1219,  881, 1509,
     1512, 1528, 1192, 1531, 1188, 1534, 1193, 1044, 1154, 1148,
     1214, 1137,  935, 1119, 1113, 3460,    0, 1077, 1068,  787,
     1067, 1031, 1024, 1023, 1008, 1010,  990,  890,  974,  960,
      937,  956,  873,  856,  845, 1544, 1636,  792,  747,  745,
     1029, 1113, 1159,  730,  720,  704, 1578, 1742,  705,  693,
      672, 1208,  662, 1584, 1745, 3460, 1748, 1587,  648,  570,
      558,  561, 1219,  557,  555, 1751, 1592,  543,  529, 1595,
     1754, 3460, 1628, 1660, 1666, 1669,  463,  428, 1674, 1757,

     1760,  168, 1778, 1781, 1784, 1787, 1790, 1793, 1796,   13,
     1799, 1802, 1805, 1808, 3460, 1812, 1838, 1864, 1890, 1916,
     1942, 1968, 1994, 2020, 2046, 2072, 2098, 2124, 2150, 2176,
     2202, 2228, 2254, 2280, 2306, 2332, 2353, 2378, 2404, 2425,
     2448, 2464, 2479, 2489, 2510, 2536, 2562, 2588, 2609, 2634,
     2657, 2678, 2691, 2700, 2709, 2726, 2749, 2770, 2783, 2796,
     2817, 2843, 2856, 2879, 2889, 2902, 2923, 2944, 2970, 2996,
     3022, 3043, 3068, 3091, 3112, 3125, 3134, 3143, 3152, 3165,
     3178, 3191, 3204, 3221, 1268, 3246, 3259, 3268, 3290, 3311,
     3324, 3333, 3355, 3381, 3394, 3415, 3428, 3437

    } ;

static const flex_int16_t yy_def[699] =
    {   0,
      616,  616,  617,  617,  618,  618,  619,  619,  620,  620,
      621,  621,  622,  622,  622,  622,  623,  623,  624,  624,
      622,  622,  625,  625,  619,  619,  622,  622,  615,   29,
      626,  626,  615,   33,  615,   35,  627,  627,  628,  628,
      615,   41,  615,   43,  615,  615,  629,  615,  630,  630,
      615,  615,  631,  615,  615,  615,  615,  632,  633,  615,
      615,  615,  615,  615,  615,  634,  634,  615,  635,  633,
      636,  636,  637,  615,  615,  638,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  639,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,

      615,  615,  615,  615,  615,  615,  640,  640,  615,  615,
      615,  615,  615,  615,  615,  615,  641,  615,  639,  642,
      641,  641,  615,  615,  641,  615,  641,  643,  643,  644,
      641,  641,  641,  645,  645,  645,  645,  645,  645,  646,
      647,  615,  648,  615,  615,  615,  615,  649,  615,  650,
      629,  630,  615,  615,  651,  631,  615,  615,  632,  633,
      615,  615,  615,  615,  615,  615,  615,  652,  634,  615,
      615,  653,  654,  655,  615,  636,  615,  656,  615,  638,
      615,  615,  615,  615,  615,  639,  615,  615,  188,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,

      615,  615,  615,  615,  615,  657,  658,  615,  615,  615,
      615,  659,  615,  615,  615,  615,  640,  640,  615,  615,
      639,  641,  641,  188,  188,  615,  615,  660,  661,  662,
      615,  663,  664,  663,  665,  615,  615,  615,  615,  666,
      615,  615,  615,  667,  641,  641,  641,  641,  668,  615,
      615,  615,  615,  615,  669,  615,  670,  671,  615,  615,
      672,  615,  673,  615,  674,  675,  652,  652,  652,  615,
      676,  677,  678,  656,  615,  615,  615,  615,  188,  615,
      279,  279,  188,  279,  188,  188,  188,  279,  615,  615,
      615,  615,  615,  615,  615,  615,  657,  658,  615,  615,

      615,  615,  615,  659,  659,  615,  640,  279,  308,  660,
      615,  615,  661,  662,  662,  663,  615,  615,  615,  664,
      316,  665,  679,  615,  615,  680,  681,  615,  682,  683,
      322,  684,  615,  685,  686,  615,  615,  615,  615,  675,
      675,  675,  675,  652,  615,  687,  688,  615,  615,  615,
      615,  615,  615,  615,  689,  279,  279,  279,  188,  188,
      188,  188,  279,  279,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  640,  689,  615,  321,  615,  322,
      615,  615,  680,  615,  615,  615,  615,  682,  615,  683,
      316,  690,  686,  686,  686,  686,  615,  615,  615,  615,

      675,  691,  692,  615,  615,  615,  615,  615,  615,  615,
      689,  693,  689,  279,  689,  188,  188,  188,  188,  279,
      279,  615,  615,  615,  615,  615,  615,  640,  376,  308,
      615,  321,  321,  321,  321,  690,  694,  686,  615,  686,
      695,  615,  615,  615,  615,  615,  615,  615,  615,  693,
      615,  279,  689,  689,  689,  188,  188,  188,  188,  279,
      279,  615,  615,  615,  615,  615,  615,  640,  308,  615,
      615,  694,  472,  472,  472,  472,  696,  697,  615,  615,
      615,  615,  615,  188,  279,  615,  615,  615,  615,  615,
      640,  615,  615,  472,  472,  472,  472,  696,  698,  615,

      615,  615,  615,  188,  615,  615,  615,  615,  508,  640,
      640,  640,  640,  615,  615,  692,  615,  615,  615,  279,
      615,  279,  279,  615,  615,  615,  615,  615,  615,  640,
      640,  640,  640,  640,  640,  615,  515,  615,  615,  615,
      615,  615,  279,  615,  615,  615,  615,  640,  640,  640,
      640,  640,  640,  640,  640,  615,  615,  615,  615,  615,
      279,  615,  615,  615,  615,  640,  640,  640,  640,  640,
      640,  640,  640,  615,  615,  615,  615,  615,  615,  279,
      615,  615,  615,  615,  640,  640,  640,  640,  640,  640,
      615,  615,  615,  615,  279,  615,  615,  615,  615,  640,

      640,  640,  615,  615,  279,  615,  279,  615,  615,  615,
      615,  640,  615,  615,    0,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615

    } ;

static const flex_int16_t yy_nxt[3521] =
    {   0,
      615,  615,   72,   67,   50,   56,   50,   73,   50,   50,
       56,   68,  615,   51,   50,  158,   50,   48,   52,   62,
       63,   64,   62,   63,   64,   50,   50,   50,   50,  615,
       67,   72,   48,  141,   65,  153,   73,   65,   68,  153,
      154,   78,   79,   78,  154,  182,  613,   80,  183,   57,
       69,   50,  142,  143,   57,  142,   70,   50,   50,  158,
       50,  184,   50,   50,  141,  183,  199,   51,   50,  184,
       50,   70,   52,   81,  145,  145,  145,   69,  200,   50,
       50,   50,   50,  142,  143,  189,  142,  145,  145,  145,
      218,  162,  163,  163,  165,  165,  165,  146,  218,  185,

      185,  185,  190,  166,  186,   50,  164,  245,  246,  167,
      146,   50,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   75,   75,
       75,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       75,   75,   75,   75,   76,   76,   76,   76,   75,   75,
       75,   76,   78,   79,   78,  165,  165,  165,   80,  179,
      179,  179,  201,  275,  166,  276,  185,  185,  185,  204,
      167,  186,  202,  203,  277,  205,  205,  205,  205,  292,

      242,  612,  181,  243,   81,   82,   83,   84,   83,   85,
       86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
       96,   97,   98,   99,  100,  101,  101,  101,  102,  103,
      104,  105,  106,   82,  107,  107,  107,  107,  108,  107,
      107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  109,   82,  110,   82,  107,  107,  107,
      107,  111,  112,  113,  107,  114,  115,  116,  115,  117,
      118,  119,  120,  121,  122,  123,  124,  124,  121,  121,
      124,  125,  126,  127,  128,  129,  129,  129,  130,  124,
      131,  132,  133,  122,  134,  135,  134,  134,  136,  134,

      134,  134,  134,  134,  137,  134,  134,  134,  134,  134,
      134,  138,  139,  124,  114,  124,  121,  134,  134,  138,
      139,  114,  122,  114,  134,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
      147,  147,  147,  147,  148,  148,  148,  148,  148,  148,
      148,  148,  148,  148,  148,  148,  148,  148,  148,  148,
      148,  148,  148,  147,  147,  147,  147,  148,  148,  148,
      148,  147,  147,  147,  148,  149,  149,  149,  149,  149,
      149,  149,  149,  149,  149,  149,  149,  149,  149,  149,

      149,  149,  149,  149,  149,  149,  149,  149,  149,  149,
      149,  149,  149,  149,  150,  150,  150,  150,  150,  150,
      150,  150,  150,  150,  150,  150,  150,  150,  150,  150,
      150,  150,  150,  149,  149,  149,  149,  150,  150,  150,
      150,  149,  149,  149,  150,  171,  171,  171,  191,  182,
      196,  206,  192,  227,  352,  197,  207,  270,  270,  270,
      610,  353,  193,  198,  208,  228,  228,  228,  228,  192,
      193,  209,  172,  210,  210,  210,  210,  220,  220,  220,
      173,  174,  221,  162,  163,  163,  209,  211,  210,  210,
      210,  210,  220,  220,  220,  285,  609,  221,  164,  286,

      287,  212,  211,  189,  323,  323,  213,  459,  231,  212,
      232,  232,  232,  232,  234,  459,  235,  235,  235,  235,
      190,  213,  224,  196,  224,  285,  224,  224,  197,  286,
      238,  224,  224,  517,  224,  518,  224,  259,  259,  259,
      262,  262,  262,  224,  224,  224,  224,  475,  336,  241,
      165,  165,  165,  337,  225,  165,  165,  165,  496,  166,
      260,  602,  288,  264,  166,  167,  289,  290,  225,  224,
      167,  226,  268,  163,  163,  224,  234,  601,  235,  235,
      235,  235,  179,  179,  179,  226,  288,  269,  600,  237,
      289,  599,  238,  179,  179,  179,  185,  185,  185,  239,

      597,  186,  302,  596,  302,  181,  240,  303,  303,  303,
      303,  241,  323,  323,  240,  595,  181,  279,  279,  280,
      281,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  282,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  283,  283,  279,  284,  279,  279,  279,
      283,  283,  283,  279,  279,  279,  279,  295,  295,  295,
      295,  300,  594,  301,  301,  301,  301,  345,  345,  345,
      209,  211,  210,  210,  210,  210,  590,  211,  306,  306,

      306,  306,  220,  220,  220,  588,  211,  221,  323,  323,
      296,  310,  310,  310,  310,  356,  357,  358,  316,  316,
      316,  316,  259,  259,  259,  213,  308,  587,  308,  349,
      308,  308,  318,  333,  334,  308,  308,  350,  308,  586,
      309,  324,  406,  585,  312,  260,  349,  308,  308,  308,
      308,  319,  300,  584,  321,  321,  321,  321,  234,  406,
      322,  322,  322,  322,  325,  335,  325,  583,  318,  326,
      326,  326,  326,  308,  238,  327,  327,  327,  579,  308,
      315,  578,  315,  424,  315,  315,  262,  262,  262,  315,
      315,  463,  315,  241,  315,  331,  331,  331,  331,  463,

      424,  315,  315,  315,  315,  262,  262,  262,  328,  264,
      341,  165,  165,  414,  268,  163,  163,  359,  452,  342,
      268,  163,  163,  558,  360,  343,  577,  315,  264,  269,
      268,  163,  163,  315,  363,  269,  295,  295,  295,  295,
      558,  364,  327,  327,  327,  344,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  295,  295,  295,  295,  465,
      279,  279,  279,  370,  370,  370,  370,  465,  573,  211,
      303,  303,  303,  303,  397,  397,  397,  211,  372,  372,
      372,  372,  374,  572,  306,  306,  306,  306,  296,  333,

      334,  310,  310,  310,  310,  571,  371,  398,  211,  310,
      310,  310,  310,  541,  430,  316,  316,  316,  316,  469,
      542,  373,  316,  316,  316,  316,  566,  213,  308,  318,
      308,  335,  308,  308,  312,  323,  323,  308,  308,  325,
      308,  325,  309,  566,  326,  326,  326,  326,  319,  308,
      308,  308,  308,  377,  451,  378,  378,  378,  378,  279,
      234,  533,  380,  380,  380,  380,  534,  552,  382,  326,
      326,  326,  326,  569,  553,  308,  238,  383,  383,  383,
      383,  308,  315,  531,  315,  532,  315,  315,  379,  570,
      569,  315,  315,  568,  315,  241,  315,  327,  327,  327,

      399,  399,  399,  315,  315,  315,  315,  538,  567,  391,
      385,  331,  331,  331,  331,  539,  393,  393,  393,  341,
      165,  165,  565,  400,  538,  268,  163,  163,  342,  315,
      387,  395,  333,  334,  343,  315,  329,  329,  329,  329,
      344,  564,  563,  341,  165,  165,  388,  388,  388,  388,
      388,  388,  342,  341,  165,  165,  562,  561,  343,  409,
      409,  409,  342,  560,  335,  396,  412,  413,  343,  390,
      341,  165,  165,  356,  357,  358,  580,  414,  519,  342,
      333,  334,  282,  546,  580,  401,  356,  357,  358,  356,
      357,  358,  370,  370,  370,  370,  370,  370,  370,  370,

      559,  557,  410,  427,  427,  427,  211,  372,  372,  372,
      372,  556,  335,  415,  372,  372,  372,  372,  301,  301,
      301,  301,  327,  327,  327,  371,  431,  431,  431,  431,
      495,  496,  211,  432,  432,  432,  432,  393,  393,  393,
      373,  433,  433,  433,  433,  555,  428,  412,  413,  429,
      554,  429,  395,  429,  429,  443,  443,  443,  430,  429,
      581,  429,  497,  309,  383,  383,  383,  383,  581,  551,
      429,  429,  429,  429,  383,  383,  383,  383,  435,  435,
      435,  435,  548,  393,  393,  393,  396,  397,  397,  397,
      409,  409,  409,  547,  415,  582,  429,  385,  395,  443,

      443,  443,  429,  329,  329,  329,  329,  393,  393,  393,
      398,  317,  582,  388,  388,  388,  388,  388,  388,  393,
      393,  393,  437,  399,  399,  399,  545,  544,  341,  165,
      165,  543,  396,  410,  438,  439,  390,  342,  444,  444,
      444,  412,  413,  401,  412,  413,  400,  453,  454,  455,
      549,  540,  414,  535,  589,  414,  396,  282,  550,  414,
      282,  445,  589,  530,  282,  598,  440,  549,  396,  427,
      427,  427,  470,  598,  471,  471,  471,  471,  433,  433,
      433,  433,  615,  519,  433,  433,  433,  433,  415,  392,
      392,  415,  475,  392,  300,  415,  435,  435,  435,  435,

      615,  470,  433,  433,  433,  433,  481,  481,  481,  453,
      454,  455,  467,  393,  393,  393,  508,  507,  444,  444,
      444,  414,  393,  393,  393,  505,  282,  504,  395,  317,
      472,  473,  393,  393,  472,  472,  472,  437,  475,  472,
      472,  445,  479,  479,  479,  472,  475,  376,  439,  453,
      454,  455,  491,  472,  472,  472,  472,  415,  472,  490,
      488,  414,  396,  487,  486,  480,  282,  489,  489,  489,
      485,  396,  492,  492,  492,  492,  481,  481,  481,  472,
      476,  472,  500,  500,  500,  460,  472,  472,  472,  393,
      393,  393,  506,  506,  506,  394,  394,  415,  484,  394,

      394,  394,  394,  456,  395,  394,  394,  394,  394,  394,
      394,  489,  489,  489,  456,  394,  355,  477,  477,  477,
      477,  477,  477,  477,  477,  477,  477,  477,  477,  477,
      477,  477,  477,  477,  477,  477,  394,  451,  396,  483,
      477,  477,  477,  477,  453,  454,  455,  477,  470,  482,
      493,  493,  493,  493,  468,  466,  414,  479,  479,  479,
      464,  282,  514,  514,  514,  514,  500,  500,  500,  520,
      521,  522,  501,  501,  501,  462,  461,  524,  524,  524,
      480,  506,  506,  506,  526,  526,  526,  536,  536,  536,
      536,  460,  415,  472,  473,  393,  393,  472,  472,  472,

      458,  457,  472,  472,  502,  456,  451,  503,  472,  494,
      520,  521,  522,  524,  524,  524,  472,  472,  472,  472,
      523,  472,  449,  448,  503,  501,  501,  501,  525,  520,
      521,  522,  524,  524,  524,  526,  526,  526,  447,  509,
      509,  509,  472,  476,  472,  574,  574,  574,  446,  472,
      472,  472,  393,  393,  393,  434,  426,  502,  425,  394,
      503,  423,  394,  394,  394,  394,  422,  438,  439,  394,
      510,  511,  421,  420,  512,  419,  418,  503,  394,  574,
      574,  574,  417,  416,  513,  574,  574,  574,  593,  593,
      593,  512,  513,  593,  593,  593,  603,  603,  603,  440,

      408,  396,  515,  515,  515,  515,  515,  515,  515,  515,
      515,  515,  515,  515,  515,  515,  515,  515,  515,  515,
      515,  509,  509,  509,  407,  515,  515,  515,  515,  593,
      593,  593,  515,  393,  393,  393,  405,  575,  575,  575,
      394,  404,  334,  394,  394,  394,  394,  227,  438,  439,
      394,  376,  527,  502,  375,  615,  528,  305,  299,  394,
      576,  604,  604,  604,  369,  368,  529,  605,  606,  607,
      608,  608,  608,  528,  529,  603,  603,  603,  367,  366,
      440,  365,  396,  472,  473,  393,  393,  472,  472,  472,
      537,  474,  472,  472,  474,  474,  474,  474,  472,  495,

      496,  474,  537,  537,  537,  537,  472,  472,  472,  472,
      474,  472,  537,  537,  537,  537,  537,  537,  537,  537,
      537,  537,  537,  537,  537,  537,  537,  537,  537,  537,
      537,  497,  472,  476,  472,  537,  537,  537,  537,  472,
      472,  472,  537,  575,  575,  575,  575,  575,  575,  591,
      591,  591,  591,  591,  591,  591,  591,  591,  611,  611,
      611,  604,  604,  604,  362,  361,  576,  355,  354,  576,
      351,  177,  592,  339,  338,  592,  256,  330,  592,  603,
      603,  603,  604,  604,  604,  605,  606,  607,  608,  608,
      608,  605,  606,  607,  608,  608,  608,  611,  611,  611,

      611,  611,  611,  614,  614,  614,  614,  614,  614,  614,
      614,  614,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   46,   46,
       46,   46,   46,   46,   46,   46,   46,   46,   47,   47,
       47,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   47,   47,   47,   47,   47,   47,
       47,   47,   47,   47,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,

       53,   53,   53,   53,   53,   53,   53,   53,   53,   53,
       53,   53,   53,   53,   53,   53,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   55,   55,   55,   55,   55,   55,   55,   55,
       55,   55,   58,   58,   58,   58,   58,   58,   58,   58,
       58,   58,   58,   58,   58,   58,   58,   58,   58,   58,
       58,   58,   58,   58,   58,   58,   58,   58,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   59,   59,   59,   59,   59,   59,
       59,   59,   59,   59,   61,   61,   61,   61,   61,   61,

       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       61,   61,   61,   61,   61,   61,   61,   61,   61,   61,
       66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
       66,   66,   66,   66,   66,   66,   66,   66,   66,   66,
       66,   66,   66,   66,   66,   66,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   71,   71,   71,   71,   71,   71,   71,   71,
       71,   71,   77,   77,   77,   77,   77,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   77,   77,   77,   77,
       77,   77,   77,   77,   77,   77,   77,   77,  140,  140,

      140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
      140,  140,  140,  140,  140,  140,  140,  140,  140,  140,
      140,  140,  140,  140,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      144,  144,  144,  144,  144,  144,  144,  144,  144,  144,
      151,  151,  151,  151,  151,  151,  151,  227,  151,  151,
      151,  151,  151,  151,  151,  151,  151,  151,  151,  151,
      151,  151,  151,  151,  151,  151,  152,  152,  152,  152,
      152,  152,  152,  152,  152,  307,  152,  152,  305,  152,
      152,  152,  152,  152,  152,  152,  152,  152,  152,  152,

      152,  152,  156,  156,  156,  156,  299,  156,  156,  156,
      156,  156,  156,  156,  156,  156,  156,  156,  156,  156,
      156,  156,  156,  156,  156,  156,  156,  156,  159,  159,
      159,  159,  159,  159,  159,  294,  159,  159,  159,  159,
      159,  159,  159,  159,  159,  159,  159,  159,  159,  159,
      159,  159,  159,  159,  160,  160,  160,  160,  160,  160,
      160,  293,  160,  160,  160,  160,  160,  160,  160,  160,
      160,  160,  160,  160,  160,  160,  160,  160,  160,  160,
      169,  169,  169,  169,  169,  169,  169,  291,  169,  169,
      169,  169,  169,  169,  169,  169,  169,  169,  169,  169,

      169,  169,  169,  169,  278,  169,  170,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170,  170,  170,  170,
      170,  170,  170,  170,  170,  170,  170,  170,  170,  170,
      170,  170,  176,  176,  176,  176,  176,  277,  176,  176,
      176,  176,  176,  176,  176,  176,  176,  176,  176,  176,
      176,  176,  176,  176,  176,  176,  176,  176,  178,  177,
      266,  168,  256,  254,  253,  252,  251,  250,  248,  247,
      233,  230,  223,  219,  178,  178,  216,  215,  178,  180,
      180,  214,  195,  180,  194,  187,  157,  177,  175,  161,
      168,  180,  180,  180,  161,  180,  157,  155,  615,  180,

      180,   60,   60,  180,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      217,   74,   74,   60,   60,   60,   60,   48,  217,  217,
      217,   48,   54,   54,   48,   48,  217,  217,  615,  615,
      217,  222,  615,  615,  222,  615,  615,  222,  222,  615,
      222,  615,  615,  615,  615,  615,  222,  222,  222,  229,
      615,  615,  615,  615,  615,  615,  615,  229,  229,  229,
      615,  615,  615,  615,  615,  229,  229,  615,  615,  229,
      236,  615,  236,  236,  236,  615,  615,  615,  615,  615,

      236,  236,  615,  615,  236,  244,  615,  615,  244,  615,
      244,  244,  615,  615,  244,  249,  615,  615,  615,  615,
      615,  615,  615,  249,  249,  249,  615,  615,  615,  615,
      615,  249,  249,  615,  615,  249,  255,  255,  255,  255,
      615,  255,  255,  255,  255,  255,  255,  255,  255,  255,
      255,  255,  255,  255,  615,  255,  615,  255,  255,  255,
      255,  255,  257,  257,  257,  257,  615,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  258,  258,
      258,  258,  258,  258,  258,  258,  258,  258,  258,  258,

      258,  258,  258,  258,  258,  258,  258,  258,  615,  258,
      258,  258,  258,  258,  261,  615,  615,  615,  615,  615,
      615,  615,  261,  261,  261,  615,  615,  615,  615,  615,
      261,  261,  615,  615,  261,  263,  263,  615,  615,  263,
      615,  615,  615,  615,  615,  615,  615,  263,  263,  263,
      615,  263,  615,  615,  615,  263,  263,  615,  615,  263,
      265,  615,  615,  265,  615,  615,  265,  265,  615,  265,
      615,  615,  615,  615,  615,  265,  265,  265,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,
      267,  267,  267,  267,  267,  267,  267,  267,  267,  267,

      267,  267,  267,  267,  271,  271,  271,  615,  615,  615,
      615,  615,  271,  272,  272,  272,  615,  615,  615,  615,
      615,  272,  273,  273,  273,  615,  615,  615,  615,  615,
      273,  274,  615,  615,  615,  615,  615,  615,  615,  274,
      274,  274,  615,  615,  615,  615,  615,  274,  274,  615,
      615,  274,  297,  615,  615,  297,  615,  615,  297,  297,
      615,  297,  615,  615,  615,  615,  615,  297,  297,  297,
      298,  298,  298,  298,  298,  298,  298,  298,  298,  298,
      298,  298,  298,  298,  298,  298,  298,  298,  298,  298,
      298,  298,  298,  298,  298,  298,  304,  304,  304,  615,

      615,  615,  615,  615,  304,  615,  615,  615,  304,  311,
      311,  311,  615,  615,  615,  615,  615,  311,  311,  615,
      615,  311,  313,  615,  615,  615,  615,  615,  615,  615,
      313,  313,  313,  615,  615,  615,  615,  615,  313,  313,
      615,  615,  313,  314,  314,  615,  314,  314,  314,  314,
      314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
      314,  314,  314,  314,  314,  314,  314,  314,  314,  317,
      317,  317,  615,  615,  615,  615,  615,  317,  317,  615,
      615,  317,  320,  615,  615,  320,  615,  615,  320,  320,
      615,  320,  615,  615,  615,  615,  615,  320,  320,  320,

      236,  615,  236,  236,  236,  615,  615,  615,  615,  615,
      236,  236,  615,  615,  236,  329,  329,  329,  615,  615,
      615,  615,  615,  329,  615,  615,  615,  329,  332,  615,
      615,  615,  615,  332,  332,  615,  332,  332,  332,  615,
      615,  615,  615,  615,  332,  332,  332,  615,  332,  249,
      615,  615,  615,  615,  615,  615,  615,  249,  249,  249,
      615,  615,  615,  615,  615,  249,  249,  615,  615,  249,
      255,  255,  255,  255,  615,  255,  255,  255,  255,  255,
      255,  255,  255,  255,  255,  255,  255,  255,  615,  255,
      615,  255,  255,  255,  255,  255,  257,  257,  257,  257,

      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  258,  258,  258,  258,  258,  258,  258,  258,
      258,  258,  258,  258,  258,  258,  258,  258,  258,  258,
      258,  258,  258,  258,  258,  258,  258,  258,  261,  615,
      615,  615,  615,  615,  615,  615,  261,  261,  261,  615,
      615,  615,  615,  615,  261,  261,  615,  615,  261,  263,
      263,  615,  615,  263,  615,  615,  615,  615,  615,  615,
      615,  263,  263,  263,  615,  263,  615,  615,  615,  263,
      263,  615,  615,  263,  265,  615,  615,  265,  615,  615,

      265,  265,  615,  265,  615,  615,  615,  615,  615,  265,
      265,  265,  340,  340,  340,  340,  340,  340,  340,  340,
      340,  340,  340,  340,  340,  340,  340,  340,  340,  340,
      340,  340,  340,  340,  340,  340,  340,  340,  346,  346,
      346,  615,  615,  615,  615,  615,  346,  347,  347,  347,
      615,  615,  615,  615,  615,  347,  348,  348,  348,  615,
      615,  615,  615,  615,  348,  381,  615,  615,  615,  615,
      615,  615,  615,  381,  381,  615,  615,  381,  384,  384,
      384,  615,  615,  615,  615,  615,  384,  384,  615,  615,
      384,  386,  386,  615,  615,  615,  615,  615,  615,  386,

      386,  615,  615,  386,  389,  389,  389,  615,  615,  615,
      615,  615,  389,  389,  615,  615,  389,  329,  329,  329,
      615,  615,  615,  615,  615,  329,  332,  615,  615,  615,
      615,  332,  332,  615,  332,  332,  332,  615,  615,  615,
      615,  615,  332,  332,  332,  615,  332,  394,  394,  615,
      615,  394,  394,  615,  394,  394,  394,  394,  394,  394,
      394,  394,  615,  615,  615,  615,  394,  394,  394,  394,
      615,  394,  402,  402,  402,  615,  615,  615,  615,  615,
      402,  403,  403,  403,  615,  615,  615,  615,  615,  403,
      411,  411,  411,  411,  411,  411,  411,  411,  411,  411,

      411,  411,  411,  411,  411,  411,  411,  411,  411,  411,
      411,  411,  411,  411,  411,  411,  436,  615,  615,  615,
      615,  436,  436,  615,  436,  436,  436,  615,  615,  615,
      615,  615,  436,  436,  436,  615,  436,  441,  441,  441,
      615,  615,  615,  615,  615,  441,  442,  442,  442,  615,
      615,  615,  615,  615,  442,  450,  450,  450,  450,  450,
      450,  450,  450,  450,  450,  450,  450,  615,  450,  450,
      450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
      450,  474,  474,  474,  474,  474,  474,  474,  474,  474,
      474,  474,  474,  474,  474,  474,  474,  474,  474,  474,

      474,  474,  474,  474,  474,  474,  474,  478,  478,  478,
      615,  615,  615,  615,  615,  478,  498,  498,  615,  615,
      498,  498,  615,  498,  498,  498,  498,  498,  498,  498,
      498,  615,  615,  615,  615,  498,  498,  498,  498,  615,
      498,  499,  499,  499,  615,  615,  615,  615,  615,  499,
      516,  516,  516,  615,  615,  615,  615,  615,  516,   45,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,

      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615
    } ;

static const flex_int16_t yy_chk[3521] =
    {   0,
        0,    0,   23,   19,    5,    9,    5,   23,    5,    5,
       10,   19,    0,    5,    5,   57,    5,   21,    5,   17,
       17,   17,   18,   18,   18,    5,    5,    5,    5,    0,
       20,   24,   22,   37,   17,   51,   24,   18,   20,  153,
       51,   31,   31,   31,  153,   80,  610,   31,   80,    9,
       19,    5,   37,   37,   10,   37,   21,    5,    6,   57,
        6,   81,    6,    6,   38,   80,   95,    6,    6,   81,
        6,   22,    6,   31,   39,   39,   39,   20,   95,    6,
        6,    6,    6,   38,   38,   87,   38,   40,   40,   40,
      108,   62,   62,   62,   63,   63,   63,   39,  108,   83,

       83,   83,   87,   63,   83,    6,   62,  131,  131,   63,
       40,    6,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   29,   29,   29,   29,   29,   29,   29,   29,
       29,   29,   32,   32,   32,   64,   64,   64,   32,   76,
       76,   76,   97,  182,   64,  182,   84,   84,   84,   98,
       64,   84,   97,   97,  192,   98,   98,   98,   98,  192,

      130,  602,   76,  130,   32,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   33,   33,   33,   33,   33,
       33,   33,   33,   33,   33,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,

       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   35,   35,   35,   35,   35,
       35,   35,   35,   35,   35,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   41,   41,
       41,   41,   41,   41,   41,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,

       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   69,   69,   69,   88,   88,
       94,   99,   88,  120,  277,   94,   99,  171,  171,  171,
      598,  277,   88,   94,   99,  120,  120,  120,  120,   88,
       88,  100,   69,  100,  100,  100,  100,  115,  115,  115,
       69,   69,  115,  162,  162,  162,  101,  100,  101,  101,
      101,  101,  116,  116,  116,  189,  597,  116,  162,  189,

      189,  100,  101,  186,  324,  324,  100,  419,  126,  100,
      126,  126,  126,  126,  129,  419,  129,  129,  129,  129,
      186,  101,  119,  196,  119,  225,  119,  119,  196,  225,
      129,  119,  119,  502,  119,  502,  119,  145,  145,  145,
      150,  150,  150,  119,  119,  119,  119,  495,  253,  129,
      163,  163,  163,  253,  119,  165,  165,  165,  495,  163,
      145,  589,  190,  150,  165,  163,  190,  190,  221,  119,
      165,  119,  168,  168,  168,  119,  128,  588,  128,  128,
      128,  128,  179,  179,  179,  221,  226,  168,  585,  128,
      226,  584,  128,  180,  180,  180,  185,  185,  185,  128,

      582,  185,  211,  581,  211,  179,  128,  211,  211,  211,
      211,  128,  382,  382,  128,  580,  180,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  188,  188,  188,
      188,  188,  188,  188,  188,  188,  188,  205,  205,  205,
      205,  209,  579,  209,  209,  209,  209,  270,  270,  270,
      210,  205,  210,  210,  210,  210,  573,  209,  213,  213,

      213,  213,  220,  220,  220,  571,  210,  220,  237,  237,
      205,  228,  228,  228,  228,  284,  284,  284,  232,  232,
      232,  232,  259,  259,  259,  210,  224,  570,  224,  275,
      224,  224,  232,  244,  244,  224,  224,  275,  224,  569,
      224,  237,  351,  566,  228,  259,  275,  224,  224,  224,
      224,  232,  234,  565,  234,  234,  234,  234,  235,  351,
      235,  235,  235,  235,  238,  244,  238,  564,  234,  238,
      238,  238,  238,  224,  235,  239,  239,  239,  560,  224,
      230,  559,  230,  367,  230,  230,  262,  262,  262,  230,
      230,  423,  230,  235,  230,  241,  241,  241,  241,  423,

      367,  230,  230,  230,  230,  263,  263,  263,  239,  262,
      266,  266,  266,  414,  267,  267,  267,  285,  414,  266,
      268,  268,  268,  540,  285,  266,  558,  230,  263,  267,
      269,  269,  269,  230,  288,  268,  296,  296,  296,  296,
      540,  288,  328,  328,  328,  269,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  295,  295,  295,  295,  425,
      279,  279,  279,  301,  301,  301,  301,  425,  555,  295,
      302,  302,  302,  302,  338,  338,  338,  301,  303,  303,
      303,  303,  306,  554,  306,  306,  306,  306,  295,  332,

      332,  310,  310,  310,  310,  553,  301,  338,  306,  312,
      312,  312,  312,  519,  430,  316,  316,  316,  316,  430,
      519,  303,  319,  319,  319,  319,  548,  306,  308,  316,
      308,  332,  308,  308,  310,  323,  323,  308,  308,  318,
      308,  318,  308,  548,  318,  318,  318,  318,  316,  308,
      308,  308,  308,  321,  451,  321,  321,  321,  321,  451,
      322,  512,  322,  322,  322,  322,  512,  533,  323,  325,
      325,  325,  325,  551,  533,  308,  322,  326,  326,  326,
      326,  308,  315,  511,  315,  511,  315,  315,  321,  552,
      551,  315,  315,  550,  315,  322,  315,  327,  327,  327,

      339,  339,  339,  315,  315,  315,  315,  517,  549,  331,
      326,  331,  331,  331,  331,  517,  335,  335,  335,  340,
      340,  340,  547,  339,  517,  344,  344,  344,  340,  315,
      327,  335,  392,  392,  340,  315,  329,  329,  329,  329,
      344,  546,  545,  341,  341,  341,  329,  329,  329,  329,
      329,  329,  341,  342,  342,  342,  544,  543,  341,  354,
      354,  354,  342,  542,  392,  335,  355,  355,  342,  329,
      343,  343,  343,  356,  356,  356,  561,  355,  528,  343,
      436,  436,  355,  528,  561,  343,  357,  357,  357,  358,
      358,  358,  370,  370,  370,  370,  371,  371,  371,  371,

      541,  539,  354,  375,  375,  375,  370,  372,  372,  372,
      372,  538,  436,  355,  373,  373,  373,  373,  374,  374,
      374,  374,  387,  387,  387,  370,  377,  377,  377,  377,
      476,  476,  374,  378,  378,  378,  378,  393,  393,  393,
      372,  379,  379,  379,  379,  535,  375,  376,  376,  376,
      534,  376,  393,  376,  376,  404,  404,  404,  376,  376,
      562,  376,  476,  376,  383,  383,  383,  383,  562,  532,
      376,  376,  376,  376,  385,  385,  385,  385,  391,  391,
      391,  391,  530,  394,  394,  394,  393,  397,  397,  397,
      409,  409,  409,  529,  376,  563,  376,  383,  394,  443,

      443,  443,  376,  388,  388,  388,  388,  395,  395,  395,
      397,  391,  563,  388,  388,  388,  388,  388,  388,  396,
      396,  396,  395,  399,  399,  399,  527,  525,  401,  401,
      401,  523,  394,  409,  396,  396,  388,  401,  405,  405,
      405,  411,  411,  401,  413,  413,  399,  415,  415,  415,
      531,  518,  411,  513,  572,  413,  395,  411,  531,  415,
      413,  405,  572,  510,  415,  583,  396,  531,  396,  427,
      427,  427,  431,  583,  431,  431,  431,  431,  432,  432,
      432,  432,  433,  503,  433,  433,  433,  433,  411,  685,
      685,  413,  494,  685,  434,  415,  434,  434,  434,  434,

      435,  493,  435,  435,  435,  435,  447,  447,  447,  453,
      453,  453,  427,  440,  440,  440,  490,  488,  444,  444,
      444,  453,  438,  438,  438,  486,  453,  484,  440,  434,
      437,  437,  437,  437,  437,  437,  437,  438,  475,  437,
      437,  444,  446,  446,  446,  437,  437,  469,  438,  454,
      454,  454,  468,  437,  437,  437,  437,  453,  437,  467,
      465,  454,  440,  464,  463,  446,  454,  466,  466,  466,
      462,  438,  470,  470,  470,  470,  481,  481,  481,  437,
      437,  437,  482,  482,  482,  461,  437,  437,  437,  439,
      439,  439,  487,  487,  487,  439,  439,  454,  459,  439,

      439,  439,  439,  458,  439,  439,  439,  439,  439,  439,
      439,  489,  489,  489,  457,  439,  452,  439,  439,  439,
      439,  439,  439,  439,  439,  439,  439,  439,  439,  439,
      439,  439,  439,  439,  439,  439,  439,  450,  439,  449,
      439,  439,  439,  439,  455,  455,  455,  439,  471,  448,
      471,  471,  471,  471,  428,  426,  455,  479,  479,  479,
      424,  455,  492,  492,  492,  492,  500,  500,  500,  504,
      504,  504,  483,  483,  483,  422,  421,  505,  505,  505,
      479,  506,  506,  506,  507,  507,  507,  514,  514,  514,
      514,  420,  455,  472,  472,  472,  472,  472,  472,  472,

      418,  417,  472,  472,  483,  416,  412,  483,  472,  472,
      520,  520,  520,  521,  521,  521,  472,  472,  472,  472,
      504,  472,  410,  408,  483,  501,  501,  501,  505,  522,
      522,  522,  524,  524,  524,  526,  526,  526,  407,  491,
      491,  491,  472,  472,  472,  556,  556,  556,  406,  472,
      472,  472,  477,  477,  477,  380,  369,  501,  368,  477,
      501,  366,  477,  477,  477,  477,  365,  477,  477,  477,
      491,  491,  364,  363,  491,  362,  361,  501,  477,  567,
      567,  567,  360,  359,  491,  574,  574,  574,  578,  578,
      578,  491,  491,  587,  587,  587,  590,  590,  590,  477,

      353,  477,  496,  496,  496,  496,  496,  496,  496,  496,
      496,  496,  496,  496,  496,  496,  496,  496,  496,  496,
      496,  508,  508,  508,  352,  496,  496,  496,  496,  593,
      593,  593,  496,  498,  498,  498,  350,  557,  557,  557,
      498,  349,  333,  498,  498,  498,  498,  313,  498,  498,
      498,  309,  508,  508,  307,  305,  508,  304,  298,  498,
      557,  594,  594,  594,  293,  292,  508,  595,  595,  595,
      596,  596,  596,  508,  508,  599,  599,  599,  291,  290,
      498,  289,  498,  515,  515,  515,  515,  515,  515,  515,
      515,  515,  515,  515,  515,  515,  515,  515,  515,  515,

      515,  515,  515,  515,  515,  515,  515,  515,  515,  515,
      515,  515,  515,  515,  515,  515,  515,  515,  515,  515,
      515,  515,  515,  515,  515,  515,  515,  515,  515,  515,
      515,  515,  515,  515,  515,  515,  515,  515,  515,  515,
      515,  515,  515,  568,  568,  568,  575,  575,  575,  577,
      577,  577,  586,  586,  586,  591,  591,  591,  600,  600,
      600,  601,  601,  601,  287,  286,  568,  282,  278,  575,
      276,  274,  577,  258,  257,  586,  255,  240,  591,  603,
      603,  603,  604,  604,  604,  605,  605,  605,  606,  606,
      606,  607,  607,  607,  608,  608,  608,  609,  609,  609,

      611,  611,  611,  612,  612,  612,  613,  613,  613,  614,
      614,  614,  616,  616,  616,  616,  616,  616,  616,  616,
      616,  616,  616,  616,  616,  616,  616,  616,  616,  616,
      616,  616,  616,  616,  616,  616,  616,  616,  617,  617,
      617,  617,  617,  617,  617,  617,  617,  617,  617,  617,
      617,  617,  617,  617,  617,  617,  617,  617,  617,  617,
      617,  617,  617,  617,  618,  618,  618,  618,  618,  618,
      618,  618,  618,  618,  618,  618,  618,  618,  618,  618,
      618,  618,  618,  618,  618,  618,  618,  618,  618,  618,
      619,  619,  619,  619,  619,  619,  619,  619,  619,  619,

      619,  619,  619,  619,  619,  619,  619,  619,  619,  619,
      619,  619,  619,  619,  619,  619,  620,  620,  620,  620,
      620,  620,  620,  620,  620,  620,  620,  620,  620,  620,
      620,  620,  620,  620,  620,  620,  620,  620,  620,  620,
      620,  620,  621,  621,  621,  621,  621,  621,  621,  621,
      621,  621,  621,  621,  621,  621,  621,  621,  621,  621,
      621,  621,  621,  621,  621,  621,  621,  621,  622,  622,
      622,  622,  622,  622,  622,  622,  622,  622,  622,  622,
      622,  622,  622,  622,  622,  622,  622,  622,  622,  622,
      622,  622,  622,  622,  623,  623,  623,  623,  623,  623,

      623,  623,  623,  623,  623,  623,  623,  623,  623,  623,
      623,  623,  623,  623,  623,  623,  623,  623,  623,  623,
      624,  624,  624,  624,  624,  624,  624,  624,  624,  624,
      624,  624,  624,  624,  624,  624,  624,  624,  624,  624,
      624,  624,  624,  624,  624,  624,  625,  625,  625,  625,
      625,  625,  625,  625,  625,  625,  625,  625,  625,  625,
      625,  625,  625,  625,  625,  625,  625,  625,  625,  625,
      625,  625,  626,  626,  626,  626,  626,  626,  626,  626,
      626,  626,  626,  626,  626,  626,  626,  626,  626,  626,
      626,  626,  626,  626,  626,  626,  626,  626,  627,  627,

      627,  627,  627,  627,  627,  627,  627,  627,  627,  627,
      627,  627,  627,  627,  627,  627,  627,  627,  627,  627,
      627,  627,  627,  627,  628,  628,  628,  628,  628,  628,
      628,  628,  628,  628,  628,  628,  628,  628,  628,  628,
      628,  628,  628,  628,  628,  628,  628,  628,  628,  628,
      629,  629,  629,  629,  629,  629,  629,  229,  629,  629,
      629,  629,  629,  629,  629,  629,  629,  629,  629,  629,
      629,  629,  629,  629,  629,  629,  630,  630,  630,  630,
      630,  630,  630,  630,  630,  218,  630,  630,  212,  630,
      630,  630,  630,  630,  630,  630,  630,  630,  630,  630,

      630,  630,  631,  631,  631,  631,  207,  631,  631,  631,
      631,  631,  631,  631,  631,  631,  631,  631,  631,  631,
      631,  631,  631,  631,  631,  631,  631,  631,  632,  632,
      632,  632,  632,  632,  632,  203,  632,  632,  632,  632,
      632,  632,  632,  632,  632,  632,  632,  632,  632,  632,
      632,  632,  632,  632,  633,  633,  633,  633,  633,  633,
      633,  193,  633,  633,  633,  633,  633,  633,  633,  633,
      633,  633,  633,  633,  633,  633,  633,  633,  633,  633,
      634,  634,  634,  634,  634,  634,  634,  191,  634,  634,
      634,  634,  634,  634,  634,  634,  634,  634,  634,  634,

      634,  634,  634,  634,  184,  634,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  635,  635,  635,  635,  635,  635,  635,  635,
      635,  635,  636,  636,  636,  636,  636,  183,  636,  636,
      636,  636,  636,  636,  636,  636,  636,  636,  636,  636,
      636,  636,  636,  636,  636,  636,  636,  636,  637,  178,
      167,  164,  140,  139,  138,  137,  136,  135,  133,  132,
      127,  125,  117,  112,  637,  637,  106,  105,  637,  638,
      638,  104,   90,  638,   89,   85,   74,   73,   70,   68,
       65,  638,  638,  638,   60,  638,   54,   52,   45,  638,

      638,   28,   27,  638,  639,  639,  639,  639,  639,  639,
      639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
      639,  639,  639,  639,  639,  639,  639,  639,  639,  639,
      640,   26,   25,   16,   15,   14,   13,   12,  640,  640,
      640,   11,    8,    7,    4,    3,  640,  640,    0,    0,
      640,  641,    0,    0,  641,    0,    0,  641,  641,    0,
      641,    0,    0,    0,    0,    0,  641,  641,  641,  642,
        0,    0,    0,    0,    0,    0,    0,  642,  642,  642,
        0,    0,    0,    0,    0,  642,  642,    0,    0,  642,
      643,    0,  643,  643,  643,    0,    0,    0,    0,    0,

      643,  643,    0,    0,  643,  644,    0,    0,  644,    0,
      644,  644,    0,    0,  644,  645,    0,    0,    0,    0,
        0,    0,    0,  645,  645,  645,    0,    0,    0,    0,
        0,  645,  645,    0,    0,  645,  646,  646,  646,  646,
        0,  646,  646,  646,  646,  646,  646,  646,  646,  646,
      646,  646,  646,  646,    0,  646,    0,  646,  646,  646,
      646,  646,  647,  647,  647,  647,    0,  647,  647,  647,
      647,  647,  647,  647,  647,  647,  647,  647,  647,  647,
      647,  647,  647,  647,  647,  647,  647,  647,  648,  648,
      648,  648,  648,  648,  648,  648,  648,  648,  648,  648,

      648,  648,  648,  648,  648,  648,  648,  648,    0,  648,
      648,  648,  648,  648,  649,    0,    0,    0,    0,    0,
        0,    0,  649,  649,  649,    0,    0,    0,    0,    0,
      649,  649,    0,    0,  649,  650,  650,    0,    0,  650,
        0,    0,    0,    0,    0,    0,    0,  650,  650,  650,
        0,  650,    0,    0,    0,  650,  650,    0,    0,  650,
      651,    0,    0,  651,    0,    0,  651,  651,    0,  651,
        0,    0,    0,    0,    0,  651,  651,  651,  652,  652,
      652,  652,  652,  652,  652,  652,  652,  652,  652,  652,
      652,  652,  652,  652,  652,  652,  652,  652,  652,  652,

      652,  652,  652,  652,  653,  653,  653,    0,    0,    0,
        0,    0,  653,  654,  654,  654,    0,    0,    0,    0,
        0,  654,  655,  655,  655,    0,    0,    0,    0,    0,
      655,  656,    0,    0,    0,    0,    0,    0,    0,  656,
      656,  656,    0,    0,    0,    0,    0,  656,  656,    0,
        0,  656,  657,    0,    0,  657,    0,    0,  657,  657,
        0,  657,    0,    0,    0,    0,    0,  657,  657,  657,
      658,  658,  658,  658,  658,  658,  658,  658,  658,  658,
      658,  658,  658,  658,  658,  658,  658,  658,  658,  658,
      658,  658,  658,  658,  658,  658,  659,  659,  659,    0,

        0,    0,    0,    0,  659,    0,    0,    0,  659,  660,
      660,  660,    0,    0,    0,    0,    0,  660,  660,    0,
        0,  660,  661,    0,    0,    0,    0,    0,    0,    0,
      661,  661,  661,    0,    0,    0,    0,    0,  661,  661,
        0,    0,  661,  662,  662,    0,  662,  662,  662,  662,
      662,  662,  662,  662,  662,  662,  662,  662,  662,  662,
      662,  662,  662,  662,  662,  662,  662,  662,  662,  663,
      663,  663,    0,    0,    0,    0,    0,  663,  663,    0,
        0,  663,  664,    0,    0,  664,    0,    0,  664,  664,
        0,  664,    0,    0,    0,    0,    0,  664,  664,  664,

      665,    0,  665,  665,  665,    0,    0,    0,    0,    0,
      665,  665,    0,    0,  665,  666,  666,  666,    0,    0,
        0,    0,    0,  666,    0,    0,    0,  666,  667,    0,
        0,    0,    0,  667,  667,    0,  667,  667,  667,    0,
        0,    0,    0,    0,  667,  667,  667,    0,  667,  668,
        0,    0,    0,    0,    0,    0,    0,  668,  668,  668,
        0,    0,    0,    0,    0,  668,  668,    0,    0,  668,
      669,  669,  669,  669,    0,  669,  669,  669,  669,  669,
      669,  669,  669,  669,  669,  669,  669,  669,    0,  669,
        0,  669,  669,  669,  669,  669,  670,  670,  670,  670,

      670,  670,  670,  670,  670,  670,  670,  670,  670,  670,
      670,  670,  670,  670,  670,  670,  670,  670,  670,  670,
      670,  670,  671,  671,  671,  671,  671,  671,  671,  671,
      671,  671,  671,  671,  671,  671,  671,  671,  671,  671,
      671,  671,  671,  671,  671,  671,  671,  671,  672,    0,
        0,    0,    0,    0,    0,    0,  672,  672,  672,    0,
        0,    0,    0,    0,  672,  672,    0,    0,  672,  673,
      673,    0,    0,  673,    0,    0,    0,    0,    0,    0,
        0,  673,  673,  673,    0,  673,    0,    0,    0,  673,
      673,    0,    0,  673,  674,    0,    0,  674,    0,    0,

      674,  674,    0,  674,    0,    0,    0,    0,    0,  674,
      674,  674,  675,  675,  675,  675,  675,  675,  675,  675,
      675,  675,  675,  675,  675,  675,  675,  675,  675,  675,
      675,  675,  675,  675,  675,  675,  675,  675,  676,  676,
      676,    0,    0,    0,    0,    0,  676,  677,  677,  677,
        0,    0,    0,    0,    0,  677,  678,  678,  678,    0,
        0,    0,    0,    0,  678,  679,    0,    0,    0,    0,
        0,    0,    0,  679,  679,    0,    0,  679,  680,  680,
      680,    0,    0,    0,    0,    0,  680,  680,    0,    0,
      680,  681,  681,    0,    0,    0,    0,    0,    0,  681,

      681,    0,    0,  681,  682,  682,  682,    0,    0,    0,
        0,    0,  682,  682,    0,    0,  682,  683,  683,  683,
        0,    0,    0,    0,    0,  683,  684,    0,    0,    0,
        0,  684,  684,    0,  684,  684,  684,    0,    0,    0,
        0,    0,  684,  684,  684,    0,  684,  686,  686,    0,
        0,  686,  686,    0,  686,  686,  686,  686,  686,  686,
      686,  686,    0,    0,    0,    0,  686,  686,  686,  686,
        0,  686,  687,  687,  687,    0,    0,    0,    0,    0,
      687,  688,  688,  688,    0,    0,    0,    0,    0,  688,
      689,  689,  689,  689,  689,  689,  689,  689,  689,  689,

      689,  689,  689,  689,  689,  689,  689,  689,  689,  689,
      689,  689,  689,  689,  689,  689,  690,    0,    0,    0,
        0,  690,  690,    0,  690,  690,  690,    0,    0,    0,
        0,    0,  690,  690,  690,    0,  690,  691,  691,  691,
        0,    0,    0,    0,    0,  691,  692,  692,  692,    0,
        0,    0,    0,    0,  692,  693,  693,  693,  693,  693,
      693,  693,  693,  693,  693,  693,  693,    0,  693,  693,
      693,  693,  693,  693,  693,  693,  693,  693,  693,  693,
      693,  694,  694,  694,  694,  694,  694,  694,  694,  694,
      694,  694,  694,  694,  694,  694,  694,  694,  694,  694,

      694,  694,  694,  694,  694,  694,  694,  695,  695,  695,
        0,    0,    0,    0,    0,  695,  696,  696,    0,    0,
      696,  696,    0,  696,  696,  696,  696,  696,  696,  696,
      696,    0,    0,    0,    0,  696,  696,  696,  696,    0,
      696,  697,  697,  697,    0,    0,    0,    0,    0,  697,
      698,  698,  698,    0,    0,    0,    0,    0,  698,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,

      615,  615,  615,  615,  615,  615,  615,  615,  615,  615,
      615,  615,  615,  615,  615,  615,  615,  615,  615,  615
    } ;

/* Table of booleans, true if rule could match eol. */
static const flex_int32_t yy_rule_can_match_eol[148] =
    {   0,
1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
    1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 
    0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 
    1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 
    1, 1, 1, 1, 1, 1, 1, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "pgc.l"

#line 33 "pgc.l"

/* LCOV_EXCL_START */

extern YYSTYPE base_yylval;

static int		xcdepth = 0;	/* depth of nesting in slash-star comments */
static char	   *dolqstart = NULL;	/* current $foo$ quote start string */

/*
 * literalbuf is used to accumulate literal values when multiple rules
 * are needed to parse a single literal.  Call startlit to reset buffer
 * to empty, addlit to add text.  Note that the buffer is permanently
 * malloc'd to the largest size needed so far in the current run.
 */
static char	   *literalbuf = NULL;		/* expandable buffer */
static int		literallen;				/* actual current length */
static int		literalalloc;			/* current allocated buffer size */

/* Used for detecting global state together with braces_open */
static int		parenths_open;

/* Used to tell parse_include() whether the command was #include or #include_next */
static bool		include_next;

#define startlit()	(literalbuf[0] = '\0', literallen = 0)
static void addlit(char *ytext, int yleng);
static void addlitchar(unsigned char ychar);
static int	process_integer_literal(const char *token, YYSTYPE *lval, int base);
static void parse_include(void);
static bool ecpg_isspace(char ch);
static bool isdefine(void);
static bool isinformixdefine(void);

char *token_start;

/* vars to keep track of start conditions when scanning literals */
static int state_before_str_start;
static int state_before_str_stop;

struct _yy_buffer
{
	YY_BUFFER_STATE		buffer;
	long				lineno;
	char			   *filename;
	struct _yy_buffer  *next;
} *yy_buffer = NULL;

static char *old;

/*
 * Vars for handling ifdef/elif/endif constructs.  preproc_tos is the current
 * nesting depth of such constructs, and stacked_if_value[preproc_tos] is the
 * state for the innermost level.  (For convenience, stacked_if_value[0] is
 * initialized as though we are in the active branch of some outermost IF.)
 * The active field is true if the current branch is active (being expanded).
 * The saw_active field is true if we have found any successful branch,
 * so that all subsequent branches of this level should be skipped.
 * The else_branch field is true if we've found an 'else' (so that another
 * 'else' or 'elif' at this level is an error.)
 * For IFs nested within an inactive branch, all branches always have active
 * set to false, but saw_active and else_branch are maintained normally.
 * ifcond is valid only while evaluating an if-condition; it's true if we
 * are doing ifdef, false if ifndef.
 */
#define MAX_NESTED_IF 128
static short preproc_tos;
static bool ifcond;
static struct _if_value
{
	bool		active;
	bool		saw_active;
	bool		else_branch;
} stacked_if_value[MAX_NESTED_IF];

#line 1835 "pgc.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xdc> double-quoted strings in C
 *  <xh> hexadecimal byte string
 *  <xn> national character quoted strings
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xqc> single-quoted strings in C
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xcond> condition of an EXEC SQL IFDEF construct
 *  <xskip> skipping the inactive part of an EXEC SQL IFDEF construct
 *
 * Note: we intentionally don't mimic the backend's <xeu> state; we have
 * no need to distinguish it from <xe> state.
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/* Additional exclusive states that are specific to ECPG */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  SQL-style comments, which start with -- and extend to the
 * next newline, are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix ecpg_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 */
/* Hexadecimal byte string */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* special stuff for C strings */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/*
 * Numbers
 *
 * Unary minus is not part of a number here.  Instead we pass it separately to
 * the parser, and there it gets coerced via doNegate().
 *
 * {numericfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail} is added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/* special characters for other dbms */
/* we have to react differently in compat mode */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
/* some stuff needed for ecpg */
/* we might want to parse all cpp include files */
/* take care of cpp lines, they may also be continued */
/* first a general line for all commands not starting with "i" */
/* and then the other commands starting with "i", we have to add these
 * separately because the cppline production would match on "include" too
 */
#line 1996 "pgc.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xdc 4
#define xh 5
#define xn 6
#define xq 7
#define xqs 8
#define xe 9
#define xqc 10
#define xdolq 11
#define xui 12
#define xus 13
#define xcond 14
#define xskip 15
#define C 16
#define SQL 17
#define incl 18
#define def 19
#define def_ident 20
#define undef 21

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals ( void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( void );

int yyget_debug ( void );

void yyset_debug ( int debug_flag  );

YY_EXTRA_TYPE yyget_extra ( void );

void yyset_extra ( YY_EXTRA_TYPE user_defined  );

FILE *yyget_in ( void );

void yyset_in  ( FILE * _in_str  );

FILE *yyget_out ( void );

void yyset_out  ( FILE * _out_str  );

			int yyget_leng ( void );

char *yyget_text ( void );

int yyget_lineno ( void );

void yyset_lineno ( int _line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( void );
#else
extern int yywrap ( void );
#endif
#endif

#ifndef YY_NO_UNPUT
    
    static void yyunput ( int c, char *buf_ptr  );
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * );
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( void );
#else
static int input ( void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	{
#line 443 "pgc.l"



#line 447 "pgc.l"
		/* code to execute during start of each call of yylex() */
		token_start = NULL;


#line 2243 "pgc.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)] ;
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 616 )
					yy_c = yy_meta[yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 615 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 452 "pgc.l"
{
					/* ignore */
				}
	YY_BREAK
/* <SQL> */

case 2:
YY_RULE_SETUP
#line 458 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
					fputs("/*", yyout);
				}
	YY_BREAK
/* <C,SQL> */

case 3:
YY_RULE_SETUP
#line 470 "pgc.l"
{
					if (state_before_str_start == SQL)
					{
						xcdepth++;
						/* Put back any characters past slash-star; see above */
						yyless(2);
						fputs("/_*", yyout);
					}
					else if (state_before_str_start == C)
					{
						ECHO;
					}
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 484 "pgc.l"
{
					if (state_before_str_start == SQL)
					{
						if (xcdepth <= 0)
						{
							ECHO;
							BEGIN(SQL);
							token_start = NULL;
						}
						else
						{
							xcdepth--;
							fputs("*_/", yyout);
						}
					}
					else if (state_before_str_start == C)
					{
						ECHO;
						BEGIN(C);
						token_start = NULL;
					}
				}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 507 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 511 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 515 "pgc.l"
{
					ECHO;
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 519 "pgc.l"
{
					mmfatal(PARSE_ERROR, "unterminated /* comment");
				}
	YY_BREAK
/* <xc> */

case 8:
YY_RULE_SETUP
#line 525 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xb);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 9:
/* rule 9 can match eol */
#line 534 "pgc.l"
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 534 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 537 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated bit string literal"); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 539 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xh);
					startlit();
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 545 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated hexadecimal string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 547 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xqc);
					startlit();
				}
	YY_BREAK

case 13:
YY_RULE_SETUP
#line 555 "pgc.l"
{
					/* National character.
					 * Transfer it as-is to the backend.
					 */
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xn);
					startlit();
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 565 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xq);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 571 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 577 "pgc.l"
{
					token_start = yytext;
					state_before_str_start = YYSTATE;
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 17:
YY_RULE_SETUP
#line 585 "pgc.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
YY_RULE_SETUP
#line 597 "pgc.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(state_before_str_stop);
				}
	YY_BREAK
case 19:
/* rule 19 can match eol */
#line 606 "pgc.l"
case 20:
/* rule 20 can match eol */
#line 607 "pgc.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 607 "pgc.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(state_before_str_start);

					switch (state_before_str_stop)
					{
						case xb:
							if (literalbuf[strspn(literalbuf, "01")] != '\0')
								mmerror(PARSE_ERROR, ET_ERROR, "invalid bit string literal");
							base_yylval.str = psprintf("b'%s'", literalbuf);
							return BCONST;
						case xh:
							if (literalbuf[strspn(literalbuf, "0123456789abcdefABCDEF")] != '\0')
								mmerror(PARSE_ERROR, ET_ERROR, "invalid hexadecimal string literal");
							base_yylval.str = psprintf("x'%s'", literalbuf);
							return XCONST;
						case xq:
							/* fallthrough */
						case xqc:
							base_yylval.str = psprintf("'%s'", literalbuf);
							return SCONST;
						case xe:
							base_yylval.str = psprintf("E'%s'", literalbuf);
							return SCONST;
						case xn:
							base_yylval.str = psprintf("N'%s'", literalbuf);
							return SCONST;
						case xus:
							base_yylval.str = psprintf("U&'%s'", literalbuf);
							return USCONST;
						default:
							mmfatal(PARSE_ERROR, "unhandled previous state in xqs\n");
					}
				}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 647 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 648 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 649 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 650 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 653 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 26:
/* rule 26 can match eol */
YY_RULE_SETUP
#line 656 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 659 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 662 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 665 "pgc.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0]);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xqc):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xn):
case YY_STATE_EOF(xus):
#line 669 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK

case 30:
YY_RULE_SETUP
#line 672 "pgc.l"
{
					token_start = yytext;
					if (dolqstart)
						free(dolqstart);
					dolqstart = mm_strdup(yytext);
					BEGIN(xdolq);
					startlit();
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 681 "pgc.l"
{
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
/* <SQL> */
case 32:
YY_RULE_SETUP
#line 689 "pgc.l"
{
					if (strcmp(yytext, dolqstart) == 0)
					{
						addlit(yytext, yyleng);
						free(dolqstart);
						dolqstart = NULL;
						BEGIN(SQL);
						base_yylval.str = mm_strdup(literalbuf);
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 33:
/* rule 33 can match eol */
YY_RULE_SETUP
#line 710 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 713 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 716 "pgc.l"
{
					/* single quote or dollar sign */
					addlitchar(yytext[0]);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 720 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated dollar-quoted string"); }
	YY_BREAK

case 36:
YY_RULE_SETUP
#line 723 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 728 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
/* <SQL> */
case 38:
YY_RULE_SETUP
#line 735 "pgc.l"
{
					BEGIN(state_before_str_start);
					if (literallen == 0)
						mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
					/*
					 * The server will truncate the identifier here.  We do
					 * not, as (1) it does not change the result; (2) we don't
					 * know what NAMEDATALEN the server might use; (3) this
					 * code path is also taken for literal query strings in
					 * PREPARE and EXECUTE IMMEDIATE, which can certainly be
					 * longer than NAMEDATALEN.
					 */
					base_yylval.str = mm_strdup(literalbuf);
					return CSTRING;
				}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 750 "pgc.l"
{
					BEGIN(state_before_str_start);
					base_yylval.str = mm_strdup(literalbuf);
					return CSTRING;
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 755 "pgc.l"
{
					BEGIN(state_before_str_start);
					if (literallen == 0)
						mmerror(PARSE_ERROR, ET_ERROR, "zero-length delimited identifier");
					/* The backend will truncate the identifier here. We do not as it does not change the result. */
					base_yylval.str = psprintf("U&\"%s\"", literalbuf);
					return UIDENT;
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 763 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 766 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 769 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted identifier"); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 770 "pgc.l"
{
					state_before_str_start = YYSTATE;
					BEGIN(xdc);
					startlit();
				}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 775 "pgc.l"
{
					addlit(yytext, yyleng);
				}
	YY_BREAK
case YY_STATE_EOF(xdc):
#line 778 "pgc.l"
{ mmfatal(PARSE_ERROR, "unterminated quoted string"); }
	YY_BREAK

case 45:
YY_RULE_SETUP
#line 781 "pgc.l"
{
					return TYPECAST;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 785 "pgc.l"
{
					return DOT_DOT;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 789 "pgc.l"
{
					return COLON_EQUALS;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 793 "pgc.l"
{
					return EQUALS_GREATER;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 797 "pgc.l"
{
					return LESS_EQUALS;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 801 "pgc.l"
{
					return GREATER_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 805 "pgc.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					return NOT_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 810 "pgc.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 815 "pgc.l"
{
			  /* are we simulating Informix? */
				if (INFORMIX_MODE)
				{
					unput(':');
				}
				else
					return yytext[0];
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 825 "pgc.l"
{
					/*
					 * We may find a ';' inside a structure
					 * definition in a TYPE or VAR statement.
					 * This is not an EOL marker.
					 */
					if (yytext[0] == ';' && struct_level == 0)
						BEGIN(C);
					return yytext[0];
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 836 "pgc.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					base_yylval.str = mm_strdup(yytext);
					return Op;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 933 "pgc.l"
{
					base_yylval.ival = atol(yytext+1);
					return PARAM;
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 937 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after parameter");
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 941 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return IP;
				}
	YY_BREAK
/* <SQL> */

case 59:
YY_RULE_SETUP
#line 948 "pgc.l"
{
					return process_integer_literal(yytext, &base_yylval, 10);
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 951 "pgc.l"
{
					return process_integer_literal(yytext, &base_yylval, 16);
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 954 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 958 "pgc.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					return process_integer_literal(yytext, &base_yylval, 10);
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 963 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 967 "pgc.l"
{
					/*
					 * throw back the [Ee][+-], and figure out whether what
					 * remains is an {decinteger} or {numeric}.
					 */
					yyless(yyleng - 2);
					return process_integer_literal(yytext, &base_yylval, 10);
				}
	YY_BREAK
/* <C,SQL> */

case 65:
YY_RULE_SETUP
#line 978 "pgc.l"
{
					return process_integer_literal(yytext, &base_yylval, 8);
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 981 "pgc.l"
{
					return process_integer_literal(yytext, &base_yylval, 2);
				}
	YY_BREAK
/*
	 * Note that some trailing junk is valid in C (such as 100LL), so we
	 * contain this to SQL mode.
	 */
case 67:
YY_RULE_SETUP
#line 989 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 992 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 995 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 998 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1001 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 1004 "pgc.l"
{
					mmfatal(PARSE_ERROR, "trailing junk after numeric literal");
				}
	YY_BREAK
case 73:
/* rule 73 can match eol */
YY_RULE_SETUP
#line 1008 "pgc.l"
{
					base_yylval.str = mm_strdup(yytext+1);
					return CVARIABLE;
				}
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 1013 "pgc.l"
{
					if (!isdefine())
					{
						int		kwvalue;

						/*
						 * User-defined typedefs override SQL keywords, but
						 * not C keywords.  Currently, a typedef name is just
						 * reported as IDENT, but someday we might need to
						 * return a distinct token type.
						 */
						if (get_typedef(yytext, true) == NULL)
						{
							/* Is it an SQL/ECPG keyword? */
							kwvalue = ScanECPGKeywordLookup(yytext);
							if (kwvalue >= 0)
								return kwvalue;
						}

						/* Is it a C keyword? */
						kwvalue = ScanCKeywordLookup(yytext);
						if (kwvalue >= 0)
							return kwvalue;

						/*
						 * None of the above.  Return it as an identifier.
						 *
						 * The backend will attempt to truncate and case-fold
						 * the identifier, but I see no good reason for ecpg
						 * to do so; that's just another way that ecpg could get
						 * out of step with the backend.
						 */
						base_yylval.str = mm_strdup(yytext);
						return IDENT;
					}
				}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 1050 "pgc.l"
{
					return yytext[0];
				}
	YY_BREAK
/* <SQL> */
/*
	 * Begin ECPG-specific rules
	 */
case 76:
/* rule 76 can match eol */
YY_RULE_SETUP
#line 1059 "pgc.l"
{ BEGIN(SQL); return SQL_START; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 1060 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(SQL);
							return SQL_START;
						}
						else
							return S_ANYTHING;
					 }
	YY_BREAK
case 78:
/* rule 78 can match eol */
YY_RULE_SETUP
#line 1070 "pgc.l"
{ ECHO; }
	YY_BREAK
case 79:
/* rule 79 can match eol */
YY_RULE_SETUP
#line 1071 "pgc.l"
{
						if (system_includes)
						{
							include_next = false;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(yytext);
							return CPP_LINE;
						}
					}
	YY_BREAK
case 80:
/* rule 80 can match eol */
YY_RULE_SETUP
#line 1083 "pgc.l"
{
						if (system_includes)
						{
							include_next = true;
							BEGIN(incl);
						}
						else
						{
							base_yylval.str = mm_strdup(yytext);
							return CPP_LINE;
						}
					}
	YY_BREAK
case 81:
/* rule 81 can match eol */
YY_RULE_SETUP
#line 1095 "pgc.l"
{
						base_yylval.str = mm_strdup(yytext);
						return CPP_LINE;
					}
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 1099 "pgc.l"
{
						/*
						 * Try to detect a function name:
						 * look for identifiers at the global scope
						 * keep the last identifier before the first '(' and '{'
						 */
						if (braces_open == 0 && parenths_open == 0)
						{
							if (current_function)
								free(current_function);
							current_function = mm_strdup(yytext);
						}
						/* Informix uses SQL defines only in SQL space */
						/* however, some defines have to be taken care of for compatibility */
						if ((!INFORMIX_MODE || !isinformixdefine()) && !isdefine())
						{
							int		kwvalue;

							kwvalue = ScanCKeywordLookup(yytext);
							if (kwvalue >= 0)
								return kwvalue;
							else
							{
								base_yylval.str = mm_strdup(yytext);
								return IDENT;
							}
						}
					}
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 1127 "pgc.l"
{ mmerror(PARSE_ERROR, ET_ERROR, "nested /* ... */ comments"); }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 1128 "pgc.l"
{ return ':'; }
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 1129 "pgc.l"
{ return ';'; }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 1130 "pgc.l"
{ return ','; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 1131 "pgc.l"
{ return '*'; }
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 1132 "pgc.l"
{ return '%'; }
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 1133 "pgc.l"
{ return '/'; }
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 1134 "pgc.l"
{ return '+'; }
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 1135 "pgc.l"
{ return '-'; }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 1136 "pgc.l"
{ parenths_open++; return '('; }
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 1137 "pgc.l"
{ parenths_open--; return ')'; }
	YY_BREAK
case 94:
/* rule 94 can match eol */
YY_RULE_SETUP
#line 1138 "pgc.l"
{ ECHO; }
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 1139 "pgc.l"
{ return '{'; }
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 1140 "pgc.l"
{ return '}'; }
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 1141 "pgc.l"
{ return '['; }
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 1142 "pgc.l"
{ return ']'; }
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 1143 "pgc.l"
{ return '='; }
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 1144 "pgc.l"
{ return S_MEMBER; }
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 1145 "pgc.l"
{ return S_RSHIFT; }
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 1146 "pgc.l"
{ return S_LSHIFT; }
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 1147 "pgc.l"
{ return S_OR; }
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 1148 "pgc.l"
{ return S_AND; }
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 1149 "pgc.l"
{ return S_INC; }
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 1150 "pgc.l"
{ return S_DEC; }
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 1151 "pgc.l"
{ return S_EQUAL; }
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 1152 "pgc.l"
{ return S_NEQUAL; }
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 1153 "pgc.l"
{ return S_ADD; }
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 1154 "pgc.l"
{ return S_SUB; }
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 1155 "pgc.l"
{ return S_MUL; }
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 1156 "pgc.l"
{ return S_DIV; }
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 1157 "pgc.l"
{ return S_MOD; }
	YY_BREAK
case 114:
YY_RULE_SETUP
#line 1158 "pgc.l"
{ return S_MEMPOINT; }
	YY_BREAK
case 115:
YY_RULE_SETUP
#line 1159 "pgc.l"
{ return S_DOTPOINT; }
	YY_BREAK
case 116:
YY_RULE_SETUP
#line 1160 "pgc.l"
{ return S_ANYTHING; }
	YY_BREAK
case 117:
/* rule 117 can match eol */
YY_RULE_SETUP
#line 1161 "pgc.l"
{ BEGIN(def_ident); }
	YY_BREAK
case 118:
/* rule 118 can match eol */
YY_RULE_SETUP
#line 1162 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(def_ident);
						}
						else
						{
							yyless(1);
							return S_ANYTHING;
						}
					}
	YY_BREAK
case 119:
/* rule 119 can match eol */
YY_RULE_SETUP
#line 1174 "pgc.l"
{ BEGIN(undef); }
	YY_BREAK
case 120:
/* rule 120 can match eol */
YY_RULE_SETUP
#line 1175 "pgc.l"
{
						/* are we simulating Informix? */
						if (INFORMIX_MODE)
						{
							BEGIN(undef);
						}
						else
						{
							yyless(1);
							return S_ANYTHING;
						}
					}
	YY_BREAK
case 121:
/* rule 121 can match eol */
YY_RULE_SETUP
#line 1187 "pgc.l"
{
					struct _defines *ptr, *ptr2 = NULL;
					int i;

					/*
					 *	Skip the ";" and trailing whitespace. Note that yytext
					 *	contains at least one non-space character plus the ";"
					 */
					for (i = strlen(yytext)-2;
						 i > 0 && ecpg_isspace(yytext[i]);
						 i--)
						;
					yytext[i+1] = '\0';


					for (ptr = defines; ptr != NULL; ptr2 = ptr, ptr = ptr->next)
					{
						if (strcmp(yytext, ptr->olddef) == 0)
						{
							if (ptr2 == NULL)
								defines = ptr->next;
							else
								ptr2->next = ptr->next;
							free(ptr->newdef);
							free(ptr->olddef);
							free(ptr);
							break;
						}
					}

					BEGIN(C);
				}
	YY_BREAK
case 122:
/* rule 122 can match eol */
YY_RULE_SETUP
#line 1219 "pgc.l"
{
						mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL UNDEF command");
						yyterminate();
				}
	YY_BREAK
case 123:
/* rule 123 can match eol */
YY_RULE_SETUP
#line 1223 "pgc.l"
{ BEGIN(incl); }
	YY_BREAK
case 124:
/* rule 124 can match eol */
YY_RULE_SETUP
#line 1224 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  BEGIN(incl);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 125:
/* rule 125 can match eol */
YY_RULE_SETUP
#line 1236 "pgc.l"
{
					  if (preproc_tos >= MAX_NESTED_IF-1)
						  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
					  preproc_tos++;
					  stacked_if_value[preproc_tos].active = false;
					  stacked_if_value[preproc_tos].saw_active = false;
					  stacked_if_value[preproc_tos].else_branch = false;
					  ifcond = true;
					  BEGIN(xcond);
					}
	YY_BREAK
case 126:
/* rule 126 can match eol */
YY_RULE_SETUP
#line 1246 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  if (preproc_tos >= MAX_NESTED_IF-1)
							  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
						  preproc_tos++;
						  stacked_if_value[preproc_tos].active = false;
						  stacked_if_value[preproc_tos].saw_active = false;
						  stacked_if_value[preproc_tos].else_branch = false;
						  ifcond = true;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 127:
/* rule 127 can match eol */
YY_RULE_SETUP
#line 1265 "pgc.l"
{
					  if (preproc_tos >= MAX_NESTED_IF-1)
						  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
					  preproc_tos++;
					  stacked_if_value[preproc_tos].active = false;
					  stacked_if_value[preproc_tos].saw_active = false;
					  stacked_if_value[preproc_tos].else_branch = false;
					  ifcond = false;
					  BEGIN(xcond);
					}
	YY_BREAK
case 128:
/* rule 128 can match eol */
YY_RULE_SETUP
#line 1275 "pgc.l"
{
					  /* are we simulating Informix? */
					  if (INFORMIX_MODE)
					  {
						  if (preproc_tos >= MAX_NESTED_IF-1)
							  mmfatal(PARSE_ERROR, "too many nested EXEC SQL IFDEF conditions");
						  preproc_tos++;
						  stacked_if_value[preproc_tos].active = false;
						  stacked_if_value[preproc_tos].saw_active = false;
						  stacked_if_value[preproc_tos].else_branch = false;
						  ifcond = false;
						  BEGIN(xcond);
					  }
					  else
					  {
						  yyless(1);
						  return S_ANYTHING;
					  }
					}
	YY_BREAK
case 129:
/* rule 129 can match eol */
YY_RULE_SETUP
#line 1294 "pgc.l"
{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						ifcond = true;
						BEGIN(xcond);
					}
	YY_BREAK
case 130:
/* rule 130 can match eol */
YY_RULE_SETUP
#line 1302 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						ifcond = true;
						BEGIN(xcond);
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 131:
/* rule 131 can match eol */
YY_RULE_SETUP
#line 1320 "pgc.l"
{	/* only exec sql endif pops the stack, so take care of duplicated 'else' */
					if (preproc_tos == 0)
						mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
					else if (stacked_if_value[preproc_tos].else_branch)
						mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
					else
					{
						stacked_if_value[preproc_tos].else_branch = true;
						stacked_if_value[preproc_tos].active =
							(stacked_if_value[preproc_tos-1].active &&
							 !stacked_if_value[preproc_tos].saw_active);
						stacked_if_value[preproc_tos].saw_active = true;

						if (stacked_if_value[preproc_tos].active)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
				}
	YY_BREAK
case 132:
/* rule 132 can match eol */
YY_RULE_SETUP
#line 1339 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "missing matching \"EXEC SQL IFDEF\" / \"EXEC SQL IFNDEF\"");
						else if (stacked_if_value[preproc_tos].else_branch)
							mmfatal(PARSE_ERROR, "more than one EXEC SQL ELSE");
						else
						{
							stacked_if_value[preproc_tos].else_branch = true;
							stacked_if_value[preproc_tos].active =
								(stacked_if_value[preproc_tos-1].active &&
								 !stacked_if_value[preproc_tos].saw_active);
							stacked_if_value[preproc_tos].saw_active = true;

							if (stacked_if_value[preproc_tos].active)
								BEGIN(C);
							else
								BEGIN(xskip);
						}
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 133:
/* rule 133 can match eol */
YY_RULE_SETUP
#line 1367 "pgc.l"
{
					if (preproc_tos == 0)
						mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
					else
						preproc_tos--;

					if (stacked_if_value[preproc_tos].active)
					   BEGIN(C);
					else
					   BEGIN(xskip);
				}
	YY_BREAK
case 134:
/* rule 134 can match eol */
YY_RULE_SETUP
#line 1378 "pgc.l"
{
					/* are we simulating Informix? */
					if (INFORMIX_MODE)
					{
						if (preproc_tos == 0)
							mmfatal(PARSE_ERROR, "unmatched EXEC SQL ENDIF");
						else
							preproc_tos--;

						if (stacked_if_value[preproc_tos].active)
							BEGIN(C);
						else
							BEGIN(xskip);
					}
					else
					{
						yyless(1);
						return S_ANYTHING;
					}
				}
	YY_BREAK
case 135:
YY_RULE_SETUP
#line 1399 "pgc.l"
{ /* ignore */ }
	YY_BREAK
case 136:
/* rule 136 can match eol */
YY_RULE_SETUP
#line 1401 "pgc.l"
{
					{
						struct _defines *defptr;
						unsigned int i;
						bool this_active;

						/*
						 *	Skip the ";" and trailing whitespace. Note that yytext
						 *	contains at least one non-space character plus the ";"
						 */
						for (i = strlen(yytext)-2;
							 i > 0 && ecpg_isspace(yytext[i]);
							 i--)
							;
						yytext[i+1] = '\0';

						for (defptr = defines;
							 defptr != NULL &&
							 strcmp(yytext, defptr->olddef) != 0;
							 defptr = defptr->next)
							/* skip */ ;

						this_active = (defptr ? ifcond : !ifcond);
						stacked_if_value[preproc_tos].active =
							(stacked_if_value[preproc_tos-1].active &&
							 !stacked_if_value[preproc_tos].saw_active &&
							 this_active);
						stacked_if_value[preproc_tos].saw_active |= this_active;
					}

					if (stacked_if_value[preproc_tos].active)
						BEGIN(C);
					else
						BEGIN(xskip);
				}
	YY_BREAK
case 137:
/* rule 137 can match eol */
YY_RULE_SETUP
#line 1437 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL IFDEF command");
				yyterminate();
			}
	YY_BREAK
case 138:
YY_RULE_SETUP
#line 1441 "pgc.l"
{
				old = mm_strdup(yytext);
				BEGIN(def);
				startlit();
			}
	YY_BREAK
case 139:
/* rule 139 can match eol */
YY_RULE_SETUP
#line 1446 "pgc.l"
{
				mmfatal(PARSE_ERROR, "missing identifier in EXEC SQL DEFINE command");
				yyterminate();
			}
	YY_BREAK
case 140:
/* rule 140 can match eol */
YY_RULE_SETUP
#line 1450 "pgc.l"
{
						struct _defines *ptr, *this;

						for (ptr = defines; ptr != NULL; ptr = ptr->next)
						{
							 if (strcmp(old, ptr->olddef) == 0)
							 {
								free(ptr->newdef);
								ptr->newdef = mm_strdup(literalbuf);
							 }
						}
						if (ptr == NULL)
						{
							this = (struct _defines *) mm_alloc(sizeof(struct _defines));

							/* initial definition */
							this->olddef = old;
							this->newdef = mm_strdup(literalbuf);
							this->next = defines;
							this->used = NULL;
							defines = this;
						}

						BEGIN(C);
					}
	YY_BREAK
case 141:
/* rule 141 can match eol */
YY_RULE_SETUP
#line 1475 "pgc.l"
{ addlit(yytext, yyleng); }
	YY_BREAK
case 142:
/* rule 142 can match eol */
YY_RULE_SETUP
#line 1476 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 143:
/* rule 143 can match eol */
YY_RULE_SETUP
#line 1477 "pgc.l"
{	parse_include(); }
	YY_BREAK
case 144:
/* rule 144 can match eol */
YY_RULE_SETUP
#line 1478 "pgc.l"
{ parse_include(); }
	YY_BREAK
case 145:
/* rule 145 can match eol */
YY_RULE_SETUP
#line 1479 "pgc.l"
{
					mmfatal(PARSE_ERROR, "syntax error in EXEC SQL INCLUDE command");
					yyterminate();
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(xcond):
case YY_STATE_EOF(xskip):
case YY_STATE_EOF(C):
case YY_STATE_EOF(SQL):
case YY_STATE_EOF(incl):
case YY_STATE_EOF(def):
case YY_STATE_EOF(def_ident):
case YY_STATE_EOF(undef):
#line 1484 "pgc.l"
{
					if (yy_buffer == NULL)
					{
						if (preproc_tos > 0)
						{
							preproc_tos = 0;
							mmfatal(PARSE_ERROR, "missing \"EXEC SQL ENDIF;\"");
						}
						yyterminate();
					}
					else
					{
						struct _yy_buffer *yb = yy_buffer;
						int i;
						struct _defines *ptr;

						for (ptr = defines; ptr; ptr = ptr->next)
							if (ptr->used == yy_buffer)
							{
								ptr->used = NULL;
								break;
							}

						if (yyin != NULL)
							fclose(yyin);

						yy_delete_buffer(YY_CURRENT_BUFFER);
						yy_switch_to_buffer(yy_buffer->buffer);

						yylineno = yy_buffer->lineno;

						/* We have to output the filename only if we change files here */
						i = strcmp(input_filename, yy_buffer->filename);

						free(input_filename);
						input_filename = yy_buffer->filename;

						yy_buffer = yy_buffer->next;
						free(yb);

						if (i != 0)
							output_line_number();

					}
				}
	YY_BREAK
case 146:
/* rule 146 can match eol */
YY_RULE_SETUP
#line 1530 "pgc.l"
{ mmfatal(PARSE_ERROR, "internal error: unreachable state; please report this to <%s>", PACKAGE_BUGREPORT); }
	YY_BREAK
case 147:
YY_RULE_SETUP
#line 1532 "pgc.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 4008 "pgc.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = (yytext_ptr);
	int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr) - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2)  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if (((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 616 )
				yy_c = yy_meta[yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	int yy_is_jam;
    	char *yy_cp = (yy_c_buf_p);

	YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 616 )
			yy_c = yy_meta[yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	yy_is_jam = (yy_current_state == 615);

		return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

    static void yyunput (int c, char * yy_bp )
{
	char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		int number_to_move = (yy_n_chars) + 2;
		char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = (int) YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int) ((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2)  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf  );

	yyfree( (void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr )
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg )
{
			fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
    
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param _line_number line number
 * 
 */
void yyset_lineno (int  _line_number )
{
    
    yylineno = _line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str )
{
        yyin = _in_str ;
}

void yyset_out (FILE *  _out_str )
{
        yyout = _out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  _bdebug )
{
        yy_flex_debug = _bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = NULL;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = NULL;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n )
{
		
	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s )
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
			return malloc(size);
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
		
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return realloc(ptr, size);
}

void yyfree (void * ptr )
{
			free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 1532 "pgc.l"


/* LCOV_EXCL_STOP */

void
lex_init(void)
{
	braces_open = 0;
	parenths_open = 0;
	current_function = NULL;

	yylineno = 1;

	/* initialize state for if/else/endif */
	preproc_tos = 0;
	stacked_if_value[preproc_tos].active = true;
	stacked_if_value[preproc_tos].saw_active = true;
	stacked_if_value[preproc_tos].else_branch = false;

	/* initialize literal buffer to a reasonable but expansible size */
	if (literalbuf == NULL)
	{
		literalalloc = 1024;
		literalbuf = (char *) mm_alloc(literalalloc);
	}
	startlit();

	BEGIN(C);
}

static void
addlit(char *ytext, int yleng)
{
	/* enlarge buffer if needed */
	if ((literallen+yleng) >= literalalloc)
	{
		do
			literalalloc *= 2;
		while ((literallen+yleng) >= literalalloc);
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	memcpy(literalbuf+literallen, ytext, yleng);
	literallen += yleng;
	literalbuf[literallen] = '\0';
}

static void
addlitchar(unsigned char ychar)
{
	/* enlarge buffer if needed */
	if ((literallen+1) >= literalalloc)
	{
		literalalloc *= 2;
		literalbuf = (char *) realloc(literalbuf, literalalloc);
	}
	/* append new data, add trailing null */
	literalbuf[literallen] = ychar;
	literallen += 1;
	literalbuf[literallen] = '\0';
}

/*
 * Process {decinteger}, {hexinteger}, etc.  Note this will also do the right
 * thing with {numeric}, ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval, int base)
{
	int			val;
	char	   *endptr;

	errno = 0;
	val = strtoint(base == 10 ? token : token + 2, &endptr, base);
	if (*endptr != '\0' || errno == ERANGE)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = mm_strdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
parse_include(void)
{
	/* got the include file name */
	struct _yy_buffer *yb;
	struct _include_path *ip;
	char inc_file[MAXPGPATH];
	unsigned int i;

	yb = mm_alloc(sizeof(struct _yy_buffer));

	yb->buffer =	YY_CURRENT_BUFFER;
	yb->lineno = yylineno;
	yb->filename = input_filename;
	yb->next = yy_buffer;

	yy_buffer = yb;

	/*
	 * skip the ";" if there is one and trailing whitespace. Note that
	 * yytext contains at least one non-space character plus the ";"
	 */
	for (i = strlen(yytext)-2;
		 i > 0 && ecpg_isspace(yytext[i]);
		 i--)
		;

	if (yytext[i] == ';')
		i--;

	yytext[i+1] = '\0';

	yyin = NULL;

	/* If file name is enclosed in '"' remove these and look only in '.' */
	/* Informix does look into all include paths though, except filename starts with '/' */
	if (yytext[0] == '"' && yytext[i] == '"' &&
		((compat != ECPG_COMPAT_INFORMIX && compat != ECPG_COMPAT_INFORMIX_SE) || yytext[1] == '/'))
	{
		yytext[i] = '\0';
		memmove(yytext, yytext+1, strlen(yytext));

		strlcpy(inc_file, yytext, sizeof(inc_file));
		yyin = fopen(inc_file, "r");
		if (!yyin)
		{
			if (strlen(inc_file) <= 2 || strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
			{
				strcat(inc_file, ".h");
				yyin = fopen(inc_file, "r");
			}
		}

	}
	else
	{
		if ((yytext[0] == '"' && yytext[i] == '"') || (yytext[0] == '<' && yytext[i] == '>'))
		{
			yytext[i] = '\0';
			memmove(yytext, yytext+1, strlen(yytext));
		}

		for (ip = include_paths; yyin == NULL && ip != NULL; ip = ip->next)
		{
			if (strlen(ip->path) + strlen(yytext) + 4 > MAXPGPATH)
			{
				fprintf(stderr, _("Error: include path \"%s/%s\" is too long on line %d, skipping\n"), ip->path, yytext, yylineno);
				continue;
			}
			snprintf (inc_file, sizeof(inc_file), "%s/%s", ip->path, yytext);
			yyin = fopen(inc_file, "r");
			if (!yyin)
			{
				if (strcmp(inc_file + strlen(inc_file) - 2, ".h") != 0)
				{
					strcat(inc_file, ".h");
					yyin = fopen(inc_file, "r");
				}
			}
			/* if the command was "include_next" we have to disregard the first hit */
			if (yyin && include_next)
			{
				fclose (yyin);
				yyin = NULL;
				include_next = false;
			}
		}
	}
	if (!yyin)
		mmfatal(NO_INCLUDE_FILE, "could not open include file \"%s\" on line %d", yytext, yylineno);

	input_filename = mm_strdup(inc_file);
	yy_switch_to_buffer(yy_create_buffer(yyin,YY_BUF_SIZE));
	yylineno = 1;
	output_line_number();

	BEGIN(C);
}

/*
 * ecpg_isspace() --- return true if flex scanner considers char whitespace
 */
static bool
ecpg_isspace(char ch)
{
	if (ch == ' ' ||
		ch == '\t' ||
		ch == '\n' ||
		ch == '\r' ||
		ch == '\f')
		return true;
	return false;
}

static bool isdefine(void)
{
	struct _defines *ptr;

	/* is it a define? */
	for (ptr = defines; ptr; ptr = ptr->next)
	{
		if (strcmp(yytext, ptr->olddef) == 0 && ptr->used == NULL)
		{
			struct _yy_buffer *yb;

			yb = mm_alloc(sizeof(struct _yy_buffer));

			yb->buffer =  YY_CURRENT_BUFFER;
			yb->lineno = yylineno;
			yb->filename = mm_strdup(input_filename);
			yb->next = yy_buffer;

			ptr->used = yy_buffer = yb;

			yy_scan_string(ptr->newdef);
			return true;
		}
	}

	return false;
}

static bool isinformixdefine(void)
{
	const char *new = NULL;

	if (strcmp(yytext, "dec_t") == 0)
		new = "decimal";
	else if (strcmp(yytext, "intrvl_t") == 0)
		new = "interval";
	else if (strcmp(yytext, "dtime_t") == 0)
		new = "timestamp";

	if (new)
	{
		struct _yy_buffer *yb;

		yb = mm_alloc(sizeof(struct _yy_buffer));

		yb->buffer =  YY_CURRENT_BUFFER;
		yb->lineno = yylineno;
		yb->filename = mm_strdup(input_filename);
		yb->next = yy_buffer;
		yy_buffer = yb;

		yy_scan_string(new);
		return true;
	}

	return false;
}

