// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_RENDERER_HOST_PEPPER_PEPPER_SOCKET_UTILS_H_
#define CONTENT_BROWSER_RENDERER_HOST_PEPPER_PEPPER_SOCKET_UTILS_H_

#include "build/build_config.h"
#include "content/public/common/socket_permission_request.h"
#include "ppapi/c/pp_stdint.h"

#if defined(OS_CHROMEOS)
#include "base/callback_forward.h"
#include "base/memory/scoped_ptr.h"
#include "net/base/ip_endpoint.h"
#endif  // defined(OS_CHROMEOS)

struct PP_NetAddress_Private;

#if defined(OS_CHROMEOS)
namespace chromeos {
class FirewallHole;
}
#endif  // defined(OS_CHROMEOS)

namespace net {
class X509Certificate;
}

namespace ppapi {
class PPB_X509Certificate_Fields;
}

namespace content {

namespace pepper_socket_utils {

SocketPermissionRequest CreateSocketPermissionRequest(
    SocketPermissionRequest::OperationType type,
    const PP_NetAddress_Private& net_addr);

// Returns true if the socket operation specified by |params| is allowed.
// If |params| is NULL, this method checks the basic "socket" permission, which
// is for those operations that don't require a specific socket permission rule.
bool CanUseSocketAPIs(bool external_plugin,
                      bool private_api,
                      const SocketPermissionRequest* params,
                      int render_process_id,
                      int render_frame_id);

// Extracts the certificate field data from a net::X509Certificate into
// PPB_X509Certificate_Fields.
bool GetCertificateFields(const net::X509Certificate& cert,
                          ppapi::PPB_X509Certificate_Fields* fields);

// Extracts the certificate field data from the DER representation of a
// certificate into PPB_X509Certificate_Fields.
bool GetCertificateFields(const char* der,
                          uint32_t length,
                          ppapi::PPB_X509Certificate_Fields* fields);

#if defined(OS_CHROMEOS)
typedef base::Callback<void(scoped_ptr<chromeos::FirewallHole>)>
    FirewallHoleOpenCallback;

// Returns true if the open operation is in progress.
void OpenTCPFirewallHole(const net::IPEndPoint& address,
                         FirewallHoleOpenCallback callback);

void OpenUDPFirewallHole(const net::IPEndPoint& address,
                         FirewallHoleOpenCallback callback);
#endif  // defined(OS_CHROMEOS)

}  // namespace pepper_socket_utils

}  // namespace content

#endif  // CONTENT_BROWSER_RENDERER_HOST_PEPPER_PEPPER_SOCKET_UTILS_H_
