//===----------------------------------------------------------------------===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is dual licensed under the MIT and the University of Illinois Open
// Source Licenses. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//


// XFAIL: libcpp-no-exceptions
// <string_view>

// constexpr int compare(size_type pos1, size_type n1,
//             const charT* s, size_type n2) const;

#include <experimental/string_view>
#include <cassert>

#include "constexpr_char_traits.hpp"

int sign ( int x ) { return x > 0 ? 1 : ( x < 0 ? -1 : 0 ); }

template<typename CharT>
void test1 ( std::experimental::basic_string_view<CharT> sv1, size_t pos1, size_t n1,
             const CharT *s2, size_t n2,
             int expected ) {

    try
    {
        assert ( sign( sv1.compare(pos1, n1, s2, n2)) == sign(expected));
        assert(pos1 <= sv1.size());
    }
    catch (const std::out_of_range&) { assert(pos1 > sv1.size()); }
}


template<typename CharT>
void test ( const CharT *s1, size_t pos1, size_t n1, 
            const CharT *s2, size_t n2, 
            int expected ) {
    typedef std::experimental::basic_string_view<CharT> string_view_t;
    
    string_view_t sv1 ( s1 );
    test1 (sv1, pos1, n1, s2, n2, expected);
}


void test0()
{
    test("", 0, 0, "", 0, 0);
    test("", 0, 0, "abcde", 0, 0);
    test("", 0, 0, "abcde", 1, -1);
    test("", 0, 0, "abcde", 2, -2);
    test("", 0, 0, "abcde", 4, -4);
    test("", 0, 0, "abcde", 5, -5);
    test("", 0, 0, "abcdefghij", 0, 0);
    test("", 0, 0, "abcdefghij", 1, -1);
    test("", 0, 0, "abcdefghij", 5, -5);
    test("", 0, 0, "abcdefghij", 9, -9);
    test("", 0, 0, "abcdefghij", 10, -10);
    test("", 0, 0, "abcdefghijklmnopqrst", 0, 0);
    test("", 0, 0, "abcdefghijklmnopqrst", 1, -1);
    test("", 0, 0, "abcdefghijklmnopqrst", 10, -10);
    test("", 0, 0, "abcdefghijklmnopqrst", 19, -19);
    test("", 0, 0, "abcdefghijklmnopqrst", 20, -20);
    test("", 0, 1, "", 0, 0);
    test("", 0, 1, "abcde", 0, 0);
    test("", 0, 1, "abcde", 1, -1);
    test("", 0, 1, "abcde", 2, -2);
    test("", 0, 1, "abcde", 4, -4);
    test("", 0, 1, "abcde", 5, -5);
    test("", 0, 1, "abcdefghij", 0, 0);
    test("", 0, 1, "abcdefghij", 1, -1);
    test("", 0, 1, "abcdefghij", 5, -5);
    test("", 0, 1, "abcdefghij", 9, -9);
    test("", 0, 1, "abcdefghij", 10, -10);
    test("", 0, 1, "abcdefghijklmnopqrst", 0, 0);
    test("", 0, 1, "abcdefghijklmnopqrst", 1, -1);
    test("", 0, 1, "abcdefghijklmnopqrst", 10, -10);
    test("", 0, 1, "abcdefghijklmnopqrst", 19, -19);
    test("", 0, 1, "abcdefghijklmnopqrst", 20, -20);
    test("", 1, 0, "", 0, 0);
    test("", 1, 0, "abcde", 0, 0);
    test("", 1, 0, "abcde", 1, 0);
    test("", 1, 0, "abcde", 2, 0);
    test("", 1, 0, "abcde", 4, 0);
    test("", 1, 0, "abcde", 5, 0);
    test("", 1, 0, "abcdefghij", 0, 0);
    test("", 1, 0, "abcdefghij", 1, 0);
    test("", 1, 0, "abcdefghij", 5, 0);
    test("", 1, 0, "abcdefghij", 9, 0);
    test("", 1, 0, "abcdefghij", 10, 0);
    test("", 1, 0, "abcdefghijklmnopqrst", 0, 0);
    test("", 1, 0, "abcdefghijklmnopqrst", 1, 0);
    test("", 1, 0, "abcdefghijklmnopqrst", 10, 0);
    test("", 1, 0, "abcdefghijklmnopqrst", 19, 0);
    test("", 1, 0, "abcdefghijklmnopqrst", 20, 0);
    test("abcde", 0, 0, "", 0, 0);
    test("abcde", 0, 0, "abcde", 0, 0);
    test("abcde", 0, 0, "abcde", 1, -1);
    test("abcde", 0, 0, "abcde", 2, -2);
    test("abcde", 0, 0, "abcde", 4, -4);
    test("abcde", 0, 0, "abcde", 5, -5);
    test("abcde", 0, 0, "abcdefghij", 0, 0);
    test("abcde", 0, 0, "abcdefghij", 1, -1);
    test("abcde", 0, 0, "abcdefghij", 5, -5);
    test("abcde", 0, 0, "abcdefghij", 9, -9);
    test("abcde", 0, 0, "abcdefghij", 10, -10);
    test("abcde", 0, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcde", 0, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcde", 0, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcde", 0, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcde", 0, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcde", 0, 1, "", 0, 1);
    test("abcde", 0, 1, "abcde", 0, 1);
    test("abcde", 0, 1, "abcde", 1, 0);
    test("abcde", 0, 1, "abcde", 2, -1);
    test("abcde", 0, 1, "abcde", 4, -3);
    test("abcde", 0, 1, "abcde", 5, -4);
    test("abcde", 0, 1, "abcdefghij", 0, 1);
    test("abcde", 0, 1, "abcdefghij", 1, 0);
    test("abcde", 0, 1, "abcdefghij", 5, -4);
    test("abcde", 0, 1, "abcdefghij", 9, -8);
    test("abcde", 0, 1, "abcdefghij", 10, -9);
    test("abcde", 0, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcde", 0, 1, "abcdefghijklmnopqrst", 1, 0);
    test("abcde", 0, 1, "abcdefghijklmnopqrst", 10, -9);
    test("abcde", 0, 1, "abcdefghijklmnopqrst", 19, -18);
    test("abcde", 0, 1, "abcdefghijklmnopqrst", 20, -19);
    test("abcde", 0, 2, "", 0, 2);
    test("abcde", 0, 2, "abcde", 0, 2);
    test("abcde", 0, 2, "abcde", 1, 1);
    test("abcde", 0, 2, "abcde", 2, 0);
    test("abcde", 0, 2, "abcde", 4, -2);
    test("abcde", 0, 2, "abcde", 5, -3);
    test("abcde", 0, 2, "abcdefghij", 0, 2);
    test("abcde", 0, 2, "abcdefghij", 1, 1);
    test("abcde", 0, 2, "abcdefghij", 5, -3);
    test("abcde", 0, 2, "abcdefghij", 9, -7);
    test("abcde", 0, 2, "abcdefghij", 10, -8);
    test("abcde", 0, 2, "abcdefghijklmnopqrst", 0, 2);
    test("abcde", 0, 2, "abcdefghijklmnopqrst", 1, 1);
    test("abcde", 0, 2, "abcdefghijklmnopqrst", 10, -8);
    test("abcde", 0, 2, "abcdefghijklmnopqrst", 19, -17);
    test("abcde", 0, 2, "abcdefghijklmnopqrst", 20, -18);
    test("abcde", 0, 4, "", 0, 4);
    test("abcde", 0, 4, "abcde", 0, 4);
    test("abcde", 0, 4, "abcde", 1, 3);
    test("abcde", 0, 4, "abcde", 2, 2);
}


void test1()
{
    test("abcde", 0, 4, "abcde", 4, 0);
    test("abcde", 0, 4, "abcde", 5, -1);
    test("abcde", 0, 4, "abcdefghij", 0, 4);
    test("abcde", 0, 4, "abcdefghij", 1, 3);
    test("abcde", 0, 4, "abcdefghij", 5, -1);
    test("abcde", 0, 4, "abcdefghij", 9, -5);
    test("abcde", 0, 4, "abcdefghij", 10, -6);
    test("abcde", 0, 4, "abcdefghijklmnopqrst", 0, 4);
    test("abcde", 0, 4, "abcdefghijklmnopqrst", 1, 3);
    test("abcde", 0, 4, "abcdefghijklmnopqrst", 10, -6);
    test("abcde", 0, 4, "abcdefghijklmnopqrst", 19, -15);
    test("abcde", 0, 4, "abcdefghijklmnopqrst", 20, -16);
    test("abcde", 0, 5, "", 0, 5);
    test("abcde", 0, 5, "abcde", 0, 5);
    test("abcde", 0, 5, "abcde", 1, 4);
    test("abcde", 0, 5, "abcde", 2, 3);
    test("abcde", 0, 5, "abcde", 4, 1);
    test("abcde", 0, 5, "abcde", 5, 0);
    test("abcde", 0, 5, "abcdefghij", 0, 5);
    test("abcde", 0, 5, "abcdefghij", 1, 4);
    test("abcde", 0, 5, "abcdefghij", 5, 0);
    test("abcde", 0, 5, "abcdefghij", 9, -4);
    test("abcde", 0, 5, "abcdefghij", 10, -5);
    test("abcde", 0, 5, "abcdefghijklmnopqrst", 0, 5);
    test("abcde", 0, 5, "abcdefghijklmnopqrst", 1, 4);
    test("abcde", 0, 5, "abcdefghijklmnopqrst", 10, -5);
    test("abcde", 0, 5, "abcdefghijklmnopqrst", 19, -14);
    test("abcde", 0, 5, "abcdefghijklmnopqrst", 20, -15);
    test("abcde", 0, 6, "", 0, 5);
    test("abcde", 0, 6, "abcde", 0, 5);
    test("abcde", 0, 6, "abcde", 1, 4);
    test("abcde", 0, 6, "abcde", 2, 3);
    test("abcde", 0, 6, "abcde", 4, 1);
    test("abcde", 0, 6, "abcde", 5, 0);
    test("abcde", 0, 6, "abcdefghij", 0, 5);
    test("abcde", 0, 6, "abcdefghij", 1, 4);
    test("abcde", 0, 6, "abcdefghij", 5, 0);
    test("abcde", 0, 6, "abcdefghij", 9, -4);
    test("abcde", 0, 6, "abcdefghij", 10, -5);
    test("abcde", 0, 6, "abcdefghijklmnopqrst", 0, 5);
    test("abcde", 0, 6, "abcdefghijklmnopqrst", 1, 4);
    test("abcde", 0, 6, "abcdefghijklmnopqrst", 10, -5);
    test("abcde", 0, 6, "abcdefghijklmnopqrst", 19, -14);
    test("abcde", 0, 6, "abcdefghijklmnopqrst", 20, -15);
    test("abcde", 1, 0, "", 0, 0);
    test("abcde", 1, 0, "abcde", 0, 0);
    test("abcde", 1, 0, "abcde", 1, -1);
    test("abcde", 1, 0, "abcde", 2, -2);
    test("abcde", 1, 0, "abcde", 4, -4);
    test("abcde", 1, 0, "abcde", 5, -5);
    test("abcde", 1, 0, "abcdefghij", 0, 0);
    test("abcde", 1, 0, "abcdefghij", 1, -1);
    test("abcde", 1, 0, "abcdefghij", 5, -5);
    test("abcde", 1, 0, "abcdefghij", 9, -9);
    test("abcde", 1, 0, "abcdefghij", 10, -10);
    test("abcde", 1, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcde", 1, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcde", 1, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcde", 1, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcde", 1, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcde", 1, 1, "", 0, 1);
    test("abcde", 1, 1, "abcde", 0, 1);
    test("abcde", 1, 1, "abcde", 1, 1);
    test("abcde", 1, 1, "abcde", 2, 1);
    test("abcde", 1, 1, "abcde", 4, 1);
    test("abcde", 1, 1, "abcde", 5, 1);
    test("abcde", 1, 1, "abcdefghij", 0, 1);
    test("abcde", 1, 1, "abcdefghij", 1, 1);
    test("abcde", 1, 1, "abcdefghij", 5, 1);
    test("abcde", 1, 1, "abcdefghij", 9, 1);
    test("abcde", 1, 1, "abcdefghij", 10, 1);
    test("abcde", 1, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcde", 1, 1, "abcdefghijklmnopqrst", 1, 1);
    test("abcde", 1, 1, "abcdefghijklmnopqrst", 10, 1);
    test("abcde", 1, 1, "abcdefghijklmnopqrst", 19, 1);
    test("abcde", 1, 1, "abcdefghijklmnopqrst", 20, 1);
    test("abcde", 1, 2, "", 0, 2);
    test("abcde", 1, 2, "abcde", 0, 2);
    test("abcde", 1, 2, "abcde", 1, 1);
    test("abcde", 1, 2, "abcde", 2, 1);
    test("abcde", 1, 2, "abcde", 4, 1);
    test("abcde", 1, 2, "abcde", 5, 1);
    test("abcde", 1, 2, "abcdefghij", 0, 2);
    test("abcde", 1, 2, "abcdefghij", 1, 1);
    test("abcde", 1, 2, "abcdefghij", 5, 1);
    test("abcde", 1, 2, "abcdefghij", 9, 1);
    test("abcde", 1, 2, "abcdefghij", 10, 1);
    test("abcde", 1, 2, "abcdefghijklmnopqrst", 0, 2);
    test("abcde", 1, 2, "abcdefghijklmnopqrst", 1, 1);
    test("abcde", 1, 2, "abcdefghijklmnopqrst", 10, 1);
    test("abcde", 1, 2, "abcdefghijklmnopqrst", 19, 1);
    test("abcde", 1, 2, "abcdefghijklmnopqrst", 20, 1);
    test("abcde", 1, 3, "", 0, 3);
    test("abcde", 1, 3, "abcde", 0, 3);
    test("abcde", 1, 3, "abcde", 1, 1);
    test("abcde", 1, 3, "abcde", 2, 1);
    test("abcde", 1, 3, "abcde", 4, 1);
    test("abcde", 1, 3, "abcde", 5, 1);
    test("abcde", 1, 3, "abcdefghij", 0, 3);
    test("abcde", 1, 3, "abcdefghij", 1, 1);
}


void test2()
{
    test("abcde", 1, 3, "abcdefghij", 5, 1);
    test("abcde", 1, 3, "abcdefghij", 9, 1);
    test("abcde", 1, 3, "abcdefghij", 10, 1);
    test("abcde", 1, 3, "abcdefghijklmnopqrst", 0, 3);
    test("abcde", 1, 3, "abcdefghijklmnopqrst", 1, 1);
    test("abcde", 1, 3, "abcdefghijklmnopqrst", 10, 1);
    test("abcde", 1, 3, "abcdefghijklmnopqrst", 19, 1);
    test("abcde", 1, 3, "abcdefghijklmnopqrst", 20, 1);
    test("abcde", 1, 4, "", 0, 4);
    test("abcde", 1, 4, "abcde", 0, 4);
    test("abcde", 1, 4, "abcde", 1, 1);
    test("abcde", 1, 4, "abcde", 2, 1);
    test("abcde", 1, 4, "abcde", 4, 1);
    test("abcde", 1, 4, "abcde", 5, 1);
    test("abcde", 1, 4, "abcdefghij", 0, 4);
    test("abcde", 1, 4, "abcdefghij", 1, 1);
    test("abcde", 1, 4, "abcdefghij", 5, 1);
    test("abcde", 1, 4, "abcdefghij", 9, 1);
    test("abcde", 1, 4, "abcdefghij", 10, 1);
    test("abcde", 1, 4, "abcdefghijklmnopqrst", 0, 4);
    test("abcde", 1, 4, "abcdefghijklmnopqrst", 1, 1);
    test("abcde", 1, 4, "abcdefghijklmnopqrst", 10, 1);
    test("abcde", 1, 4, "abcdefghijklmnopqrst", 19, 1);
    test("abcde", 1, 4, "abcdefghijklmnopqrst", 20, 1);
    test("abcde", 1, 5, "", 0, 4);
    test("abcde", 1, 5, "abcde", 0, 4);
    test("abcde", 1, 5, "abcde", 1, 1);
    test("abcde", 1, 5, "abcde", 2, 1);
    test("abcde", 1, 5, "abcde", 4, 1);
    test("abcde", 1, 5, "abcde", 5, 1);
    test("abcde", 1, 5, "abcdefghij", 0, 4);
    test("abcde", 1, 5, "abcdefghij", 1, 1);
    test("abcde", 1, 5, "abcdefghij", 5, 1);
    test("abcde", 1, 5, "abcdefghij", 9, 1);
    test("abcde", 1, 5, "abcdefghij", 10, 1);
    test("abcde", 1, 5, "abcdefghijklmnopqrst", 0, 4);
    test("abcde", 1, 5, "abcdefghijklmnopqrst", 1, 1);
    test("abcde", 1, 5, "abcdefghijklmnopqrst", 10, 1);
    test("abcde", 1, 5, "abcdefghijklmnopqrst", 19, 1);
    test("abcde", 1, 5, "abcdefghijklmnopqrst", 20, 1);
    test("abcde", 2, 0, "", 0, 0);
    test("abcde", 2, 0, "abcde", 0, 0);
    test("abcde", 2, 0, "abcde", 1, -1);
    test("abcde", 2, 0, "abcde", 2, -2);
    test("abcde", 2, 0, "abcde", 4, -4);
    test("abcde", 2, 0, "abcde", 5, -5);
    test("abcde", 2, 0, "abcdefghij", 0, 0);
    test("abcde", 2, 0, "abcdefghij", 1, -1);
    test("abcde", 2, 0, "abcdefghij", 5, -5);
    test("abcde", 2, 0, "abcdefghij", 9, -9);
    test("abcde", 2, 0, "abcdefghij", 10, -10);
    test("abcde", 2, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcde", 2, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcde", 2, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcde", 2, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcde", 2, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcde", 2, 1, "", 0, 1);
    test("abcde", 2, 1, "abcde", 0, 1);
    test("abcde", 2, 1, "abcde", 1, 2);
    test("abcde", 2, 1, "abcde", 2, 2);
    test("abcde", 2, 1, "abcde", 4, 2);
    test("abcde", 2, 1, "abcde", 5, 2);
    test("abcde", 2, 1, "abcdefghij", 0, 1);
    test("abcde", 2, 1, "abcdefghij", 1, 2);
    test("abcde", 2, 1, "abcdefghij", 5, 2);
    test("abcde", 2, 1, "abcdefghij", 9, 2);
    test("abcde", 2, 1, "abcdefghij", 10, 2);
    test("abcde", 2, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcde", 2, 1, "abcdefghijklmnopqrst", 1, 2);
    test("abcde", 2, 1, "abcdefghijklmnopqrst", 10, 2);
    test("abcde", 2, 1, "abcdefghijklmnopqrst", 19, 2);
    test("abcde", 2, 1, "abcdefghijklmnopqrst", 20, 2);
    test("abcde", 2, 2, "", 0, 2);
    test("abcde", 2, 2, "abcde", 0, 2);
    test("abcde", 2, 2, "abcde", 1, 2);
    test("abcde", 2, 2, "abcde", 2, 2);
    test("abcde", 2, 2, "abcde", 4, 2);
    test("abcde", 2, 2, "abcde", 5, 2);
    test("abcde", 2, 2, "abcdefghij", 0, 2);
    test("abcde", 2, 2, "abcdefghij", 1, 2);
    test("abcde", 2, 2, "abcdefghij", 5, 2);
    test("abcde", 2, 2, "abcdefghij", 9, 2);
    test("abcde", 2, 2, "abcdefghij", 10, 2);
    test("abcde", 2, 2, "abcdefghijklmnopqrst", 0, 2);
    test("abcde", 2, 2, "abcdefghijklmnopqrst", 1, 2);
    test("abcde", 2, 2, "abcdefghijklmnopqrst", 10, 2);
    test("abcde", 2, 2, "abcdefghijklmnopqrst", 19, 2);
    test("abcde", 2, 2, "abcdefghijklmnopqrst", 20, 2);
    test("abcde", 2, 3, "", 0, 3);
    test("abcde", 2, 3, "abcde", 0, 3);
    test("abcde", 2, 3, "abcde", 1, 2);
    test("abcde", 2, 3, "abcde", 2, 2);
    test("abcde", 2, 3, "abcde", 4, 2);
    test("abcde", 2, 3, "abcde", 5, 2);
    test("abcde", 2, 3, "abcdefghij", 0, 3);
    test("abcde", 2, 3, "abcdefghij", 1, 2);
    test("abcde", 2, 3, "abcdefghij", 5, 2);
    test("abcde", 2, 3, "abcdefghij", 9, 2);
    test("abcde", 2, 3, "abcdefghij", 10, 2);
    test("abcde", 2, 3, "abcdefghijklmnopqrst", 0, 3);
}


void test3()
{
    test("abcde", 2, 3, "abcdefghijklmnopqrst", 1, 2);
    test("abcde", 2, 3, "abcdefghijklmnopqrst", 10, 2);
    test("abcde", 2, 3, "abcdefghijklmnopqrst", 19, 2);
    test("abcde", 2, 3, "abcdefghijklmnopqrst", 20, 2);
    test("abcde", 2, 4, "", 0, 3);
    test("abcde", 2, 4, "abcde", 0, 3);
    test("abcde", 2, 4, "abcde", 1, 2);
    test("abcde", 2, 4, "abcde", 2, 2);
    test("abcde", 2, 4, "abcde", 4, 2);
    test("abcde", 2, 4, "abcde", 5, 2);
    test("abcde", 2, 4, "abcdefghij", 0, 3);
    test("abcde", 2, 4, "abcdefghij", 1, 2);
    test("abcde", 2, 4, "abcdefghij", 5, 2);
    test("abcde", 2, 4, "abcdefghij", 9, 2);
    test("abcde", 2, 4, "abcdefghij", 10, 2);
    test("abcde", 2, 4, "abcdefghijklmnopqrst", 0, 3);
    test("abcde", 2, 4, "abcdefghijklmnopqrst", 1, 2);
    test("abcde", 2, 4, "abcdefghijklmnopqrst", 10, 2);
    test("abcde", 2, 4, "abcdefghijklmnopqrst", 19, 2);
    test("abcde", 2, 4, "abcdefghijklmnopqrst", 20, 2);
    test("abcde", 4, 0, "", 0, 0);
    test("abcde", 4, 0, "abcde", 0, 0);
    test("abcde", 4, 0, "abcde", 1, -1);
    test("abcde", 4, 0, "abcde", 2, -2);
    test("abcde", 4, 0, "abcde", 4, -4);
    test("abcde", 4, 0, "abcde", 5, -5);
    test("abcde", 4, 0, "abcdefghij", 0, 0);
    test("abcde", 4, 0, "abcdefghij", 1, -1);
    test("abcde", 4, 0, "abcdefghij", 5, -5);
    test("abcde", 4, 0, "abcdefghij", 9, -9);
    test("abcde", 4, 0, "abcdefghij", 10, -10);
    test("abcde", 4, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcde", 4, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcde", 4, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcde", 4, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcde", 4, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcde", 4, 1, "", 0, 1);
    test("abcde", 4, 1, "abcde", 0, 1);
    test("abcde", 4, 1, "abcde", 1, 4);
    test("abcde", 4, 1, "abcde", 2, 4);
    test("abcde", 4, 1, "abcde", 4, 4);
    test("abcde", 4, 1, "abcde", 5, 4);
    test("abcde", 4, 1, "abcdefghij", 0, 1);
    test("abcde", 4, 1, "abcdefghij", 1, 4);
    test("abcde", 4, 1, "abcdefghij", 5, 4);
    test("abcde", 4, 1, "abcdefghij", 9, 4);
    test("abcde", 4, 1, "abcdefghij", 10, 4);
    test("abcde", 4, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcde", 4, 1, "abcdefghijklmnopqrst", 1, 4);
    test("abcde", 4, 1, "abcdefghijklmnopqrst", 10, 4);
    test("abcde", 4, 1, "abcdefghijklmnopqrst", 19, 4);
    test("abcde", 4, 1, "abcdefghijklmnopqrst", 20, 4);
    test("abcde", 4, 2, "", 0, 1);
    test("abcde", 4, 2, "abcde", 0, 1);
    test("abcde", 4, 2, "abcde", 1, 4);
    test("abcde", 4, 2, "abcde", 2, 4);
    test("abcde", 4, 2, "abcde", 4, 4);
    test("abcde", 4, 2, "abcde", 5, 4);
    test("abcde", 4, 2, "abcdefghij", 0, 1);
    test("abcde", 4, 2, "abcdefghij", 1, 4);
    test("abcde", 4, 2, "abcdefghij", 5, 4);
    test("abcde", 4, 2, "abcdefghij", 9, 4);
    test("abcde", 4, 2, "abcdefghij", 10, 4);
    test("abcde", 4, 2, "abcdefghijklmnopqrst", 0, 1);
    test("abcde", 4, 2, "abcdefghijklmnopqrst", 1, 4);
    test("abcde", 4, 2, "abcdefghijklmnopqrst", 10, 4);
    test("abcde", 4, 2, "abcdefghijklmnopqrst", 19, 4);
    test("abcde", 4, 2, "abcdefghijklmnopqrst", 20, 4);
    test("abcde", 5, 0, "", 0, 0);
    test("abcde", 5, 0, "abcde", 0, 0);
    test("abcde", 5, 0, "abcde", 1, -1);
    test("abcde", 5, 0, "abcde", 2, -2);
    test("abcde", 5, 0, "abcde", 4, -4);
    test("abcde", 5, 0, "abcde", 5, -5);
    test("abcde", 5, 0, "abcdefghij", 0, 0);
    test("abcde", 5, 0, "abcdefghij", 1, -1);
    test("abcde", 5, 0, "abcdefghij", 5, -5);
    test("abcde", 5, 0, "abcdefghij", 9, -9);
    test("abcde", 5, 0, "abcdefghij", 10, -10);
    test("abcde", 5, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcde", 5, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcde", 5, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcde", 5, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcde", 5, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcde", 5, 1, "", 0, 0);
    test("abcde", 5, 1, "abcde", 0, 0);
    test("abcde", 5, 1, "abcde", 1, -1);
    test("abcde", 5, 1, "abcde", 2, -2);
    test("abcde", 5, 1, "abcde", 4, -4);
    test("abcde", 5, 1, "abcde", 5, -5);
    test("abcde", 5, 1, "abcdefghij", 0, 0);
    test("abcde", 5, 1, "abcdefghij", 1, -1);
    test("abcde", 5, 1, "abcdefghij", 5, -5);
    test("abcde", 5, 1, "abcdefghij", 9, -9);
    test("abcde", 5, 1, "abcdefghij", 10, -10);
    test("abcde", 5, 1, "abcdefghijklmnopqrst", 0, 0);
    test("abcde", 5, 1, "abcdefghijklmnopqrst", 1, -1);
    test("abcde", 5, 1, "abcdefghijklmnopqrst", 10, -10);
    test("abcde", 5, 1, "abcdefghijklmnopqrst", 19, -19);
    test("abcde", 5, 1, "abcdefghijklmnopqrst", 20, -20);
}


void test4()
{
    test("abcde", 6, 0, "", 0, 0);
    test("abcde", 6, 0, "abcde", 0, 0);
    test("abcde", 6, 0, "abcde", 1, 0);
    test("abcde", 6, 0, "abcde", 2, 0);
    test("abcde", 6, 0, "abcde", 4, 0);
    test("abcde", 6, 0, "abcde", 5, 0);
    test("abcde", 6, 0, "abcdefghij", 0, 0);
    test("abcde", 6, 0, "abcdefghij", 1, 0);
    test("abcde", 6, 0, "abcdefghij", 5, 0);
    test("abcde", 6, 0, "abcdefghij", 9, 0);
    test("abcde", 6, 0, "abcdefghij", 10, 0);
    test("abcde", 6, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcde", 6, 0, "abcdefghijklmnopqrst", 1, 0);
    test("abcde", 6, 0, "abcdefghijklmnopqrst", 10, 0);
    test("abcde", 6, 0, "abcdefghijklmnopqrst", 19, 0);
    test("abcde", 6, 0, "abcdefghijklmnopqrst", 20, 0);
    test("abcdefghij", 0, 0, "", 0, 0);
    test("abcdefghij", 0, 0, "abcde", 0, 0);
    test("abcdefghij", 0, 0, "abcde", 1, -1);
    test("abcdefghij", 0, 0, "abcde", 2, -2);
    test("abcdefghij", 0, 0, "abcde", 4, -4);
    test("abcdefghij", 0, 0, "abcde", 5, -5);
    test("abcdefghij", 0, 0, "abcdefghij", 0, 0);
    test("abcdefghij", 0, 0, "abcdefghij", 1, -1);
    test("abcdefghij", 0, 0, "abcdefghij", 5, -5);
    test("abcdefghij", 0, 0, "abcdefghij", 9, -9);
    test("abcdefghij", 0, 0, "abcdefghij", 10, -10);
    test("abcdefghij", 0, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghij", 0, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghij", 0, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghij", 0, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghij", 0, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghij", 0, 1, "", 0, 1);
    test("abcdefghij", 0, 1, "abcde", 0, 1);
    test("abcdefghij", 0, 1, "abcde", 1, 0);
    test("abcdefghij", 0, 1, "abcde", 2, -1);
    test("abcdefghij", 0, 1, "abcde", 4, -3);
    test("abcdefghij", 0, 1, "abcde", 5, -4);
    test("abcdefghij", 0, 1, "abcdefghij", 0, 1);
    test("abcdefghij", 0, 1, "abcdefghij", 1, 0);
    test("abcdefghij", 0, 1, "abcdefghij", 5, -4);
    test("abcdefghij", 0, 1, "abcdefghij", 9, -8);
    test("abcdefghij", 0, 1, "abcdefghij", 10, -9);
    test("abcdefghij", 0, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcdefghij", 0, 1, "abcdefghijklmnopqrst", 1, 0);
    test("abcdefghij", 0, 1, "abcdefghijklmnopqrst", 10, -9);
    test("abcdefghij", 0, 1, "abcdefghijklmnopqrst", 19, -18);
    test("abcdefghij", 0, 1, "abcdefghijklmnopqrst", 20, -19);
    test("abcdefghij", 0, 5, "", 0, 5);
    test("abcdefghij", 0, 5, "abcde", 0, 5);
    test("abcdefghij", 0, 5, "abcde", 1, 4);
    test("abcdefghij", 0, 5, "abcde", 2, 3);
    test("abcdefghij", 0, 5, "abcde", 4, 1);
    test("abcdefghij", 0, 5, "abcde", 5, 0);
    test("abcdefghij", 0, 5, "abcdefghij", 0, 5);
    test("abcdefghij", 0, 5, "abcdefghij", 1, 4);
    test("abcdefghij", 0, 5, "abcdefghij", 5, 0);
    test("abcdefghij", 0, 5, "abcdefghij", 9, -4);
    test("abcdefghij", 0, 5, "abcdefghij", 10, -5);
    test("abcdefghij", 0, 5, "abcdefghijklmnopqrst", 0, 5);
    test("abcdefghij", 0, 5, "abcdefghijklmnopqrst", 1, 4);
    test("abcdefghij", 0, 5, "abcdefghijklmnopqrst", 10, -5);
    test("abcdefghij", 0, 5, "abcdefghijklmnopqrst", 19, -14);
    test("abcdefghij", 0, 5, "abcdefghijklmnopqrst", 20, -15);
    test("abcdefghij", 0, 9, "", 0, 9);
    test("abcdefghij", 0, 9, "abcde", 0, 9);
    test("abcdefghij", 0, 9, "abcde", 1, 8);
    test("abcdefghij", 0, 9, "abcde", 2, 7);
    test("abcdefghij", 0, 9, "abcde", 4, 5);
    test("abcdefghij", 0, 9, "abcde", 5, 4);
    test("abcdefghij", 0, 9, "abcdefghij", 0, 9);
    test("abcdefghij", 0, 9, "abcdefghij", 1, 8);
    test("abcdefghij", 0, 9, "abcdefghij", 5, 4);
    test("abcdefghij", 0, 9, "abcdefghij", 9, 0);
    test("abcdefghij", 0, 9, "abcdefghij", 10, -1);
    test("abcdefghij", 0, 9, "abcdefghijklmnopqrst", 0, 9);
    test("abcdefghij", 0, 9, "abcdefghijklmnopqrst", 1, 8);
    test("abcdefghij", 0, 9, "abcdefghijklmnopqrst", 10, -1);
    test("abcdefghij", 0, 9, "abcdefghijklmnopqrst", 19, -10);
    test("abcdefghij", 0, 9, "abcdefghijklmnopqrst", 20, -11);
    test("abcdefghij", 0, 10, "", 0, 10);
    test("abcdefghij", 0, 10, "abcde", 0, 10);
    test("abcdefghij", 0, 10, "abcde", 1, 9);
    test("abcdefghij", 0, 10, "abcde", 2, 8);
    test("abcdefghij", 0, 10, "abcde", 4, 6);
    test("abcdefghij", 0, 10, "abcde", 5, 5);
    test("abcdefghij", 0, 10, "abcdefghij", 0, 10);
    test("abcdefghij", 0, 10, "abcdefghij", 1, 9);
    test("abcdefghij", 0, 10, "abcdefghij", 5, 5);
    test("abcdefghij", 0, 10, "abcdefghij", 9, 1);
    test("abcdefghij", 0, 10, "abcdefghij", 10, 0);
    test("abcdefghij", 0, 10, "abcdefghijklmnopqrst", 0, 10);
    test("abcdefghij", 0, 10, "abcdefghijklmnopqrst", 1, 9);
    test("abcdefghij", 0, 10, "abcdefghijklmnopqrst", 10, 0);
    test("abcdefghij", 0, 10, "abcdefghijklmnopqrst", 19, -9);
    test("abcdefghij", 0, 10, "abcdefghijklmnopqrst", 20, -10);
    test("abcdefghij", 0, 11, "", 0, 10);
    test("abcdefghij", 0, 11, "abcde", 0, 10);
    test("abcdefghij", 0, 11, "abcde", 1, 9);
    test("abcdefghij", 0, 11, "abcde", 2, 8);
}


void test5()
{
    test("abcdefghij", 0, 11, "abcde", 4, 6);
    test("abcdefghij", 0, 11, "abcde", 5, 5);
    test("abcdefghij", 0, 11, "abcdefghij", 0, 10);
    test("abcdefghij", 0, 11, "abcdefghij", 1, 9);
    test("abcdefghij", 0, 11, "abcdefghij", 5, 5);
    test("abcdefghij", 0, 11, "abcdefghij", 9, 1);
    test("abcdefghij", 0, 11, "abcdefghij", 10, 0);
    test("abcdefghij", 0, 11, "abcdefghijklmnopqrst", 0, 10);
    test("abcdefghij", 0, 11, "abcdefghijklmnopqrst", 1, 9);
    test("abcdefghij", 0, 11, "abcdefghijklmnopqrst", 10, 0);
    test("abcdefghij", 0, 11, "abcdefghijklmnopqrst", 19, -9);
    test("abcdefghij", 0, 11, "abcdefghijklmnopqrst", 20, -10);
    test("abcdefghij", 1, 0, "", 0, 0);
    test("abcdefghij", 1, 0, "abcde", 0, 0);
    test("abcdefghij", 1, 0, "abcde", 1, -1);
    test("abcdefghij", 1, 0, "abcde", 2, -2);
    test("abcdefghij", 1, 0, "abcde", 4, -4);
    test("abcdefghij", 1, 0, "abcde", 5, -5);
    test("abcdefghij", 1, 0, "abcdefghij", 0, 0);
    test("abcdefghij", 1, 0, "abcdefghij", 1, -1);
    test("abcdefghij", 1, 0, "abcdefghij", 5, -5);
    test("abcdefghij", 1, 0, "abcdefghij", 9, -9);
    test("abcdefghij", 1, 0, "abcdefghij", 10, -10);
    test("abcdefghij", 1, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghij", 1, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghij", 1, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghij", 1, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghij", 1, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghij", 1, 1, "", 0, 1);
    test("abcdefghij", 1, 1, "abcde", 0, 1);
    test("abcdefghij", 1, 1, "abcde", 1, 1);
    test("abcdefghij", 1, 1, "abcde", 2, 1);
    test("abcdefghij", 1, 1, "abcde", 4, 1);
    test("abcdefghij", 1, 1, "abcde", 5, 1);
    test("abcdefghij", 1, 1, "abcdefghij", 0, 1);
    test("abcdefghij", 1, 1, "abcdefghij", 1, 1);
    test("abcdefghij", 1, 1, "abcdefghij", 5, 1);
    test("abcdefghij", 1, 1, "abcdefghij", 9, 1);
    test("abcdefghij", 1, 1, "abcdefghij", 10, 1);
    test("abcdefghij", 1, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcdefghij", 1, 1, "abcdefghijklmnopqrst", 1, 1);
    test("abcdefghij", 1, 1, "abcdefghijklmnopqrst", 10, 1);
    test("abcdefghij", 1, 1, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghij", 1, 1, "abcdefghijklmnopqrst", 20, 1);
    test("abcdefghij", 1, 4, "", 0, 4);
    test("abcdefghij", 1, 4, "abcde", 0, 4);
    test("abcdefghij", 1, 4, "abcde", 1, 1);
    test("abcdefghij", 1, 4, "abcde", 2, 1);
    test("abcdefghij", 1, 4, "abcde", 4, 1);
    test("abcdefghij", 1, 4, "abcde", 5, 1);
    test("abcdefghij", 1, 4, "abcdefghij", 0, 4);
    test("abcdefghij", 1, 4, "abcdefghij", 1, 1);
    test("abcdefghij", 1, 4, "abcdefghij", 5, 1);
    test("abcdefghij", 1, 4, "abcdefghij", 9, 1);
    test("abcdefghij", 1, 4, "abcdefghij", 10, 1);
    test("abcdefghij", 1, 4, "abcdefghijklmnopqrst", 0, 4);
    test("abcdefghij", 1, 4, "abcdefghijklmnopqrst", 1, 1);
    test("abcdefghij", 1, 4, "abcdefghijklmnopqrst", 10, 1);
    test("abcdefghij", 1, 4, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghij", 1, 4, "abcdefghijklmnopqrst", 20, 1);
    test("abcdefghij", 1, 8, "", 0, 8);
    test("abcdefghij", 1, 8, "abcde", 0, 8);
    test("abcdefghij", 1, 8, "abcde", 1, 1);
    test("abcdefghij", 1, 8, "abcde", 2, 1);
    test("abcdefghij", 1, 8, "abcde", 4, 1);
    test("abcdefghij", 1, 8, "abcde", 5, 1);
    test("abcdefghij", 1, 8, "abcdefghij", 0, 8);
    test("abcdefghij", 1, 8, "abcdefghij", 1, 1);
    test("abcdefghij", 1, 8, "abcdefghij", 5, 1);
    test("abcdefghij", 1, 8, "abcdefghij", 9, 1);
    test("abcdefghij", 1, 8, "abcdefghij", 10, 1);
    test("abcdefghij", 1, 8, "abcdefghijklmnopqrst", 0, 8);
    test("abcdefghij", 1, 8, "abcdefghijklmnopqrst", 1, 1);
    test("abcdefghij", 1, 8, "abcdefghijklmnopqrst", 10, 1);
    test("abcdefghij", 1, 8, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghij", 1, 8, "abcdefghijklmnopqrst", 20, 1);
    test("abcdefghij", 1, 9, "", 0, 9);
    test("abcdefghij", 1, 9, "abcde", 0, 9);
    test("abcdefghij", 1, 9, "abcde", 1, 1);
    test("abcdefghij", 1, 9, "abcde", 2, 1);
    test("abcdefghij", 1, 9, "abcde", 4, 1);
    test("abcdefghij", 1, 9, "abcde", 5, 1);
    test("abcdefghij", 1, 9, "abcdefghij", 0, 9);
    test("abcdefghij", 1, 9, "abcdefghij", 1, 1);
    test("abcdefghij", 1, 9, "abcdefghij", 5, 1);
    test("abcdefghij", 1, 9, "abcdefghij", 9, 1);
    test("abcdefghij", 1, 9, "abcdefghij", 10, 1);
    test("abcdefghij", 1, 9, "abcdefghijklmnopqrst", 0, 9);
    test("abcdefghij", 1, 9, "abcdefghijklmnopqrst", 1, 1);
    test("abcdefghij", 1, 9, "abcdefghijklmnopqrst", 10, 1);
    test("abcdefghij", 1, 9, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghij", 1, 9, "abcdefghijklmnopqrst", 20, 1);
    test("abcdefghij", 1, 10, "", 0, 9);
    test("abcdefghij", 1, 10, "abcde", 0, 9);
    test("abcdefghij", 1, 10, "abcde", 1, 1);
    test("abcdefghij", 1, 10, "abcde", 2, 1);
    test("abcdefghij", 1, 10, "abcde", 4, 1);
    test("abcdefghij", 1, 10, "abcde", 5, 1);
    test("abcdefghij", 1, 10, "abcdefghij", 0, 9);
    test("abcdefghij", 1, 10, "abcdefghij", 1, 1);
}


void test6()
{
    test("abcdefghij", 1, 10, "abcdefghij", 5, 1);
    test("abcdefghij", 1, 10, "abcdefghij", 9, 1);
    test("abcdefghij", 1, 10, "abcdefghij", 10, 1);
    test("abcdefghij", 1, 10, "abcdefghijklmnopqrst", 0, 9);
    test("abcdefghij", 1, 10, "abcdefghijklmnopqrst", 1, 1);
    test("abcdefghij", 1, 10, "abcdefghijklmnopqrst", 10, 1);
    test("abcdefghij", 1, 10, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghij", 1, 10, "abcdefghijklmnopqrst", 20, 1);
    test("abcdefghij", 5, 0, "", 0, 0);
    test("abcdefghij", 5, 0, "abcde", 0, 0);
    test("abcdefghij", 5, 0, "abcde", 1, -1);
    test("abcdefghij", 5, 0, "abcde", 2, -2);
    test("abcdefghij", 5, 0, "abcde", 4, -4);
    test("abcdefghij", 5, 0, "abcde", 5, -5);
    test("abcdefghij", 5, 0, "abcdefghij", 0, 0);
    test("abcdefghij", 5, 0, "abcdefghij", 1, -1);
    test("abcdefghij", 5, 0, "abcdefghij", 5, -5);
    test("abcdefghij", 5, 0, "abcdefghij", 9, -9);
    test("abcdefghij", 5, 0, "abcdefghij", 10, -10);
    test("abcdefghij", 5, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghij", 5, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghij", 5, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghij", 5, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghij", 5, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghij", 5, 1, "", 0, 1);
    test("abcdefghij", 5, 1, "abcde", 0, 1);
    test("abcdefghij", 5, 1, "abcde", 1, 5);
    test("abcdefghij", 5, 1, "abcde", 2, 5);
    test("abcdefghij", 5, 1, "abcde", 4, 5);
    test("abcdefghij", 5, 1, "abcde", 5, 5);
    test("abcdefghij", 5, 1, "abcdefghij", 0, 1);
    test("abcdefghij", 5, 1, "abcdefghij", 1, 5);
    test("abcdefghij", 5, 1, "abcdefghij", 5, 5);
    test("abcdefghij", 5, 1, "abcdefghij", 9, 5);
    test("abcdefghij", 5, 1, "abcdefghij", 10, 5);
    test("abcdefghij", 5, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcdefghij", 5, 1, "abcdefghijklmnopqrst", 1, 5);
    test("abcdefghij", 5, 1, "abcdefghijklmnopqrst", 10, 5);
    test("abcdefghij", 5, 1, "abcdefghijklmnopqrst", 19, 5);
    test("abcdefghij", 5, 1, "abcdefghijklmnopqrst", 20, 5);
    test("abcdefghij", 5, 2, "", 0, 2);
    test("abcdefghij", 5, 2, "abcde", 0, 2);
    test("abcdefghij", 5, 2, "abcde", 1, 5);
    test("abcdefghij", 5, 2, "abcde", 2, 5);
    test("abcdefghij", 5, 2, "abcde", 4, 5);
    test("abcdefghij", 5, 2, "abcde", 5, 5);
    test("abcdefghij", 5, 2, "abcdefghij", 0, 2);
    test("abcdefghij", 5, 2, "abcdefghij", 1, 5);
    test("abcdefghij", 5, 2, "abcdefghij", 5, 5);
    test("abcdefghij", 5, 2, "abcdefghij", 9, 5);
    test("abcdefghij", 5, 2, "abcdefghij", 10, 5);
    test("abcdefghij", 5, 2, "abcdefghijklmnopqrst", 0, 2);
    test("abcdefghij", 5, 2, "abcdefghijklmnopqrst", 1, 5);
    test("abcdefghij", 5, 2, "abcdefghijklmnopqrst", 10, 5);
    test("abcdefghij", 5, 2, "abcdefghijklmnopqrst", 19, 5);
    test("abcdefghij", 5, 2, "abcdefghijklmnopqrst", 20, 5);
    test("abcdefghij", 5, 4, "", 0, 4);
    test("abcdefghij", 5, 4, "abcde", 0, 4);
    test("abcdefghij", 5, 4, "abcde", 1, 5);
    test("abcdefghij", 5, 4, "abcde", 2, 5);
    test("abcdefghij", 5, 4, "abcde", 4, 5);
    test("abcdefghij", 5, 4, "abcde", 5, 5);
    test("abcdefghij", 5, 4, "abcdefghij", 0, 4);
    test("abcdefghij", 5, 4, "abcdefghij", 1, 5);
    test("abcdefghij", 5, 4, "abcdefghij", 5, 5);
    test("abcdefghij", 5, 4, "abcdefghij", 9, 5);
    test("abcdefghij", 5, 4, "abcdefghij", 10, 5);
    test("abcdefghij", 5, 4, "abcdefghijklmnopqrst", 0, 4);
    test("abcdefghij", 5, 4, "abcdefghijklmnopqrst", 1, 5);
    test("abcdefghij", 5, 4, "abcdefghijklmnopqrst", 10, 5);
    test("abcdefghij", 5, 4, "abcdefghijklmnopqrst", 19, 5);
    test("abcdefghij", 5, 4, "abcdefghijklmnopqrst", 20, 5);
    test("abcdefghij", 5, 5, "", 0, 5);
    test("abcdefghij", 5, 5, "abcde", 0, 5);
    test("abcdefghij", 5, 5, "abcde", 1, 5);
    test("abcdefghij", 5, 5, "abcde", 2, 5);
    test("abcdefghij", 5, 5, "abcde", 4, 5);
    test("abcdefghij", 5, 5, "abcde", 5, 5);
    test("abcdefghij", 5, 5, "abcdefghij", 0, 5);
    test("abcdefghij", 5, 5, "abcdefghij", 1, 5);
    test("abcdefghij", 5, 5, "abcdefghij", 5, 5);
    test("abcdefghij", 5, 5, "abcdefghij", 9, 5);
    test("abcdefghij", 5, 5, "abcdefghij", 10, 5);
    test("abcdefghij", 5, 5, "abcdefghijklmnopqrst", 0, 5);
    test("abcdefghij", 5, 5, "abcdefghijklmnopqrst", 1, 5);
    test("abcdefghij", 5, 5, "abcdefghijklmnopqrst", 10, 5);
    test("abcdefghij", 5, 5, "abcdefghijklmnopqrst", 19, 5);
    test("abcdefghij", 5, 5, "abcdefghijklmnopqrst", 20, 5);
    test("abcdefghij", 5, 6, "", 0, 5);
    test("abcdefghij", 5, 6, "abcde", 0, 5);
    test("abcdefghij", 5, 6, "abcde", 1, 5);
    test("abcdefghij", 5, 6, "abcde", 2, 5);
    test("abcdefghij", 5, 6, "abcde", 4, 5);
    test("abcdefghij", 5, 6, "abcde", 5, 5);
    test("abcdefghij", 5, 6, "abcdefghij", 0, 5);
    test("abcdefghij", 5, 6, "abcdefghij", 1, 5);
    test("abcdefghij", 5, 6, "abcdefghij", 5, 5);
    test("abcdefghij", 5, 6, "abcdefghij", 9, 5);
    test("abcdefghij", 5, 6, "abcdefghij", 10, 5);
    test("abcdefghij", 5, 6, "abcdefghijklmnopqrst", 0, 5);
}


void test7()
{
    test("abcdefghij", 5, 6, "abcdefghijklmnopqrst", 1, 5);
    test("abcdefghij", 5, 6, "abcdefghijklmnopqrst", 10, 5);
    test("abcdefghij", 5, 6, "abcdefghijklmnopqrst", 19, 5);
    test("abcdefghij", 5, 6, "abcdefghijklmnopqrst", 20, 5);
    test("abcdefghij", 9, 0, "", 0, 0);
    test("abcdefghij", 9, 0, "abcde", 0, 0);
    test("abcdefghij", 9, 0, "abcde", 1, -1);
    test("abcdefghij", 9, 0, "abcde", 2, -2);
    test("abcdefghij", 9, 0, "abcde", 4, -4);
    test("abcdefghij", 9, 0, "abcde", 5, -5);
    test("abcdefghij", 9, 0, "abcdefghij", 0, 0);
    test("abcdefghij", 9, 0, "abcdefghij", 1, -1);
    test("abcdefghij", 9, 0, "abcdefghij", 5, -5);
    test("abcdefghij", 9, 0, "abcdefghij", 9, -9);
    test("abcdefghij", 9, 0, "abcdefghij", 10, -10);
    test("abcdefghij", 9, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghij", 9, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghij", 9, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghij", 9, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghij", 9, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghij", 9, 1, "", 0, 1);
    test("abcdefghij", 9, 1, "abcde", 0, 1);
    test("abcdefghij", 9, 1, "abcde", 1, 9);
    test("abcdefghij", 9, 1, "abcde", 2, 9);
    test("abcdefghij", 9, 1, "abcde", 4, 9);
    test("abcdefghij", 9, 1, "abcde", 5, 9);
    test("abcdefghij", 9, 1, "abcdefghij", 0, 1);
    test("abcdefghij", 9, 1, "abcdefghij", 1, 9);
    test("abcdefghij", 9, 1, "abcdefghij", 5, 9);
    test("abcdefghij", 9, 1, "abcdefghij", 9, 9);
    test("abcdefghij", 9, 1, "abcdefghij", 10, 9);
    test("abcdefghij", 9, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcdefghij", 9, 1, "abcdefghijklmnopqrst", 1, 9);
    test("abcdefghij", 9, 1, "abcdefghijklmnopqrst", 10, 9);
    test("abcdefghij", 9, 1, "abcdefghijklmnopqrst", 19, 9);
    test("abcdefghij", 9, 1, "abcdefghijklmnopqrst", 20, 9);
    test("abcdefghij", 9, 2, "", 0, 1);
    test("abcdefghij", 9, 2, "abcde", 0, 1);
    test("abcdefghij", 9, 2, "abcde", 1, 9);
    test("abcdefghij", 9, 2, "abcde", 2, 9);
    test("abcdefghij", 9, 2, "abcde", 4, 9);
    test("abcdefghij", 9, 2, "abcde", 5, 9);
    test("abcdefghij", 9, 2, "abcdefghij", 0, 1);
    test("abcdefghij", 9, 2, "abcdefghij", 1, 9);
    test("abcdefghij", 9, 2, "abcdefghij", 5, 9);
    test("abcdefghij", 9, 2, "abcdefghij", 9, 9);
    test("abcdefghij", 9, 2, "abcdefghij", 10, 9);
    test("abcdefghij", 9, 2, "abcdefghijklmnopqrst", 0, 1);
    test("abcdefghij", 9, 2, "abcdefghijklmnopqrst", 1, 9);
    test("abcdefghij", 9, 2, "abcdefghijklmnopqrst", 10, 9);
    test("abcdefghij", 9, 2, "abcdefghijklmnopqrst", 19, 9);
    test("abcdefghij", 9, 2, "abcdefghijklmnopqrst", 20, 9);
    test("abcdefghij", 10, 0, "", 0, 0);
    test("abcdefghij", 10, 0, "abcde", 0, 0);
    test("abcdefghij", 10, 0, "abcde", 1, -1);
    test("abcdefghij", 10, 0, "abcde", 2, -2);
    test("abcdefghij", 10, 0, "abcde", 4, -4);
    test("abcdefghij", 10, 0, "abcde", 5, -5);
    test("abcdefghij", 10, 0, "abcdefghij", 0, 0);
    test("abcdefghij", 10, 0, "abcdefghij", 1, -1);
    test("abcdefghij", 10, 0, "abcdefghij", 5, -5);
    test("abcdefghij", 10, 0, "abcdefghij", 9, -9);
    test("abcdefghij", 10, 0, "abcdefghij", 10, -10);
    test("abcdefghij", 10, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghij", 10, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghij", 10, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghij", 10, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghij", 10, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghij", 10, 1, "", 0, 0);
    test("abcdefghij", 10, 1, "abcde", 0, 0);
    test("abcdefghij", 10, 1, "abcde", 1, -1);
    test("abcdefghij", 10, 1, "abcde", 2, -2);
    test("abcdefghij", 10, 1, "abcde", 4, -4);
    test("abcdefghij", 10, 1, "abcde", 5, -5);
    test("abcdefghij", 10, 1, "abcdefghij", 0, 0);
    test("abcdefghij", 10, 1, "abcdefghij", 1, -1);
    test("abcdefghij", 10, 1, "abcdefghij", 5, -5);
    test("abcdefghij", 10, 1, "abcdefghij", 9, -9);
    test("abcdefghij", 10, 1, "abcdefghij", 10, -10);
    test("abcdefghij", 10, 1, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghij", 10, 1, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghij", 10, 1, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghij", 10, 1, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghij", 10, 1, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghij", 11, 0, "", 0, 0);
    test("abcdefghij", 11, 0, "abcde", 0, 0);
    test("abcdefghij", 11, 0, "abcde", 1, 0);
    test("abcdefghij", 11, 0, "abcde", 2, 0);
    test("abcdefghij", 11, 0, "abcde", 4, 0);
    test("abcdefghij", 11, 0, "abcde", 5, 0);
    test("abcdefghij", 11, 0, "abcdefghij", 0, 0);
    test("abcdefghij", 11, 0, "abcdefghij", 1, 0);
    test("abcdefghij", 11, 0, "abcdefghij", 5, 0);
    test("abcdefghij", 11, 0, "abcdefghij", 9, 0);
    test("abcdefghij", 11, 0, "abcdefghij", 10, 0);
    test("abcdefghij", 11, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghij", 11, 0, "abcdefghijklmnopqrst", 1, 0);
    test("abcdefghij", 11, 0, "abcdefghijklmnopqrst", 10, 0);
    test("abcdefghij", 11, 0, "abcdefghijklmnopqrst", 19, 0);
    test("abcdefghij", 11, 0, "abcdefghijklmnopqrst", 20, 0);
}

void test8()
{
    test("abcdefghijklmnopqrst", 0, 0, "", 0, 0);
    test("abcdefghijklmnopqrst", 0, 0, "abcde", 0, 0);
    test("abcdefghijklmnopqrst", 0, 0, "abcde", 1, -1);
    test("abcdefghijklmnopqrst", 0, 0, "abcde", 2, -2);
    test("abcdefghijklmnopqrst", 0, 0, "abcde", 4, -4);
    test("abcdefghijklmnopqrst", 0, 0, "abcde", 5, -5);
    test("abcdefghijklmnopqrst", 0, 0, "abcdefghij", 0, 0);
    test("abcdefghijklmnopqrst", 0, 0, "abcdefghij", 1, -1);
    test("abcdefghijklmnopqrst", 0, 0, "abcdefghij", 5, -5);
    test("abcdefghijklmnopqrst", 0, 0, "abcdefghij", 9, -9);
    test("abcdefghijklmnopqrst", 0, 0, "abcdefghij", 10, -10);
    test("abcdefghijklmnopqrst", 0, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghijklmnopqrst", 0, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghijklmnopqrst", 0, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghijklmnopqrst", 0, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghijklmnopqrst", 0, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghijklmnopqrst", 0, 1, "", 0, 1);
    test("abcdefghijklmnopqrst", 0, 1, "abcde", 0, 1);
    test("abcdefghijklmnopqrst", 0, 1, "abcde", 1, 0);
    test("abcdefghijklmnopqrst", 0, 1, "abcde", 2, -1);
    test("abcdefghijklmnopqrst", 0, 1, "abcde", 4, -3);
    test("abcdefghijklmnopqrst", 0, 1, "abcde", 5, -4);
    test("abcdefghijklmnopqrst", 0, 1, "abcdefghij", 0, 1);
    test("abcdefghijklmnopqrst", 0, 1, "abcdefghij", 1, 0);
    test("abcdefghijklmnopqrst", 0, 1, "abcdefghij", 5, -4);
    test("abcdefghijklmnopqrst", 0, 1, "abcdefghij", 9, -8);
    test("abcdefghijklmnopqrst", 0, 1, "abcdefghij", 10, -9);
    test("abcdefghijklmnopqrst", 0, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcdefghijklmnopqrst", 0, 1, "abcdefghijklmnopqrst", 1, 0);
    test("abcdefghijklmnopqrst", 0, 1, "abcdefghijklmnopqrst", 10, -9);
    test("abcdefghijklmnopqrst", 0, 1, "abcdefghijklmnopqrst", 19, -18);
    test("abcdefghijklmnopqrst", 0, 1, "abcdefghijklmnopqrst", 20, -19);
    test("abcdefghijklmnopqrst", 0, 10, "", 0, 10);
    test("abcdefghijklmnopqrst", 0, 10, "abcde", 0, 10);
    test("abcdefghijklmnopqrst", 0, 10, "abcde", 1, 9);
    test("abcdefghijklmnopqrst", 0, 10, "abcde", 2, 8);
    test("abcdefghijklmnopqrst", 0, 10, "abcde", 4, 6);
    test("abcdefghijklmnopqrst", 0, 10, "abcde", 5, 5);
    test("abcdefghijklmnopqrst", 0, 10, "abcdefghij", 0, 10);
    test("abcdefghijklmnopqrst", 0, 10, "abcdefghij", 1, 9);
    test("abcdefghijklmnopqrst", 0, 10, "abcdefghij", 5, 5);
    test("abcdefghijklmnopqrst", 0, 10, "abcdefghij", 9, 1);
    test("abcdefghijklmnopqrst", 0, 10, "abcdefghij", 10, 0);
    test("abcdefghijklmnopqrst", 0, 10, "abcdefghijklmnopqrst", 0, 10);
    test("abcdefghijklmnopqrst", 0, 10, "abcdefghijklmnopqrst", 1, 9);
    test("abcdefghijklmnopqrst", 0, 10, "abcdefghijklmnopqrst", 10, 0);
    test("abcdefghijklmnopqrst", 0, 10, "abcdefghijklmnopqrst", 19, -9);
    test("abcdefghijklmnopqrst", 0, 10, "abcdefghijklmnopqrst", 20, -10);
    test("abcdefghijklmnopqrst", 0, 19, "", 0, 19);
    test("abcdefghijklmnopqrst", 0, 19, "abcde", 0, 19);
    test("abcdefghijklmnopqrst", 0, 19, "abcde", 1, 18);
    test("abcdefghijklmnopqrst", 0, 19, "abcde", 2, 17);
    test("abcdefghijklmnopqrst", 0, 19, "abcde", 4, 15);
    test("abcdefghijklmnopqrst", 0, 19, "abcde", 5, 14);
    test("abcdefghijklmnopqrst", 0, 19, "abcdefghij", 0, 19);
    test("abcdefghijklmnopqrst", 0, 19, "abcdefghij", 1, 18);
    test("abcdefghijklmnopqrst", 0, 19, "abcdefghij", 5, 14);
    test("abcdefghijklmnopqrst", 0, 19, "abcdefghij", 9, 10);
    test("abcdefghijklmnopqrst", 0, 19, "abcdefghij", 10, 9);
    test("abcdefghijklmnopqrst", 0, 19, "abcdefghijklmnopqrst", 0, 19);
    test("abcdefghijklmnopqrst", 0, 19, "abcdefghijklmnopqrst", 1, 18);
    test("abcdefghijklmnopqrst", 0, 19, "abcdefghijklmnopqrst", 10, 9);
    test("abcdefghijklmnopqrst", 0, 19, "abcdefghijklmnopqrst", 19, 0);
    test("abcdefghijklmnopqrst", 0, 19, "abcdefghijklmnopqrst", 20, -1);
    test("abcdefghijklmnopqrst", 0, 20, "", 0, 20);
    test("abcdefghijklmnopqrst", 0, 20, "abcde", 0, 20);
    test("abcdefghijklmnopqrst", 0, 20, "abcde", 1, 19);
    test("abcdefghijklmnopqrst", 0, 20, "abcde", 2, 18);
    test("abcdefghijklmnopqrst", 0, 20, "abcde", 4, 16);
    test("abcdefghijklmnopqrst", 0, 20, "abcde", 5, 15);
    test("abcdefghijklmnopqrst", 0, 20, "abcdefghij", 0, 20);
    test("abcdefghijklmnopqrst", 0, 20, "abcdefghij", 1, 19);
    test("abcdefghijklmnopqrst", 0, 20, "abcdefghij", 5, 15);
    test("abcdefghijklmnopqrst", 0, 20, "abcdefghij", 9, 11);
    test("abcdefghijklmnopqrst", 0, 20, "abcdefghij", 10, 10);
    test("abcdefghijklmnopqrst", 0, 20, "abcdefghijklmnopqrst", 0, 20);
    test("abcdefghijklmnopqrst", 0, 20, "abcdefghijklmnopqrst", 1, 19);
    test("abcdefghijklmnopqrst", 0, 20, "abcdefghijklmnopqrst", 10, 10);
    test("abcdefghijklmnopqrst", 0, 20, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghijklmnopqrst", 0, 20, "abcdefghijklmnopqrst", 20, 0);
    test("abcdefghijklmnopqrst", 0, 21, "", 0, 20);
    test("abcdefghijklmnopqrst", 0, 21, "abcde", 0, 20);
    test("abcdefghijklmnopqrst", 0, 21, "abcde", 1, 19);
    test("abcdefghijklmnopqrst", 0, 21, "abcde", 2, 18);
    test("abcdefghijklmnopqrst", 0, 21, "abcde", 4, 16);
    test("abcdefghijklmnopqrst", 0, 21, "abcde", 5, 15);
    test("abcdefghijklmnopqrst", 0, 21, "abcdefghij", 0, 20);
    test("abcdefghijklmnopqrst", 0, 21, "abcdefghij", 1, 19);
    test("abcdefghijklmnopqrst", 0, 21, "abcdefghij", 5, 15);
    test("abcdefghijklmnopqrst", 0, 21, "abcdefghij", 9, 11);
    test("abcdefghijklmnopqrst", 0, 21, "abcdefghij", 10, 10);
    test("abcdefghijklmnopqrst", 0, 21, "abcdefghijklmnopqrst", 0, 20);
    test("abcdefghijklmnopqrst", 0, 21, "abcdefghijklmnopqrst", 1, 19);
    test("abcdefghijklmnopqrst", 0, 21, "abcdefghijklmnopqrst", 10, 10);
    test("abcdefghijklmnopqrst", 0, 21, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghijklmnopqrst", 0, 21, "abcdefghijklmnopqrst", 20, 0);
    test("abcdefghijklmnopqrst", 1, 0, "", 0, 0);
    test("abcdefghijklmnopqrst", 1, 0, "abcde", 0, 0);
    test("abcdefghijklmnopqrst", 1, 0, "abcde", 1, -1);
    test("abcdefghijklmnopqrst", 1, 0, "abcde", 2, -2);
}


void test9()
{
    test("abcdefghijklmnopqrst", 1, 0, "abcde", 4, -4);
    test("abcdefghijklmnopqrst", 1, 0, "abcde", 5, -5);
    test("abcdefghijklmnopqrst", 1, 0, "abcdefghij", 0, 0);
    test("abcdefghijklmnopqrst", 1, 0, "abcdefghij", 1, -1);
    test("abcdefghijklmnopqrst", 1, 0, "abcdefghij", 5, -5);
    test("abcdefghijklmnopqrst", 1, 0, "abcdefghij", 9, -9);
    test("abcdefghijklmnopqrst", 1, 0, "abcdefghij", 10, -10);
    test("abcdefghijklmnopqrst", 1, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghijklmnopqrst", 1, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghijklmnopqrst", 1, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghijklmnopqrst", 1, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghijklmnopqrst", 1, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghijklmnopqrst", 1, 1, "", 0, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcde", 0, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcde", 1, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcde", 2, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcde", 4, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcde", 5, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcdefghij", 0, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcdefghij", 1, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcdefghij", 5, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcdefghij", 9, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcdefghij", 10, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcdefghijklmnopqrst", 1, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcdefghijklmnopqrst", 10, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghijklmnopqrst", 1, 1, "abcdefghijklmnopqrst", 20, 1);
    test("abcdefghijklmnopqrst", 1, 9, "", 0, 9);
    test("abcdefghijklmnopqrst", 1, 9, "abcde", 0, 9);
    test("abcdefghijklmnopqrst", 1, 9, "abcde", 1, 1);
    test("abcdefghijklmnopqrst", 1, 9, "abcde", 2, 1);
    test("abcdefghijklmnopqrst", 1, 9, "abcde", 4, 1);
    test("abcdefghijklmnopqrst", 1, 9, "abcde", 5, 1);
    test("abcdefghijklmnopqrst", 1, 9, "abcdefghij", 0, 9);
    test("abcdefghijklmnopqrst", 1, 9, "abcdefghij", 1, 1);
    test("abcdefghijklmnopqrst", 1, 9, "abcdefghij", 5, 1);
    test("abcdefghijklmnopqrst", 1, 9, "abcdefghij", 9, 1);
    test("abcdefghijklmnopqrst", 1, 9, "abcdefghij", 10, 1);
    test("abcdefghijklmnopqrst", 1, 9, "abcdefghijklmnopqrst", 0, 9);
    test("abcdefghijklmnopqrst", 1, 9, "abcdefghijklmnopqrst", 1, 1);
    test("abcdefghijklmnopqrst", 1, 9, "abcdefghijklmnopqrst", 10, 1);
    test("abcdefghijklmnopqrst", 1, 9, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghijklmnopqrst", 1, 9, "abcdefghijklmnopqrst", 20, 1);
    test("abcdefghijklmnopqrst", 1, 18, "", 0, 18);
    test("abcdefghijklmnopqrst", 1, 18, "abcde", 0, 18);
    test("abcdefghijklmnopqrst", 1, 18, "abcde", 1, 1);
    test("abcdefghijklmnopqrst", 1, 18, "abcde", 2, 1);
    test("abcdefghijklmnopqrst", 1, 18, "abcde", 4, 1);
    test("abcdefghijklmnopqrst", 1, 18, "abcde", 5, 1);
    test("abcdefghijklmnopqrst", 1, 18, "abcdefghij", 0, 18);
    test("abcdefghijklmnopqrst", 1, 18, "abcdefghij", 1, 1);
    test("abcdefghijklmnopqrst", 1, 18, "abcdefghij", 5, 1);
    test("abcdefghijklmnopqrst", 1, 18, "abcdefghij", 9, 1);
    test("abcdefghijklmnopqrst", 1, 18, "abcdefghij", 10, 1);
    test("abcdefghijklmnopqrst", 1, 18, "abcdefghijklmnopqrst", 0, 18);
    test("abcdefghijklmnopqrst", 1, 18, "abcdefghijklmnopqrst", 1, 1);
    test("abcdefghijklmnopqrst", 1, 18, "abcdefghijklmnopqrst", 10, 1);
    test("abcdefghijklmnopqrst", 1, 18, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghijklmnopqrst", 1, 18, "abcdefghijklmnopqrst", 20, 1);
    test("abcdefghijklmnopqrst", 1, 19, "", 0, 19);
    test("abcdefghijklmnopqrst", 1, 19, "abcde", 0, 19);
    test("abcdefghijklmnopqrst", 1, 19, "abcde", 1, 1);
    test("abcdefghijklmnopqrst", 1, 19, "abcde", 2, 1);
    test("abcdefghijklmnopqrst", 1, 19, "abcde", 4, 1);
    test("abcdefghijklmnopqrst", 1, 19, "abcde", 5, 1);
    test("abcdefghijklmnopqrst", 1, 19, "abcdefghij", 0, 19);
    test("abcdefghijklmnopqrst", 1, 19, "abcdefghij", 1, 1);
    test("abcdefghijklmnopqrst", 1, 19, "abcdefghij", 5, 1);
    test("abcdefghijklmnopqrst", 1, 19, "abcdefghij", 9, 1);
    test("abcdefghijklmnopqrst", 1, 19, "abcdefghij", 10, 1);
    test("abcdefghijklmnopqrst", 1, 19, "abcdefghijklmnopqrst", 0, 19);
    test("abcdefghijklmnopqrst", 1, 19, "abcdefghijklmnopqrst", 1, 1);
    test("abcdefghijklmnopqrst", 1, 19, "abcdefghijklmnopqrst", 10, 1);
    test("abcdefghijklmnopqrst", 1, 19, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghijklmnopqrst", 1, 19, "abcdefghijklmnopqrst", 20, 1);
    test("abcdefghijklmnopqrst", 1, 20, "", 0, 19);
    test("abcdefghijklmnopqrst", 1, 20, "abcde", 0, 19);
    test("abcdefghijklmnopqrst", 1, 20, "abcde", 1, 1);
    test("abcdefghijklmnopqrst", 1, 20, "abcde", 2, 1);
    test("abcdefghijklmnopqrst", 1, 20, "abcde", 4, 1);
    test("abcdefghijklmnopqrst", 1, 20, "abcde", 5, 1);
    test("abcdefghijklmnopqrst", 1, 20, "abcdefghij", 0, 19);
    test("abcdefghijklmnopqrst", 1, 20, "abcdefghij", 1, 1);
    test("abcdefghijklmnopqrst", 1, 20, "abcdefghij", 5, 1);
    test("abcdefghijklmnopqrst", 1, 20, "abcdefghij", 9, 1);
    test("abcdefghijklmnopqrst", 1, 20, "abcdefghij", 10, 1);
    test("abcdefghijklmnopqrst", 1, 20, "abcdefghijklmnopqrst", 0, 19);
    test("abcdefghijklmnopqrst", 1, 20, "abcdefghijklmnopqrst", 1, 1);
    test("abcdefghijklmnopqrst", 1, 20, "abcdefghijklmnopqrst", 10, 1);
    test("abcdefghijklmnopqrst", 1, 20, "abcdefghijklmnopqrst", 19, 1);
    test("abcdefghijklmnopqrst", 1, 20, "abcdefghijklmnopqrst", 20, 1);
    test("abcdefghijklmnopqrst", 10, 0, "", 0, 0);
    test("abcdefghijklmnopqrst", 10, 0, "abcde", 0, 0);
    test("abcdefghijklmnopqrst", 10, 0, "abcde", 1, -1);
    test("abcdefghijklmnopqrst", 10, 0, "abcde", 2, -2);
    test("abcdefghijklmnopqrst", 10, 0, "abcde", 4, -4);
    test("abcdefghijklmnopqrst", 10, 0, "abcde", 5, -5);
    test("abcdefghijklmnopqrst", 10, 0, "abcdefghij", 0, 0);
    test("abcdefghijklmnopqrst", 10, 0, "abcdefghij", 1, -1);
}


void test10()
{
    test("abcdefghijklmnopqrst", 10, 0, "abcdefghij", 5, -5);
    test("abcdefghijklmnopqrst", 10, 0, "abcdefghij", 9, -9);
    test("abcdefghijklmnopqrst", 10, 0, "abcdefghij", 10, -10);
    test("abcdefghijklmnopqrst", 10, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghijklmnopqrst", 10, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghijklmnopqrst", 10, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghijklmnopqrst", 10, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghijklmnopqrst", 10, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghijklmnopqrst", 10, 1, "", 0, 1);
    test("abcdefghijklmnopqrst", 10, 1, "abcde", 0, 1);
    test("abcdefghijklmnopqrst", 10, 1, "abcde", 1, 10);
    test("abcdefghijklmnopqrst", 10, 1, "abcde", 2, 10);
    test("abcdefghijklmnopqrst", 10, 1, "abcde", 4, 10);
    test("abcdefghijklmnopqrst", 10, 1, "abcde", 5, 10);
    test("abcdefghijklmnopqrst", 10, 1, "abcdefghij", 0, 1);
    test("abcdefghijklmnopqrst", 10, 1, "abcdefghij", 1, 10);
    test("abcdefghijklmnopqrst", 10, 1, "abcdefghij", 5, 10);
    test("abcdefghijklmnopqrst", 10, 1, "abcdefghij", 9, 10);
    test("abcdefghijklmnopqrst", 10, 1, "abcdefghij", 10, 10);
    test("abcdefghijklmnopqrst", 10, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcdefghijklmnopqrst", 10, 1, "abcdefghijklmnopqrst", 1, 10);
    test("abcdefghijklmnopqrst", 10, 1, "abcdefghijklmnopqrst", 10, 10);
    test("abcdefghijklmnopqrst", 10, 1, "abcdefghijklmnopqrst", 19, 10);
    test("abcdefghijklmnopqrst", 10, 1, "abcdefghijklmnopqrst", 20, 10);
    test("abcdefghijklmnopqrst", 10, 5, "", 0, 5);
    test("abcdefghijklmnopqrst", 10, 5, "abcde", 0, 5);
    test("abcdefghijklmnopqrst", 10, 5, "abcde", 1, 10);
    test("abcdefghijklmnopqrst", 10, 5, "abcde", 2, 10);
    test("abcdefghijklmnopqrst", 10, 5, "abcde", 4, 10);
    test("abcdefghijklmnopqrst", 10, 5, "abcde", 5, 10);
    test("abcdefghijklmnopqrst", 10, 5, "abcdefghij", 0, 5);
    test("abcdefghijklmnopqrst", 10, 5, "abcdefghij", 1, 10);
    test("abcdefghijklmnopqrst", 10, 5, "abcdefghij", 5, 10);
    test("abcdefghijklmnopqrst", 10, 5, "abcdefghij", 9, 10);
    test("abcdefghijklmnopqrst", 10, 5, "abcdefghij", 10, 10);
    test("abcdefghijklmnopqrst", 10, 5, "abcdefghijklmnopqrst", 0, 5);
    test("abcdefghijklmnopqrst", 10, 5, "abcdefghijklmnopqrst", 1, 10);
    test("abcdefghijklmnopqrst", 10, 5, "abcdefghijklmnopqrst", 10, 10);
    test("abcdefghijklmnopqrst", 10, 5, "abcdefghijklmnopqrst", 19, 10);
    test("abcdefghijklmnopqrst", 10, 5, "abcdefghijklmnopqrst", 20, 10);
    test("abcdefghijklmnopqrst", 10, 9, "", 0, 9);
    test("abcdefghijklmnopqrst", 10, 9, "abcde", 0, 9);
    test("abcdefghijklmnopqrst", 10, 9, "abcde", 1, 10);
    test("abcdefghijklmnopqrst", 10, 9, "abcde", 2, 10);
    test("abcdefghijklmnopqrst", 10, 9, "abcde", 4, 10);
    test("abcdefghijklmnopqrst", 10, 9, "abcde", 5, 10);
    test("abcdefghijklmnopqrst", 10, 9, "abcdefghij", 0, 9);
    test("abcdefghijklmnopqrst", 10, 9, "abcdefghij", 1, 10);
    test("abcdefghijklmnopqrst", 10, 9, "abcdefghij", 5, 10);
    test("abcdefghijklmnopqrst", 10, 9, "abcdefghij", 9, 10);
    test("abcdefghijklmnopqrst", 10, 9, "abcdefghij", 10, 10);
    test("abcdefghijklmnopqrst", 10, 9, "abcdefghijklmnopqrst", 0, 9);
    test("abcdefghijklmnopqrst", 10, 9, "abcdefghijklmnopqrst", 1, 10);
    test("abcdefghijklmnopqrst", 10, 9, "abcdefghijklmnopqrst", 10, 10);
    test("abcdefghijklmnopqrst", 10, 9, "abcdefghijklmnopqrst", 19, 10);
    test("abcdefghijklmnopqrst", 10, 9, "abcdefghijklmnopqrst", 20, 10);
    test("abcdefghijklmnopqrst", 10, 10, "", 0, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcde", 0, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcde", 1, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcde", 2, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcde", 4, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcde", 5, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcdefghij", 0, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcdefghij", 1, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcdefghij", 5, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcdefghij", 9, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcdefghij", 10, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcdefghijklmnopqrst", 0, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcdefghijklmnopqrst", 1, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcdefghijklmnopqrst", 10, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcdefghijklmnopqrst", 19, 10);
    test("abcdefghijklmnopqrst", 10, 10, "abcdefghijklmnopqrst", 20, 10);
    test("abcdefghijklmnopqrst", 10, 11, "", 0, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcde", 0, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcde", 1, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcde", 2, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcde", 4, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcde", 5, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcdefghij", 0, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcdefghij", 1, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcdefghij", 5, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcdefghij", 9, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcdefghij", 10, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcdefghijklmnopqrst", 0, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcdefghijklmnopqrst", 1, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcdefghijklmnopqrst", 10, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcdefghijklmnopqrst", 19, 10);
    test("abcdefghijklmnopqrst", 10, 11, "abcdefghijklmnopqrst", 20, 10);
    test("abcdefghijklmnopqrst", 19, 0, "", 0, 0);
    test("abcdefghijklmnopqrst", 19, 0, "abcde", 0, 0);
    test("abcdefghijklmnopqrst", 19, 0, "abcde", 1, -1);
    test("abcdefghijklmnopqrst", 19, 0, "abcde", 2, -2);
    test("abcdefghijklmnopqrst", 19, 0, "abcde", 4, -4);
    test("abcdefghijklmnopqrst", 19, 0, "abcde", 5, -5);
    test("abcdefghijklmnopqrst", 19, 0, "abcdefghij", 0, 0);
    test("abcdefghijklmnopqrst", 19, 0, "abcdefghij", 1, -1);
    test("abcdefghijklmnopqrst", 19, 0, "abcdefghij", 5, -5);
    test("abcdefghijklmnopqrst", 19, 0, "abcdefghij", 9, -9);
    test("abcdefghijklmnopqrst", 19, 0, "abcdefghij", 10, -10);
    test("abcdefghijklmnopqrst", 19, 0, "abcdefghijklmnopqrst", 0, 0);
}


void test11()
{
    test("abcdefghijklmnopqrst", 19, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghijklmnopqrst", 19, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghijklmnopqrst", 19, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghijklmnopqrst", 19, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghijklmnopqrst", 19, 1, "", 0, 1);
    test("abcdefghijklmnopqrst", 19, 1, "abcde", 0, 1);
    test("abcdefghijklmnopqrst", 19, 1, "abcde", 1, 19);
    test("abcdefghijklmnopqrst", 19, 1, "abcde", 2, 19);
    test("abcdefghijklmnopqrst", 19, 1, "abcde", 4, 19);
    test("abcdefghijklmnopqrst", 19, 1, "abcde", 5, 19);
    test("abcdefghijklmnopqrst", 19, 1, "abcdefghij", 0, 1);
    test("abcdefghijklmnopqrst", 19, 1, "abcdefghij", 1, 19);
    test("abcdefghijklmnopqrst", 19, 1, "abcdefghij", 5, 19);
    test("abcdefghijklmnopqrst", 19, 1, "abcdefghij", 9, 19);
    test("abcdefghijklmnopqrst", 19, 1, "abcdefghij", 10, 19);
    test("abcdefghijklmnopqrst", 19, 1, "abcdefghijklmnopqrst", 0, 1);
    test("abcdefghijklmnopqrst", 19, 1, "abcdefghijklmnopqrst", 1, 19);
    test("abcdefghijklmnopqrst", 19, 1, "abcdefghijklmnopqrst", 10, 19);
    test("abcdefghijklmnopqrst", 19, 1, "abcdefghijklmnopqrst", 19, 19);
    test("abcdefghijklmnopqrst", 19, 1, "abcdefghijklmnopqrst", 20, 19);
    test("abcdefghijklmnopqrst", 19, 2, "", 0, 1);
    test("abcdefghijklmnopqrst", 19, 2, "abcde", 0, 1);
    test("abcdefghijklmnopqrst", 19, 2, "abcde", 1, 19);
    test("abcdefghijklmnopqrst", 19, 2, "abcde", 2, 19);
    test("abcdefghijklmnopqrst", 19, 2, "abcde", 4, 19);
    test("abcdefghijklmnopqrst", 19, 2, "abcde", 5, 19);
    test("abcdefghijklmnopqrst", 19, 2, "abcdefghij", 0, 1);
    test("abcdefghijklmnopqrst", 19, 2, "abcdefghij", 1, 19);
    test("abcdefghijklmnopqrst", 19, 2, "abcdefghij", 5, 19);
    test("abcdefghijklmnopqrst", 19, 2, "abcdefghij", 9, 19);
    test("abcdefghijklmnopqrst", 19, 2, "abcdefghij", 10, 19);
    test("abcdefghijklmnopqrst", 19, 2, "abcdefghijklmnopqrst", 0, 1);
    test("abcdefghijklmnopqrst", 19, 2, "abcdefghijklmnopqrst", 1, 19);
    test("abcdefghijklmnopqrst", 19, 2, "abcdefghijklmnopqrst", 10, 19);
    test("abcdefghijklmnopqrst", 19, 2, "abcdefghijklmnopqrst", 19, 19);
    test("abcdefghijklmnopqrst", 19, 2, "abcdefghijklmnopqrst", 20, 19);
    test("abcdefghijklmnopqrst", 20, 0, "", 0, 0);
    test("abcdefghijklmnopqrst", 20, 0, "abcde", 0, 0);
    test("abcdefghijklmnopqrst", 20, 0, "abcde", 1, -1);
    test("abcdefghijklmnopqrst", 20, 0, "abcde", 2, -2);
    test("abcdefghijklmnopqrst", 20, 0, "abcde", 4, -4);
    test("abcdefghijklmnopqrst", 20, 0, "abcde", 5, -5);
    test("abcdefghijklmnopqrst", 20, 0, "abcdefghij", 0, 0);
    test("abcdefghijklmnopqrst", 20, 0, "abcdefghij", 1, -1);
    test("abcdefghijklmnopqrst", 20, 0, "abcdefghij", 5, -5);
    test("abcdefghijklmnopqrst", 20, 0, "abcdefghij", 9, -9);
    test("abcdefghijklmnopqrst", 20, 0, "abcdefghij", 10, -10);
    test("abcdefghijklmnopqrst", 20, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghijklmnopqrst", 20, 0, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghijklmnopqrst", 20, 0, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghijklmnopqrst", 20, 0, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghijklmnopqrst", 20, 0, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghijklmnopqrst", 20, 1, "", 0, 0);
    test("abcdefghijklmnopqrst", 20, 1, "abcde", 0, 0);
    test("abcdefghijklmnopqrst", 20, 1, "abcde", 1, -1);
    test("abcdefghijklmnopqrst", 20, 1, "abcde", 2, -2);
    test("abcdefghijklmnopqrst", 20, 1, "abcde", 4, -4);
    test("abcdefghijklmnopqrst", 20, 1, "abcde", 5, -5);
    test("abcdefghijklmnopqrst", 20, 1, "abcdefghij", 0, 0);
    test("abcdefghijklmnopqrst", 20, 1, "abcdefghij", 1, -1);
    test("abcdefghijklmnopqrst", 20, 1, "abcdefghij", 5, -5);
    test("abcdefghijklmnopqrst", 20, 1, "abcdefghij", 9, -9);
    test("abcdefghijklmnopqrst", 20, 1, "abcdefghij", 10, -10);
    test("abcdefghijklmnopqrst", 20, 1, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghijklmnopqrst", 20, 1, "abcdefghijklmnopqrst", 1, -1);
    test("abcdefghijklmnopqrst", 20, 1, "abcdefghijklmnopqrst", 10, -10);
    test("abcdefghijklmnopqrst", 20, 1, "abcdefghijklmnopqrst", 19, -19);
    test("abcdefghijklmnopqrst", 20, 1, "abcdefghijklmnopqrst", 20, -20);
    test("abcdefghijklmnopqrst", 21, 0, "", 0, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcde", 0, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcde", 1, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcde", 2, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcde", 4, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcde", 5, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcdefghij", 0, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcdefghij", 1, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcdefghij", 5, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcdefghij", 9, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcdefghij", 10, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcdefghijklmnopqrst", 0, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcdefghijklmnopqrst", 1, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcdefghijklmnopqrst", 10, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcdefghijklmnopqrst", 19, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcdefghijklmnopqrst", 20, 0);
    }


int main () {
    test0();
    test1();
    test2();
    test3();
    test4();
    test5();
    test6();
    test7();
    test8();
    test9();
    test10();
    test11();
    
    {
    test("", 0, 0, "abcde", 0, 0);
    test("", 0, 0, "abcde", 1, -1);
    test("abcdefghijklmnopqrst", 21, 0, "abcde", 0, 0);
    test("abcdefghijklmnopqrst", 21, 0, "abcde", 1, 0);
    test("abcdefghijklmnopqrst", 10, 0, "abcdefghij", 10, -10);
    }

    {
    test(L"", 0, 0, L"abcde", 0, 0);
    test(L"", 0, 0, L"abcde", 1, -1);
    test(L"abcdefghijklmnopqrst", 21, 0, L"abcde", 0, 0);
    test(L"abcdefghijklmnopqrst", 21, 0, L"abcde", 1, 0);
    test(L"abcdefghijklmnopqrst", 10, 0, L"abcdefghij", 10, -10);
    }

#if __cplusplus >= 201103L
    {
    test(U"", 0, 0, U"abcde", 0, 0);
    test(U"", 0, 0, U"abcde", 1, -1);
    test(U"abcdefghijklmnopqrst", 21, 0, U"abcde", 0, 0);
    test(U"abcdefghijklmnopqrst", 21, 0, U"abcde", 1, 0);
    test(U"abcdefghijklmnopqrst", 10, 0, U"abcdefghij", 10, -10);
    }

    {
    test(U"", 0, 0, U"abcde", 0, 0);
    test(U"", 0, 0, U"abcde", 1, -1);
    test(U"abcdefghijklmnopqrst", 21, 0, U"abcde", 0, 0);
    test(U"abcdefghijklmnopqrst", 21, 0, U"abcde", 1, 0);
    test(U"abcdefghijklmnopqrst", 10, 0, U"abcdefghij", 10, -10);
    }
#endif

#if _LIBCPP_STD_VER > 11
    {
    typedef std::experimental::basic_string_view<char, constexpr_char_traits<char>> SV;
    constexpr SV  sv1;
    constexpr SV  sv2 { "abcdefghijklmnopqrst", 21 };
    static_assert ( sv1.compare(0, 0, "abcde", 0) == 0, "" );
    static_assert ( sv1.compare(0, 0, "abcde", 1) == -1, "" );
    static_assert ( sv2.compare(0, 0, "abcde", 1, 0) == 0, "" );
    }
#endif
}
