// Copyright (C) 2018 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-array.prototype.sort
description: >
  Stability of Array.prototype.sort for an array with 513 elements.
info: |
  The sort is required to be stable (that is, elements that compare equal
  remain in their original order).
  The array length of 513 was chosen because until late 2018, Chakra
  used to apply an unstable QuickSort for arrays with more than 512
  elements, although it used a stable insertion sort for anything else.
  https://github.com/Microsoft/ChakraCore/pull/5724
---*/

const array = [
  { name: 'A00', rating: 2 },
  { name: 'A01', rating: 2 },
  { name: 'A02', rating: 2 },
  { name: 'A03', rating: 2 },
  { name: 'A04', rating: 2 },
  { name: 'A05', rating: 2 },
  { name: 'A06', rating: 2 },
  { name: 'A07', rating: 2 },
  { name: 'A08', rating: 2 },
  { name: 'A09', rating: 2 },
  { name: 'A10', rating: 2 },
  { name: 'A11', rating: 2 },
  { name: 'A12', rating: 2 },
  { name: 'A13', rating: 2 },
  { name: 'A14', rating: 2 },
  { name: 'A15', rating: 2 },
  { name: 'A16', rating: 2 },
  { name: 'A17', rating: 2 },
  { name: 'A18', rating: 2 },
  { name: 'A19', rating: 2 },
  { name: 'A20', rating: 2 },
  { name: 'A21', rating: 2 },
  { name: 'A22', rating: 2 },
  { name: 'A23', rating: 2 },
  { name: 'A24', rating: 2 },
  { name: 'A25', rating: 2 },
  { name: 'A26', rating: 2 },
  { name: 'A27', rating: 2 },
  { name: 'A28', rating: 2 },
  { name: 'A29', rating: 2 },
  { name: 'A30', rating: 2 },
  { name: 'A31', rating: 2 },
  { name: 'A32', rating: 2 },
  { name: 'A33', rating: 2 },
  { name: 'A34', rating: 2 },
  { name: 'A35', rating: 2 },
  { name: 'A36', rating: 2 },
  { name: 'A37', rating: 2 },
  { name: 'A38', rating: 2 },
  { name: 'A39', rating: 2 },
  { name: 'A40', rating: 2 },
  { name: 'A41', rating: 2 },
  { name: 'A42', rating: 2 },
  { name: 'A43', rating: 2 },
  { name: 'A44', rating: 2 },
  { name: 'A45', rating: 2 },
  { name: 'A46', rating: 2 },
  { name: 'B00', rating: 3 },
  { name: 'B01', rating: 3 },
  { name: 'B02', rating: 3 },
  { name: 'B03', rating: 3 },
  { name: 'B04', rating: 3 },
  { name: 'B05', rating: 3 },
  { name: 'B06', rating: 3 },
  { name: 'B07', rating: 3 },
  { name: 'B08', rating: 3 },
  { name: 'B09', rating: 3 },
  { name: 'B10', rating: 3 },
  { name: 'B11', rating: 3 },
  { name: 'B12', rating: 3 },
  { name: 'B13', rating: 3 },
  { name: 'B14', rating: 3 },
  { name: 'B15', rating: 3 },
  { name: 'B16', rating: 3 },
  { name: 'B17', rating: 3 },
  { name: 'B18', rating: 3 },
  { name: 'B19', rating: 3 },
  { name: 'B20', rating: 3 },
  { name: 'B21', rating: 3 },
  { name: 'B22', rating: 3 },
  { name: 'B23', rating: 3 },
  { name: 'B24', rating: 3 },
  { name: 'B25', rating: 3 },
  { name: 'B26', rating: 3 },
  { name: 'B27', rating: 3 },
  { name: 'B28', rating: 3 },
  { name: 'B29', rating: 3 },
  { name: 'B30', rating: 3 },
  { name: 'B31', rating: 3 },
  { name: 'B32', rating: 3 },
  { name: 'B33', rating: 3 },
  { name: 'B34', rating: 3 },
  { name: 'B35', rating: 3 },
  { name: 'B36', rating: 3 },
  { name: 'B37', rating: 3 },
  { name: 'B38', rating: 3 },
  { name: 'B39', rating: 3 },
  { name: 'B40', rating: 3 },
  { name: 'B41', rating: 3 },
  { name: 'B42', rating: 3 },
  { name: 'B43', rating: 3 },
  { name: 'B44', rating: 3 },
  { name: 'B45', rating: 3 },
  { name: 'B46', rating: 3 },
  { name: 'C00', rating: 2 },
  { name: 'C01', rating: 2 },
  { name: 'C02', rating: 2 },
  { name: 'C03', rating: 2 },
  { name: 'C04', rating: 2 },
  { name: 'C05', rating: 2 },
  { name: 'C06', rating: 2 },
  { name: 'C07', rating: 2 },
  { name: 'C08', rating: 2 },
  { name: 'C09', rating: 2 },
  { name: 'C10', rating: 2 },
  { name: 'C11', rating: 2 },
  { name: 'C12', rating: 2 },
  { name: 'C13', rating: 2 },
  { name: 'C14', rating: 2 },
  { name: 'C15', rating: 2 },
  { name: 'C16', rating: 2 },
  { name: 'C17', rating: 2 },
  { name: 'C18', rating: 2 },
  { name: 'C19', rating: 2 },
  { name: 'C20', rating: 2 },
  { name: 'C21', rating: 2 },
  { name: 'C22', rating: 2 },
  { name: 'C23', rating: 2 },
  { name: 'C24', rating: 2 },
  { name: 'C25', rating: 2 },
  { name: 'C26', rating: 2 },
  { name: 'C27', rating: 2 },
  { name: 'C28', rating: 2 },
  { name: 'C29', rating: 2 },
  { name: 'C30', rating: 2 },
  { name: 'C31', rating: 2 },
  { name: 'C32', rating: 2 },
  { name: 'C33', rating: 2 },
  { name: 'C34', rating: 2 },
  { name: 'C35', rating: 2 },
  { name: 'C36', rating: 2 },
  { name: 'C37', rating: 2 },
  { name: 'C38', rating: 2 },
  { name: 'C39', rating: 2 },
  { name: 'C40', rating: 2 },
  { name: 'C41', rating: 2 },
  { name: 'C42', rating: 2 },
  { name: 'C43', rating: 2 },
  { name: 'C44', rating: 2 },
  { name: 'C45', rating: 2 },
  { name: 'C46', rating: 2 },
  { name: 'D00', rating: 4 },
  { name: 'D01', rating: 4 },
  { name: 'D02', rating: 4 },
  { name: 'D03', rating: 4 },
  { name: 'D04', rating: 4 },
  { name: 'D05', rating: 4 },
  { name: 'D06', rating: 4 },
  { name: 'D07', rating: 4 },
  { name: 'D08', rating: 4 },
  { name: 'D09', rating: 4 },
  { name: 'D10', rating: 4 },
  { name: 'D11', rating: 4 },
  { name: 'D12', rating: 4 },
  { name: 'D13', rating: 4 },
  { name: 'D14', rating: 4 },
  { name: 'D15', rating: 4 },
  { name: 'D16', rating: 4 },
  { name: 'D17', rating: 4 },
  { name: 'D18', rating: 4 },
  { name: 'D19', rating: 4 },
  { name: 'D20', rating: 4 },
  { name: 'D21', rating: 4 },
  { name: 'D22', rating: 4 },
  { name: 'D23', rating: 4 },
  { name: 'D24', rating: 4 },
  { name: 'D25', rating: 4 },
  { name: 'D26', rating: 4 },
  { name: 'D27', rating: 4 },
  { name: 'D28', rating: 4 },
  { name: 'D29', rating: 4 },
  { name: 'D30', rating: 4 },
  { name: 'D31', rating: 4 },
  { name: 'D32', rating: 4 },
  { name: 'D33', rating: 4 },
  { name: 'D34', rating: 4 },
  { name: 'D35', rating: 4 },
  { name: 'D36', rating: 4 },
  { name: 'D37', rating: 4 },
  { name: 'D38', rating: 4 },
  { name: 'D39', rating: 4 },
  { name: 'D40', rating: 4 },
  { name: 'D41', rating: 4 },
  { name: 'D42', rating: 4 },
  { name: 'D43', rating: 4 },
  { name: 'D44', rating: 4 },
  { name: 'D45', rating: 4 },
  { name: 'D46', rating: 4 },
  { name: 'E00', rating: 3 },
  { name: 'E01', rating: 3 },
  { name: 'E02', rating: 3 },
  { name: 'E03', rating: 3 },
  { name: 'E04', rating: 3 },
  { name: 'E05', rating: 3 },
  { name: 'E06', rating: 3 },
  { name: 'E07', rating: 3 },
  { name: 'E08', rating: 3 },
  { name: 'E09', rating: 3 },
  { name: 'E10', rating: 3 },
  { name: 'E11', rating: 3 },
  { name: 'E12', rating: 3 },
  { name: 'E13', rating: 3 },
  { name: 'E14', rating: 3 },
  { name: 'E15', rating: 3 },
  { name: 'E16', rating: 3 },
  { name: 'E17', rating: 3 },
  { name: 'E18', rating: 3 },
  { name: 'E19', rating: 3 },
  { name: 'E20', rating: 3 },
  { name: 'E21', rating: 3 },
  { name: 'E22', rating: 3 },
  { name: 'E23', rating: 3 },
  { name: 'E24', rating: 3 },
  { name: 'E25', rating: 3 },
  { name: 'E26', rating: 3 },
  { name: 'E27', rating: 3 },
  { name: 'E28', rating: 3 },
  { name: 'E29', rating: 3 },
  { name: 'E30', rating: 3 },
  { name: 'E31', rating: 3 },
  { name: 'E32', rating: 3 },
  { name: 'E33', rating: 3 },
  { name: 'E34', rating: 3 },
  { name: 'E35', rating: 3 },
  { name: 'E36', rating: 3 },
  { name: 'E37', rating: 3 },
  { name: 'E38', rating: 3 },
  { name: 'E39', rating: 3 },
  { name: 'E40', rating: 3 },
  { name: 'E41', rating: 3 },
  { name: 'E42', rating: 3 },
  { name: 'E43', rating: 3 },
  { name: 'E44', rating: 3 },
  { name: 'E45', rating: 3 },
  { name: 'E46', rating: 3 },
  { name: 'F00', rating: 3 },
  { name: 'F01', rating: 3 },
  { name: 'F02', rating: 3 },
  { name: 'F03', rating: 3 },
  { name: 'F04', rating: 3 },
  { name: 'F05', rating: 3 },
  { name: 'F06', rating: 3 },
  { name: 'F07', rating: 3 },
  { name: 'F08', rating: 3 },
  { name: 'F09', rating: 3 },
  { name: 'F10', rating: 3 },
  { name: 'F11', rating: 3 },
  { name: 'F12', rating: 3 },
  { name: 'F13', rating: 3 },
  { name: 'F14', rating: 3 },
  { name: 'F15', rating: 3 },
  { name: 'F16', rating: 3 },
  { name: 'F17', rating: 3 },
  { name: 'F18', rating: 3 },
  { name: 'F19', rating: 3 },
  { name: 'F20', rating: 3 },
  { name: 'F21', rating: 3 },
  { name: 'F22', rating: 3 },
  { name: 'F23', rating: 3 },
  { name: 'F24', rating: 3 },
  { name: 'F25', rating: 3 },
  { name: 'F26', rating: 3 },
  { name: 'F27', rating: 3 },
  { name: 'F28', rating: 3 },
  { name: 'F29', rating: 3 },
  { name: 'F30', rating: 3 },
  { name: 'F31', rating: 3 },
  { name: 'F32', rating: 3 },
  { name: 'F33', rating: 3 },
  { name: 'F34', rating: 3 },
  { name: 'F35', rating: 3 },
  { name: 'F36', rating: 3 },
  { name: 'F37', rating: 3 },
  { name: 'F38', rating: 3 },
  { name: 'F39', rating: 3 },
  { name: 'F40', rating: 3 },
  { name: 'F41', rating: 3 },
  { name: 'F42', rating: 3 },
  { name: 'F43', rating: 3 },
  { name: 'F44', rating: 3 },
  { name: 'F45', rating: 3 },
  { name: 'F46', rating: 3 },
  { name: 'G00', rating: 4 },
  { name: 'G01', rating: 4 },
  { name: 'G02', rating: 4 },
  { name: 'G03', rating: 4 },
  { name: 'G04', rating: 4 },
  { name: 'G05', rating: 4 },
  { name: 'G06', rating: 4 },
  { name: 'G07', rating: 4 },
  { name: 'G08', rating: 4 },
  { name: 'G09', rating: 4 },
  { name: 'G10', rating: 4 },
  { name: 'G11', rating: 4 },
  { name: 'G12', rating: 4 },
  { name: 'G13', rating: 4 },
  { name: 'G14', rating: 4 },
  { name: 'G15', rating: 4 },
  { name: 'G16', rating: 4 },
  { name: 'G17', rating: 4 },
  { name: 'G18', rating: 4 },
  { name: 'G19', rating: 4 },
  { name: 'G20', rating: 4 },
  { name: 'G21', rating: 4 },
  { name: 'G22', rating: 4 },
  { name: 'G23', rating: 4 },
  { name: 'G24', rating: 4 },
  { name: 'G25', rating: 4 },
  { name: 'G26', rating: 4 },
  { name: 'G27', rating: 4 },
  { name: 'G28', rating: 4 },
  { name: 'G29', rating: 4 },
  { name: 'G30', rating: 4 },
  { name: 'G31', rating: 4 },
  { name: 'G32', rating: 4 },
  { name: 'G33', rating: 4 },
  { name: 'G34', rating: 4 },
  { name: 'G35', rating: 4 },
  { name: 'G36', rating: 4 },
  { name: 'G37', rating: 4 },
  { name: 'G38', rating: 4 },
  { name: 'G39', rating: 4 },
  { name: 'G40', rating: 4 },
  { name: 'G41', rating: 4 },
  { name: 'G42', rating: 4 },
  { name: 'G43', rating: 4 },
  { name: 'G44', rating: 4 },
  { name: 'G45', rating: 4 },
  { name: 'G46', rating: 4 },
  { name: 'H00', rating: 3 },
  { name: 'H01', rating: 3 },
  { name: 'H02', rating: 3 },
  { name: 'H03', rating: 3 },
  { name: 'H04', rating: 3 },
  { name: 'H05', rating: 3 },
  { name: 'H06', rating: 3 },
  { name: 'H07', rating: 3 },
  { name: 'H08', rating: 3 },
  { name: 'H09', rating: 3 },
  { name: 'H10', rating: 3 },
  { name: 'H11', rating: 3 },
  { name: 'H12', rating: 3 },
  { name: 'H13', rating: 3 },
  { name: 'H14', rating: 3 },
  { name: 'H15', rating: 3 },
  { name: 'H16', rating: 3 },
  { name: 'H17', rating: 3 },
  { name: 'H18', rating: 3 },
  { name: 'H19', rating: 3 },
  { name: 'H20', rating: 3 },
  { name: 'H21', rating: 3 },
  { name: 'H22', rating: 3 },
  { name: 'H23', rating: 3 },
  { name: 'H24', rating: 3 },
  { name: 'H25', rating: 3 },
  { name: 'H26', rating: 3 },
  { name: 'H27', rating: 3 },
  { name: 'H28', rating: 3 },
  { name: 'H29', rating: 3 },
  { name: 'H30', rating: 3 },
  { name: 'H31', rating: 3 },
  { name: 'H32', rating: 3 },
  { name: 'H33', rating: 3 },
  { name: 'H34', rating: 3 },
  { name: 'H35', rating: 3 },
  { name: 'H36', rating: 3 },
  { name: 'H37', rating: 3 },
  { name: 'H38', rating: 3 },
  { name: 'H39', rating: 3 },
  { name: 'H40', rating: 3 },
  { name: 'H41', rating: 3 },
  { name: 'H42', rating: 3 },
  { name: 'H43', rating: 3 },
  { name: 'H44', rating: 3 },
  { name: 'H45', rating: 3 },
  { name: 'H46', rating: 3 },
  { name: 'I00', rating: 2 },
  { name: 'I01', rating: 2 },
  { name: 'I02', rating: 2 },
  { name: 'I03', rating: 2 },
  { name: 'I04', rating: 2 },
  { name: 'I05', rating: 2 },
  { name: 'I06', rating: 2 },
  { name: 'I07', rating: 2 },
  { name: 'I08', rating: 2 },
  { name: 'I09', rating: 2 },
  { name: 'I10', rating: 2 },
  { name: 'I11', rating: 2 },
  { name: 'I12', rating: 2 },
  { name: 'I13', rating: 2 },
  { name: 'I14', rating: 2 },
  { name: 'I15', rating: 2 },
  { name: 'I16', rating: 2 },
  { name: 'I17', rating: 2 },
  { name: 'I18', rating: 2 },
  { name: 'I19', rating: 2 },
  { name: 'I20', rating: 2 },
  { name: 'I21', rating: 2 },
  { name: 'I22', rating: 2 },
  { name: 'I23', rating: 2 },
  { name: 'I24', rating: 2 },
  { name: 'I25', rating: 2 },
  { name: 'I26', rating: 2 },
  { name: 'I27', rating: 2 },
  { name: 'I28', rating: 2 },
  { name: 'I29', rating: 2 },
  { name: 'I30', rating: 2 },
  { name: 'I31', rating: 2 },
  { name: 'I32', rating: 2 },
  { name: 'I33', rating: 2 },
  { name: 'I34', rating: 2 },
  { name: 'I35', rating: 2 },
  { name: 'I36', rating: 2 },
  { name: 'I37', rating: 2 },
  { name: 'I38', rating: 2 },
  { name: 'I39', rating: 2 },
  { name: 'I40', rating: 2 },
  { name: 'I41', rating: 2 },
  { name: 'I42', rating: 2 },
  { name: 'I43', rating: 2 },
  { name: 'I44', rating: 2 },
  { name: 'I45', rating: 2 },
  { name: 'I46', rating: 2 },
  { name: 'J00', rating: 2 },
  { name: 'J01', rating: 2 },
  { name: 'J02', rating: 2 },
  { name: 'J03', rating: 2 },
  { name: 'J04', rating: 2 },
  { name: 'J05', rating: 2 },
  { name: 'J06', rating: 2 },
  { name: 'J07', rating: 2 },
  { name: 'J08', rating: 2 },
  { name: 'J09', rating: 2 },
  { name: 'J10', rating: 2 },
  { name: 'J11', rating: 2 },
  { name: 'J12', rating: 2 },
  { name: 'J13', rating: 2 },
  { name: 'J14', rating: 2 },
  { name: 'J15', rating: 2 },
  { name: 'J16', rating: 2 },
  { name: 'J17', rating: 2 },
  { name: 'J18', rating: 2 },
  { name: 'J19', rating: 2 },
  { name: 'J20', rating: 2 },
  { name: 'J21', rating: 2 },
  { name: 'J22', rating: 2 },
  { name: 'J23', rating: 2 },
  { name: 'J24', rating: 2 },
  { name: 'J25', rating: 2 },
  { name: 'J26', rating: 2 },
  { name: 'J27', rating: 2 },
  { name: 'J28', rating: 2 },
  { name: 'J29', rating: 2 },
  { name: 'J30', rating: 2 },
  { name: 'J31', rating: 2 },
  { name: 'J32', rating: 2 },
  { name: 'J33', rating: 2 },
  { name: 'J34', rating: 2 },
  { name: 'J35', rating: 2 },
  { name: 'J36', rating: 2 },
  { name: 'J37', rating: 2 },
  { name: 'J38', rating: 2 },
  { name: 'J39', rating: 2 },
  { name: 'J40', rating: 2 },
  { name: 'J41', rating: 2 },
  { name: 'J42', rating: 2 },
  { name: 'J43', rating: 2 },
  { name: 'J44', rating: 2 },
  { name: 'J45', rating: 2 },
  { name: 'J46', rating: 2 },
  { name: 'K00', rating: 2 },
  { name: 'K01', rating: 2 },
  { name: 'K02', rating: 2 },
  { name: 'K03', rating: 2 },
  { name: 'K04', rating: 2 },
  { name: 'K05', rating: 2 },
  { name: 'K06', rating: 2 },
  { name: 'K07', rating: 2 },
  { name: 'K08', rating: 2 },
  { name: 'K09', rating: 2 },
  { name: 'K10', rating: 2 },
  { name: 'K11', rating: 2 },
  { name: 'K12', rating: 2 },
  { name: 'K13', rating: 2 },
  { name: 'K14', rating: 2 },
  { name: 'K15', rating: 2 },
  { name: 'K16', rating: 2 },
  { name: 'K17', rating: 2 },
  { name: 'K18', rating: 2 },
  { name: 'K19', rating: 2 },
  { name: 'K20', rating: 2 },
  { name: 'K21', rating: 2 },
  { name: 'K22', rating: 2 },
  { name: 'K23', rating: 2 },
  { name: 'K24', rating: 2 },
  { name: 'K25', rating: 2 },
  { name: 'K26', rating: 2 },
  { name: 'K27', rating: 2 },
  { name: 'K28', rating: 2 },
  { name: 'K29', rating: 2 },
  { name: 'K30', rating: 2 },
  { name: 'K31', rating: 2 },
  { name: 'K32', rating: 2 },
  { name: 'K33', rating: 2 },
  { name: 'K34', rating: 2 },
  { name: 'K35', rating: 2 },
  { name: 'K36', rating: 2 },
  { name: 'K37', rating: 2 },
  { name: 'K38', rating: 2 },
  { name: 'K39', rating: 2 },
  { name: 'K40', rating: 2 },
  { name: 'K41', rating: 2 },
  { name: 'K42', rating: 2 },
];
assert.sameValue(array.length, 513);

// Sort the elements by `rating` in descending order.
// (This updates `array` in place.)
array.sort((a, b) => b.rating - a.rating);

const reduced = array.reduce((acc, element) => {
  const letter = element.name.slice(0, 1);
  const previousLetter = acc.slice(-1);
  if (previousLetter === letter) {
    return acc;
  }
  return acc + letter;
}, '');
assert.sameValue(reduced, 'DGBEFHACIJK');

reportCompare(0, 0);
