/*
 * unity-webapps-action-tracker.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#include "unity-webapps-indicator-model-controller.h"

#include "../unity-webapps-debug.h"

struct _UnityWebappsIndicatorModelControllerPrivate {
  UnityWebappsIndicatorModel *model;
  UnityWebappsInterestManager *interest_manager;
};

enum {
  PROP_0,
  PROP_INDICATOR_MODEL,
  PROP_INTEREST_MANAGER
};

G_DEFINE_TYPE(UnityWebappsIndicatorModelController, unity_webapps_indicator_model_controller, G_TYPE_OBJECT)

#define UNITY_WEBAPPS_INDICATOR_MODEL_CONTROLLER_GET_PRIVATE(object) (G_TYPE_INSTANCE_GET_PRIVATE ((object), UNITY_WEBAPPS_TYPE_INDICATOR_MODEL_CONTROLLER, UnityWebappsIndicatorModelControllerPrivate))

static void
unity_webapps_indicator_model_controller_dispose (GObject *object)
{
  UnityWebappsIndicatorModelController *controller;
  
  controller = UNITY_WEBAPPS_INDICATOR_MODEL_CONTROLLER (object);
  
  if (controller->priv->interest_manager)
    g_object_unref (controller->priv->interest_manager);
  if (controller->priv->model)
    g_object_unref (controller->priv->model);
}

static void
unity_webapps_indicator_model_controller_finalize (GObject *object)
{
  
}

static void
unity_webapps_indicator_model_controller_get_property (GObject *object,
						       guint prop_id,
						       GValue *value,
						       GParamSpec *pspec)
{
  UnityWebappsIndicatorModelController *controller;
  
  controller = UNITY_WEBAPPS_INDICATOR_MODEL_CONTROLLER (object);
  
  switch (prop_id)
    {
    case PROP_INDICATOR_MODEL:
      g_value_set_object (value, controller->priv->model);
      break;
    case PROP_INTEREST_MANAGER:
      g_value_set_object (value, controller->priv->interest_manager);
      break;      
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
unity_webapps_indicator_model_controller_interest_removed (UnityWebappsInterestManager *manager,
							   UnityWebappsInterest *interest,
							   gpointer user_data)
{
  UnityWebappsIndicatorModelController *controller;
  
  controller = (UnityWebappsIndicatorModelController *)user_data;
  
  unity_webapps_indicator_model_clear_indicators_for_interest (controller->priv->model, interest->id);
}

static void
unity_webapps_indicator_model_controller_setup_interest_manager (UnityWebappsIndicatorModelController *controller)
{
  g_signal_connect_object (controller->priv->interest_manager,
			   "interest-removed",
			   G_CALLBACK(unity_webapps_indicator_model_controller_interest_removed),
			   controller, 0);
}

static void
unity_webapps_indicator_model_controller_set_property (GObject *object,
						       guint prop_id,
						       const GValue *value,
						       GParamSpec *pspec)
{
  UnityWebappsIndicatorModelController *controller;
  
  controller = UNITY_WEBAPPS_INDICATOR_MODEL_CONTROLLER (object);
  
  switch (prop_id)
    {
    case PROP_INDICATOR_MODEL:
      g_return_if_fail (controller->priv->model == NULL);
      controller->priv->model = g_value_dup_object (value);
      break;
    case PROP_INTEREST_MANAGER:
      g_return_if_fail (controller->priv->interest_manager == NULL);
      controller->priv->interest_manager = g_value_dup_object (value);
      
      unity_webapps_indicator_model_controller_setup_interest_manager (controller);
      break;      
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
unity_webapps_indicator_model_controller_class_init (UnityWebappsIndicatorModelControllerClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  
  object_class->finalize = unity_webapps_indicator_model_controller_finalize;
  object_class->dispose = unity_webapps_indicator_model_controller_dispose;

  object_class->get_property = unity_webapps_indicator_model_controller_get_property;
  object_class->set_property = unity_webapps_indicator_model_controller_set_property;
  
  g_type_class_add_private (object_class, sizeof(UnityWebappsIndicatorModelControllerPrivate));
  
  g_object_class_install_property (object_class, PROP_INDICATOR_MODEL,
				   g_param_spec_object ("model",
							"Model",
							"The UnityWebappsIndicatorModel for the controller",
							UNITY_WEBAPPS_TYPE_INDICATOR_MODEL,
							G_PARAM_READWRITE |
							G_PARAM_CONSTRUCT_ONLY |
							G_PARAM_STATIC_STRINGS));

  g_object_class_install_property (object_class, PROP_INTEREST_MANAGER,
				   g_param_spec_object ("interest-manager",
							"Interest manager",
							"The UnityWebappsInterestManager for the controller",
							UNITY_WEBAPPS_TYPE_INTEREST_MANAGER, 
							G_PARAM_READWRITE |
							G_PARAM_CONSTRUCT_ONLY |
							G_PARAM_STATIC_STRINGS));
							
}

static void
unity_webapps_indicator_model_controller_init (UnityWebappsIndicatorModelController *tracker)
{
  tracker->priv = UNITY_WEBAPPS_INDICATOR_MODEL_CONTROLLER_GET_PRIVATE (tracker);
  
  tracker->priv->model = NULL;
  tracker->priv->interest_manager = NULL;
}

UnityWebappsIndicatorModelController *
unity_webapps_indicator_model_controller_new (UnityWebappsIndicatorModel *model, 
					      UnityWebappsInterestManager *manager)
{
  return g_object_new (UNITY_WEBAPPS_TYPE_INDICATOR_MODEL_CONTROLLER, 
		       "model", model,
		       "interest-manager", manager,
		       NULL);
}

UnityWebappsIndicatorModel *
unity_webapps_indicator_model_controller_get_model (UnityWebappsIndicatorModelController *controller)
{
  g_return_val_if_fail (UNITY_WEBAPPS_IS_INDICATOR_MODEL_CONTROLLER (controller), NULL);
  
  return controller->priv->model;
}

UnityWebappsInterestManager *
unity_webapps_indicator_model_controller_get_interest_manager (UnityWebappsIndicatorModelController *controller)
{
  g_return_val_if_fail (UNITY_WEBAPPS_IS_INDICATOR_MODEL_CONTROLLER (controller), NULL);
  
  return controller->priv->interest_manager;
}
