/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SVL_AEITEM_HXX
#define INCLUDED_SVL_AEITEM_HXX

#include <svl/svldllapi.h>
#include <svl/eitem.hxx>

#include <cstddef>
#include <memory>
#include <vector>

class SVL_DLLPUBLIC SfxAllEnumItem final : public SfxPoolItem
{
    std::vector<OUString>   m_Values;

public:
    explicit                SfxAllEnumItem( sal_uInt16 nWhich);
                            SfxAllEnumItem( const SfxAllEnumItem & );
                            virtual ~SfxAllEnumItem() override;

    void                    SetTextByPos( sal_uInt16 nPos, const OUString &rText );
    OUString const &        GetTextByPos( sal_uInt16 nPos ) const;
    sal_Int32               GetTextCount() const;
    virtual SfxPoolItem*    Clone( SfxItemPool *pPool = nullptr ) const override;
    virtual bool            operator==( SfxPoolItem const & ) const override;
};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
