/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef _GLTF_TYPES_H
#define _GLTF_TYPES_H

#define LIBGLTF_SUCCESS                    0
#define LIBGLTF_INVALID_SIZE              -1
#define LIBGLTF_CREATE_FBO_ERROR          -2
#define LIBGLTF_BIND_FBO_ERROR            -3

#define LIBGLTF_PARSE_JSON_ERROR          -8
#define LIBGLTF_PARSE_CAMERA_ERROR        -9
#define LIBGLTF_PARSE_LIGHT_ERROR         -10
#define LIBGLTF_PARSE_NODE_ERROR          -11
#define LIBGLTF_PARSE_MESH_ERROR          -12
#define LIBGLTF_PARSE_MATERIAL_ERROR      -13
#define LIBGLTF_PARSE_ATTRIBUTE_ERROR     -14
#define LIBGLTF_PARSE_TECHNIQUE_ERROR     -15
#define LIBGLTF_PARSE_ANIMATION_ERROR     -16
#define LIBGLTF_PARSE_SKIN_ERROR          -17

#define LIBGLTF_SHADER_ERROR              -32
#define LIBGLTF_SHADER_NOT_FOUND          -33
#define LIBGLTF_FILE_NOT_LOAD             -34

#define LIBGLTF_MEMORY_ERROR              -64
#define LIBGLTF_UNKNOWN_BOOST_ERROR      -128
#define LIBGLTF_UNKNOWN_ERROR            -256

#include <string>

namespace libgltf
{

enum glTFFileType { GLTF_NONE, GLTF_JSON, GLTF_BINARY, GLTF_IMAGE, GLTF_GLSL };

struct glTFViewport
{
    int x;
    int y;
    int width;
    int height;
};

struct glTFFile
{
    glTFFileType type;
    std::string filename;
    char* buffer;   // It is the file content in general, but when type is GLTF_IMAGE, then it must contain bitmap.
    size_t size;
    int imageheight;
    int imagewidth;

    glTFFile();

    // Shallow copy! Copy methods are defined mainly to allow to use STL containers.
    glTFFile(const glTFFile& copy);
    glTFFile& operator=(const glTFFile& copy);
};

struct glTFHandle
{
    glTFViewport viewport;
    void*        renderer;
};

} // namespace libgltf

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
