/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef EBOOKSTREAMSLICE_H_INCLUDED
#define EBOOKSTREAMSLICE_H_INCLUDED

#include <libwpd-stream/libwpd-stream.h>

namespace libebook
{

/** A stream representing a slice of (or view into) another stream.
  *
  * The purpose of this class is only to simplify reading of chunks of
  * data from the original stream. All reading operations change the
  * original stream. That means that it is not advisable to use the
  * original stream while a slice of it is in use too.
  */
class EBOOKStreamSlice : public WPXInputStream
{
  // -Weffc++
  EBOOKStreamSlice(const EBOOKStreamSlice &other);
  EBOOKStreamSlice &operator=(const EBOOKStreamSlice &other);

public:
  EBOOKStreamSlice(WPXInputStream *stream, long begin, long end);
  virtual ~EBOOKStreamSlice();

  virtual bool isOLEStream();
  virtual WPXInputStream *getDocumentOLEStream(const char *name);

  virtual const unsigned char *read(unsigned long numBytes, unsigned long &numBytesRead);
  virtual int seek(long offset, WPX_SEEK_TYPE seekType);
  virtual long tell();
  virtual bool atEOS();

private:
  WPXInputStream *const m_stream;
  const long m_begin;
  const long m_end;
};

}

#endif // EBOOKSTREAMSLICE_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
