/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import javax.xml.parsers.SAXParser;
import javax.xml.validation.Validator;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.ManifestEntry;
import org.odftoolkit.odfvalidator.ManifestEntryListener;
import org.odftoolkit.odfvalidator.ManifestFilter;
import org.odftoolkit.odfvalidator.ODFPackageErrorHandler;
import org.odftoolkit.odfvalidator.ODFPackageValidator;
import org.odftoolkit.odfvalidator.ODFSubPackageValidator;
import org.odftoolkit.odfvalidator.ODFValidatorException;
import org.odftoolkit.odfvalidator.ODFValidatorProvider;
import org.odftoolkit.odfvalidator.OdfValidatorMode;
import org.odftoolkit.odfvalidator.OdfVersion;
import org.odftoolkit.odfvalidator.SAXParseExceptionFilter;
import org.odftoolkit.odfvalidator.SAXVersionException;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

abstract class ODFRootPackageValidator
extends ODFPackageValidator
implements ManifestEntryListener {
    private OdfPackage m_aPkg = null;
    private ArrayList<ManifestEntry> m_aSubDocs = null;
    private ODFPackageErrorHandler m_ErrorHandler = null;

    protected ODFRootPackageValidator(Logger.LogLevel nLogLevel, OdfValidatorMode eMode, OdfVersion aVersion, SAXParseExceptionFilter aFilter, ODFValidatorProvider aValidatorProvider) {
        super(nLogLevel, eMode, aVersion, aFilter, aValidatorProvider);
    }

    protected abstract OdfPackage getPackage(ErrorHandler var1) throws Exception;

    protected abstract byte[] getBytes() throws IOException;

    private Integer lastIndexOf(byte[] haystack, byte[] needle) {
        assert (needle != null);
        assert (haystack != null);
        assert (needle.length > 0);
        assert (haystack.length >= needle.length);
        block0: for (int i = haystack.length - needle.length; 0 <= i; --i) {
            if (haystack[i] != needle[0]) continue;
            for (int j = 1; j < needle.length; ++j) {
                if (haystack[i + j] != needle[j]) continue block0;
            }
            return i;
        }
        return null;
    }

    private Integer findEndOfCD(byte[] file) throws IOException {
        byte[] endSig = new byte[]{80, 75, 5, 6};
        Integer sigPos = this.lastIndexOf(file, endSig);
        return sigPos;
    }

    private WishJavaHadTuples getFileHeader(ByteBuffer buf, int pos) throws IOException {
        if (buf.getInt(pos) != 33639248) {
            return null;
        }
        ZipEntry ret = new ZipEntry();
        ret.compressed = (buf.getShort(pos + 10) & 8) != 0;
        ret.crc = buf.getInt(pos + 16);
        ret.size = buf.getInt(pos + 20);
        short fileNameLength = buf.getShort(pos + 28);
        short extraFieldLength = buf.getShort(pos + 30);
        short fileCommentLength = buf.getShort(pos + 32);
        ret.offset = buf.getInt(pos + 42);
        ret.name = new String(buf.array(), pos + 46, (int)fileNameLength, StandardCharsets.UTF_8);
        return new WishJavaHadTuples(ret, pos + 46 + fileNameLength + extraFieldLength + fileCommentLength);
    }

    private List<ZipEntry> readEntries(byte[] file) throws IOException {
        Integer i = this.findEndOfCD(file);
        if (i == null || file.length < i + 20) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(file).order(ByteOrder.LITTLE_ENDIAN);
        int cdSize = bb.getInt(i + 12);
        int cdOffset = bb.getInt(i + 16);
        bb = ByteBuffer.wrap(file).order(ByteOrder.LITTLE_ENDIAN);
        ArrayList<ZipEntry> results = new ArrayList<ZipEntry>();
        try {
            WishJavaHadTuples result = this.getFileHeader(bb, cdOffset);
            while (result != null) {
                results.add(result.entry);
                if (result.pos < cdOffset + cdSize) {
                    result = this.getFileHeader(bb, result.pos);
                    continue;
                }
                break;
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return results;
    }

    private InputStream readEntry(byte[] file, ZipEntry entry) throws IOException {
        short fileNameLength = (short)(Byte.toUnsignedInt(file[entry.offset + 27]) << 8 | Byte.toUnsignedInt(file[entry.offset + 26]));
        short extraFieldLength = (short)(Byte.toUnsignedInt(file[entry.offset + 29]) << 8 | Byte.toUnsignedInt(file[entry.offset + 28]));
        ByteArrayInputStream stream = new ByteArrayInputStream(file, entry.offset + 30 + fileNameLength + extraFieldLength, entry.size);
        if (entry.compressed) {
            return new InflaterInputStream(stream, new Inflater(true));
        }
        return stream;
    }

    protected String getVersionFromManifest(Logger logger, InputStream stream) throws ODFValidatorException {
        String version = null;
        SAXParser parser = this.getSAXParser(false);
        ManifestVersionHandler handler = new ManifestVersionHandler();
        try {
            parser.parse(stream, (DefaultHandler)handler);
        }
        catch (SAXVersionException e) {
            version = e.getVersion();
        }
        catch (SAXException e) {
            logger.logFatalError(e.getMessage());
        }
        catch (IOException e) {
            logger.logFatalError(e.getMessage());
        }
        return version;
    }

    protected void fallbackValidateManifest(Logger logger) {
        try {
            byte[] file = this.getBytes();
            List<ZipEntry> entries = this.readEntries(file);
            for (ZipEntry entry : entries) {
                if (!entry.name.equals(OdfPackage.OdfFile.MANIFEST.getPath())) continue;
                InputStream stream = this.readEntry(file, entry);
                String versionString = this.getVersionFromManifest(logger, stream);
                logger.logInfo("ODF version of manifest: \"" + versionString + "\"", false);
                OdfVersion version = OdfVersion.valueOf(versionString, true);
                stream = this.readEntry(file, entry);
                ManifestFilter filter = new ManifestFilter(logger, this.m_aResult, this);
                Validator manifestValidator = this.m_aValidatorProvider.getManifestValidator(logger.getOutputStream(), version);
                this.validate(stream, filter, manifestValidator, logger);
                return;
            }
        }
        catch (Exception e) {
            logger.logWarning("fallbackValidateManifest Exception:\n" + e);
        }
    }

    @Override
    protected OdfPackage getPackage(Logger aLogger) {
        if (this.m_aPkg == null) {
            try {
                this.m_ErrorHandler = new ODFPackageErrorHandler();
                this.m_aPkg = this.getPackage(this.m_ErrorHandler);
                try {
                    OdfDocument.loadDocument(this.m_aPkg, "");
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                if (e.getMessage().endsWith("only DEFLATED entries can have EXT descriptor")) {
                    aLogger.logFatalError(e.getMessage());
                    aLogger.logFatalError("The document is encrypted. Validation of encrypted documents is not supported.");
                    Logger aManifestLogger = new Logger(OdfPackage.OdfFile.MANIFEST.getPath(), aLogger);
                    this.fallbackValidateManifest(aManifestLogger);
                    aLogger.logSummaryInfo();
                } else {
                    aLogger.logFatalError(e.getMessage());
                }
            }
            catch (Exception e) {
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                aLogger.logFatalError(e.getMessage() + "\n" + errors.toString());
            }
        }
        return this.m_aPkg;
    }

    @Override
    protected String getStreamName(String aEntry) {
        return aEntry;
    }

    @Override
    protected boolean validatePre(Logger aLogger, OdfVersion aVersion) throws ODFValidatorException, IOException {
        Logger aManifestLogger = new Logger(OdfPackage.OdfFile.MANIFEST.getPath(), aLogger);
        Logger aMimetypeLogger = new Logger("mimetype", aLogger);
        this.m_aPkg.getFilePaths();
        boolean bErrorsFound = this.m_ErrorHandler.processErrors(aLogger, aManifestLogger, aMimetypeLogger, aVersion);
        bErrorsFound |= this.validateMimetype(aMimetypeLogger, aVersion);
        aMimetypeLogger.logSummaryInfo();
        return bErrorsFound |= this.validateManifest(aManifestLogger, aVersion);
    }

    @Override
    protected boolean validatePost(Logger aLogger, OdfVersion aVersion) throws ODFValidatorException, IOException {
        boolean bHasErrors = false;
        if (this.m_aSubDocs != null) {
            for (ManifestEntry aEntry : this.m_aSubDocs) {
                ODFSubPackageValidator aPackageValidator = new ODFSubPackageValidator(this.getPackage(aLogger), this.getLoggerName(), aEntry.getFullPath(), aEntry.getMediaType(), this.m_nLogLevel, this.m_eMode, this.m_aConfigVersion, this.m_aFilter, this.m_aResult.getGenerator(), this.m_aValidatorProvider);
                bHasErrors |= aPackageValidator.validate(aLogger);
            }
        }
        if (aVersion.compareTo(OdfVersion.V1_2) >= 0) {
            bHasErrors |= this.validateDSig(aLogger, "META-INF/documentsignatures.xml", aVersion);
            bHasErrors |= this.validateDSig(aLogger, "META-INF/macrosignatures.xml", aVersion);
        }
        return bHasErrors;
    }

    @Override
    protected void logSummary(boolean bHasErrors, Logger aLogger) {
        aLogger.logSummaryInfo();
        if ((bHasErrors || aLogger.hasError()) && this.m_nLogLevel.compareTo(Logger.LogLevel.INFO) < 0) {
            aLogger.logInfo("Generator: " + this.m_aResult.getGenerator(), true);
        }
    }

    @Override
    public void foundManifestEntry(ManifestEntry aManifestEntry) {
        if (aManifestEntry.isOpenDocumentMediaType()) {
            if (this.m_aSubDocs == null) {
                this.m_aSubDocs = new ArrayList();
            }
            this.m_aSubDocs.add(aManifestEntry);
        }
    }

    private boolean validateMimetype(Logger aLogger, OdfVersion aVersion) {
        boolean bHasErrors = false;
        String aMimetype = this.getPackage(aLogger).getMediaTypeString();
        if (aMimetype == null || aMimetype.length() == 0) {
            aLogger.logFatalError("file is not a zip file, or has no mimetype.");
            bHasErrors = true;
        } else if (!(aMimetype.equals("application/vnd.oasis.opendocument.text") || aMimetype.equals("application/vnd.oasis.opendocument.text-template") || aMimetype.equals("application/vnd.oasis.opendocument.graphics") || aMimetype.equals("application/vnd.oasis.opendocument.graphics-template") || aMimetype.equals("application/vnd.oasis.opendocument.presentation") || aMimetype.equals("application/vnd.oasis.opendocument.spreadsheet") || aMimetype.equals("application/vnd.oasis.opendocument.spreadsheet-template") || aMimetype.equals("application/vnd.oasis.opendocument.chart") || aMimetype.equals("application/vnd.oasis.opendocument.chart-template") || aMimetype.equals("application/vnd.oasis.opendocument.image") || aMimetype.equals("application/vnd.oasis.opendocument.image-template") || aMimetype.equals("application/vnd.oasis.opendocument.formula") || aMimetype.equals("application/vnd.oasis.opendocument.formula-template") || aMimetype.equals("application/vnd.oasis.opendocument.text-master") || aMimetype.equals("application/vnd.oasis.opendocument.text-web"))) {
            aLogger.logInfo("mimetype is not an ODFMediaTypes mimetype.", false);
            bHasErrors = true;
        }
        return bHasErrors;
    }

    private boolean validateManifest(Logger aLogger, OdfVersion aVersion) throws IOException, ZipException, IllegalStateException, ODFValidatorException {
        boolean bRet;
        ManifestFilter aFilter = new ManifestFilter(aLogger, this.m_aResult, this);
        Validator aManifestValidator = this.m_aValidatorProvider.getManifestValidator(aLogger.getOutputStream(), aVersion);
        if (aManifestValidator != null) {
            bRet = this.validateEntry(aFilter, aManifestValidator, aLogger, OdfPackage.OdfFile.MANIFEST.getPath());
        } else {
            aLogger.logInfo("Validation of " + OdfPackage.OdfFile.MANIFEST.getPath() + " skipped.", false);
            bRet = this.parseEntry(aFilter, aLogger, OdfPackage.OdfFile.MANIFEST.getPath(), false);
        }
        return bRet;
    }

    class ManifestVersionHandler
    extends DefaultHandler {
        private static final String NAMESPACE_URI = "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0";
        private static final String ROOT = "manifest";
        private static final String VERSION = "version";

        ManifestVersionHandler() {
        }

        @Override
        public void startElement(String aUri, String aLocalName, String aQName, Attributes aAttributes) throws SAXException {
            super.startElement(aUri, aLocalName, aQName, aAttributes);
            if (aUri.equals(NAMESPACE_URI) && aLocalName.equalsIgnoreCase(ROOT)) {
                String aVersion = aAttributes.getValue(NAMESPACE_URI, VERSION);
                throw new SAXVersionException(aVersion);
            }
        }
    }

    class WishJavaHadTuples {
        ZipEntry entry;
        int pos;

        WishJavaHadTuples(ZipEntry a, int b) {
            this.entry = a;
            this.pos = b;
        }
    }

    class ZipEntry {
        String name;
        int offset;
        int size;
        int crc;
        boolean compressed;

        ZipEntry() {
        }
    }
}

