package main;

use strict;
use warnings;

use lib qw{ inc };

use PPIx::Regexp::Test;

# NOTE: It is intended that all individual tests in this file be
# generated by PPIx::Regexp::Dumper. Special tests should go in
# t/unit.t.

tokenize( '' );
count   ( 0 );

parse   ( '' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 0 );

tokenize( 'fubar' );
count   ( 1 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( 'fubar' );

parse   ( 'fubar' );
value   ( failures => [], 1);
class   ( 'PPIx::Regexp' );
count   ( 1 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( 'fubar' );

tokenize( '/(/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(/' );
value   ( failures => [], 1);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 0 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( undef );
content ( undef );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/)/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/)/' );
value   ( failures => [], 1);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Unmatched' );
content ( ')' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm//' );
count   ( 4 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm//' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 0 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr\'\'' );
count   ( 4 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\'' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\'' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr\'\'' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 0 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\'' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\'' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr /foo/' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr /foo/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 4 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
choose  ( child => 2, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 2, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 2, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm{}' );
count   ( 4 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm{}' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 0 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm{}smx' );
count   ( 4 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

parse   ( 'm{}smx' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 0 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

tokenize( 'm{foo}' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm{foo}' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/m{foo\\t\\0334\\o{61}\\cK\\xBB\\_\\{\\}\\!/' );
count   ( 19 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'm' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\t' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\033' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 4 );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\o{61}' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\cK' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\xBB' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\_' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\{' );
choose  ( 15 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\}' );
choose  ( 16 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\!' );
choose  ( 17 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 18 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/m{foo\\t\\0334\\o{61}\\cK\\xBB\\_\\{\\}\\!/' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 15 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'm' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '{' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\t' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\033' );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 4 );
choose  ( child => 1, child => 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\o{61}' );
choose  ( child => 1, child => 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\cK' );
choose  ( child => 1, child => 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\xBB' );
choose  ( child => 1, child => 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\_' );
choose  ( child => 1, child => 12 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\{' );
choose  ( child => 1, child => 13 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\}' );
choose  ( child => 1, child => 14 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\!' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/\\\\{/' );
count   ( 6 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/\\\\{/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '{' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/\\N{LATIN SMALL LETTER A}/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\N{LATIN SMALL LETTER A}' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/\\N{LATIN SMALL LETTER A}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\N{LATIN SMALL LETTER A}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/\\C{4}/' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\C' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 4 );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/\\C{4}/' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\C' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 1 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 4 );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(\\C)/' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\C' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(\\C)/' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\C' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr{foo+}' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr{foo+}' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr{foo?}' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr{foo?}' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr{foo*}' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr{foo*}' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr{foo*bar+}' );
count   ( 12 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr{foo*bar+}' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 8 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr{+}' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( '+' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr{+}' );
value   ( failures => [], 1);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( '+' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr/foo{3}/' );
count   ( 10 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '3' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr/foo{3}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 1 );
choose  ( child => 1, child => 3, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 3, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 3, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr/foo{3,}/' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '3' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr/foo{3,}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 2 );
choose  ( child => 1, child => 3, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 3, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 3, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( child => 1, child => 3, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr/foo{3,5}/' );
count   ( 12 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '3' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '5' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr/foo{3,5}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 3 );
choose  ( child => 1, child => 3, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 3, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 3, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( child => 1, child => 3, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( child => 1, child => 3, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 5 );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr/foo{3,$bar}/' );
count   ( 12 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$bar' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr/foo{3,$bar}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 3 );
choose  ( child => 1, child => 3, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 3, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 3, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( child => 1, child => 3, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( child => 1, child => 3, child => 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$bar' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr/foo{,3}/' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '3' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr/foo{,3}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 7 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '{' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/{}/' );
count   ( 6 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/{}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '{' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/x{}/' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/x{}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '{' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/{2}/' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '2' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/{2}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '{' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 2 );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/f{oo/' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/f{oo/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '{' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(f{oo)/' );
count   ( 10 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(f{oo)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 4 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '{' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/{?+}/' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( '+' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/{?+}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '{' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Greediness' );
content ( '+' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/./' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '.' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/./' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '.' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/\\\\d{3,5}+.*?/' );
count   ( 15 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'd' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '3' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '5' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Greediness' );
content ( '+' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '.' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Greediness' );
content ( '?' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/\\\\d{3,5}+.*?/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 7 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'd' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 3 );
choose  ( child => 1, child => 2, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 2, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( child => 1, child => 2, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( child => 1, child => 2, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 5 );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Greediness' );
content ( '+' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '.' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Greediness' );
content ( '?' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/\\w+\\W*\\s?\\S\\d\\D\\v\\V\\h\\H/' );
count   ( 17 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\W' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\s' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\S' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\d' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\D' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\v' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\V' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\h' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\H' );
choose  ( 15 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 16 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/\\w+\\W*\\s?\\S\\d\\D\\v\\V\\h\\H/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 13 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\W' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\s' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\S' );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\d' );
choose  ( child => 1, child => 8 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\D' );
choose  ( child => 1, child => 9 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\v' );
choose  ( child => 1, child => 10 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\V' );
choose  ( child => 1, child => 11 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\h' );
choose  ( child => 1, child => 12 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\H' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/\\p{Punctuation}/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\p{Punctuation}' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/\\p{Punctuation}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\p{Punctuation}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/\\p{My::InEvenChars}/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\p{My::InEvenChars}' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/\\p{My::InEvenChars}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\p{My::InEvenChars}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/foo bar/' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/foo bar/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 7 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/foo bar/x' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

parse   ( 'm/foo bar/x' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 7 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

tokenize( '/$foo/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/$foo/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/${foo}/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '${foo}' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/${foo}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '${foo}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm\'$foo\'' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\'' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\'' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm\'$foo\'' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\'' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\'' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/A $foo{bar} baz/' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'A' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo{bar}' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/A $foo{bar} baz/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 7 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'A' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo{bar}' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/A $foo{3} baz/' );
count   ( 14 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'A' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '3' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/A $foo{3} baz/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 8 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'A' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 1 );
choose  ( child => 1, child => 3, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 3, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 3, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/A @{[ scalar time ]} baz/' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'A' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '@{[ scalar time ]}' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/A @{[ scalar time ]} baz/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 7 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'A' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '@{[ scalar time ]}' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/[$foo]/' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/[$foo]/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 's/([\\x00-\\x1f])/$UNPRINTABLE[ord($1)]/g' );
count   ( 13 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\x00' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '-' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\x1f' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$UNPRINTABLE[ord($1)]' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'g' );

parse   ( 's/([\\x00-\\x1f])/$UNPRINTABLE[ord($1)]/g' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 4 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 1 );
choose  ( child => 1, child => 0, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Node::Range' );
count   ( 3 );
choose  ( child => 1, child => 0, child => 0, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\x00' );
choose  ( child => 1, child => 0, child => 0, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '-' );
choose  ( child => 1, child => 0, child => 0, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\x1f' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Structure::Replacement' );
count   ( 1 );
choose  ( child => 2, start => [] );
count   ( 0 );
choose  ( child => 2, type => [] );
count   ( 0 );
choose  ( child => 2, finish => [] );
count   ( 1 );
choose  ( child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 2, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$UNPRINTABLE[ord($1)]' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'g' );

tokenize( 's/$$foo{bar}/$$bar{foo}/' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$$foo{bar}' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$$bar{foo}' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 's/$$foo{bar}/$$bar{foo}/' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 4 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$$foo{bar}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Structure::Replacement' );
count   ( 1 );
choose  ( child => 2, start => [] );
count   ( 0 );
choose  ( child => 2, type => [] );
count   ( 0 );
choose  ( child => 2, finish => [] );
count   ( 1 );
choose  ( child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 2, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$$bar{foo}' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/a|b/' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/a|b/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/$|$($)@+@-/' );
count   ( 14 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '@' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '@' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '-' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/$|$($)@+@-/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 8 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
choose  ( child => 1, child => 3, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 3, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 3, child => 0 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '@' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '@' );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '-' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/$-$+$$$[$]$-[0]$+[0]$-{foo}$+{foo}/' );
count   ( 13 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$-' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$+' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$$' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$[' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$]' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$-[0]' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$+[0]' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$-{foo}' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$+{foo}' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/$-$+$$$[$]$-[0]$+[0]$-{foo}$+{foo}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 9 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$-' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$+' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$$' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$[' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$]' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$-[0]' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$+[0]' );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$-{foo}' );
choose  ( child => 1, child => 8 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$+{foo}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/\\Q\\w$foo\\\\E\\E/' );
count   ( 10 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\Q' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\w' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'E' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\E' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/\\Q\\w$foo\\\\E\\E/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 6 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\Q' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\w' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'E' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\E' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/\\lX\\uy\\LFOO\\Ubar\\Q.^\\E/' );
count   ( 20 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\l' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'X' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\u' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\L' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'F' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'O' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'O' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\U' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\Q' );
choose  ( 15 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '.' );
choose  ( 16 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '^' );
choose  ( 17 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\E' );
choose  ( 18 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 19 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/\\lX\\uy\\LFOO\\Ubar\\Q.^\\E/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 16 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\l' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'X' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\u' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'y' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\L' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'F' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'O' );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'O' );
choose  ( child => 1, child => 8 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\U' );
choose  ( child => 1, child => 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 1, child => 12 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\Q' );
choose  ( child => 1, child => 13 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '.' );
choose  ( child => 1, child => 14 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '^' );
choose  ( child => 1, child => 15 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\E' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/$foo?/' );
count   ( 6 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/$foo?/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/$#foo/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$#foo' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/$#foo/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$#foo' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/$#$foo{3}/' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$#$foo' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/$#$foo{3}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$#$foo' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 1 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/$#{^_foo}{4}/' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$#{^_foo}' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 4 );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/$#{^_foo}{4}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$#{^_foo}' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 1 );
choose  ( child => 1, child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 4 );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/foo\\Ub\\wr\\Ebaz/' );
count   ( 15 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\U' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\E' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/foo\\Ub\\wr\\Ebaz/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 11 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\U' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\E' );
choose  ( child => 1, child => 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/\\Fu/' );
count   ( 6 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\F' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'u' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/\\Fu/' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Control' );
content ( '\\F' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'u' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/ foo (?# match foo )+/' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Comment' );
content ( '(?# match foo )' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/ foo (?# match foo )+/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 7 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Comment' );
content ( '(?# match foo )' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/ foo # match foo
/smx' );
count   ( 10 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Comment' );
content ( '# match foo
' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

parse   ( 'm/ foo # match foo
/smx' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 5 );
choose  ( child => 1, start => [] );
count   ( 2 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, start => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Comment' );
content ( '# match foo
' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

tokenize( '/^#/x' );
count   ( 6 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '^' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Comment' );
content ( '#' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

parse   ( '/^#/x' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '^' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Comment' );
content ( '#' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

tokenize( 'm/[# ]/x' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '#' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

parse   ( 'm/[# ]/x' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 2 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '#' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

tokenize( '/(?<foo>x)\\1?\\g{-1}*\\k<foo>{1,3}+/' );
count   ( 19 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?<foo>' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\1' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\g{-1}' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\k<foo>' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 1 );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( 15 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 16 );
class   ( 'PPIx::Regexp::Token::Greediness' );
content ( '+' );
choose  ( 17 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 18 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?<foo>x)\\1?\\g{-1}*\\k<foo>{1,3}+/' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 8 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::NamedCapture' );
count   ( 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?<foo>' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\1' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\g{-1}' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\k<foo>' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 3 );
choose  ( child => 1, child => 6, start => [] );
count   ( 1 );
choose  ( child => 1, child => 6, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 6, type => [] );
count   ( 0 );
choose  ( child => 1, child => 6, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 6, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 6, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 1 );
choose  ( child => 1, child => 6, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( child => 1, child => 6, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::Greediness' );
content ( '+' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?<foo>x)\\1?\\g{-1}*\\k<foo>{1,3}+/' );
count   ( 19 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?<foo>' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\1' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\g{-1}' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\k<foo>' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 1 );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( 15 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 16 );
class   ( 'PPIx::Regexp::Token::Greediness' );
content ( '+' );
choose  ( 17 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 18 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?<foo>x)\\1?\\g{-1}*\\k<foo>{1,3}+/' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 8 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::NamedCapture' );
count   ( 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?<foo>' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\1' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\g{-1}' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\k<foo>' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Structure::Quantifier' );
count   ( 3 );
choose  ( child => 1, child => 6, start => [] );
count   ( 1 );
choose  ( child => 1, child => 6, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '{' );
choose  ( child => 1, child => 6, type => [] );
count   ( 0 );
choose  ( child => 1, child => 6, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 6, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( child => 1, child => 6, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 1 );
choose  ( child => 1, child => 6, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ',' );
choose  ( child => 1, child => 6, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 3 );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::Greediness' );
content ( '+' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 's/(foo)/\\1bar/g' );
count   ( 14 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\1' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'g' );

parse   ( 's/(foo)/\\1bar/g' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 4 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 3 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Structure::Replacement' );
count   ( 4 );
choose  ( child => 2, start => 0 );
class   ( undef );
content ( undef );
choose  ( child => 2, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 2, child => 0 );
class   ( 'PPIx::Regexp::Token::Backreference' );
content ( '\\1' );
choose  ( child => 2, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 2, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 2, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'g' );

tokenize( 's/x/$1/e' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Code' );
content ( '$1' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'e' );

parse   ( 's/x/$1/e' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 4 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Structure::Replacement' );
count   ( 1 );
choose  ( child => 2, start => [] );
count   ( 0 );
choose  ( child => 2, type => [] );
count   ( 0 );
choose  ( child => 2, finish => [] );
count   ( 1 );
choose  ( child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 2, child => 0 );
class   ( 'PPIx::Regexp::Token::Code' );
content ( '$1' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'e' );

tokenize( 's/x/$1/eeg' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$1' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'eeg' );

parse   ( 's/x/$1/eeg' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 4 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Structure::Replacement' );
count   ( 1 );
choose  ( child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 2, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$1' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'eeg' );
false   ( asserts => [ 'e' ] );
true    ( asserts => [ 'ee' ] );
true    ( asserts => [ 'g' ] );

tokenize( '/^\\A\\b\\B\\G\\Z\\z$/' );
count   ( 12 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '^' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\A' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\b' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\B' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\G' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\Z' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\z' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/^\\A\\b\\B\\G\\Z\\z$/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 8 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '^' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\A' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\b' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\B' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\G' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\Z' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\z' );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/(?smx)bar/' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '(?smx)' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/(?smx)bar/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '(?smx)' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/(?smx:foo)bar/' );
count   ( 13 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Modifier' );
content ( '?smx:' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/(?smx:foo)bar/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Modifier' );
count   ( 3 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Modifier' );
content ( '?smx:' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?-x:#1)#2/x' );
count   ( 10 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Modifier' );
content ( '?-x:' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '#' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 1 );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Comment' );
content ( '#2' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

parse   ( '/(?-x:#1)#2/x' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Modifier' );
count   ( 2 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Modifier' );
content ( '?-x:' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '#' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 1 );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Comment' );
content ( '#2' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

tokenize( '/(?-x)#1(?x)#2/x' );
count   ( 9 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '(?-x)' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '#' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 1 );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '(?x)' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Comment' );
content ( '#2' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

parse   ( '/(?-x)#1(?x)#2/x' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 5 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '(?-x)' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '#' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 1 );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '(?x)' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Comment' );
content ( '#2' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

tokenize( '/(?$foo:$bar)/' );
count   ( 10 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ':' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$bar' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?$foo:$bar)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Modifier' );
count   ( 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 3 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Modifier' );
content ( '?' );
choose  ( child => 1, child => 0, type => 1 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( child => 1, child => 0, type => 2 );
class   ( 'PPIx::Regexp::Token::GroupType' );
content ( ':' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$bar' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?$foo)$bar/' );
count   ( 9 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$bar' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?$foo)$bar/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Modifier' );
count   ( 0 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 2 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Modifier' );
content ( '?' );
choose  ( child => 1, child => 0, type => 1 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$bar' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?$on-$off:$foo)/' );
count   ( 12 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$on' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '-' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$off' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ':' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?$on-$off:$foo)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Modifier' );
count   ( 1 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 5 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Modifier' );
content ( '?' );
choose  ( child => 1, child => 0, type => 1 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$on' );
choose  ( child => 1, child => 0, type => 2 );
class   ( 'PPIx::Regexp::Token::GroupType' );
content ( '-' );
choose  ( child => 1, child => 0, type => 3 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$off' );
choose  ( child => 1, child => 0, type => 4 );
class   ( 'PPIx::Regexp::Token::GroupType' );
content ( ':' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?$on-$off)$foo/' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$on' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '-' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$off' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?$on-$off)$foo/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Modifier' );
count   ( 0 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 4 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Modifier' );
content ( '?' );
choose  ( child => 1, child => 0, type => 1 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$on' );
choose  ( child => 1, child => 0, type => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '-' );
choose  ( child => 1, child => 0, type => 3 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$off' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$foo' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?<foo>bar)/' );
count   ( 10 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?<foo>' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?<foo>bar)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::NamedCapture' );
count   ( 3 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?<foo>' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?\'foo\'bar)/' );
count   ( 10 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?\'foo\'' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?\'foo\'bar)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::NamedCapture' );
count   ( 3 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?\'foo\'' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?P<foo>bar)/' );
count   ( 10 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?P<foo>' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?P<foo>bar)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::NamedCapture' );
count   ( 3 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?P<foo>' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr/(?<f>\\w)/' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?<f>' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr/(?<f>\\w)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::NamedCapture' );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::NamedCapture' );
content ( '?<f>' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/foo(?=bar)/' );
count   ( 13 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?=' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/foo(?=bar)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Structure::Assertion' );
count   ( 3 );
choose  ( child => 1, child => 3, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 3, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?=' );
choose  ( child => 1, child => 3, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 3, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 3, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 3, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/foo(?!bar)/' );
count   ( 13 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?!' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/foo(?!bar)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Structure::Assertion' );
count   ( 3 );
choose  ( child => 1, child => 3, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 3, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?!' );
choose  ( child => 1, child => 3, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 3, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 3, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 3, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?<=foo)bar/' );
count   ( 13 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?<=' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?<=foo)bar/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Assertion' );
count   ( 3 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?<=' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?<!foo)bar/' );
count   ( 13 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?<!' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?<!foo)bar/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Assertion' );
count   ( 3 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?<!' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(*PRUNE:foo)x/' );
count   ( 6 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Backtrack' );
content ( '(*PRUNE:foo)' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(*PRUNE:foo)x/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Backtrack' );
content ( '(*PRUNE:foo)' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/[^]0-9\\w]/' );
count   ( 12 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '^' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ']' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '0' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '-' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '9' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'm/[^]0-9\\w]/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 3 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '^' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ']' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Node::Range' );
count   ( 3 );
choose  ( child => 1, child => 0, child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 0 );
choose  ( child => 1, child => 0, child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '-' );
choose  ( child => 1, child => 0, child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 9 );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'm/ [\\w\\{] /smx' );
count   ( 10 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\{' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

parse   ( 'm/ [\\w\\{] /smx' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, start => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 2 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\{' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

tokenize( 'm/ [\\w{] /smx' );
count   ( 10 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '{' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

parse   ( 'm/ [\\w{] /smx' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, start => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 2 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '{' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

tokenize( 'm/ [-\\\\^\\$\\]] /smx' );
count   ( 13 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '-' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '^' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\$' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\]' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

parse   ( 'm/ [-\\\\^\\$\\]] /smx' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, start => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 5 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '-' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '^' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\$' );
choose  ( child => 1, child => 0, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\]' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

tokenize( 'm/ [\\\\\\^^.\\||()\\[] /smx' );
count   ( 17 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\^' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '^' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '.' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\|' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '|' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '(' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ')' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\[' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 15 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 16 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

parse   ( 'm/ [\\\\\\^^.\\||()\\[] /smx' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'm' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, start => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 9 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\^' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '^' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '.' );
choose  ( child => 1, child => 0, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\|' );
choose  ( child => 1, child => 0, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '|' );
choose  ( child => 1, child => 0, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '(' );
choose  ( child => 1, child => 0, child => 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ')' );
choose  ( child => 1, child => 0, child => 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\[' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

tokenize( '/[[:upper:]]+[[:^lower:]]?/' );
count   ( 12 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::CharClass::POSIX' );
content ( '[:upper:]' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::CharClass::POSIX' );
content ( '[:^lower:]' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/[[:upper:]]+[[:^lower:]]?/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::POSIX' );
content ( '[:upper:]' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 1 );
choose  ( child => 1, child => 2, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 2, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 2, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::POSIX' );
content ( '[:^lower:]' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 'qr{ \\A \\\\ x \\{ \\w+ \\} }smx' );
count   ( 18 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\A' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\{' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\}' );
choose  ( 15 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 16 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( 17 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

parse   ( 'qr{ \\A \\\\ x \\{ \\w+ \\} }smx' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 13 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '{' );
choose  ( child => 1, start => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '}' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\A' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\\\' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'x' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\{' );
choose  ( child => 1, child => 7 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 8 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\w' );
choose  ( child => 1, child => 9 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '+' );
choose  ( child => 1, child => 10 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\}' );
choose  ( child => 1, child => 12 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'smx' );

tokenize( 's/foo\\Kbar/baz/' );
count   ( 15 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\K' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 's/foo\\Kbar/baz/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 4 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 7 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\K' );
choose  ( child => 1, child => 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Structure::Replacement' );
count   ( 3 );
choose  ( child => 2, start => 0 );
class   ( undef );
content ( undef );
choose  ( child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 2, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 2, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 2, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 's/$CR?$LF/\\n/g' );
count   ( 9 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$CR' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$LF' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\n' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'g' );

parse   ( 's/$CR?$LF/\\n/g' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 4 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$CR' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '?' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$LF' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Structure::Replacement' );
count   ( 1 );
choose  ( child => 2, start => 0 );
class   ( undef );
content ( undef );
choose  ( child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 2, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\n' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'g' );

tokenize( '/$RE{delimited}{-delim=>\'"\'}{-esc=>\'\\\\\'}/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$RE{delimited}{-delim=>\'"\'}{-esc=>\'\\\\\'}' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/$RE{delimited}{-delim=>\'"\'}{-esc=>\'\\\\\'}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '$RE{delimited}{-delim=>\'"\'}{-esc=>\'\\\\\'}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 's%(.*?${/})%%o' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '%' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '.' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Greediness' );
content ( '?' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '${/}' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '%' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '%' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'o' );

parse   ( 's%(.*?${/})%%o' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 4 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '%' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '%' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 4 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '.' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Quantifier' );
content ( '*' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Greediness' );
content ( '?' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Interpolation' );
content ( '${/}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Structure::Replacement' );
count   ( 0 );
choose  ( child => 2, start => [] );
count   ( 0 );
choose  ( child => 2, type => [] );
count   ( 0 );
choose  ( child => 2, finish => [] );
count   ( 1 );
choose  ( child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '%' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'o' );

tokenize( 's[foo]
[bar]' );
count   ( 13 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '[' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( ']' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( '
' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '[' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( ']' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 's[foo]
[bar]' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 5 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '[' );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( ']' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( '
' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Structure::Replacement' );
count   ( 3 );
choose  ( child => 3, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '[' );
choose  ( child => 3, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( ']' );
choose  ( child => 3, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 3, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 3, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?{ print "Hello, world!\\n" })/' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Code' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Code' );
content ( '{ print "Hello, world!\\n" }' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?{ print "Hello, world!\\n" })/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Code' );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Code' );
content ( '?' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Code' );
content ( '{ print "Hello, world!\\n" }' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(??{ $foo })/' );
count   ( 8 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Code' );
content ( '??' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Code' );
content ( '{ $foo }' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(??{ $foo })/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Code' );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Code' );
content ( '??' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Code' );
content ( '{ $foo }' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?|(foo))/' );
count   ( 12 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::BranchReset' );
content ( '?|' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?|(foo))/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::BranchReset' );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::BranchReset' );
content ( '?|' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 3 );
choose  ( child => 1, child => 0, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, child => 0, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, child => 0, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?1)/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?1)' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?1)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?1)' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?+2)/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?+2)' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?+2)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?+2)' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?-3)/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?-3)' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?-3)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?-3)' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?R)/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?R)' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?R)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?R)' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?&foo)/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?&foo)' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?&foo)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?&foo)' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?P>foo)/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?P>foo)' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?P>foo)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Recursion' );
content ( '(?P>foo)' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/foo(?>bar)/' );
count   ( 13 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::GroupType::Subexpression' );
content ( '?>' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/foo(?>bar)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Structure::Subexpression' );
count   ( 3 );
choose  ( child => 1, child => 3, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 3, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Subexpression' );
content ( '?>' );
choose  ( child => 1, child => 3, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 3, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 3, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 3, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/}/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '}' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/}/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(})/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '}' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/]/' );
count   ( 5 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/]/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ']' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(])/' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(])/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Capture' );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ']' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?(1)foo)/' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Condition' );
content ( '(1)' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?(1)foo)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Switch' );
count   ( 4 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Condition' );
content ( '(1)' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?(1)foo|bar)/' );
count   ( 15 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Condition' );
content ( '(1)' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?(1)foo|bar)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Switch' );
count   ( 8 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Condition' );
content ( '(1)' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 4 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
choose  ( child => 1, child => 0, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 0, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 0, child => 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?(1)foo|bar|baz)/' );
count   ( 19 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Condition' );
content ( '(1)' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 15 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( 16 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 17 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 18 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?(1)foo|bar|baz)/' );
value   ( failures => [], 1);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Switch' );
count   ( 12 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Condition' );
content ( '(1)' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 4 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
choose  ( child => 1, child => 0, child => 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 0, child => 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 0, child => 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 1, child => 0, child => 8 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( '|' );
choose  ( child => 1, child => 0, child => 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 0, child => 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 0, child => 11 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'z' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?(<baz>)foo)/' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Condition' );
content ( '(<baz>)' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?(<baz>)foo)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Switch' );
count   ( 4 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Condition' );
content ( '(<baz>)' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?(\'baz\')foo)/' );
count   ( 11 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Condition' );
content ( '(\'baz\')' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?(\'baz\')foo)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Switch' );
count   ( 4 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Condition' );
content ( '(\'baz\')' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?(?{0})foo)/' );
count   ( 14 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::GroupType::Code' );
content ( '?' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Code' );
content ( '{0}' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?(?{0})foo)/' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => 0 );
class   ( undef );
content ( undef );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Switch' );
count   ( 4 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Switch' );
content ( '?' );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Structure::Code' );
count   ( 1 );
choose  ( child => 1, child => 0, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Code' );
content ( '?' );
choose  ( child => 1, child => 0, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Code' );
content ( '{0}' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

# TODO /(?(R\d*)..)/, /(?(R&name)...)/, /(?(DEFINE)...)/.

tokenize( '/ ( ?<= bar ) /x' );
count   ( 15 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?<=' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

parse   ( '/ ( ?<= bar ) /x' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => [] );
count   ( 2 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, start => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Assertion' );
count   ( 4 );
choose  ( child => 1, child => 0, start => [] );
count   ( 2 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, start => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, type => [] );
count   ( 2 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?<=' );
choose  ( child => 1, child => 0, type => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( 'x' );

tokenize( 'qr!(?<\\!foo)bar!' );
count   ( 13 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '!' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?<\\!' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '!' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 'qr!(?<\\!foo)bar!' );
value   ( failures => [], 0);
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 'qr' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 4 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '!' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '!' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Assertion' );
count   ( 3 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Assertion' );
content ( '?<\\!' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'f' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'o' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'b' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'a' );
choose  ( child => 1, child => 3 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 'r' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?{ foo } )/' );
count   ( 9 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::GroupType::Code' );
content ( '?' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Code' );
content ( '{ foo }' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?{ foo } )/' );
value   ( failures => [], 1 );
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::Code' );
count   ( 2 );
choose  ( child => 1, child => 0, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, type => [] );
count   ( 1 );
choose  ( child => 1, child => 0, type => 0 );
class   ( 'PPIx::Regexp::Token::GroupType::Code' );
content ( '?' );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::Code' );
content ( '{ foo }' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Unknown' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 's/\\b/\\b/' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\b' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\b' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );
finis   ();

parse   ( 's/\\b/\\b/' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 4 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '\\b' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Structure::Replacement' );
count   ( 1 );
choose  ( child => 2, start => [] );
count   ( 0 );
choose  ( child => 2, type => [] );
count   ( 0 );
choose  ( child => 2, finish => [] );
count   ( 1 );
choose  ( child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 2, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '\\b' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( 's\\/$\\\\' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\\' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '/' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\\' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\\' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( 's\\/$\\\\' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 4 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( 's' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\\' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\\' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '/' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Assertion' );
content ( '$' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Structure::Replacement' );
count   ( 0 );
choose  ( child => 2, start => [] );
count   ( 0 );
choose  ( child => 2, type => [] );
count   ( 0 );
choose  ( child => 2, finish => [] );
count   ( 1 );
choose  ( child => 2, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '\\' );
choose  ( child => 3 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/ . /' );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '.' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/ . /' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 3 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '.' );
choose  ( child => 1, child => 2 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/ . /', default_modifiers => [ 'smx' ] );
count   ( 7 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '.' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/ . /', default_modifiers => [ 'smx' ] );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 2 );
choose  ( child => 1, start => [] );
count   ( 2 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, start => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '.' );
choose  ( child => 1, child => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

tokenize( '/(?[ \\P{Foo} & ( [:alpha:] | [ . \\d ] - [9] ) ])/' );
count   ( 33 );
choose  ( 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( 1 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 2 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(?[' );
choose  ( 3 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 4 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\P{Foo}' );
choose  ( 5 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 6 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '&' );
choose  ( 7 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 8 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( 9 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 10 );
class   ( 'PPIx::Regexp::Token::CharClass::POSIX' );
content ( '[:alpha:]' );
choose  ( 11 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 12 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
choose  ( 13 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 14 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 15 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 16 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '.' );
choose  ( 17 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 18 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\d' );
choose  ( 19 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 20 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 21 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 22 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '-' );
choose  ( 23 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 24 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( 25 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 9 );
choose  ( 26 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( 27 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 28 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( 29 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( 30 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '])' );
choose  ( 31 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( 32 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );

parse   ( '/(?[ \\P{Foo} & ( [:alpha:] | [ . \\d ] - [9] ) ])/' );
value   ( failures => [], 0 );
class   ( 'PPIx::Regexp' );
count   ( 3 );
choose  ( child => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '' );
choose  ( child => 1 );
class   ( 'PPIx::Regexp::Structure::Regexp' );
count   ( 1 );
choose  ( child => 1, start => [] );
count   ( 1 );
choose  ( child => 1, start => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, type => [] );
count   ( 0 );
choose  ( child => 1, finish => [] );
count   ( 1 );
choose  ( child => 1, finish => 0 );
class   ( 'PPIx::Regexp::Token::Delimiter' );
content ( '/' );
choose  ( child => 1, child => 0 );
class   ( 'PPIx::Regexp::Structure::RegexSet' );
count   ( 6 );
choose  ( child => 1, child => 0, start => [] );
count   ( 2 );
choose  ( child => 1, child => 0, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(?[' );
choose  ( child => 1, child => 0, start => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '])' );
choose  ( child => 1, child => 0, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\P{Foo}' );
choose  ( child => 1, child => 0, child => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, child => 2 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '&' );
choose  ( child => 1, child => 0, child => 3 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, child => 4 );
class   ( 'PPIx::Regexp::Structure' );
count   ( 10 );
choose  ( child => 1, child => 0, child => 4, start => [] );
count   ( 2 );
choose  ( child => 1, child => 0, child => 4, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '(' );
choose  ( child => 1, child => 0, child => 4, start => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, child => 4, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, child => 4, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 4, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ')' );
choose  ( child => 1, child => 0, child => 4, child => 0 );
class   ( 'PPIx::Regexp::Token::CharClass::POSIX' );
content ( '[:alpha:]' );
choose  ( child => 1, child => 0, child => 4, child => 1 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, child => 4, child => 2 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '|' );
choose  ( child => 1, child => 0, child => 4, child => 3 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, child => 4, child => 4 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 5 );
choose  ( child => 1, child => 0, child => 4, child => 4, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 4, child => 4, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, child => 4, child => 4, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, child => 4, child => 4, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 4, child => 4, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 4, child => 4, child => 0 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, child => 4, child => 4, child => 1 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( '.' );
choose  ( child => 1, child => 0, child => 4, child => 4, child => 2 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, child => 4, child => 4, child => 3 );
class   ( 'PPIx::Regexp::Token::CharClass::Simple' );
content ( '\\d' );
choose  ( child => 1, child => 0, child => 4, child => 4, child => 4 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, child => 4, child => 5 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, child => 4, child => 6 );
class   ( 'PPIx::Regexp::Token::Operator' );
content ( '-' );
choose  ( child => 1, child => 0, child => 4, child => 7 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, child => 4, child => 8 );
class   ( 'PPIx::Regexp::Structure::CharClass' );
count   ( 1 );
choose  ( child => 1, child => 0, child => 4, child => 8, start => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 4, child => 8, start => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( '[' );
choose  ( child => 1, child => 0, child => 4, child => 8, type => [] );
count   ( 0 );
choose  ( child => 1, child => 0, child => 4, child => 8, finish => [] );
count   ( 1 );
choose  ( child => 1, child => 0, child => 4, child => 8, finish => 0 );
class   ( 'PPIx::Regexp::Token::Structure' );
content ( ']' );
choose  ( child => 1, child => 0, child => 4, child => 8, child => 0 );
class   ( 'PPIx::Regexp::Token::Literal' );
content ( 9 );
choose  ( child => 1, child => 0, child => 4, child => 9 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 1, child => 0, child => 5 );
class   ( 'PPIx::Regexp::Token::Whitespace' );
content ( ' ' );
choose  ( child => 2 );
class   ( 'PPIx::Regexp::Token::Modifier' );
content ( '' );


done_testing;

1;

# ex: set textwidth=72 :
