/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.SkipInstructionException;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.instruct.WithParam;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public abstract class Instruction
implements Serializable,
SourceLocator {
    protected Instruction[] children;
    private int sourceLocation;

    public void setChildren(Instruction[] instructionArray) {
        this.children = instructionArray;
    }

    public Instruction[] getChildren() {
        return this.children;
    }

    public void setSourceLocation(int n, int n2) {
        this.sourceLocation = n << 20 | n2 & 0x7FFFF;
    }

    public String getSystemId(Executable executable) {
        int n = this.sourceLocation >> 20 & 0x3FF;
        return executable.getSystemId(n);
    }

    public String getSystemId() {
        return "unknown";
    }

    public String getPublicId() {
        return null;
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getLineNumber() {
        return this.sourceLocation & 0x7FFFF;
    }

    public InstructionDetails getInstructionDetails(Controller controller) {
        InstructionDetails instructionDetails = new InstructionDetails();
        this.setInstructionDetails(controller, controller.getNamePool(), instructionDetails);
        instructionDetails.setSystemId(this.getSystemId(controller.getExecutable()));
        instructionDetails.setLineNumber(this.getLineNumber());
        instructionDetails.setProperty("controller", controller);
        return instructionDetails;
    }

    public abstract void setInstructionDetails(Controller var1, NamePool var2, InstructionDetails var3);

    public String getInstructionName() {
        InstructionDetails instructionDetails = new InstructionDetails();
        this.setInstructionDetails(null, null, instructionDetails);
        return instructionDetails.getInstructionName();
    }

    public SequenceType getResultType() {
        return SequenceType.ANY_SEQUENCE;
    }

    public abstract TailCall processLeavingTail(XPathContext var1) throws TransformerException;

    public void process(XPathContext xPathContext) throws TransformerException {
        TailCall tailCall = this.processLeavingTail(xPathContext);
        while (tailCall != null) {
            tailCall = tailCall.processLeavingTail(xPathContext);
        }
    }

    protected void processChildren(XPathContext xPathContext) throws TransformerException {
        if (this.children == null) {
            return;
        }
        Controller controller = xPathContext.getController();
        if (controller.isTracing()) {
            TraceListener traceListener = controller.getTraceListener();
            int n = 0;
            while (n < this.children.length) {
                try {
                    InstructionDetails instructionDetails = this.children[n].getInstructionDetails(controller);
                    traceListener.enter(instructionDetails);
                    this.children[n].process(xPathContext);
                    traceListener.leave(instructionDetails);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof SkipInstructionException) {
                        this.children[n].recoverableError(transformerException.getMessage(), controller);
                    }
                    throw this.children[n].styleError(transformerException, controller);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.children.length) {
                try {
                    this.children[n].process(xPathContext);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof SkipInstructionException) {
                        this.children[n].recoverableError(transformerException.getMessage(), controller);
                    }
                    throw this.children[n].styleError(transformerException, controller);
                }
                ++n;
            }
        }
    }

    protected TailCall processChildrenLeavingTail(XPathContext xPathContext) throws TransformerException {
        if (this.children == null) {
            return null;
        }
        Controller controller = xPathContext.getController();
        TailCall tailCall = null;
        if (controller.isTracing()) {
            TraceListener traceListener = controller.getTraceListener();
            int n = 0;
            while (n < this.children.length) {
                try {
                    InstructionDetails instructionDetails = this.children[n].getInstructionDetails(controller);
                    traceListener.enter(instructionDetails);
                    tailCall = this.children[n].processLeavingTail(xPathContext);
                    traceListener.leave(instructionDetails);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof SkipInstructionException) {
                        this.children[n].recoverableError(transformerException.getMessage(), controller);
                    }
                    throw this.children[n].styleError(transformerException, controller);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.children.length) {
                try {
                    tailCall = this.children[n].processLeavingTail(xPathContext);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof SkipInstructionException) {
                        this.children[n].recoverableError(transformerException.getMessage(), controller);
                    }
                    throw this.children[n].styleError(transformerException, controller);
                }
                ++n;
            }
        }
        return tailCall;
    }

    protected TransformerException styleError(TransformerException transformerException, Controller controller) {
        if (transformerException instanceof TerminationException) {
            return transformerException;
        }
        if (transformerException.getException() instanceof TransformerException) {
            return this.styleError((TransformerException)transformerException.getException(), controller);
        }
        if (transformerException.getLocator() == null || transformerException.getLocator().getLineNumber() == -1) {
            try {
                InstructionDetails instructionDetails = this.getInstructionDetails(controller);
                return new TransformerException(transformerException.getMessage(), instructionDetails, transformerException.getException());
            }
            catch (Exception exception) {
                return transformerException;
            }
        }
        if (transformerException instanceof XPathException) {
            if (controller.getConfiguration().getHostLanguage() == 11) {
                return transformerException;
            }
            if (transformerException.getLocator() != null) {
                return transformerException;
            }
            try {
                InstructionDetails instructionDetails = this.getInstructionDetails(controller);
                return new TransformerException(transformerException.getMessage(), instructionDetails, transformerException.getException());
            }
            catch (Exception exception) {
                return transformerException;
            }
        }
        return transformerException;
    }

    protected TransformerException styleError(String string, Controller controller) {
        InstructionDetails instructionDetails = this.getInstructionDetails(controller);
        return new TransformerException(string, instructionDetails);
    }

    protected void recoverableError(String string, Controller controller) throws TransformerException {
        InstructionDetails instructionDetails = this.getInstructionDetails(controller);
        controller.recoverableError(string, instructionDetails);
    }

    protected ParameterSet assembleParams(XPathContext xPathContext, WithParam[] withParamArray) throws TransformerException {
        if (withParamArray == null || withParamArray.length == 0) {
            return null;
        }
        ParameterSet parameterSet = new ParameterSet();
        int n = 0;
        while (n < withParamArray.length) {
            parameterSet.put(withParamArray[n].getVariableFingerprint(), withParamArray[n].getSelectValue(xPathContext));
            ++n;
        }
        return parameterSet;
    }

    protected ParameterSet assembleTunnelParams(XPathContext xPathContext, WithParam[] withParamArray) throws TransformerException {
        ParameterSet parameterSet = xPathContext.getController().getBindery().getTunnelParameters();
        if (parameterSet == null) {
            return this.assembleParams(xPathContext, withParamArray);
        }
        ParameterSet parameterSet2 = new ParameterSet(parameterSet);
        if (withParamArray == null || withParamArray.length == 0) {
            return parameterSet2;
        }
        int n = 0;
        while (n < withParamArray.length) {
            parameterSet2.put(withParamArray[n].getVariableFingerprint(), withParamArray[n].getSelectValue(xPathContext));
            ++n;
        }
        return parameterSet2;
    }
}

