; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vbmi2 | FileCheck %s --check-prefixes=AVX512,AVX512VBMI2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VLBW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vbmi2,+avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VLVBMI2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx | FileCheck %s --check-prefixes=XOP,XOPAVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx2 | FileCheck %s --check-prefixes=XOP,XOPAVX2

; Just one 32-bit run to make sure we do reasonable things for i64 cases.
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=X32-SSE,X32-SSE2

declare <2 x i64> @llvm.fshr.v2i64(<2 x i64>, <2 x i64>, <2 x i64>)
declare <4 x i32> @llvm.fshr.v4i32(<4 x i32>, <4 x i32>, <4 x i32>)
declare <8 x i16> @llvm.fshr.v8i16(<8 x i16>, <8 x i16>, <8 x i16>)
declare <16 x i8> @llvm.fshr.v16i8(<16 x i8>, <16 x i8>, <16 x i8>)

;
; Variable Shifts
;

define <2 x i64> @var_funnnel_v2i64(<2 x i64> %x, <2 x i64> %y, <2 x i64> %amt) nounwind {
; SSE2-LABEL: var_funnnel_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    psrlq %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[2,3,0,1]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrlq %xmm4, %xmm5
; SSE2-NEXT:    movsd {{.*#+}} xmm5 = xmm3[0],xmm5[1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [64,64]
; SSE2-NEXT:    psubq %xmm2, %xmm3
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    psllq %xmm3, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,3,0,1]
; SSE2-NEXT:    psllq %xmm3, %xmm0
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE2-NEXT:    orpd %xmm5, %xmm0
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[1,0,3,2]
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: var_funnnel_v2i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    psrlq %xmm2, %xmm0
; SSE41-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[2,3,0,1]
; SSE41-NEXT:    movdqa %xmm1, %xmm5
; SSE41-NEXT:    psrlq %xmm4, %xmm5
; SSE41-NEXT:    pblendw {{.*#+}} xmm5 = xmm0[0,1,2,3],xmm5[4,5,6,7]
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [64,64]
; SSE41-NEXT:    psubq %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    psllq %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE41-NEXT:    psllq %xmm0, %xmm3
; SSE41-NEXT:    pblendw {{.*#+}} xmm3 = xmm4[0,1,2,3],xmm3[4,5,6,7]
; SSE41-NEXT:    por %xmm5, %xmm3
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm3
; SSE41-NEXT:    movapd %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: var_funnnel_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpsrlq %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm2[2,3,0,1]
; AVX1-NEXT:    vpsrlq %xmm4, %xmm1, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1,2,3],xmm4[4,5,6,7]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX1-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX1-NEXT:    vpsllq %xmm4, %xmm0, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[2,3,0,1]
; AVX1-NEXT:    vpsllq %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm5[0,1,2,3],xmm0[4,5,6,7]
; AVX1-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_funnnel_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX2-NEXT:    vpsrlvq %xmm2, %xmm1, %xmm3
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX2-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX2-NEXT:    vpsllvq %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqq %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: var_funnnel_v2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512F-NEXT:    vpsrlvq %xmm2, %xmm1, %xmm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512F-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpsllvq %xmm4, %xmm0, %xmm0
; AVX512F-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512F-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VL-NEXT:    vpsrlvq %xmm2, %xmm1, %xmm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512VL-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpsllvq %xmm4, %xmm0, %xmm0
; AVX512VL-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestnmq %xmm2, %xmm2, %k1
; AVX512VL-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1}
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v2i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512BW-NEXT:    vpsrlvq %xmm2, %xmm1, %xmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512BW-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpsllvq %xmm4, %xmm0, %xmm0
; AVX512BW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512BW-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v2i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512VBMI2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpsrlvq %xmm2, %xmm1, %xmm3
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512VBMI2-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpsllvq %xmm4, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512VBMI2-NEXT:    vzeroupper
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v2i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsrlvq %xmm2, %xmm1, %xmm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512VLBW-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpsllvq %xmm4, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vptestnmq %xmm2, %xmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v2i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvq %xmm2, %xmm0, %xmm1
; AVX512VLVBMI2-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: var_funnnel_v2i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsubq %xmm2, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpshlq %xmm4, %xmm1, %xmm4
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [64,64]
; XOPAVX1-NEXT:    vpsubq %xmm2, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpshlq %xmm5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm4, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpcomeqq %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_funnnel_v2i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOPAVX2-NEXT:    vpsrlvq %xmm2, %xmm1, %xmm3
; XOPAVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; XOPAVX2-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; XOPAVX2-NEXT:    vpsllvq %xmm4, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX2-NEXT:    vpcomeqq %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    retq
;
; X32-SSE-LABEL: var_funnnel_v2i64:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm2
; X32-SSE-NEXT:    movdqa %xmm1, %xmm3
; X32-SSE-NEXT:    psrlq %xmm2, %xmm3
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[2,3,0,1]
; X32-SSE-NEXT:    movdqa %xmm1, %xmm5
; X32-SSE-NEXT:    psrlq %xmm4, %xmm5
; X32-SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm3[0],xmm5[1]
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm3 = [64,0,64,0]
; X32-SSE-NEXT:    psubq %xmm2, %xmm3
; X32-SSE-NEXT:    movdqa %xmm0, %xmm4
; X32-SSE-NEXT:    psllq %xmm3, %xmm4
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,3,0,1]
; X32-SSE-NEXT:    psllq %xmm3, %xmm0
; X32-SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; X32-SSE-NEXT:    orpd %xmm5, %xmm0
; X32-SSE-NEXT:    pxor %xmm3, %xmm3
; X32-SSE-NEXT:    pcmpeqd %xmm2, %xmm3
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[1,0,3,2]
; X32-SSE-NEXT:    pand %xmm3, %xmm2
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pandn %xmm0, %xmm2
; X32-SSE-NEXT:    por %xmm1, %xmm2
; X32-SSE-NEXT:    movdqa %xmm2, %xmm0
; X32-SSE-NEXT:    retl
  %res = call <2 x i64> @llvm.fshr.v2i64(<2 x i64> %x, <2 x i64> %y, <2 x i64> %amt)
  ret <2 x i64> %res
}

define <4 x i32> @var_funnnel_v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> %amt) nounwind {
; SSE2-LABEL: var_funnnel_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm2[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psrld %xmm3, %xmm4
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm2[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    psrld %xmm5, %xmm3
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[2,3,0,1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm4[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm6
; SSE2-NEXT:    psrld %xmm5, %xmm6
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrld %xmm4, %xmm5
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm5 = xmm5[1],xmm6[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm5[0,3]
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [32,32,32,32]
; SSE2-NEXT:    psubd %xmm2, %xmm4
; SSE2-NEXT:    pslld $23, %xmm4
; SSE2-NEXT:    paddd {{.*}}(%rip), %xmm4
; SSE2-NEXT:    cvttps2dq %xmm4, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm4, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm5, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1]
; SSE2-NEXT:    por %xmm3, %xmm6
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    pandn %xmm6, %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: var_funnnel_v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[2,3,3,3,4,5,6,7]
; SSE41-NEXT:    movdqa %xmm1, %xmm4
; SSE41-NEXT:    psrld %xmm0, %xmm4
; SSE41-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,3,0,1]
; SSE41-NEXT:    pshuflw {{.*#+}} xmm5 = xmm0[2,3,3,3,4,5,6,7]
; SSE41-NEXT:    movdqa %xmm1, %xmm6
; SSE41-NEXT:    psrld %xmm5, %xmm6
; SSE41-NEXT:    pblendw {{.*#+}} xmm6 = xmm4[0,1,2,3],xmm6[4,5,6,7]
; SSE41-NEXT:    pshuflw {{.*#+}} xmm4 = xmm2[0,1,1,1,4,5,6,7]
; SSE41-NEXT:    movdqa %xmm1, %xmm5
; SSE41-NEXT:    psrld %xmm4, %xmm5
; SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,1,1,4,5,6,7]
; SSE41-NEXT:    movdqa %xmm1, %xmm4
; SSE41-NEXT:    psrld %xmm0, %xmm4
; SSE41-NEXT:    pblendw {{.*#+}} xmm4 = xmm5[0,1,2,3],xmm4[4,5,6,7]
; SSE41-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm6[2,3],xmm4[4,5],xmm6[6,7]
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [32,32,32,32]
; SSE41-NEXT:    psubd %xmm2, %xmm0
; SSE41-NEXT:    pslld $23, %xmm0
; SSE41-NEXT:    paddd {{.*}}(%rip), %xmm0
; SSE41-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE41-NEXT:    pmulld %xmm0, %xmm3
; SSE41-NEXT:    por %xmm4, %xmm3
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm1, %xmm3
; SSE41-NEXT:    movaps %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: var_funnnel_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpsrldq {{.*#+}} xmm3 = xmm2[12,13,14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpsrld %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vpsrlq $32, %xmm2, %xmm4
; AVX1-NEXT:    vpsrld %xmm4, %xmm1, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm4[0,1,2,3],xmm3[4,5,6,7]
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpunpckhdq {{.*#+}} xmm5 = xmm2[2],xmm4[2],xmm2[3],xmm4[3]
; AVX1-NEXT:    vpsrld %xmm5, %xmm1, %xmm5
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm6 = xmm2[0],zero,xmm2[1],zero
; AVX1-NEXT:    vpsrld %xmm6, %xmm1, %xmm6
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm6[0,1,2,3],xmm5[4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm5[0,1],xmm3[2,3],xmm5[4,5],xmm3[6,7]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [32,32,32,32]
; AVX1-NEXT:    vpsubd %xmm2, %xmm5, %xmm5
; AVX1-NEXT:    vpslld $23, %xmm5, %xmm5
; AVX1-NEXT:    vpaddd {{.*}}(%rip), %xmm5, %xmm5
; AVX1-NEXT:    vcvttps2dq %xmm5, %xmm5
; AVX1-NEXT:    vpmulld %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_funnnel_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX2-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpsrlvd %xmm2, %xmm1, %xmm3
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX2-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX2-NEXT:    vpsllvd %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: var_funnnel_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX512F-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpsrlvd %xmm2, %xmm1, %xmm3
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512F-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpsllvd %xmm4, %xmm0, %xmm0
; AVX512F-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512F-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpandd {{.*}}(%rip){1to4}, %xmm2, %xmm2
; AVX512VL-NEXT:    vpsrlvd %xmm2, %xmm1, %xmm3
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512VL-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpsllvd %xmm4, %xmm0, %xmm0
; AVX512VL-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestnmd %xmm2, %xmm2, %k1
; AVX512VL-NEXT:    vmovdqa32 %xmm1, %xmm0 {%k1}
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v4i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX512BW-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vpsrlvd %xmm2, %xmm1, %xmm3
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512BW-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpsllvd %xmm4, %xmm0, %xmm0
; AVX512BW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512BW-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v4i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512VBMI2-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX512VBMI2-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpsrlvd %xmm2, %xmm1, %xmm3
; AVX512VBMI2-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512VBMI2-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpsllvd %xmm4, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512VBMI2-NEXT:    vzeroupper
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v4i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpandd {{.*}}(%rip){1to4}, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsrlvd %xmm2, %xmm1, %xmm3
; AVX512VLBW-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512VLBW-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpsllvd %xmm4, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vptestnmd %xmm2, %xmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa32 %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v4i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvd %xmm2, %xmm0, %xmm1
; AVX512VLVBMI2-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: var_funnnel_v4i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsubd %xmm2, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpshld %xmm4, %xmm1, %xmm4
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [32,32,32,32]
; XOPAVX1-NEXT:    vpsubd %xmm2, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpshld %xmm5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm4, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpcomeqd %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: var_funnnel_v4i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; XOPAVX2-NEXT:    vpand %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpsrlvd %xmm2, %xmm1, %xmm3
; XOPAVX2-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; XOPAVX2-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; XOPAVX2-NEXT:    vpsllvd %xmm4, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX2-NEXT:    vpcomeqd %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    retq
;
; X32-SSE-LABEL: var_funnnel_v4i32:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm2
; X32-SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm2[2,3,3,3,4,5,6,7]
; X32-SSE-NEXT:    movdqa %xmm1, %xmm4
; X32-SSE-NEXT:    psrld %xmm3, %xmm4
; X32-SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm2[0,1,1,1,4,5,6,7]
; X32-SSE-NEXT:    movdqa %xmm1, %xmm3
; X32-SSE-NEXT:    psrld %xmm5, %xmm3
; X32-SSE-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[2,3,0,1]
; X32-SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm4[2,3,3,3,4,5,6,7]
; X32-SSE-NEXT:    movdqa %xmm1, %xmm6
; X32-SSE-NEXT:    psrld %xmm5, %xmm6
; X32-SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,1,1,4,5,6,7]
; X32-SSE-NEXT:    movdqa %xmm1, %xmm5
; X32-SSE-NEXT:    psrld %xmm4, %xmm5
; X32-SSE-NEXT:    punpckhqdq {{.*#+}} xmm5 = xmm5[1],xmm6[1]
; X32-SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm5[0,3]
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm4 = [32,32,32,32]
; X32-SSE-NEXT:    psubd %xmm2, %xmm4
; X32-SSE-NEXT:    pslld $23, %xmm4
; X32-SSE-NEXT:    paddd {{\.LCPI.*}}, %xmm4
; X32-SSE-NEXT:    cvttps2dq %xmm4, %xmm4
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,3,3]
; X32-SSE-NEXT:    pmuludq %xmm4, %xmm0
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[0,2,2,3]
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; X32-SSE-NEXT:    pmuludq %xmm5, %xmm0
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X32-SSE-NEXT:    punpckldq {{.*#+}} xmm6 = xmm6[0],xmm0[0],xmm6[1],xmm0[1]
; X32-SSE-NEXT:    por %xmm3, %xmm6
; X32-SSE-NEXT:    pxor %xmm0, %xmm0
; X32-SSE-NEXT:    pcmpeqd %xmm2, %xmm0
; X32-SSE-NEXT:    pand %xmm0, %xmm1
; X32-SSE-NEXT:    pandn %xmm6, %xmm0
; X32-SSE-NEXT:    por %xmm1, %xmm0
; X32-SSE-NEXT:    retl
  %res = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> %amt)
  ret <4 x i32> %res
}

define <8 x i16> @var_funnnel_v8i16(<8 x i16> %x, <8 x i16> %y, <8 x i16> %amt) nounwind {
; SSE2-LABEL: var_funnnel_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    psllw $12, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm3
; SSE2-NEXT:    psraw $15, %xmm3
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrlw $8, %xmm5
; SSE2-NEXT:    pand %xmm3, %xmm5
; SSE2-NEXT:    pandn %xmm1, %xmm3
; SSE2-NEXT:    por %xmm5, %xmm3
; SSE2-NEXT:    paddw %xmm4, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    psraw $15, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm6
; SSE2-NEXT:    pandn %xmm3, %xmm6
; SSE2-NEXT:    psrlw $4, %xmm3
; SSE2-NEXT:    pand %xmm5, %xmm3
; SSE2-NEXT:    por %xmm6, %xmm3
; SSE2-NEXT:    paddw %xmm4, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    psraw $15, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm6
; SSE2-NEXT:    pandn %xmm3, %xmm6
; SSE2-NEXT:    psrlw $2, %xmm3
; SSE2-NEXT:    pand %xmm5, %xmm3
; SSE2-NEXT:    por %xmm6, %xmm3
; SSE2-NEXT:    paddw %xmm4, %xmm4
; SSE2-NEXT:    psraw $15, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    pandn %xmm3, %xmm5
; SSE2-NEXT:    psrlw $1, %xmm3
; SSE2-NEXT:    pand %xmm4, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; SSE2-NEXT:    psubw %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    movdqa %xmm4, %xmm7
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm8[4],xmm7[5],xmm8[5],xmm7[6],xmm8[6],xmm7[7],xmm8[7]
; SSE2-NEXT:    pslld $23, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [1065353216,1065353216,1065353216,1065353216]
; SSE2-NEXT:    paddd %xmm6, %xmm7
; SSE2-NEXT:    cvttps2dq %xmm7, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,2,2,3]
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1],xmm4[2],xmm8[2],xmm4[3],xmm8[3]
; SSE2-NEXT:    pslld $23, %xmm4
; SSE2-NEXT:    paddd %xmm6, %xmm4
; SSE2-NEXT:    cvttps2dq %xmm4, %xmm4
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,2,2,3,4,5,6,7]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,6,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm7[0]
; SSE2-NEXT:    pmullw %xmm0, %xmm4
; SSE2-NEXT:    por %xmm5, %xmm4
; SSE2-NEXT:    por %xmm3, %xmm4
; SSE2-NEXT:    pcmpeqw %xmm8, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pandn %xmm4, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: var_funnnel_v8i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm8
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm5 = [16,16,16,16,16,16,16,16]
; SSE41-NEXT:    psubw %xmm2, %xmm5
; SSE41-NEXT:    pxor %xmm4, %xmm4
; SSE41-NEXT:    pmovzxwd {{.*#+}} xmm6 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero
; SSE41-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4],xmm4[4],xmm5[5],xmm4[5],xmm5[6],xmm4[6],xmm5[7],xmm4[7]
; SSE41-NEXT:    pcmpeqw %xmm2, %xmm4
; SSE41-NEXT:    psllw $12, %xmm2
; SSE41-NEXT:    psllw $4, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    paddw %xmm0, %xmm2
; SSE41-NEXT:    movdqa %xmm1, %xmm7
; SSE41-NEXT:    psrlw $8, %xmm7
; SSE41-NEXT:    movdqa %xmm1, %xmm3
; SSE41-NEXT:    pblendvb %xmm0, %xmm7, %xmm3
; SSE41-NEXT:    movdqa %xmm3, %xmm7
; SSE41-NEXT:    psrlw $4, %xmm7
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm7, %xmm3
; SSE41-NEXT:    movdqa %xmm3, %xmm7
; SSE41-NEXT:    psrlw $2, %xmm7
; SSE41-NEXT:    paddw %xmm2, %xmm2
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm7, %xmm3
; SSE41-NEXT:    movdqa %xmm3, %xmm7
; SSE41-NEXT:    psrlw $1, %xmm7
; SSE41-NEXT:    paddw %xmm2, %xmm2
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm7, %xmm3
; SSE41-NEXT:    pslld $23, %xmm5
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [1065353216,1065353216,1065353216,1065353216]
; SSE41-NEXT:    paddd %xmm0, %xmm5
; SSE41-NEXT:    cvttps2dq %xmm5, %xmm2
; SSE41-NEXT:    pslld $23, %xmm6
; SSE41-NEXT:    paddd %xmm0, %xmm6
; SSE41-NEXT:    cvttps2dq %xmm6, %xmm0
; SSE41-NEXT:    packusdw %xmm2, %xmm0
; SSE41-NEXT:    pmullw %xmm0, %xmm8
; SSE41-NEXT:    por %xmm3, %xmm8
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm1, %xmm8
; SSE41-NEXT:    movdqa %xmm8, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: var_funnnel_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpsllw $12, %xmm2, %xmm3
; AVX1-NEXT:    vpsllw $4, %xmm2, %xmm4
; AVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpaddw %xmm3, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm1, %xmm5
; AVX1-NEXT:    vpblendvb %xmm3, %xmm5, %xmm1, %xmm3
; AVX1-NEXT:    vpsrlw $4, %xmm3, %xmm5
; AVX1-NEXT:    vpblendvb %xmm4, %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $2, %xmm3, %xmm5
; AVX1-NEXT:    vpaddw %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpblendvb %xmm4, %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm3, %xmm5
; AVX1-NEXT:    vpaddw %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpblendvb %xmm4, %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX1-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm5, %xmm5, %xmm5
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm6 = xmm4[4],xmm5[4],xmm4[5],xmm5[5],xmm4[6],xmm5[6],xmm4[7],xmm5[7]
; AVX1-NEXT:    vpslld $23, %xmm6, %xmm6
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [1065353216,1065353216,1065353216,1065353216]
; AVX1-NEXT:    vpaddd %xmm7, %xmm6, %xmm6
; AVX1-NEXT:    vcvttps2dq %xmm6, %xmm6
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero
; AVX1-NEXT:    vpslld $23, %xmm4, %xmm4
; AVX1-NEXT:    vpaddd %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vcvttps2dq %xmm4, %xmm4
; AVX1-NEXT:    vpackusdw %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpmullw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqw %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: var_funnnel_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; AVX2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; AVX2-NEXT:    vpsrlvd %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [0,1,4,5,8,9,12,13,8,9,12,13,12,13,14,15,16,17,20,21,24,25,28,29,24,25,28,29,28,29,30,31]
; AVX2-NEXT:    vpshufb %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpermq {{.*#+}} ymm3 = ymm3[0,2,2,3]
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm5 = [16,16,16,16,16,16,16,16]
; AVX2-NEXT:    vpsubw %xmm2, %xmm5, %xmm5
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpsllvd %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,2,3]
; AVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqw %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: var_funnnel_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; AVX512F-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} ymm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; AVX512F-NEXT:    vpsrlvd %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512F-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero
; AVX512F-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512F-NEXT:    vpsllvd %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512F-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vpcmpeqw %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} ymm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; AVX512VL-NEXT:    vpsrlvd %ymm4, %ymm3, %ymm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512VL-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero
; AVX512VL-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX512VL-NEXT:    vpsllvd %ymm4, %ymm0, %ymm0
; AVX512VL-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpcmpeqw %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v8i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512BW-NEXT:    vpsrlvw %zmm2, %zmm1, %zmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512BW-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpsllvw %zmm4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512BW-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v8i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512VBMI2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpsrlvw %zmm2, %zmm1, %zmm3
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512VBMI2-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpsllvw %zmm4, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqu16 %zmm1, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512VBMI2-NEXT:    vzeroupper
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v8i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsrlvw %xmm2, %xmm1, %xmm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512VLBW-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpsllvw %xmm4, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vptestnmw %xmm2, %xmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu16 %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v8i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvw %xmm2, %xmm0, %xmm1
; AVX512VLVBMI2-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOP-LABEL: var_funnnel_v8i16:
; XOP:       # %bb.0:
; XOP-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOP-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOP-NEXT:    vpsubw %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpshlw %xmm4, %xmm1, %xmm4
; XOP-NEXT:    vmovdqa {{.*#+}} xmm5 = [16,16,16,16,16,16,16,16]
; XOP-NEXT:    vpsubw %xmm2, %xmm5, %xmm5
; XOP-NEXT:    vpshlw %xmm5, %xmm0, %xmm0
; XOP-NEXT:    vpor %xmm4, %xmm0, %xmm0
; XOP-NEXT:    vpcomeqw %xmm3, %xmm2, %xmm2
; XOP-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; XOP-NEXT:    retq
;
; X32-SSE-LABEL: var_funnnel_v8i16:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    subl $28, %esp
; X32-SSE-NEXT:    movups %xmm0, (%esp) # 16-byte Spill
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm2
; X32-SSE-NEXT:    movdqa %xmm2, %xmm4
; X32-SSE-NEXT:    psllw $12, %xmm4
; X32-SSE-NEXT:    movdqa %xmm4, %xmm3
; X32-SSE-NEXT:    psraw $15, %xmm3
; X32-SSE-NEXT:    movdqa %xmm1, %xmm5
; X32-SSE-NEXT:    psrlw $8, %xmm5
; X32-SSE-NEXT:    pand %xmm3, %xmm5
; X32-SSE-NEXT:    pandn %xmm1, %xmm3
; X32-SSE-NEXT:    por %xmm5, %xmm3
; X32-SSE-NEXT:    paddw %xmm4, %xmm4
; X32-SSE-NEXT:    movdqa %xmm4, %xmm5
; X32-SSE-NEXT:    psraw $15, %xmm5
; X32-SSE-NEXT:    movdqa %xmm5, %xmm6
; X32-SSE-NEXT:    pandn %xmm3, %xmm6
; X32-SSE-NEXT:    psrlw $4, %xmm3
; X32-SSE-NEXT:    pand %xmm5, %xmm3
; X32-SSE-NEXT:    por %xmm6, %xmm3
; X32-SSE-NEXT:    paddw %xmm4, %xmm4
; X32-SSE-NEXT:    movdqa %xmm4, %xmm5
; X32-SSE-NEXT:    psraw $15, %xmm5
; X32-SSE-NEXT:    movdqa %xmm5, %xmm6
; X32-SSE-NEXT:    pandn %xmm3, %xmm6
; X32-SSE-NEXT:    psrlw $2, %xmm3
; X32-SSE-NEXT:    pand %xmm5, %xmm3
; X32-SSE-NEXT:    por %xmm6, %xmm3
; X32-SSE-NEXT:    paddw %xmm4, %xmm4
; X32-SSE-NEXT:    psraw $15, %xmm4
; X32-SSE-NEXT:    movdqa %xmm4, %xmm5
; X32-SSE-NEXT:    pandn %xmm3, %xmm5
; X32-SSE-NEXT:    psrlw $1, %xmm3
; X32-SSE-NEXT:    pand %xmm4, %xmm3
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; X32-SSE-NEXT:    psubw %xmm2, %xmm4
; X32-SSE-NEXT:    pxor %xmm6, %xmm6
; X32-SSE-NEXT:    movdqa %xmm4, %xmm7
; X32-SSE-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4],xmm6[4],xmm7[5],xmm6[5],xmm7[6],xmm6[6],xmm7[7],xmm6[7]
; X32-SSE-NEXT:    pslld $23, %xmm7
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm0 = [1065353216,1065353216,1065353216,1065353216]
; X32-SSE-NEXT:    paddd %xmm0, %xmm7
; X32-SSE-NEXT:    punpcklwd {{.*#+}} xmm4 = xmm4[0],xmm6[0],xmm4[1],xmm6[1],xmm4[2],xmm6[2],xmm4[3],xmm6[3]
; X32-SSE-NEXT:    pslld $23, %xmm4
; X32-SSE-NEXT:    paddd %xmm0, %xmm4
; X32-SSE-NEXT:    cvttps2dq %xmm7, %xmm0
; X32-SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,2,2,3,4,5,6,7]
; X32-SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,6,6,7]
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X32-SSE-NEXT:    cvttps2dq %xmm4, %xmm4
; X32-SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,2,2,3,4,5,6,7]
; X32-SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,6,6,7]
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; X32-SSE-NEXT:    punpcklqdq {{.*#+}} xmm4 = xmm4[0],xmm0[0]
; X32-SSE-NEXT:    movdqu (%esp), %xmm0 # 16-byte Reload
; X32-SSE-NEXT:    pmullw %xmm0, %xmm4
; X32-SSE-NEXT:    por %xmm5, %xmm4
; X32-SSE-NEXT:    por %xmm3, %xmm4
; X32-SSE-NEXT:    pcmpeqw %xmm6, %xmm2
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pandn %xmm4, %xmm2
; X32-SSE-NEXT:    por %xmm1, %xmm2
; X32-SSE-NEXT:    movdqa %xmm2, %xmm0
; X32-SSE-NEXT:    addl $28, %esp
; X32-SSE-NEXT:    retl
  %res = call <8 x i16> @llvm.fshr.v8i16(<8 x i16> %x, <8 x i16> %y, <8 x i16> %amt)
  ret <8 x i16> %res
}

define <16 x i8> @var_funnnel_v16i8(<16 x i8> %x, <16 x i8> %y, <16 x i8> %amt) nounwind {
; SSE2-LABEL: var_funnnel_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    psllw $5, %xmm5
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm6
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psrlw $4, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pandn %xmm1, %xmm6
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm4
; SSE2-NEXT:    por %xmm6, %xmm4
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm6
; SSE2-NEXT:    movdqa %xmm6, %xmm7
; SSE2-NEXT:    pandn %xmm4, %xmm7
; SSE2-NEXT:    psrlw $2, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm4
; SSE2-NEXT:    por %xmm7, %xmm4
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm6
; SSE2-NEXT:    movdqa %xmm6, %xmm5
; SSE2-NEXT:    pandn %xmm4, %xmm5
; SSE2-NEXT:    psrlw $1, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm4
; SSE2-NEXT:    por %xmm5, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; SSE2-NEXT:    psubb %xmm2, %xmm5
; SSE2-NEXT:    psllw $5, %xmm5
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm6
; SSE2-NEXT:    movdqa %xmm6, %xmm7
; SSE2-NEXT:    pandn %xmm0, %xmm7
; SSE2-NEXT:    psllw $4, %xmm0
; SSE2-NEXT:    pand %xmm6, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm7, %xmm0
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pxor %xmm6, %xmm6
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm6
; SSE2-NEXT:    movdqa %xmm6, %xmm7
; SSE2-NEXT:    pandn %xmm0, %xmm7
; SSE2-NEXT:    psllw $2, %xmm0
; SSE2-NEXT:    pand %xmm6, %xmm0
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm7, %xmm0
; SSE2-NEXT:    paddb %xmm5, %xmm5
; SSE2-NEXT:    pcmpeqb %xmm3, %xmm2
; SSE2-NEXT:    pcmpgtb %xmm5, %xmm3
; SSE2-NEXT:    movdqa %xmm3, %xmm5
; SSE2-NEXT:    pandn %xmm0, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    paddb %xmm0, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: var_funnnel_v16i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; SSE41-NEXT:    psubb %xmm2, %xmm4
; SSE41-NEXT:    pxor %xmm5, %xmm5
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm5
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    psllw $5, %xmm0
; SSE41-NEXT:    movdqa %xmm1, %xmm2
; SSE41-NEXT:    psrlw $4, %xmm2
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE41-NEXT:    movdqa %xmm1, %xmm6
; SSE41-NEXT:    pblendvb %xmm0, %xmm2, %xmm6
; SSE41-NEXT:    movdqa %xmm6, %xmm2
; SSE41-NEXT:    psrlw $2, %xmm2
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE41-NEXT:    paddb %xmm0, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm2, %xmm6
; SSE41-NEXT:    movdqa %xmm6, %xmm2
; SSE41-NEXT:    psrlw $1, %xmm2
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE41-NEXT:    paddb %xmm0, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm2, %xmm6
; SSE41-NEXT:    psllw $5, %xmm4
; SSE41-NEXT:    movdqa %xmm4, %xmm2
; SSE41-NEXT:    paddb %xmm4, %xmm2
; SSE41-NEXT:    movdqa %xmm3, %xmm7
; SSE41-NEXT:    psllw $4, %xmm7
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm7
; SSE41-NEXT:    movdqa %xmm4, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm7, %xmm3
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    psllw $2, %xmm4
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm4
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm4, %xmm3
; SSE41-NEXT:    movdqa %xmm3, %xmm4
; SSE41-NEXT:    paddb %xmm3, %xmm4
; SSE41-NEXT:    paddb %xmm2, %xmm2
; SSE41-NEXT:    movdqa %xmm2, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm4, %xmm3
; SSE41-NEXT:    por %xmm6, %xmm3
; SSE41-NEXT:    movdqa %xmm5, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm1, %xmm3
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX-LABEL: var_funnnel_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX-NEXT:    vpsllw $5, %xmm2, %xmm3
; AVX-NEXT:    vpsrlw $4, %xmm1, %xmm4
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm4, %xmm4
; AVX-NEXT:    vpblendvb %xmm3, %xmm4, %xmm1, %xmm4
; AVX-NEXT:    vpsrlw $2, %xmm4, %xmm5
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm5, %xmm5
; AVX-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vpblendvb %xmm3, %xmm5, %xmm4, %xmm4
; AVX-NEXT:    vpsrlw $1, %xmm4, %xmm5
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm5, %xmm5
; AVX-NEXT:    vpaddb %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vpblendvb %xmm3, %xmm5, %xmm4, %xmm3
; AVX-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX-NEXT:    vpsllw $5, %xmm4, %xmm4
; AVX-NEXT:    vpaddb %xmm4, %xmm4, %xmm5
; AVX-NEXT:    vpsllw $4, %xmm0, %xmm6
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm6, %xmm6
; AVX-NEXT:    vpblendvb %xmm4, %xmm6, %xmm0, %xmm0
; AVX-NEXT:    vpsllw $2, %xmm0, %xmm4
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm4, %xmm4
; AVX-NEXT:    vpblendvb %xmm5, %xmm4, %xmm0, %xmm0
; AVX-NEXT:    vpaddb %xmm0, %xmm0, %xmm4
; AVX-NEXT:    vpaddb %xmm5, %xmm5, %xmm5
; AVX-NEXT:    vpblendvb %xmm5, %xmm4, %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX-NEXT:    vpcmpeqb %xmm3, %xmm2, %xmm2
; AVX-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512F-LABEL: var_funnnel_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm3 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512F-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm4 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512F-NEXT:    vpsrlvd %zmm4, %zmm3, %zmm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512F-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero,xmm4[8],zero,zero,zero,xmm4[9],zero,zero,zero,xmm4[10],zero,zero,zero,xmm4[11],zero,zero,zero,xmm4[12],zero,zero,zero,xmm4[13],zero,zero,zero,xmm4[14],zero,zero,zero,xmm4[15],zero,zero,zero
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512F-NEXT:    vpsllvd %zmm4, %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm3, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vpcmpeqb %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: var_funnnel_v16i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm3 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm4 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512VL-NEXT:    vpsrlvd %zmm4, %zmm3, %zmm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VL-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero,xmm4[8],zero,zero,zero,xmm4[9],zero,zero,zero,xmm4[10],zero,zero,zero,xmm4[11],zero,zero,zero,xmm4[12],zero,zero,zero,xmm4[13],zero,zero,zero,xmm4[14],zero,zero,zero,xmm4[15],zero,zero,zero
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512VL-NEXT:    vpsllvd %zmm4, %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm3, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpcmpeqb %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: var_funnnel_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512BW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero,xmm2[8],zero,xmm2[9],zero,xmm2[10],zero,xmm2[11],zero,xmm2[12],zero,xmm2[13],zero,xmm2[14],zero,xmm2[15],zero
; AVX512BW-NEXT:    vpsrlvw %zmm4, %zmm3, %zmm3
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512BW-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512BW-NEXT:    vpsllvw %zmm4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: var_funnnel_v16i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512VBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512VBMI2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero,xmm2[8],zero,xmm2[9],zero,xmm2[10],zero,xmm2[11],zero,xmm2[12],zero,xmm2[13],zero,xmm2[14],zero,xmm2[15],zero
; AVX512VBMI2-NEXT:    vpsrlvw %zmm4, %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VBMI2-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512VBMI2-NEXT:    vpsllvw %zmm4, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX512VBMI2-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512VBMI2-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm1, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512VBMI2-NEXT:    vzeroupper
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: var_funnnel_v16i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512VLBW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero,xmm2[8],zero,xmm2[9],zero,xmm2[10],zero,xmm2[11],zero,xmm2[12],zero,xmm2[13],zero,xmm2[14],zero,xmm2[15],zero
; AVX512VLBW-NEXT:    vpsrlvw %ymm4, %ymm3, %ymm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLBW-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512VLBW-NEXT:    vpsllvw %ymm4, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpmovwb %ymm0, %xmm0
; AVX512VLBW-NEXT:    vptestnmb %xmm2, %xmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: var_funnnel_v16i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512VLVBMI2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VLVBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero,xmm2[8],zero,xmm2[9],zero,xmm2[10],zero,xmm2[11],zero,xmm2[12],zero,xmm2[13],zero,xmm2[14],zero,xmm2[15],zero
; AVX512VLVBMI2-NEXT:    vpsrlvw %ymm4, %ymm3, %ymm3
; AVX512VLVBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLVBMI2-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VLVBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512VLVBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512VLVBMI2-NEXT:    vpsllvw %ymm4, %ymm0, %ymm0
; AVX512VLVBMI2-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX512VLVBMI2-NEXT:    vpmovwb %ymm0, %xmm0
; AVX512VLVBMI2-NEXT:    vptestnmb %xmm2, %xmm2, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %xmm1, %xmm0 {%k1}
; AVX512VLVBMI2-NEXT:    vzeroupper
; AVX512VLVBMI2-NEXT:    retq
;
; XOP-LABEL: var_funnnel_v16i8:
; XOP:       # %bb.0:
; XOP-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOP-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOP-NEXT:    vpsubb %xmm2, %xmm3, %xmm4
; XOP-NEXT:    vpshlb %xmm4, %xmm1, %xmm4
; XOP-NEXT:    vmovdqa {{.*#+}} xmm5 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; XOP-NEXT:    vpsubb %xmm2, %xmm5, %xmm5
; XOP-NEXT:    vpshlb %xmm5, %xmm0, %xmm0
; XOP-NEXT:    vpor %xmm4, %xmm0, %xmm0
; XOP-NEXT:    vpcomeqb %xmm3, %xmm2, %xmm2
; XOP-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; XOP-NEXT:    retq
;
; X32-SSE-LABEL: var_funnnel_v16i8:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm2
; X32-SSE-NEXT:    movdqa %xmm2, %xmm5
; X32-SSE-NEXT:    psllw $5, %xmm5
; X32-SSE-NEXT:    pxor %xmm3, %xmm3
; X32-SSE-NEXT:    pxor %xmm6, %xmm6
; X32-SSE-NEXT:    pcmpgtb %xmm5, %xmm6
; X32-SSE-NEXT:    movdqa %xmm1, %xmm4
; X32-SSE-NEXT:    psrlw $4, %xmm4
; X32-SSE-NEXT:    pand %xmm6, %xmm4
; X32-SSE-NEXT:    pandn %xmm1, %xmm6
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm4
; X32-SSE-NEXT:    por %xmm6, %xmm4
; X32-SSE-NEXT:    paddb %xmm5, %xmm5
; X32-SSE-NEXT:    pxor %xmm6, %xmm6
; X32-SSE-NEXT:    pcmpgtb %xmm5, %xmm6
; X32-SSE-NEXT:    movdqa %xmm6, %xmm7
; X32-SSE-NEXT:    pandn %xmm4, %xmm7
; X32-SSE-NEXT:    psrlw $2, %xmm4
; X32-SSE-NEXT:    pand %xmm6, %xmm4
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm4
; X32-SSE-NEXT:    por %xmm7, %xmm4
; X32-SSE-NEXT:    paddb %xmm5, %xmm5
; X32-SSE-NEXT:    pxor %xmm6, %xmm6
; X32-SSE-NEXT:    pcmpgtb %xmm5, %xmm6
; X32-SSE-NEXT:    movdqa %xmm6, %xmm5
; X32-SSE-NEXT:    pandn %xmm4, %xmm5
; X32-SSE-NEXT:    psrlw $1, %xmm4
; X32-SSE-NEXT:    pand %xmm6, %xmm4
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm4
; X32-SSE-NEXT:    por %xmm5, %xmm4
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm5 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; X32-SSE-NEXT:    psubb %xmm2, %xmm5
; X32-SSE-NEXT:    psllw $5, %xmm5
; X32-SSE-NEXT:    pxor %xmm6, %xmm6
; X32-SSE-NEXT:    pcmpgtb %xmm5, %xmm6
; X32-SSE-NEXT:    movdqa %xmm6, %xmm7
; X32-SSE-NEXT:    pandn %xmm0, %xmm7
; X32-SSE-NEXT:    psllw $4, %xmm0
; X32-SSE-NEXT:    pand %xmm6, %xmm0
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm0
; X32-SSE-NEXT:    por %xmm7, %xmm0
; X32-SSE-NEXT:    paddb %xmm5, %xmm5
; X32-SSE-NEXT:    pxor %xmm6, %xmm6
; X32-SSE-NEXT:    pcmpgtb %xmm5, %xmm6
; X32-SSE-NEXT:    movdqa %xmm6, %xmm7
; X32-SSE-NEXT:    pandn %xmm0, %xmm7
; X32-SSE-NEXT:    psllw $2, %xmm0
; X32-SSE-NEXT:    pand %xmm6, %xmm0
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm0
; X32-SSE-NEXT:    por %xmm7, %xmm0
; X32-SSE-NEXT:    paddb %xmm5, %xmm5
; X32-SSE-NEXT:    pcmpeqb %xmm3, %xmm2
; X32-SSE-NEXT:    pcmpgtb %xmm5, %xmm3
; X32-SSE-NEXT:    movdqa %xmm3, %xmm5
; X32-SSE-NEXT:    pandn %xmm0, %xmm5
; X32-SSE-NEXT:    por %xmm4, %xmm5
; X32-SSE-NEXT:    paddb %xmm0, %xmm0
; X32-SSE-NEXT:    pand %xmm3, %xmm0
; X32-SSE-NEXT:    por %xmm5, %xmm0
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pandn %xmm0, %xmm2
; X32-SSE-NEXT:    por %xmm1, %xmm2
; X32-SSE-NEXT:    movdqa %xmm2, %xmm0
; X32-SSE-NEXT:    retl
  %res = call <16 x i8> @llvm.fshr.v16i8(<16 x i8> %x, <16 x i8> %y, <16 x i8> %amt)
  ret <16 x i8> %res
}

;
; Uniform Variable Shifts
;

define <2 x i64> @splatvar_funnnel_v2i64(<2 x i64> %x, <2 x i64> %y, <2 x i64> %amt) nounwind {
; SSE2-LABEL: splatvar_funnnel_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    psrlq %xmm2, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [64,64]
; SSE2-NEXT:    psubq %xmm2, %xmm4
; SSE2-NEXT:    psllq %xmm4, %xmm0
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[1,0,3,2]
; SSE2-NEXT:    pand %xmm3, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: splatvar_funnnel_v2i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    psrlq %xmm2, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [64,64]
; SSE41-NEXT:    psubq %xmm2, %xmm4
; SSE41-NEXT:    psllq %xmm4, %xmm3
; SSE41-NEXT:    por %xmm0, %xmm3
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE41-NEXT:    blendvpd %xmm0, %xmm1, %xmm3
; SSE41-NEXT:    movapd %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: splatvar_funnnel_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpsrlq %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX1-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX1-NEXT:    vpsllq %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_funnnel_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq %xmm2, %xmm2
; AVX2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX2-NEXT:    vpsrlq %xmm2, %xmm1, %xmm3
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX2-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX2-NEXT:    vpsllq %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqq %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatvar_funnnel_v2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    vpbroadcastq %xmm2, %xmm2
; AVX512F-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512F-NEXT:    vpsrlq %xmm2, %xmm1, %xmm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512F-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpsllq %xmm4, %xmm0, %xmm0
; AVX512F-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512F-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq %xmm2, %xmm2
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VL-NEXT:    vpsrlq %xmm2, %xmm1, %xmm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512VL-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpsllq %xmm4, %xmm0, %xmm0
; AVX512VL-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestnmq %xmm2, %xmm2, %k1
; AVX512VL-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1}
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v2i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    vpbroadcastq %xmm2, %xmm2
; AVX512BW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512BW-NEXT:    vpsrlq %xmm2, %xmm1, %xmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512BW-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpsllq %xmm4, %xmm0, %xmm0
; AVX512BW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512BW-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v2i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512VBMI2-NEXT:    vpbroadcastq %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpsrlq %xmm2, %xmm1, %xmm3
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512VBMI2-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpsllq %xmm4, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vptestnmq %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512VBMI2-NEXT:    vzeroupper
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v2i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastq %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpsrlq %xmm2, %xmm1, %xmm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; AVX512VLBW-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpsllq %xmm4, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vptestnmq %xmm2, %xmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v2i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastq %xmm2, %xmm2
; AVX512VLVBMI2-NEXT:    vpshrdvq %xmm2, %xmm0, %xmm1
; AVX512VLVBMI2-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_funnnel_v2i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; XOPAVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq %xmm2, %xmm1, %xmm3
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; XOPAVX1-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpsllq %xmm4, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm3, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpcomeqq %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_funnnel_v2i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastq %xmm2, %xmm2
; XOPAVX2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOPAVX2-NEXT:    vpsrlq %xmm2, %xmm1, %xmm3
; XOPAVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [64,64]
; XOPAVX2-NEXT:    vpsubq %xmm2, %xmm4, %xmm4
; XOPAVX2-NEXT:    vpsllq %xmm4, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX2-NEXT:    vpcomeqq %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    retq
;
; X32-SSE-LABEL: splatvar_funnnel_v2i64:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,1,0,1]
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm2
; X32-SSE-NEXT:    movdqa %xmm1, %xmm3
; X32-SSE-NEXT:    psrlq %xmm2, %xmm3
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[2,3,0,1]
; X32-SSE-NEXT:    movdqa %xmm1, %xmm5
; X32-SSE-NEXT:    psrlq %xmm4, %xmm5
; X32-SSE-NEXT:    movsd {{.*#+}} xmm5 = xmm3[0],xmm5[1]
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm3 = [64,0,64,0]
; X32-SSE-NEXT:    psubq %xmm2, %xmm3
; X32-SSE-NEXT:    movdqa %xmm0, %xmm4
; X32-SSE-NEXT:    psllq %xmm3, %xmm4
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,3,0,1]
; X32-SSE-NEXT:    psllq %xmm3, %xmm0
; X32-SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; X32-SSE-NEXT:    orpd %xmm5, %xmm0
; X32-SSE-NEXT:    pxor %xmm3, %xmm3
; X32-SSE-NEXT:    pcmpeqd %xmm2, %xmm3
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[1,0,3,2]
; X32-SSE-NEXT:    pand %xmm3, %xmm2
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pandn %xmm0, %xmm2
; X32-SSE-NEXT:    por %xmm1, %xmm2
; X32-SSE-NEXT:    movdqa %xmm2, %xmm0
; X32-SSE-NEXT:    retl
  %splat = shufflevector <2 x i64> %amt, <2 x i64> undef, <2 x i32> zeroinitializer
  %res = call <2 x i64> @llvm.fshr.v2i64(<2 x i64> %x, <2 x i64> %y, <2 x i64> %splat)
  ret <2 x i64> %res
}

define <4 x i32> @splatvar_funnnel_v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> %amt) nounwind {
; SSE2-LABEL: splatvar_funnnel_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    xorps %xmm4, %xmm4
; SSE2-NEXT:    movss {{.*#+}} xmm4 = xmm2[0],xmm4[1,2,3]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrld %xmm4, %xmm5
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    movl $32, %ecx
; SSE2-NEXT:    subl %eax, %ecx
; SSE2-NEXT:    movd %ecx, %xmm4
; SSE2-NEXT:    pslld %xmm4, %xmm0
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: splatvar_funnnel_v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm2[0],zero,xmm2[1],zero
; SSE41-NEXT:    movdqa %xmm1, %xmm4
; SSE41-NEXT:    psrld %xmm0, %xmm4
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [32,32,32,32]
; SSE41-NEXT:    psubd %xmm2, %xmm0
; SSE41-NEXT:    pmovzxdq {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero
; SSE41-NEXT:    pslld %xmm0, %xmm3
; SSE41-NEXT:    por %xmm4, %xmm3
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE41-NEXT:    blendvps %xmm0, %xmm1, %xmm3
; SSE41-NEXT:    movaps %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: splatvar_funnnel_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX1-NEXT:    vpsrld %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [32,32,32,32]
; AVX1-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX1-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX1-NEXT:    vpslld %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_funnnel_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX2-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX2-NEXT:    vpsrld %xmm3, %xmm1, %xmm3
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX2-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX2-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX2-NEXT:    vpslld %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatvar_funnnel_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX512F-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512F-NEXT:    vpsrld %xmm3, %xmm1, %xmm3
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512F-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512F-NEXT:    vpslld %xmm4, %xmm0, %xmm0
; AVX512F-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512F-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512VL-NEXT:    vpandd {{.*}}(%rip){1to4}, %xmm2, %xmm2
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512VL-NEXT:    vpsrld %xmm3, %xmm1, %xmm3
; AVX512VL-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512VL-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512VL-NEXT:    vpslld %xmm4, %xmm0, %xmm0
; AVX512VL-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestnmd %xmm2, %xmm2, %k1
; AVX512VL-NEXT:    vmovdqa32 %xmm1, %xmm0 {%k1}
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v4i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX512BW-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512BW-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512BW-NEXT:    vpsrld %xmm3, %xmm1, %xmm3
; AVX512BW-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512BW-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512BW-NEXT:    vpslld %xmm4, %xmm0, %xmm0
; AVX512BW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512BW-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v4i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512VBMI2-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; AVX512VBMI2-NEXT:    vpand %xmm3, %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512VBMI2-NEXT:    vpsrld %xmm3, %xmm1, %xmm3
; AVX512VBMI2-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512VBMI2-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512VBMI2-NEXT:    vpslld %xmm4, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vptestnmd %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512VBMI2-NEXT:    vzeroupper
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v4i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpandd {{.*}}(%rip){1to4}, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; AVX512VLBW-NEXT:    vpsrld %xmm3, %xmm1, %xmm3
; AVX512VLBW-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; AVX512VLBW-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; AVX512VLBW-NEXT:    vpslld %xmm4, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vptestnmd %xmm2, %xmm2, %k1
; AVX512VLBW-NEXT:    vmovdqa32 %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v4i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastd %xmm2, %xmm2
; AVX512VLVBMI2-NEXT:    vpshrdvd %xmm2, %xmm0, %xmm1
; AVX512VLVBMI2-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_funnnel_v4i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; XOPAVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; XOPAVX1-NEXT:    vpsrld %xmm3, %xmm1, %xmm3
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [32,32,32,32]
; XOPAVX1-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; XOPAVX1-NEXT:    vpslld %xmm4, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm3, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpcomeqd %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_funnnel_v4i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastd %xmm2, %xmm2
; XOPAVX2-NEXT:    vpbroadcastd {{.*#+}} xmm3 = [31,31,31,31]
; XOPAVX2-NEXT:    vpand %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpmovzxdq {{.*#+}} xmm3 = xmm2[0],zero,xmm2[1],zero
; XOPAVX2-NEXT:    vpsrld %xmm3, %xmm1, %xmm3
; XOPAVX2-NEXT:    vpbroadcastd {{.*#+}} xmm4 = [32,32,32,32]
; XOPAVX2-NEXT:    vpsubd %xmm2, %xmm4, %xmm4
; XOPAVX2-NEXT:    vpmovzxdq {{.*#+}} xmm4 = xmm4[0],zero,xmm4[1],zero
; XOPAVX2-NEXT:    vpslld %xmm4, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX2-NEXT:    vpcomeqd %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vblendvps %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    retq
;
; X32-SSE-LABEL: splatvar_funnnel_v4i32:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm2
; X32-SSE-NEXT:    pxor %xmm3, %xmm3
; X32-SSE-NEXT:    xorps %xmm4, %xmm4
; X32-SSE-NEXT:    movss {{.*#+}} xmm4 = xmm2[0],xmm4[1,2,3]
; X32-SSE-NEXT:    movdqa %xmm1, %xmm5
; X32-SSE-NEXT:    psrld %xmm4, %xmm5
; X32-SSE-NEXT:    movd %xmm2, %eax
; X32-SSE-NEXT:    movl $32, %ecx
; X32-SSE-NEXT:    subl %eax, %ecx
; X32-SSE-NEXT:    movd %ecx, %xmm4
; X32-SSE-NEXT:    pslld %xmm4, %xmm0
; X32-SSE-NEXT:    por %xmm5, %xmm0
; X32-SSE-NEXT:    pcmpeqd %xmm3, %xmm2
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pandn %xmm0, %xmm2
; X32-SSE-NEXT:    por %xmm1, %xmm2
; X32-SSE-NEXT:    movdqa %xmm2, %xmm0
; X32-SSE-NEXT:    retl
  %splat = shufflevector <4 x i32> %amt, <4 x i32> undef, <4 x i32> zeroinitializer
  %res = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> %splat)
  ret <4 x i32> %res
}

define <8 x i16> @splatvar_funnnel_v8i16(<8 x i16> %x, <8 x i16> %y, <8 x i16> %amt) nounwind {
; SSE2-LABEL: splatvar_funnnel_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,0,0]
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; SSE2-NEXT:    psubw %xmm3, %xmm4
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm3, %xmm2
; SSE2-NEXT:    pslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm3[0,1]
; SSE2-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrlw %xmm3, %xmm5
; SSE2-NEXT:    pslldq {{.*#+}} xmm4 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[0,1]
; SSE2-NEXT:    psrldq {{.*#+}} xmm4 = xmm4[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE2-NEXT:    psllw %xmm4, %xmm0
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pandn %xmm0, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: splatvar_funnnel_v8i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pshuflw {{.*#+}} xmm0 = xmm2[0,0,2,3,4,5,6,7]
; SSE41-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,0,0,0]
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE41-NEXT:    pmovzxwq {{.*#+}} xmm0 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; SSE41-NEXT:    movdqa %xmm1, %xmm4
; SSE41-NEXT:    psrlw %xmm0, %xmm4
; SSE41-NEXT:    movdqa {{.*#+}} xmm0 = [16,16,16,16,16,16,16,16]
; SSE41-NEXT:    psubw %xmm2, %xmm0
; SSE41-NEXT:    pmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; SSE41-NEXT:    psllw %xmm0, %xmm3
; SSE41-NEXT:    por %xmm4, %xmm3
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm1, %xmm3
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: splatvar_funnnel_v8i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,0,2,3,4,5,6,7]
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX1-NEXT:    vpsrlw %xmm3, %xmm1, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX1-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX1-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX1-NEXT:    vpsllw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_funnnel_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX2-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX2-NEXT:    vpsrlw %xmm3, %xmm1, %xmm3
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX2-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX2-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX2-NEXT:    vpsllw %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqw %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatvar_funnnel_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512F-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512F-NEXT:    vpsrlw %xmm3, %xmm1, %xmm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512F-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512F-NEXT:    vpsllw %xmm4, %xmm0, %xmm0
; AVX512F-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512F-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vpcmpeqw %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512VL-NEXT:    vpsrlw %xmm3, %xmm1, %xmm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512VL-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512VL-NEXT:    vpsllw %xmm4, %xmm0, %xmm0
; AVX512VL-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpcmpeqw %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v8i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512BW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512BW-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512BW-NEXT:    vpsrlw %xmm3, %xmm1, %xmm3
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512BW-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512BW-NEXT:    vpsllw %xmm4, %xmm0, %xmm0
; AVX512BW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512BW-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu16 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v8i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512VBMI2-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512VBMI2-NEXT:    vpsrlw %xmm3, %xmm1, %xmm3
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512VBMI2-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512VBMI2-NEXT:    vpsllw %xmm4, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vptestnmw %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqu16 %zmm1, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512VBMI2-NEXT:    vzeroupper
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v8i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; AVX512VLBW-NEXT:    vpsrlw %xmm3, %xmm1, %xmm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; AVX512VLBW-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; AVX512VLBW-NEXT:    vpsllw %xmm4, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vptestnmw %xmm2, %xmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu16 %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v8i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastw %xmm2, %xmm2
; AVX512VLVBMI2-NEXT:    vpshrdvw %xmm2, %xmm0, %xmm1
; AVX512VLVBMI2-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_funnnel_v8i16:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshuflw {{.*#+}} xmm2 = xmm2[0,0,2,3,4,5,6,7]
; XOPAVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[0,0,0,0]
; XOPAVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; XOPAVX1-NEXT:    vpsrlw %xmm3, %xmm1, %xmm3
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; XOPAVX1-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; XOPAVX1-NEXT:    vpsllw %xmm4, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm3, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpcomeqw %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_funnnel_v8i16:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastw %xmm2, %xmm2
; XOPAVX2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOPAVX2-NEXT:    vpmovzxwq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero
; XOPAVX2-NEXT:    vpsrlw %xmm3, %xmm1, %xmm3
; XOPAVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; XOPAVX2-NEXT:    vpsubw %xmm2, %xmm4, %xmm4
; XOPAVX2-NEXT:    vpmovzxwq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero
; XOPAVX2-NEXT:    vpsllw %xmm4, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX2-NEXT:    vpcomeqw %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    retq
;
; X32-SSE-LABEL: splatvar_funnnel_v8i16:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,2,3,4,5,6,7]
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,0,0]
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm3
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm4 = [16,16,16,16,16,16,16,16]
; X32-SSE-NEXT:    psubw %xmm3, %xmm4
; X32-SSE-NEXT:    pxor %xmm2, %xmm2
; X32-SSE-NEXT:    pcmpeqw %xmm3, %xmm2
; X32-SSE-NEXT:    pslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm3[0,1]
; X32-SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; X32-SSE-NEXT:    movdqa %xmm1, %xmm5
; X32-SSE-NEXT:    psrlw %xmm3, %xmm5
; X32-SSE-NEXT:    pslldq {{.*#+}} xmm4 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[0,1]
; X32-SSE-NEXT:    psrldq {{.*#+}} xmm4 = xmm4[14,15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; X32-SSE-NEXT:    psllw %xmm4, %xmm0
; X32-SSE-NEXT:    por %xmm5, %xmm0
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pandn %xmm0, %xmm2
; X32-SSE-NEXT:    por %xmm1, %xmm2
; X32-SSE-NEXT:    movdqa %xmm2, %xmm0
; X32-SSE-NEXT:    retl
  %splat = shufflevector <8 x i16> %amt, <8 x i16> undef, <8 x i32> zeroinitializer
  %res = call <8 x i16> @llvm.fshr.v8i16(<8 x i16> %x, <8 x i16> %y, <8 x i16> %splat)
  ret <8 x i16> %res
}

define <16 x i8> @splatvar_funnnel_v16i8(<16 x i8> %x, <16 x i8> %y, <16 x i8> %amt) nounwind {
; SSE2-LABEL: splatvar_funnnel_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,0,0]
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; SSE2-NEXT:    psubb %xmm3, %xmm4
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm3, %xmm2
; SSE2-NEXT:    pslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm3[0]
; SSE2-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrlw %xmm3, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE2-NEXT:    psrlw %xmm3, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm3
; SSE2-NEXT:    psrlw $8, %xmm6
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,0,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,0,0,0]
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pslldq {{.*#+}} xmm4 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[0]
; SSE2-NEXT:    psrldq {{.*#+}} xmm4 = xmm4[15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; SSE2-NEXT:    psllw %xmm4, %xmm0
; SSE2-NEXT:    psllw %xmm4, %xmm3
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,0,2,3,4,5,6,7]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,0,0]
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    por %xmm6, %xmm3
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    pandn %xmm3, %xmm2
; SSE2-NEXT:    por %xmm1, %xmm2
; SSE2-NEXT:    movdqa %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: splatvar_funnnel_v16i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm0, %xmm3
; SSE41-NEXT:    pxor %xmm0, %xmm0
; SSE41-NEXT:    pshufb %xmm0, %xmm2
; SSE41-NEXT:    pand {{.*}}(%rip), %xmm2
; SSE41-NEXT:    pmovzxbq {{.*#+}} xmm4 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; SSE41-NEXT:    movdqa %xmm1, %xmm5
; SSE41-NEXT:    psrlw %xmm4, %xmm5
; SSE41-NEXT:    pcmpeqd %xmm6, %xmm6
; SSE41-NEXT:    pcmpeqd %xmm7, %xmm7
; SSE41-NEXT:    psrlw %xmm4, %xmm7
; SSE41-NEXT:    pshufb {{.*#+}} xmm7 = xmm7[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; SSE41-NEXT:    pand %xmm5, %xmm7
; SSE41-NEXT:    movdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; SSE41-NEXT:    psubb %xmm2, %xmm4
; SSE41-NEXT:    pmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; SSE41-NEXT:    psllw %xmm4, %xmm3
; SSE41-NEXT:    psllw %xmm4, %xmm6
; SSE41-NEXT:    pshufb %xmm0, %xmm6
; SSE41-NEXT:    pand %xmm6, %xmm3
; SSE41-NEXT:    por %xmm7, %xmm3
; SSE41-NEXT:    pcmpeqb %xmm2, %xmm0
; SSE41-NEXT:    pblendvb %xmm0, %xmm1, %xmm3
; SSE41-NEXT:    movdqa %xmm3, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: splatvar_funnnel_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpsrlw %xmm4, %xmm1, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpsrlw %xmm4, %xmm6, %xmm4
; AVX1-NEXT:    vpshufb {{.*#+}} xmm4 = xmm4[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-NEXT:    vpand %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX1-NEXT:    vpsubb %xmm2, %xmm5, %xmm5
; AVX1-NEXT:    vpmovzxbq {{.*#+}} xmm5 = xmm5[0],zero,zero,zero,zero,zero,zero,zero,xmm5[1],zero,zero,zero,zero,zero,zero,zero
; AVX1-NEXT:    vpsllw %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpsllw %xmm5, %xmm6, %xmm5
; AVX1-NEXT:    vpshufb %xmm3, %xmm5, %xmm5
; AVX1-NEXT:    vpand %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: splatvar_funnnel_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX2-NEXT:    vpmovzxbq {{.*#+}} xmm3 = xmm2[0],zero,zero,zero,zero,zero,zero,zero,xmm2[1],zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vpsrlw %xmm3, %xmm1, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm5, %xmm5, %xmm5
; AVX2-NEXT:    vpsrlw %xmm3, %xmm5, %xmm3
; AVX2-NEXT:    vpsrlw $8, %xmm3, %xmm3
; AVX2-NEXT:    vpbroadcastb %xmm3, %xmm3
; AVX2-NEXT:    vpand %xmm3, %xmm4, %xmm3
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX2-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX2-NEXT:    vpmovzxbq {{.*#+}} xmm4 = xmm4[0],zero,zero,zero,zero,zero,zero,zero,xmm4[1],zero,zero,zero,zero,zero,zero,zero
; AVX2-NEXT:    vpsllw %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpsllw %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %xmm4
; AVX2-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX2-NEXT:    vpcmpeqb %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: splatvar_funnnel_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm3 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512F-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm4 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512F-NEXT:    vpsrlvd %zmm4, %zmm3, %zmm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512F-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero,xmm4[8],zero,zero,zero,xmm4[9],zero,zero,zero,xmm4[10],zero,zero,zero,xmm4[11],zero,zero,zero,xmm4[12],zero,zero,zero,xmm4[13],zero,zero,zero,xmm4[14],zero,zero,zero,xmm4[15],zero,zero,zero
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512F-NEXT:    vpsllvd %zmm4, %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm3, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512F-NEXT:    vpcmpeqb %xmm3, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatvar_funnnel_v16i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm3 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512VL-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm4 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero,xmm2[4],zero,zero,zero,xmm2[5],zero,zero,zero,xmm2[6],zero,zero,zero,xmm2[7],zero,zero,zero,xmm2[8],zero,zero,zero,xmm2[9],zero,zero,zero,xmm2[10],zero,zero,zero,xmm2[11],zero,zero,zero,xmm2[12],zero,zero,zero,xmm2[13],zero,zero,zero,xmm2[14],zero,zero,zero,xmm2[15],zero,zero,zero
; AVX512VL-NEXT:    vpsrlvd %zmm4, %zmm3, %zmm3
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VL-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm4 = xmm4[0],zero,zero,zero,xmm4[1],zero,zero,zero,xmm4[2],zero,zero,zero,xmm4[3],zero,zero,zero,xmm4[4],zero,zero,zero,xmm4[5],zero,zero,zero,xmm4[6],zero,zero,zero,xmm4[7],zero,zero,zero,xmm4[8],zero,zero,zero,xmm4[9],zero,zero,zero,xmm4[10],zero,zero,zero,xmm4[11],zero,zero,zero,xmm4[12],zero,zero,zero,xmm4[13],zero,zero,zero,xmm4[14],zero,zero,zero,xmm4[15],zero,zero,zero
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512VL-NEXT:    vpsllvd %zmm4, %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm3, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX512VL-NEXT:    vpcmpeqb %xmm3, %xmm2, %xmm2
; AVX512VL-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatvar_funnnel_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512BW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero,xmm2[8],zero,xmm2[9],zero,xmm2[10],zero,xmm2[11],zero,xmm2[12],zero,xmm2[13],zero,xmm2[14],zero,xmm2[15],zero
; AVX512BW-NEXT:    vpsrlvw %zmm4, %zmm3, %zmm3
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512BW-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512BW-NEXT:    vpsllvw %zmm4, %zmm0, %zmm0
; AVX512BW-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512BW-NEXT:    vmovdqu8 %zmm1, %zmm0 {%k1}
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatvar_funnnel_v16i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512VBMI2-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512VBMI2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero,xmm2[8],zero,xmm2[9],zero,xmm2[10],zero,xmm2[11],zero,xmm2[12],zero,xmm2[13],zero,xmm2[14],zero,xmm2[15],zero
; AVX512VBMI2-NEXT:    vpsrlvw %zmm4, %zmm3, %zmm3
; AVX512VBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VBMI2-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512VBMI2-NEXT:    vpsllvw %zmm4, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX512VBMI2-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512VBMI2-NEXT:    vptestnmb %zmm2, %zmm2, %k1
; AVX512VBMI2-NEXT:    vmovdqu8 %zmm1, %zmm0 {%k1}
; AVX512VBMI2-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512VBMI2-NEXT:    vzeroupper
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatvar_funnnel_v16i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512VLBW-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero,xmm2[8],zero,xmm2[9],zero,xmm2[10],zero,xmm2[11],zero,xmm2[12],zero,xmm2[13],zero,xmm2[14],zero,xmm2[15],zero
; AVX512VLBW-NEXT:    vpsrlvw %ymm4, %ymm3, %ymm3
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLBW-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512VLBW-NEXT:    vpsllvw %ymm4, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpmovwb %ymm0, %xmm0
; AVX512VLBW-NEXT:    vptestnmb %xmm2, %xmm2, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatvar_funnnel_v16i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpbroadcastb %xmm2, %xmm2
; AVX512VLVBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512VLVBMI2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; AVX512VLVBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero,xmm2[8],zero,xmm2[9],zero,xmm2[10],zero,xmm2[11],zero,xmm2[12],zero,xmm2[13],zero,xmm2[14],zero,xmm2[15],zero
; AVX512VLVBMI2-NEXT:    vpsrlvw %ymm4, %ymm3, %ymm3
; AVX512VLVBMI2-NEXT:    vmovdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; AVX512VLVBMI2-NEXT:    vpsubb %xmm2, %xmm4, %xmm4
; AVX512VLVBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm4 = xmm4[0],zero,xmm4[1],zero,xmm4[2],zero,xmm4[3],zero,xmm4[4],zero,xmm4[5],zero,xmm4[6],zero,xmm4[7],zero,xmm4[8],zero,xmm4[9],zero,xmm4[10],zero,xmm4[11],zero,xmm4[12],zero,xmm4[13],zero,xmm4[14],zero,xmm4[15],zero
; AVX512VLVBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512VLVBMI2-NEXT:    vpsllvw %ymm4, %ymm0, %ymm0
; AVX512VLVBMI2-NEXT:    vpor %ymm3, %ymm0, %ymm0
; AVX512VLVBMI2-NEXT:    vpmovwb %ymm0, %xmm0
; AVX512VLVBMI2-NEXT:    vptestnmb %xmm2, %xmm2, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %xmm1, %xmm0 {%k1}
; AVX512VLVBMI2-NEXT:    vzeroupper
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: splatvar_funnnel_v16i8:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm2, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpshlb %xmm4, %xmm1, %xmm4
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; XOPAVX1-NEXT:    vpsubb %xmm2, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpshlb %xmm5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm4, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpcomeqb %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: splatvar_funnnel_v16i8:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpbroadcastb %xmm2, %xmm2
; XOPAVX2-NEXT:    vpand {{.*}}(%rip), %xmm2, %xmm2
; XOPAVX2-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; XOPAVX2-NEXT:    vpsubb %xmm2, %xmm3, %xmm4
; XOPAVX2-NEXT:    vpshlb %xmm4, %xmm1, %xmm4
; XOPAVX2-NEXT:    vmovdqa {{.*#+}} xmm5 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; XOPAVX2-NEXT:    vpsubb %xmm2, %xmm5, %xmm5
; XOPAVX2-NEXT:    vpshlb %xmm5, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpor %xmm4, %xmm0, %xmm0
; XOPAVX2-NEXT:    vpcomeqb %xmm3, %xmm2, %xmm2
; XOPAVX2-NEXT:    vpblendvb %xmm2, %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    retq
;
; X32-SSE-LABEL: splatvar_funnnel_v16i8:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X32-SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,0,2,3,4,5,6,7]
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[0,0,0,0]
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm3
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm4 = [8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8]
; X32-SSE-NEXT:    psubb %xmm3, %xmm4
; X32-SSE-NEXT:    pxor %xmm2, %xmm2
; X32-SSE-NEXT:    pcmpeqb %xmm3, %xmm2
; X32-SSE-NEXT:    pslldq {{.*#+}} xmm3 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm3[0]
; X32-SSE-NEXT:    psrldq {{.*#+}} xmm3 = xmm3[15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; X32-SSE-NEXT:    movdqa %xmm1, %xmm5
; X32-SSE-NEXT:    psrlw %xmm3, %xmm5
; X32-SSE-NEXT:    pcmpeqd %xmm6, %xmm6
; X32-SSE-NEXT:    psrlw %xmm3, %xmm6
; X32-SSE-NEXT:    pcmpeqd %xmm3, %xmm3
; X32-SSE-NEXT:    psrlw $8, %xmm6
; X32-SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X32-SSE-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,0,2,3,4,5,6,7]
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,0,0,0]
; X32-SSE-NEXT:    pand %xmm5, %xmm6
; X32-SSE-NEXT:    pslldq {{.*#+}} xmm4 = zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,xmm4[0]
; X32-SSE-NEXT:    psrldq {{.*#+}} xmm4 = xmm4[15],zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero,zero
; X32-SSE-NEXT:    psllw %xmm4, %xmm0
; X32-SSE-NEXT:    psllw %xmm4, %xmm3
; X32-SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X32-SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,0,2,3,4,5,6,7]
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,0,0,0]
; X32-SSE-NEXT:    pand %xmm0, %xmm3
; X32-SSE-NEXT:    por %xmm6, %xmm3
; X32-SSE-NEXT:    pand %xmm2, %xmm1
; X32-SSE-NEXT:    pandn %xmm3, %xmm2
; X32-SSE-NEXT:    por %xmm1, %xmm2
; X32-SSE-NEXT:    movdqa %xmm2, %xmm0
; X32-SSE-NEXT:    retl
  %splat = shufflevector <16 x i8> %amt, <16 x i8> undef, <16 x i32> zeroinitializer
  %res = call <16 x i8> @llvm.fshr.v16i8(<16 x i8> %x, <16 x i8> %y, <16 x i8> %splat)
  ret <16 x i8> %res
}

;
; Constant Shifts
;

define <2 x i64> @constant_funnnel_v2i64(<2 x i64> %x, <2 x i64> %y) nounwind {
; SSE2-LABEL: constant_funnnel_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrlq $4, %xmm2
; SSE2-NEXT:    psrlq $14, %xmm1
; SSE2-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    psllq $60, %xmm2
; SSE2-NEXT:    psllq $50, %xmm0
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm2[0],xmm0[1]
; SSE2-NEXT:    orpd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: constant_funnnel_v2i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm1, %xmm2
; SSE41-NEXT:    psrlq $14, %xmm2
; SSE41-NEXT:    psrlq $4, %xmm1
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm2[4,5,6,7]
; SSE41-NEXT:    movdqa %xmm0, %xmm2
; SSE41-NEXT:    psllq $50, %xmm2
; SSE41-NEXT:    psllq $60, %xmm0
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm2[4,5,6,7]
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: constant_funnnel_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrlq $14, %xmm1, %xmm2
; AVX1-NEXT:    vpsrlq $4, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpsllq $50, %xmm0, %xmm2
; AVX1-NEXT:    vpsllq $60, %xmm0, %xmm0
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_funnnel_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrlvq {{.*}}(%rip), %xmm1, %xmm1
; AVX2-NEXT:    vpsllvq {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: constant_funnnel_v2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlvq {{.*}}(%rip), %xmm1, %xmm1
; AVX512F-NEXT:    vpsllvq {{.*}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlvq {{.*}}(%rip), %xmm1, %xmm1
; AVX512VL-NEXT:    vpsllvq {{.*}}(%rip), %xmm0, %xmm0
; AVX512VL-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v2i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvq {{.*}}(%rip), %xmm1, %xmm1
; AVX512BW-NEXT:    vpsllvq {{.*}}(%rip), %xmm0, %xmm0
; AVX512BW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v2i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpsrlvq {{.*}}(%rip), %xmm1, %xmm1
; AVX512VBMI2-NEXT:    vpsllvq {{.*}}(%rip), %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v2i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvq {{.*}}(%rip), %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpsllvq {{.*}}(%rip), %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v2i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvq {{.*}}(%rip), %xmm0, %xmm1
; AVX512VLVBMI2-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_funnnel_v2i64:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshlq {{.*}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vpshlq {{.*}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_funnnel_v2i64:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsrlvq {{.*}}(%rip), %xmm1, %xmm1
; XOPAVX2-NEXT:    vpsllvq {{.*}}(%rip), %xmm0, %xmm0
; XOPAVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    retq
;
; X32-SSE-LABEL: constant_funnnel_v2i64:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movdqa %xmm1, %xmm2
; X32-SSE-NEXT:    psrlq $4, %xmm2
; X32-SSE-NEXT:    psrlq $14, %xmm1
; X32-SSE-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; X32-SSE-NEXT:    movdqa %xmm0, %xmm2
; X32-SSE-NEXT:    psllq $60, %xmm2
; X32-SSE-NEXT:    psllq $50, %xmm0
; X32-SSE-NEXT:    movsd {{.*#+}} xmm0 = xmm2[0],xmm0[1]
; X32-SSE-NEXT:    orpd %xmm1, %xmm0
; X32-SSE-NEXT:    retl
  %res = call <2 x i64> @llvm.fshr.v2i64(<2 x i64> %x, <2 x i64> %y, <2 x i64> <i64 4, i64 14>)
  ret <2 x i64> %res
}

define <4 x i32> @constant_funnnel_v4i32(<4 x i32> %x, <4 x i32> %y) nounwind {
; SSE2-LABEL: constant_funnnel_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrld $7, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    psrld $6, %xmm3
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrld $5, %xmm2
; SSE2-NEXT:    psrld $4, %xmm1
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm3[0,3]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [268435456,134217728,67108864,33554432]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm2, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: constant_funnnel_v4i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa %xmm1, %xmm2
; SSE41-NEXT:    psrld $7, %xmm2
; SSE41-NEXT:    movdqa %xmm1, %xmm3
; SSE41-NEXT:    psrld $5, %xmm3
; SSE41-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1,2,3],xmm2[4,5,6,7]
; SSE41-NEXT:    movdqa %xmm1, %xmm2
; SSE41-NEXT:    psrld $6, %xmm2
; SSE41-NEXT:    psrld $4, %xmm1
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm2[4,5,6,7]
; SSE41-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,3],xmm1[4,5],xmm3[6,7]
; SSE41-NEXT:    pmulld {{.*}}(%rip), %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: constant_funnnel_v4i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsrld $7, %xmm1, %xmm2
; AVX1-NEXT:    vpsrld $5, %xmm1, %xmm3
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm3[0,1,2,3],xmm2[4,5,6,7]
; AVX1-NEXT:    vpsrld $6, %xmm1, %xmm3
; AVX1-NEXT:    vpsrld $4, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm3[4,5,6,7]
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; AVX1-NEXT:    vpmulld {{.*}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_funnnel_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsrlvd {{.*}}(%rip), %xmm1, %xmm1
; AVX2-NEXT:    vpsllvd {{.*}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: constant_funnnel_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlvd {{.*}}(%rip), %xmm1, %xmm1
; AVX512F-NEXT:    vpsllvd {{.*}}(%rip), %xmm0, %xmm0
; AVX512F-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlvd {{.*}}(%rip), %xmm1, %xmm1
; AVX512VL-NEXT:    vpsllvd {{.*}}(%rip), %xmm0, %xmm0
; AVX512VL-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v4i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlvd {{.*}}(%rip), %xmm1, %xmm1
; AVX512BW-NEXT:    vpsllvd {{.*}}(%rip), %xmm0, %xmm0
; AVX512BW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v4i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpsrlvd {{.*}}(%rip), %xmm1, %xmm1
; AVX512VBMI2-NEXT:    vpsllvd {{.*}}(%rip), %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v4i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvd {{.*}}(%rip), %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpsllvd {{.*}}(%rip), %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v4i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvd {{.*}}(%rip), %xmm0, %xmm1
; AVX512VLVBMI2-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOPAVX1-LABEL: constant_funnnel_v4i32:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpshld {{.*}}(%rip), %xmm1, %xmm1
; XOPAVX1-NEXT:    vpshld {{.*}}(%rip), %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    retq
;
; XOPAVX2-LABEL: constant_funnnel_v4i32:
; XOPAVX2:       # %bb.0:
; XOPAVX2-NEXT:    vpsrlvd {{.*}}(%rip), %xmm1, %xmm1
; XOPAVX2-NEXT:    vpsllvd {{.*}}(%rip), %xmm0, %xmm0
; XOPAVX2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOPAVX2-NEXT:    retq
;
; X32-SSE-LABEL: constant_funnnel_v4i32:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movdqa %xmm1, %xmm2
; X32-SSE-NEXT:    psrld $7, %xmm2
; X32-SSE-NEXT:    movdqa %xmm1, %xmm3
; X32-SSE-NEXT:    psrld $6, %xmm3
; X32-SSE-NEXT:    punpckhqdq {{.*#+}} xmm3 = xmm3[1],xmm2[1]
; X32-SSE-NEXT:    movdqa %xmm1, %xmm2
; X32-SSE-NEXT:    psrld $5, %xmm2
; X32-SSE-NEXT:    psrld $4, %xmm1
; X32-SSE-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; X32-SSE-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm3[0,3]
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [268435456,134217728,67108864,33554432]
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm0[1,1,3,3]
; X32-SSE-NEXT:    pmuludq %xmm2, %xmm0
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; X32-SSE-NEXT:    pmuludq %xmm3, %xmm2
; X32-SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; X32-SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; X32-SSE-NEXT:    por %xmm1, %xmm0
; X32-SSE-NEXT:    retl
  %res = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> <i32 4, i32 5, i32 6, i32 7>)
  ret <4 x i32> %res
}

define <8 x i16> @constant_funnnel_v8i16(<8 x i16> %x, <8 x i16> %y) nounwind {
; SSE2-LABEL: constant_funnnel_v8i16:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = <u,32768,16384,8192,4096,2048,1024,512>
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    pmulhuw %xmm2, %xmm3
; SSE2-NEXT:    pmullw %xmm2, %xmm0
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [0,65535,65535,65535,65535,65535,65535,65535]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: constant_funnnel_v8i16:
; SSE41:       # %bb.0:
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = <u,32768,16384,8192,4096,2048,1024,512>
; SSE41-NEXT:    movdqa %xmm1, %xmm3
; SSE41-NEXT:    pmulhuw %xmm2, %xmm3
; SSE41-NEXT:    pmullw %xmm2, %xmm0
; SSE41-NEXT:    por %xmm3, %xmm0
; SSE41-NEXT:    pblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4,5,6,7]
; SSE41-NEXT:    retq
;
; AVX-LABEL: constant_funnnel_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,32768,16384,8192,4096,2048,1024,512>
; AVX-NEXT:    vpmulhuw %xmm2, %xmm1, %xmm3
; AVX-NEXT:    vpmullw %xmm2, %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4,5,6,7]
; AVX-NEXT:    retq
;
; AVX512F-LABEL: constant_funnnel_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,32768,16384,8192,4096,2048,1024,512>
; AVX512F-NEXT:    vpmulhuw %xmm2, %xmm1, %xmm3
; AVX512F-NEXT:    vpmullw %xmm2, %xmm0, %xmm0
; AVX512F-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512F-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4,5,6,7]
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,32768,16384,8192,4096,2048,1024,512>
; AVX512VL-NEXT:    vpmulhuw %xmm2, %xmm1, %xmm3
; AVX512VL-NEXT:    vpmullw %xmm2, %xmm0, %xmm0
; AVX512VL-NEXT:    vpor %xmm3, %xmm0, %xmm0
; AVX512VL-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4,5,6,7]
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v8i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,1,2,3,4,5,6,7>
; AVX512BW-NEXT:    vpsrlvw %zmm2, %zmm1, %zmm2
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,15,14,13,12,11,10,9>
; AVX512BW-NEXT:    vpsllvw %zmm3, %zmm0, %zmm0
; AVX512BW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512BW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4,5,6,7]
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v8i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512VBMI2-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm2 = <u,1,2,3,4,5,6,7>
; AVX512VBMI2-NEXT:    vpsrlvw %zmm2, %zmm1, %zmm2
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,15,14,13,12,11,10,9>
; AVX512VBMI2-NEXT:    vpsllvw %zmm3, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4,5,6,7]
; AVX512VBMI2-NEXT:    vzeroupper
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v8i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlvw {{.*}}(%rip), %xmm1, %xmm2
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4,5,6,7]
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v8i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdvw {{.*}}(%rip), %xmm0, %xmm1
; AVX512VLVBMI2-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOP-LABEL: constant_funnnel_v8i16:
; XOP:       # %bb.0:
; XOP-NEXT:    vpshlw {{.*}}(%rip), %xmm1, %xmm2
; XOP-NEXT:    vpshlw {{.*}}(%rip), %xmm0, %xmm0
; XOP-NEXT:    vpor %xmm2, %xmm0, %xmm0
; XOP-NEXT:    vpblendw {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3,4,5,6,7]
; XOP-NEXT:    retq
;
; X32-SSE-LABEL: constant_funnnel_v8i16:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = <u,32768,16384,8192,4096,2048,1024,512>
; X32-SSE-NEXT:    movdqa %xmm1, %xmm3
; X32-SSE-NEXT:    pmulhuw %xmm2, %xmm3
; X32-SSE-NEXT:    pmullw %xmm2, %xmm0
; X32-SSE-NEXT:    por %xmm3, %xmm0
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [0,65535,65535,65535,65535,65535,65535,65535]
; X32-SSE-NEXT:    pand %xmm2, %xmm0
; X32-SSE-NEXT:    pandn %xmm1, %xmm2
; X32-SSE-NEXT:    por %xmm2, %xmm0
; X32-SSE-NEXT:    retl
  %res = call <8 x i16> @llvm.fshr.v8i16(<8 x i16> %x, <8 x i16> %y, <8 x i16> <i16 0, i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7>)
  ret <8 x i16> %res
}

define <16 x i8> @constant_funnnel_v16i8(<16 x i8> %x, <16 x i8> %y) nounwind {
; SSE2-LABEL: constant_funnnel_v16i8:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = <u,2,4,8,16,32,64,128>
; SSE2-NEXT:    pmullw %xmm4, %xmm3
; SSE2-NEXT:    psrlw $8, %xmm3
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3],xmm5[4],xmm2[4],xmm5[5],xmm2[5],xmm5[6],xmm2[6],xmm5[7],xmm2[7]
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = <u,128,64,32,16,8,4,2>
; SSE2-NEXT:    pmullw %xmm2, %xmm5
; SSE2-NEXT:    psrlw $8, %xmm5
; SSE2-NEXT:    packuswb %xmm3, %xmm5
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; SSE2-NEXT:    pmullw %xmm4, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm4, %xmm3
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pmullw %xmm2, %xmm0
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    packuswb %xmm3, %xmm0
; SSE2-NEXT:    por %xmm5, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pandn %xmm1, %xmm2
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE41-LABEL: constant_funnnel_v16i8:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    movdqa %xmm1, %xmm3
; SSE41-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = <u,2,4,8,16,32,64,128>
; SSE41-NEXT:    pmullw %xmm2, %xmm3
; SSE41-NEXT:    psrlw $8, %xmm3
; SSE41-NEXT:    pmovzxbw {{.*#+}} xmm4 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; SSE41-NEXT:    movdqa {{.*#+}} xmm5 = <u,128,64,32,16,8,4,2>
; SSE41-NEXT:    pmullw %xmm5, %xmm4
; SSE41-NEXT:    psrlw $8, %xmm4
; SSE41-NEXT:    packuswb %xmm3, %xmm4
; SSE41-NEXT:    pmovzxbw {{.*#+}} xmm3 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; SSE41-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE41-NEXT:    pmullw %xmm2, %xmm0
; SSE41-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255]
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pmullw %xmm5, %xmm3
; SSE41-NEXT:    pand %xmm2, %xmm3
; SSE41-NEXT:    packuswb %xmm0, %xmm3
; SSE41-NEXT:    por %xmm4, %xmm3
; SSE41-NEXT:    movaps {{.*#+}} xmm0 = [0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; SSE41-NEXT:    pblendvb %xmm0, %xmm3, %xmm1
; SSE41-NEXT:    movdqa %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; AVX1-LABEL: constant_funnnel_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm2 = xmm1[8],xmm2[8],xmm1[9],xmm2[9],xmm1[10],xmm2[10],xmm1[11],xmm2[11],xmm1[12],xmm2[12],xmm1[13],xmm2[13],xmm1[14],xmm2[14],xmm1[15],xmm2[15]
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm3 = <u,2,4,8,16,32,64,128>
; AVX1-NEXT:    vpmullw %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $8, %xmm2, %xmm2
; AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm4 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = <u,128,64,32,16,8,4,2>
; AVX1-NEXT:    vpmullw %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpsrlw $8, %xmm4, %xmm4
; AVX1-NEXT:    vpackuswb %xmm2, %xmm4, %xmm2
; AVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX1-NEXT:    vpmullw %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX1-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpand %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; AVX1-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: constant_funnnel_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbw {{.*#+}} ymm2 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX2-NEXT:    vpmullw {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpsrlw $8, %ymm2, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX2-NEXT:    vpackuswb %xmm3, %xmm2, %xmm2
; AVX2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX2-NEXT:    vpmullw {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm3
; AVX2-NEXT:    vpackuswb %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: constant_funnnel_v16i8:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512F-NEXT:    vpsrlvd {{.*}}(%rip), %zmm2, %zmm2
; AVX512F-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512F-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512F-NEXT:    vpord %zmm2, %zmm0, %zmm0
; AVX512F-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512F-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: constant_funnnel_v16i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm2 = xmm1[0],zero,zero,zero,xmm1[1],zero,zero,zero,xmm1[2],zero,zero,zero,xmm1[3],zero,zero,zero,xmm1[4],zero,zero,zero,xmm1[5],zero,zero,zero,xmm1[6],zero,zero,zero,xmm1[7],zero,zero,zero,xmm1[8],zero,zero,zero,xmm1[9],zero,zero,zero,xmm1[10],zero,zero,zero,xmm1[11],zero,zero,zero,xmm1[12],zero,zero,zero,xmm1[13],zero,zero,zero,xmm1[14],zero,zero,zero,xmm1[15],zero,zero,zero
; AVX512VL-NEXT:    vpsrlvd {{.*}}(%rip), %zmm2, %zmm2
; AVX512VL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; AVX512VL-NEXT:    vpsllvd {{.*}}(%rip), %zmm0, %zmm0
; AVX512VL-NEXT:    vpord %zmm2, %zmm0, %zmm0
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; AVX512VL-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: constant_funnnel_v16i8:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,1,2,3,4,5,6,7,u,7,6,5,4,3,2,1>
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512BW-NEXT:    vpsrlvw %zmm2, %zmm3, %zmm2
; AVX512BW-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,7,6,5,4,3,2,1,u,1,2,3,4,5,6,7>
; AVX512BW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512BW-NEXT:    vpsllvw %zmm3, %zmm0, %zmm0
; AVX512BW-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX512BW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; AVX512BW-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: constant_funnnel_v16i8:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} ymm2 = <u,1,2,3,4,5,6,7,u,7,6,5,4,3,2,1>
; AVX512VBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm3 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512VBMI2-NEXT:    vpsrlvw %zmm2, %zmm3, %zmm2
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} ymm3 = <u,7,6,5,4,3,2,1,u,1,2,3,4,5,6,7>
; AVX512VBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512VBMI2-NEXT:    vpsllvw %zmm3, %zmm0, %zmm0
; AVX512VBMI2-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX512VBMI2-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512VBMI2-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; AVX512VBMI2-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; AVX512VBMI2-NEXT:    vzeroupper
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: constant_funnnel_v16i8:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} ymm2 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512VLBW-NEXT:    vpsrlvw {{.*}}(%rip), %ymm2, %ymm2
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512VLBW-NEXT:    vpsllvw {{.*}}(%rip), %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpmovwb %ymm0, %xmm0
; AVX512VLBW-NEXT:    movw $257, %ax # imm = 0x101
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovdqu8 %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: constant_funnnel_v16i8:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm2 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero,xmm1[8],zero,xmm1[9],zero,xmm1[10],zero,xmm1[11],zero,xmm1[12],zero,xmm1[13],zero,xmm1[14],zero,xmm1[15],zero
; AVX512VLVBMI2-NEXT:    vpsrlvw {{.*}}(%rip), %ymm2, %ymm2
; AVX512VLVBMI2-NEXT:    vpmovzxbw {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero,xmm0[8],zero,xmm0[9],zero,xmm0[10],zero,xmm0[11],zero,xmm0[12],zero,xmm0[13],zero,xmm0[14],zero,xmm0[15],zero
; AVX512VLVBMI2-NEXT:    vpsllvw {{.*}}(%rip), %ymm0, %ymm0
; AVX512VLVBMI2-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX512VLVBMI2-NEXT:    vpmovwb %ymm0, %xmm0
; AVX512VLVBMI2-NEXT:    movw $257, %ax # imm = 0x101
; AVX512VLVBMI2-NEXT:    kmovd %eax, %k1
; AVX512VLVBMI2-NEXT:    vmovdqu8 %xmm1, %xmm0 {%k1}
; AVX512VLVBMI2-NEXT:    vzeroupper
; AVX512VLVBMI2-NEXT:    retq
;
; XOP-LABEL: constant_funnnel_v16i8:
; XOP:       # %bb.0:
; XOP-NEXT:    vpshlb {{.*}}(%rip), %xmm1, %xmm2
; XOP-NEXT:    vpshlb {{.*}}(%rip), %xmm0, %xmm0
; XOP-NEXT:    vpor %xmm2, %xmm0, %xmm0
; XOP-NEXT:    vmovdqa {{.*#+}} xmm2 = [0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; XOP-NEXT:    vpblendvb %xmm2, %xmm0, %xmm1, %xmm0
; XOP-NEXT:    retq
;
; X32-SSE-LABEL: constant_funnnel_v16i8:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    pxor %xmm2, %xmm2
; X32-SSE-NEXT:    movdqa %xmm1, %xmm3
; X32-SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm4 = <u,2,4,8,16,32,64,128>
; X32-SSE-NEXT:    pmullw %xmm4, %xmm3
; X32-SSE-NEXT:    psrlw $8, %xmm3
; X32-SSE-NEXT:    movdqa %xmm1, %xmm5
; X32-SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3],xmm5[4],xmm2[4],xmm5[5],xmm2[5],xmm5[6],xmm2[6],xmm5[7],xmm2[7]
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = <u,128,64,32,16,8,4,2>
; X32-SSE-NEXT:    pmullw %xmm2, %xmm5
; X32-SSE-NEXT:    psrlw $8, %xmm5
; X32-SSE-NEXT:    packuswb %xmm3, %xmm5
; X32-SSE-NEXT:    movdqa %xmm0, %xmm3
; X32-SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; X32-SSE-NEXT:    pmullw %xmm4, %xmm3
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255]
; X32-SSE-NEXT:    pand %xmm4, %xmm3
; X32-SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; X32-SSE-NEXT:    pmullw %xmm2, %xmm0
; X32-SSE-NEXT:    pand %xmm4, %xmm0
; X32-SSE-NEXT:    packuswb %xmm3, %xmm0
; X32-SSE-NEXT:    por %xmm5, %xmm0
; X32-SSE-NEXT:    movdqa {{.*#+}} xmm2 = [0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255]
; X32-SSE-NEXT:    pand %xmm2, %xmm0
; X32-SSE-NEXT:    pandn %xmm1, %xmm2
; X32-SSE-NEXT:    por %xmm2, %xmm0
; X32-SSE-NEXT:    retl
  %res = call <16 x i8> @llvm.fshr.v16i8(<16 x i8> %x, <16 x i8> %y, <16 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 7, i8 6, i8 5, i8 4, i8 3, i8 2, i8 1>)
  ret <16 x i8> %res
}

;
; Uniform Constant Shifts
;

define <2 x i64> @splatconstant_funnnel_v2i64(<2 x i64> %x, <2 x i64> %y) nounwind {
; SSE-LABEL: splatconstant_funnnel_v2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    psrlq $14, %xmm1
; SSE-NEXT:    psllq $50, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: splatconstant_funnnel_v2i64:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrlq $14, %xmm1, %xmm1
; AVX-NEXT:    vpsllq $50, %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512F-LABEL: splatconstant_funnnel_v2i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlq $14, %xmm1, %xmm1
; AVX512F-NEXT:    vpsllq $50, %xmm0, %xmm0
; AVX512F-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v2i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlq $14, %xmm1, %xmm1
; AVX512VL-NEXT:    vpsllq $50, %xmm0, %xmm0
; AVX512VL-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v2i64:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlq $14, %xmm1, %xmm1
; AVX512BW-NEXT:    vpsllq $50, %xmm0, %xmm0
; AVX512BW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v2i64:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpsrlq $14, %xmm1, %xmm1
; AVX512VBMI2-NEXT:    vpsllq $50, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v2i64:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlq $14, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpsllq $50, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v2i64:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdq $14, %xmm0, %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOP-LABEL: splatconstant_funnnel_v2i64:
; XOP:       # %bb.0:
; XOP-NEXT:    vpsrlq $14, %xmm1, %xmm1
; XOP-NEXT:    vpsllq $50, %xmm0, %xmm0
; XOP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOP-NEXT:    retq
;
; X32-SSE-LABEL: splatconstant_funnnel_v2i64:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    psrlq $14, %xmm1
; X32-SSE-NEXT:    psllq $50, %xmm0
; X32-SSE-NEXT:    por %xmm1, %xmm0
; X32-SSE-NEXT:    retl
  %res = call <2 x i64> @llvm.fshr.v2i64(<2 x i64> %x, <2 x i64> %y, <2 x i64> <i64 14, i64 14>)
  ret <2 x i64> %res
}

define <4 x i32> @splatconstant_funnnel_v4i32(<4 x i32> %x, <4 x i32> %y) nounwind {
; SSE-LABEL: splatconstant_funnnel_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    psrld $4, %xmm1
; SSE-NEXT:    pslld $28, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: splatconstant_funnnel_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrld $4, %xmm1, %xmm1
; AVX-NEXT:    vpslld $28, %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512F-LABEL: splatconstant_funnnel_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrld $4, %xmm1, %xmm1
; AVX512F-NEXT:    vpslld $28, %xmm0, %xmm0
; AVX512F-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrld $4, %xmm1, %xmm1
; AVX512VL-NEXT:    vpslld $28, %xmm0, %xmm0
; AVX512VL-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v4i32:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrld $4, %xmm1, %xmm1
; AVX512BW-NEXT:    vpslld $28, %xmm0, %xmm0
; AVX512BW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v4i32:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpsrld $4, %xmm1, %xmm1
; AVX512VBMI2-NEXT:    vpslld $28, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v4i32:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrld $4, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpslld $28, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v4i32:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdd $4, %xmm0, %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOP-LABEL: splatconstant_funnnel_v4i32:
; XOP:       # %bb.0:
; XOP-NEXT:    vpsrld $4, %xmm1, %xmm1
; XOP-NEXT:    vpslld $28, %xmm0, %xmm0
; XOP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOP-NEXT:    retq
;
; X32-SSE-LABEL: splatconstant_funnnel_v4i32:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    psrld $4, %xmm1
; X32-SSE-NEXT:    pslld $28, %xmm0
; X32-SSE-NEXT:    por %xmm1, %xmm0
; X32-SSE-NEXT:    retl
  %res = call <4 x i32> @llvm.fshr.v4i32(<4 x i32> %x, <4 x i32> %y, <4 x i32> <i32 4, i32 4, i32 4, i32 4>)
  ret <4 x i32> %res
}

define <8 x i16> @splatconstant_funnnel_v8i16(<8 x i16> %x, <8 x i16> %y) nounwind {
; SSE-LABEL: splatconstant_funnnel_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    psrlw $7, %xmm1
; SSE-NEXT:    psllw $9, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: splatconstant_funnnel_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrlw $7, %xmm1, %xmm1
; AVX-NEXT:    vpsllw $9, %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512F-LABEL: splatconstant_funnnel_v8i16:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpsrlw $7, %xmm1, %xmm1
; AVX512F-NEXT:    vpsllw $9, %xmm0, %xmm0
; AVX512F-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: splatconstant_funnnel_v8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsrlw $7, %xmm1, %xmm1
; AVX512VL-NEXT:    vpsllw $9, %xmm0, %xmm0
; AVX512VL-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-LABEL: splatconstant_funnnel_v8i16:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsrlw $7, %xmm1, %xmm1
; AVX512BW-NEXT:    vpsllw $9, %xmm0, %xmm0
; AVX512BW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512BW-NEXT:    retq
;
; AVX512VBMI2-LABEL: splatconstant_funnnel_v8i16:
; AVX512VBMI2:       # %bb.0:
; AVX512VBMI2-NEXT:    vpsrlw $7, %xmm1, %xmm1
; AVX512VBMI2-NEXT:    vpsllw $9, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VBMI2-NEXT:    retq
;
; AVX512VLBW-LABEL: splatconstant_funnnel_v8i16:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpsrlw $7, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpsllw $9, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512VLBW-NEXT:    retq
;
; AVX512VLVBMI2-LABEL: splatconstant_funnnel_v8i16:
; AVX512VLVBMI2:       # %bb.0:
; AVX512VLVBMI2-NEXT:    vpshrdw $7, %xmm0, %xmm1, %xmm0
; AVX512VLVBMI2-NEXT:    retq
;
; XOP-LABEL: splatconstant_funnnel_v8i16:
; XOP:       # %bb.0:
; XOP-NEXT:    vpsrlw $7, %xmm1, %xmm1
; XOP-NEXT:    vpsllw $9, %xmm0, %xmm0
; XOP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOP-NEXT:    retq
;
; X32-SSE-LABEL: splatconstant_funnnel_v8i16:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    psrlw $7, %xmm1
; X32-SSE-NEXT:    psllw $9, %xmm0
; X32-SSE-NEXT:    por %xmm1, %xmm0
; X32-SSE-NEXT:    retl
  %res = call <8 x i16> @llvm.fshr.v8i16(<8 x i16> %x, <8 x i16> %y, <8 x i16> <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>)
  ret <8 x i16> %res
}

define <16 x i8> @splatconstant_funnnel_v16i8(<16 x i8> %x, <16 x i8> %y) nounwind {
; SSE-LABEL: splatconstant_funnnel_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    psrlw $4, %xmm1
; SSE-NEXT:    pand {{.*}}(%rip), %xmm1
; SSE-NEXT:    psllw $4, %xmm0
; SSE-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: splatconstant_funnnel_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm1, %xmm1
; AVX-NEXT:    vpsllw $4, %xmm0, %xmm0
; AVX-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
;
; AVX512-LABEL: splatconstant_funnnel_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsrlw $4, %xmm1, %xmm1
; AVX512-NEXT:    vpand {{.*}}(%rip), %xmm1, %xmm1
; AVX512-NEXT:    vpsllw $4, %xmm0, %xmm0
; AVX512-NEXT:    vpand {{.*}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; XOP-LABEL: splatconstant_funnnel_v16i8:
; XOP:       # %bb.0:
; XOP-NEXT:    vpshlb {{.*}}(%rip), %xmm1, %xmm1
; XOP-NEXT:    vpshlb {{.*}}(%rip), %xmm0, %xmm0
; XOP-NEXT:    vpor %xmm1, %xmm0, %xmm0
; XOP-NEXT:    retq
;
; X32-SSE-LABEL: splatconstant_funnnel_v16i8:
; X32-SSE:       # %bb.0:
; X32-SSE-NEXT:    psrlw $4, %xmm1
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm1
; X32-SSE-NEXT:    psllw $4, %xmm0
; X32-SSE-NEXT:    pand {{\.LCPI.*}}, %xmm0
; X32-SSE-NEXT:    por %xmm1, %xmm0
; X32-SSE-NEXT:    retl
  %res = call <16 x i8> @llvm.fshr.v16i8(<16 x i8> %x, <16 x i8> %y, <16 x i8> <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>)
  ret <16 x i8> %res
}
