; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instcombine -S | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

declare i32 @callee()

define i64 @test1(i32 %V) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[CALL1:%.*]] = call i32 @callee(), !range !0
; CHECK-NEXT:    [[CALL2:%.*]] = call i32 @callee(), !range !0
; CHECK-NEXT:    [[ADDCONV:%.*]] = add nuw nsw i32 [[CALL1]], [[CALL2]]
; CHECK-NEXT:    [[ADD:%.*]] = zext i32 [[ADD:%.*]]conv to i64
; CHECK-NEXT:    ret i64 [[ADD]]
;
  %call1 = call i32 @callee(), !range !0
  %call2 = call i32 @callee(), !range !0
  %zext1 = sext i32 %call1 to i64
  %zext2 = sext i32 %call2 to i64
  %add = add i64 %zext1, %zext2
  ret i64 %add
}

define i64 @test2(i32 %V) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[CALL1:%.*]] = call i32 @callee(), !range !0
; CHECK-NEXT:    [[CALL2:%.*]] = call i32 @callee(), !range !0
; CHECK-NEXT:    [[ADD:%.*]] = add nuw nsw i32 [[CALL1]], [[CALL2]]
; CHECK-NEXT:    [[ZEXT1:%.*]] = zext i32 [[ADD]] to i64
; CHECK-NEXT:    ret i64 [[ZEXT1]]
;
  %call1 = call i32 @callee(), !range !0
  %call2 = call i32 @callee(), !range !0
  %add = add i32 %call1, %call2
  %zext = sext i32 %add to i64
  ret i64 %zext
}

define i64 @test3(i32 %V) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[CALL1:%.*]] = call i32 @callee(), !range !0
; CHECK-NEXT:    [[CALL2:%.*]] = call i32 @callee(), !range !0
; CHECK-NEXT:    [[MULCONV:%.*]] = mul nuw nsw i32 [[CALL1]], [[CALL2]]
; CHECK-NEXT:    [[ADD:%.*]] = zext i32 [[MULCONV]] to i64
; CHECK-NEXT:    ret i64 [[ADD]]
;
  %call1 = call i32 @callee(), !range !0
  %call2 = call i32 @callee(), !range !0
  %zext1 = sext i32 %call1 to i64
  %zext2 = sext i32 %call2 to i64
  %add = mul i64 %zext1, %zext2
  ret i64 %add
}

define i64 @test4(i32 %V) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    [[CALL1:%.*]] = call i32 @callee(), !range !0
; CHECK-NEXT:    [[CALL2:%.*]] = call i32 @callee(), !range !0
; CHECK-NEXT:    [[ADD:%.*]] = mul nuw nsw i32 [[CALL1]], [[CALL2]]
; CHECK-NEXT:    [[ZEXT1:%.*]] = zext i32 [[ADD]] to i64
; CHECK-NEXT:    ret i64 [[ZEXT1]]
;
  %call1 = call i32 @callee(), !range !0
  %call2 = call i32 @callee(), !range !0
  %add = mul i32 %call1, %call2
  %zext = sext i32 %add to i64
  ret i64 %zext
}

!0 = !{ i32 0, i32 2000 }
