; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-pc-linux-gnu | FileCheck %s -check-prefix=DEFAULT
; RUN: llc < %s -mtriple=i686-pc-linux-gnu -x86-experimental-pref-innermost-loop-alignment=5 | FileCheck %s -check-prefix=ALIGN32
; RUN: llc < %s -mtriple=i686-pc-linux-gnu -x86-experimental-pref-loop-alignment=5 -x86-experimental-pref-innermost-loop-alignment=6 | FileCheck %s -check-prefix=ALIGN64

declare void @foo()

define void @test(i32 %n, i32 %m) {
; DEFAULT-LABEL: test:
; DEFAULT:       # %bb.0: # %entry
; DEFAULT-NEXT:    pushl %ebp
; DEFAULT-NEXT:    .cfi_def_cfa_offset 8
; DEFAULT-NEXT:    pushl %ebx
; DEFAULT-NEXT:    .cfi_def_cfa_offset 12
; DEFAULT-NEXT:    pushl %edi
; DEFAULT-NEXT:    .cfi_def_cfa_offset 16
; DEFAULT-NEXT:    pushl %esi
; DEFAULT-NEXT:    .cfi_def_cfa_offset 20
; DEFAULT-NEXT:    subl $12, %esp
; DEFAULT-NEXT:    .cfi_def_cfa_offset 32
; DEFAULT-NEXT:    .cfi_offset %esi, -20
; DEFAULT-NEXT:    .cfi_offset %edi, -16
; DEFAULT-NEXT:    .cfi_offset %ebx, -12
; DEFAULT-NEXT:    .cfi_offset %ebp, -8
; DEFAULT-NEXT:    xorl %esi, %esi
; DEFAULT-NEXT:    movl {{[0-9]+}}(%esp), %edi
; DEFAULT-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; DEFAULT-NEXT:    .p2align 4, 0x90
; DEFAULT-NEXT:  .LBB0_1: # %outer
; DEFAULT-NEXT:    # =>This Loop Header: Depth=1
; DEFAULT-NEXT:    # Child Loop BB0_2 Depth 2
; DEFAULT-NEXT:    movl %edi, %ebp
; DEFAULT-NEXT:    .p2align 4, 0x90
; DEFAULT-NEXT:  .LBB0_2: # %inner
; DEFAULT-NEXT:    # Parent Loop BB0_1 Depth=1
; DEFAULT-NEXT:    # => This Inner Loop Header: Depth=2
; DEFAULT-NEXT:    calll foo@PLT
; DEFAULT-NEXT:    decl %ebp
; DEFAULT-NEXT:    jne .LBB0_2
; DEFAULT-NEXT:  # %bb.3: # %outer_bb
; DEFAULT-NEXT:    # in Loop: Header=BB0_1 Depth=1
; DEFAULT-NEXT:    incl %esi
; DEFAULT-NEXT:    cmpl %ebx, %esi
; DEFAULT-NEXT:    jne .LBB0_1
; DEFAULT-NEXT:  # %bb.4: # %exit
; DEFAULT-NEXT:    addl $12, %esp
; DEFAULT-NEXT:    .cfi_def_cfa_offset 20
; DEFAULT-NEXT:    popl %esi
; DEFAULT-NEXT:    .cfi_def_cfa_offset 16
; DEFAULT-NEXT:    popl %edi
; DEFAULT-NEXT:    .cfi_def_cfa_offset 12
; DEFAULT-NEXT:    popl %ebx
; DEFAULT-NEXT:    .cfi_def_cfa_offset 8
; DEFAULT-NEXT:    popl %ebp
; DEFAULT-NEXT:    .cfi_def_cfa_offset 4
; DEFAULT-NEXT:    retl
;
; ALIGN32-LABEL: test:
; ALIGN32:       # %bb.0: # %entry
; ALIGN32-NEXT:    pushl %ebp
; ALIGN32-NEXT:    .cfi_def_cfa_offset 8
; ALIGN32-NEXT:    pushl %ebx
; ALIGN32-NEXT:    .cfi_def_cfa_offset 12
; ALIGN32-NEXT:    pushl %edi
; ALIGN32-NEXT:    .cfi_def_cfa_offset 16
; ALIGN32-NEXT:    pushl %esi
; ALIGN32-NEXT:    .cfi_def_cfa_offset 20
; ALIGN32-NEXT:    subl $12, %esp
; ALIGN32-NEXT:    .cfi_def_cfa_offset 32
; ALIGN32-NEXT:    .cfi_offset %esi, -20
; ALIGN32-NEXT:    .cfi_offset %edi, -16
; ALIGN32-NEXT:    .cfi_offset %ebx, -12
; ALIGN32-NEXT:    .cfi_offset %ebp, -8
; ALIGN32-NEXT:    xorl %esi, %esi
; ALIGN32-NEXT:    movl {{[0-9]+}}(%esp), %edi
; ALIGN32-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; ALIGN32-NEXT:    .p2align 4, 0x90
; ALIGN32-NEXT:  .LBB0_1: # %outer
; ALIGN32-NEXT:    # =>This Loop Header: Depth=1
; ALIGN32-NEXT:    # Child Loop BB0_2 Depth 2
; ALIGN32-NEXT:    movl %edi, %ebp
; ALIGN32-NEXT:    .p2align 5, 0x90
; ALIGN32-NEXT:  .LBB0_2: # %inner
; ALIGN32-NEXT:    # Parent Loop BB0_1 Depth=1
; ALIGN32-NEXT:    # => This Inner Loop Header: Depth=2
; ALIGN32-NEXT:    calll foo@PLT
; ALIGN32-NEXT:    decl %ebp
; ALIGN32-NEXT:    jne .LBB0_2
; ALIGN32-NEXT:  # %bb.3: # %outer_bb
; ALIGN32-NEXT:    # in Loop: Header=BB0_1 Depth=1
; ALIGN32-NEXT:    incl %esi
; ALIGN32-NEXT:    cmpl %ebx, %esi
; ALIGN32-NEXT:    jne .LBB0_1
; ALIGN32-NEXT:  # %bb.4: # %exit
; ALIGN32-NEXT:    addl $12, %esp
; ALIGN32-NEXT:    .cfi_def_cfa_offset 20
; ALIGN32-NEXT:    popl %esi
; ALIGN32-NEXT:    .cfi_def_cfa_offset 16
; ALIGN32-NEXT:    popl %edi
; ALIGN32-NEXT:    .cfi_def_cfa_offset 12
; ALIGN32-NEXT:    popl %ebx
; ALIGN32-NEXT:    .cfi_def_cfa_offset 8
; ALIGN32-NEXT:    popl %ebp
; ALIGN32-NEXT:    .cfi_def_cfa_offset 4
; ALIGN32-NEXT:    retl
;
; ALIGN64-LABEL: test:
; ALIGN64:       # %bb.0: # %entry
; ALIGN64-NEXT:    pushl %ebp
; ALIGN64-NEXT:    .cfi_def_cfa_offset 8
; ALIGN64-NEXT:    pushl %ebx
; ALIGN64-NEXT:    .cfi_def_cfa_offset 12
; ALIGN64-NEXT:    pushl %edi
; ALIGN64-NEXT:    .cfi_def_cfa_offset 16
; ALIGN64-NEXT:    pushl %esi
; ALIGN64-NEXT:    .cfi_def_cfa_offset 20
; ALIGN64-NEXT:    subl $12, %esp
; ALIGN64-NEXT:    .cfi_def_cfa_offset 32
; ALIGN64-NEXT:    .cfi_offset %esi, -20
; ALIGN64-NEXT:    .cfi_offset %edi, -16
; ALIGN64-NEXT:    .cfi_offset %ebx, -12
; ALIGN64-NEXT:    .cfi_offset %ebp, -8
; ALIGN64-NEXT:    xorl %esi, %esi
; ALIGN64-NEXT:    movl {{[0-9]+}}(%esp), %edi
; ALIGN64-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; ALIGN64-NEXT:    .p2align 5, 0x90
; ALIGN64-NEXT:  .LBB0_1: # %outer
; ALIGN64-NEXT:    # =>This Loop Header: Depth=1
; ALIGN64-NEXT:    # Child Loop BB0_2 Depth 2
; ALIGN64-NEXT:    movl %edi, %ebp
; ALIGN64-NEXT:    .p2align 6, 0x90
; ALIGN64-NEXT:  .LBB0_2: # %inner
; ALIGN64-NEXT:    # Parent Loop BB0_1 Depth=1
; ALIGN64-NEXT:    # => This Inner Loop Header: Depth=2
; ALIGN64-NEXT:    calll foo@PLT
; ALIGN64-NEXT:    decl %ebp
; ALIGN64-NEXT:    jne .LBB0_2
; ALIGN64-NEXT:  # %bb.3: # %outer_bb
; ALIGN64-NEXT:    # in Loop: Header=BB0_1 Depth=1
; ALIGN64-NEXT:    incl %esi
; ALIGN64-NEXT:    cmpl %ebx, %esi
; ALIGN64-NEXT:    jne .LBB0_1
; ALIGN64-NEXT:  # %bb.4: # %exit
; ALIGN64-NEXT:    addl $12, %esp
; ALIGN64-NEXT:    .cfi_def_cfa_offset 20
; ALIGN64-NEXT:    popl %esi
; ALIGN64-NEXT:    .cfi_def_cfa_offset 16
; ALIGN64-NEXT:    popl %edi
; ALIGN64-NEXT:    .cfi_def_cfa_offset 12
; ALIGN64-NEXT:    popl %ebx
; ALIGN64-NEXT:    .cfi_def_cfa_offset 8
; ALIGN64-NEXT:    popl %ebp
; ALIGN64-NEXT:    .cfi_def_cfa_offset 4
; ALIGN64-NEXT:    retl



entry:
  br label %outer

outer:
  %outer.iv = phi i32 [0, %entry], [%outer.iv.next, %outer_bb]
  br label %inner

inner:
  %inner.iv = phi i32 [0, %outer], [%inner.iv.next, %inner]
  call void @foo()
  %inner.iv.next = add i32 %inner.iv, 1
  %inner.cond = icmp ne i32 %inner.iv.next, %m
  br i1 %inner.cond, label %inner, label %outer_bb

outer_bb:
  %outer.iv.next = add i32 %outer.iv, 1
  %outer.cond = icmp ne i32 %outer.iv.next, %n
  br i1 %outer.cond, label %outer, label %exit

exit:
  ret void
}
