; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; Make sure that seldag legalization works correctly for freeze instruction.
; RUN: llc -mtriple=i386-apple-darwin < %s 2>&1 | FileCheck %s

define i64 @expand(i32 %x) {
; CHECK-LABEL: expand:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movl $1280068684, %eax ## imm = 0x4C4C4C4C
; CHECK-NEXT:    movl $1145324612, %edx ## imm = 0x44444444
; CHECK-NEXT:    retl
  %y1 = freeze i64 1302123111658042420 ; 0x1212121234343434
  %y2 = freeze i64 6221254864647256184 ; 0x5656565678787878
  %t2 = xor i64 %y1, %y2
  ret i64 %t2
}


define <2 x i64> @expand_vec(i32 %x) nounwind {
; CHECK-LABEL: expand_vec:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movl {{[0-9]+}}(%esp), %eax
; CHECK-NEXT:    movl $1145324612, 12(%eax) ## imm = 0x44444444
; CHECK-NEXT:    movl $1145324612, 8(%eax) ## imm = 0x44444444
; CHECK-NEXT:    movl $1145324612, 4(%eax) ## imm = 0x44444444
; CHECK-NEXT:    movl $1280068684, (%eax) ## imm = 0x4C4C4C4C
; CHECK-NEXT:    retl $4
  ; <0x1212121234343434, 0x101010123232323>
  %y1 = freeze <2 x i64> <i64 1302123111658042420, i64 72340173410738979>
  ; <0x5656565678787878, 0x4545454567676767>
  %y2 = freeze <2 x i64> <i64 6221254864647256184, i64 4991471926399952743>
  %t2 = xor <2 x i64> %y1, %y2
  ret <2 x i64> %t2
}

define i10 @promote() {
; CHECK-LABEL: promote:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movw $650, %ax ## imm = 0x28A
; CHECK-NEXT:    retl
  %a = freeze i10 682
  %b = freeze i10 992
  %res = add i10 %a, %b
  ret i10 %res
}

define <2 x i10> @promote_vec() {
; CHECK-LABEL: promote_vec:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movw $1674, %ax ## imm = 0x68A
; CHECK-NEXT:    movw $518, %dx ## imm = 0x206
; CHECK-NEXT:    retl
  %a = freeze <2 x i10> <i10 682, i10 125>
  %b = freeze <2 x i10> <i10 992, i10 393>
  %res = add <2 x i10> %a, %b
  ret <2 x i10> %res
}
