.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH intel_aubdump __appmansuffix__ __xorgversion__
.SH NAME
intel_aubdump \- Launch an application and capture rendering to an AUB file
.SH SYNOPSIS
.B intel_aubdump [\fIOPTION\fR]... \fI--\fR \fICOMMAND\fR [\fIARGUMENTS\fR]
.SH DESCRIPTION
.PP
Run
.IR COMMAND
with
.IR ARGUMENTS
and dump an AUB file that captures buffer
contents and execution of the i915 GEM application.
.TP
.B \-v
Enable verbose mode.
.TP
.B \-\^\-help
Output a usage message and exit.
.TP
.BI \-o " FILE" "\fR,\fP \-\^\-output=" FILE
Write the trace output to the file
.IR FILE .
Default is 
.IR COMMAND .aub.
.TP
.BI \-\^\-device= ID
Override the PCI ID of the drm device. This is useful for getting an
aub dump for a different generation of GPU. In this mode intel_aubdump
will intercept but not forward the execbuffer2 ioctl, as that would
typically cause a GPU hang.
.SH EXAMPLES
.TP
intel_aubdump -v --output=stuff.aub -- glxgears -geometry 500x500
Launches glxgears with its -geometry option and enables aub dumping
with the -v and --output=stuff.aub options.
